/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class FollowRelation {
    private final String source;
    private final String target;
    private final Integer activityCopyLimit;

    @JsonCreator
    public FollowRelation(@JsonProperty(value="feed_id") String source, @JsonProperty(value="target_id") String target, @JsonProperty(value="activity_copy_limit") Integer activityCopyLimit) {
        Preconditions.checkNotNull((Object)source, (Object)"FollowRelation 'source' field required");
        Preconditions.checkNotNull((Object)target, (Object)"FollowRelation 'target' field required");
        if (activityCopyLimit != null) {
            Preconditions.checkArgument((activityCopyLimit >= 0 ? 1 : 0) != 0, (Object)"Activity copy limit must be non negative");
        }
        this.source = source;
        this.target = target;
        this.activityCopyLimit = activityCopyLimit;
    }

    public FollowRelation(@JsonProperty(value="feed_id") String source, @JsonProperty(value="target_id") String target) {
        this(source, target, null);
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="activity_copy_limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getActivityCopyLimit() {
        return this.activityCopyLimit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FollowRelation that = (FollowRelation)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.target, that.target) && Objects.equals(this.activityCopyLimit, that.activityCopyLimit);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.activityCopyLimit);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).add("target", (Object)this.target).add("activityCopyLimit", (Object)this.activityCopyLimit).toString();
    }
}

