/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.http;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;

public final class RequestBody {
    private final Type type;
    private final byte[] bytes;
    private final File file;
    private final String fileName;

    RequestBody(byte[] bytes, Type type) {
        this.type = type;
        this.bytes = bytes;
        this.file = null;
        this.fileName = null;
    }

    RequestBody(String fileName, byte[] bytes, Type type) {
        this.type = type;
        this.bytes = bytes;
        this.file = null;
        this.fileName = fileName;
    }

    RequestBody(File file, Type type) {
        this.type = type;
        this.bytes = null;
        this.file = file;
        this.fileName = file.getName();
    }

    public Type getType() {
        return this.type;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestBody that = (RequestBody)o;
        return this.type == that.type && Arrays.equals(this.bytes, that.bytes) && Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type, this.file});
        result = 31 * result + Arrays.hashCode(this.bytes);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(RequestBody.class).add("type", (Object)this.type).add("bytes", (Object)this.bytes).add("file", (Object)this.file).toString();
    }

    public static enum Type {
        JSON("application/json"),
        MULTI_PART("multipart/form-data");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

