/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.getstream.core.StreamCollections$$Lambda$1;
import io.getstream.core.StreamCollections$$Lambda$2;
import io.getstream.core.StreamCollections$$Lambda$3;
import io.getstream.core.StreamCollections$$Lambda$4;
import io.getstream.core.StreamCollections$$Lambda$5;
import io.getstream.core.StreamCollections$$Lambda$6;
import io.getstream.core.StreamCollections$$Lambda$7;
import io.getstream.core.StreamCollections$$Lambda$8;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Response;
import io.getstream.core.http.Token;
import io.getstream.core.models.CollectionData;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java8.util.J8Arrays;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;
import java8.util.stream.Collectors;

public final class StreamCollections {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamCollections(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<CollectionData> add(Token token, String userID, String collection, CollectionData item) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)item, (Object)"Collection data can't be null");
        try {
            ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"data", item.getData());
            if (userID != null) {
                builder.put((Object)"user_id", (Object)userID);
            }
            if (item.getID() != null) {
                builder.put((Object)"id", (Object)item.getID());
            }
            byte[] payload = Serialization.toJSON(builder.build());
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/');
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(StreamCollections$$Lambda$1.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<CollectionData> update(Token token, String userID, String collection, CollectionData item) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)item, (Object)"Collection data can't be null");
        try {
            ImmutableMap.Builder builder = new ImmutableMap.Builder().put((Object)"data", item.getData());
            if (userID != null) {
                builder.put((Object)"user_id", (Object)userID);
            }
            byte[] payload = Serialization.toJSON(builder.build());
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/' + item.getID() + '/');
            return this.httpClient.execute(Request.buildPut(url, this.key, token, payload, new RequestOption[0])).thenApply(StreamCollections$$Lambda$2.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> upsert(Token token, final String collection, final CollectionData ... items) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkArgument((items.length > 0 ? 1 : 0) != 0, (Object)"Collection data can't be empty");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Map<String, CollectionData[]> data;
                {
                    this.data = ImmutableMap.of((Object)collection, (Object)items);
                }
            });
            URL url = Routes.buildBatchCollectionsURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(StreamCollections$$Lambda$3.lambdaFactory$());
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<CollectionData> get(Token token, String collection, String id) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)id, (Object)"Collection id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Collection id can't be empty");
        try {
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/' + id + '/');
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new RequestOption[0])).thenApply(StreamCollections$$Lambda$4.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<CollectionData>> select(Token token, String collection, String ... ids) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0, (Object)"Collection ids can't be empty");
        List foreignIDs = (List)J8Arrays.stream((Object[])ids).map(StreamCollections$$Lambda$5.lambdaFactory$(collection)).collect(Collectors.toList());
        try {
            URL url = Routes.buildBatchCollectionsURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("foreign_ids", Joiner.on((String)",").join((Iterable)foreignIDs)))).thenApply(StreamCollections$$Lambda$6.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> delete(Token token, String collection, String id) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)id, (Object)"Collection id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Collection id can't be empty");
        try {
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/' + id + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new RequestOption[0])).thenApply(StreamCollections$$Lambda$7.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> deleteMany(Token token, String collection, String ... ids) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0, (Object)"Collection ids can't be empty");
        try {
            URL url = Routes.buildBatchCollectionsURL(this.baseURL);
            RequestOption[] options = new RequestOption[]{new CustomQueryParameter("collection_name", collection), new CustomQueryParameter("ids", Joiner.on((String)",").join((Object[])ids))};
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, options)).thenApply(StreamCollections$$Lambda$8.lambdaFactory$());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    static /* synthetic */ Void lambda$deleteMany$7(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$delete$6(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ List lambda$select$5(Response response) {
        try {
            return Serialization.deserializeContainer(response, "response.data", CollectionData.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ String lambda$select$4(String collection, String id) {
        return String.format("%s:%s", collection, id);
    }

    static /* synthetic */ CollectionData lambda$get$3(Response response) {
        try {
            return Serialization.deserialize(response, CollectionData.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$upsert$2(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ CollectionData lambda$update$1(Response response) {
        try {
            return Serialization.deserialize(response, CollectionData.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ CollectionData lambda$add$0(Response response) {
        try {
            return Serialization.deserialize(response, CollectionData.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }
}

