/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.http;

import com.google.common.base.MoreObjects;
import io.getstream.core.http.RequestBody;
import io.getstream.core.http.Token;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;

public final class Request {
    private final Token token;
    private final URL url;
    private final Method method;
    private final RequestBody body;

    private Request(Builder builder) throws MalformedURLException {
        this.token = builder.token;
        this.url = builder.uri.toURL();
        this.method = builder.method;
        this.body = builder.body;
    }

    public Token getToken() {
        return this.token;
    }

    public URL getURL() {
        return this.url;
    }

    public Method getMethod() {
        return this.method;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Request request = (Request)o;
        return Objects.equals(this.token, request.token) && Objects.equals(this.url, request.url) && this.method == request.method && Objects.equals(this.body, request.body);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.token, this.url, this.method, this.body});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).add("url", (Object)this.url).add("method", (Object)this.method).add("body", (Object)this.body).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Token token;
        private URI uri;
        private StringBuilder query;
        private Method method;
        private RequestBody body;

        public Builder token(Token token) {
            this.token = token;
            return this;
        }

        public Builder url(URL url) throws URISyntaxException {
            this.uri = url.toURI();
            this.query = this.uri.getQuery() != null ? new StringBuilder(this.uri.getQuery()) : new StringBuilder();
            return this;
        }

        public Builder addQueryParameter(String key, String value) {
            if (this.query.length() > 0) {
                this.query.append('&');
            }
            this.query.append(key);
            this.query.append('=');
            this.query.append(value);
            return this;
        }

        public Builder get() {
            this.method = Method.GET;
            this.body = null;
            return this;
        }

        public Builder post(byte[] body) {
            this.method = Method.POST;
            this.body = new RequestBody(body, RequestBody.Type.JSON);
            return this;
        }

        public Builder multiPartPost(String fileName, byte[] body) {
            this.method = Method.POST;
            this.body = new RequestBody(fileName, body, RequestBody.Type.MULTI_PART);
            return this;
        }

        public Builder multiPartPost(File body) {
            this.method = Method.POST;
            this.body = new RequestBody(body, RequestBody.Type.MULTI_PART);
            return this;
        }

        public Builder put(byte[] body) {
            this.method = Method.PUT;
            this.body = new RequestBody(body, RequestBody.Type.JSON);
            return this;
        }

        public Builder delete() {
            this.method = Method.DELETE;
            this.body = null;
            return this;
        }

        public Request build() throws MalformedURLException, URISyntaxException {
            this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), this.query.toString(), null);
            return new Request(this);
        }
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

