/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.cloud;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.getstream.cloud.CloudClient;
import io.getstream.cloud.CloudFeed$$Lambda$1;
import io.getstream.cloud.CloudFeed$$Lambda$10;
import io.getstream.cloud.CloudFeed$$Lambda$11;
import io.getstream.cloud.CloudFeed$$Lambda$12;
import io.getstream.cloud.CloudFeed$$Lambda$13;
import io.getstream.cloud.CloudFeed$$Lambda$14;
import io.getstream.cloud.CloudFeed$$Lambda$15;
import io.getstream.cloud.CloudFeed$$Lambda$16;
import io.getstream.cloud.CloudFeed$$Lambda$17;
import io.getstream.cloud.CloudFeed$$Lambda$18;
import io.getstream.cloud.CloudFeed$$Lambda$19;
import io.getstream.cloud.CloudFeed$$Lambda$2;
import io.getstream.cloud.CloudFeed$$Lambda$3;
import io.getstream.cloud.CloudFeed$$Lambda$4;
import io.getstream.cloud.CloudFeed$$Lambda$5;
import io.getstream.cloud.CloudFeed$$Lambda$6;
import io.getstream.cloud.CloudFeed$$Lambda$7;
import io.getstream.cloud.CloudFeed$$Lambda$8;
import io.getstream.cloud.CloudFeed$$Lambda$9;
import io.getstream.cloud.CloudFlatFeed;
import io.getstream.cloud.FeedSubscriber;
import io.getstream.cloud.RealtimeMessageCallback;
import io.getstream.core.KeepHistory;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.faye.subscription.ChannelSubscription;
import io.getstream.core.http.Response;
import io.getstream.core.models.Activity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.FollowRelation;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.Limit;
import io.getstream.core.options.Offset;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import io.getstream.core.utils.Streams;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java8.util.J8Arrays;
import java8.util.concurrent.CompletableFuture;
import java8.util.concurrent.CompletionException;

public class CloudFeed {
    private final CloudClient client;
    private final FeedID id;
    private final FeedSubscriber subscriber;

    CloudFeed(CloudClient client, FeedID id) {
        Preconditions.checkNotNull((Object)client, (Object)"Can't create feed w/o a client");
        Preconditions.checkNotNull((Object)id, (Object)"Can't create feed w/o an ID");
        this.client = client;
        this.id = id;
        this.subscriber = null;
    }

    CloudFeed(CloudClient client, FeedID id, FeedSubscriber subscriber) {
        Preconditions.checkNotNull((Object)client, (Object)"Can't create feed w/o a client");
        Preconditions.checkNotNull((Object)id, (Object)"Can't create feed w/o an ID");
        this.client = client;
        this.id = id;
        this.subscriber = subscriber;
    }

    protected final CloudClient getClient() {
        return this.client;
    }

    public final CompletableFuture<ChannelSubscription> subscribe(RealtimeMessageCallback messageCallback) {
        Preconditions.checkNotNull((Object)this.subscriber, (Object)"A subscriber must be provided in order to start listening to a feed");
        return this.subscriber.subscribe(this.id, messageCallback);
    }

    public final FeedID getID() {
        return this.id;
    }

    public final String getSlug() {
        return this.id.getSlug();
    }

    public final String getUserID() {
        return this.id.getUserID();
    }

    public final CompletableFuture<Activity> addActivity(Activity activity) throws StreamException {
        return this.getClient().addActivity(this.id, activity).thenApply(CloudFeed$$Lambda$1.lambdaFactory$());
    }

    public final <T> CompletableFuture<T> addCustomActivity(T activity) throws StreamException {
        return this.getClient().addActivity(this.id, Activity.builder().fromCustomActivity(activity).build()).thenApply(CloudFeed$$Lambda$2.lambdaFactory$(activity));
    }

    public final CompletableFuture<List<Activity>> addActivities(Iterable<Activity> activities) throws StreamException {
        return this.addActivities((Activity[])Iterables.toArray(activities, Activity.class));
    }

    public final <T> CompletableFuture<List<T>> addCustomActivities(Iterable<T> activities) throws StreamException {
        Activity[] custom = (Activity[])Streams.stream(activities).map(CloudFeed$$Lambda$3.lambdaFactory$()).toArray(CloudFeed$$Lambda$4.lambdaFactory$());
        return this.getClient().addActivities(this.id, custom).thenApply(CloudFeed$$Lambda$5.lambdaFactory$(this));
    }

    public final CompletableFuture<List<Activity>> addActivities(Activity ... activities) throws StreamException {
        return this.getClient().addActivities(this.id, activities).thenApply(CloudFeed$$Lambda$6.lambdaFactory$());
    }

    public final <T> CompletableFuture<List<T>> addCustomActivities(T ... activities) throws StreamException {
        Activity[] custom = (Activity[])J8Arrays.stream((Object[])activities).map(CloudFeed$$Lambda$7.lambdaFactory$()).toArray(CloudFeed$$Lambda$8.lambdaFactory$());
        return this.getClient().addActivities(this.id, custom).thenApply(CloudFeed$$Lambda$9.lambdaFactory$(activities));
    }

    public final CompletableFuture<Void> removeActivityByID(String id) throws StreamException {
        return this.client.removeActivityByID(this.id, id).thenApply(CloudFeed$$Lambda$10.lambdaFactory$());
    }

    public final CompletableFuture<Void> removeActivityByForeignID(String foreignID) throws StreamException {
        return this.client.removeActivityByForeignID(this.id, foreignID).thenApply(CloudFeed$$Lambda$11.lambdaFactory$());
    }

    public final CompletableFuture<Void> follow(CloudFlatFeed feed) throws StreamException {
        return this.follow(feed, 100);
    }

    public final CompletableFuture<Void> follow(CloudFlatFeed feed, int activityCopyLimit) throws StreamException {
        Preconditions.checkArgument((activityCopyLimit <= 1000 ? 1 : 0) != 0, (Object)String.format("Activity copy limit should be less then %d", 1000));
        return this.client.follow(this.id, feed.getID(), activityCopyLimit).thenApply(CloudFeed$$Lambda$12.lambdaFactory$());
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(FeedID ... feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(limit, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, FeedID ... feedIDs) throws StreamException {
        return this.getFollowers(limit, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Offset offset, FeedID ... feedIDs) throws StreamException {
        return this.getFollowers(DefaultOptions.DEFAULT_LIMIT, offset, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowers(limit, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowers(Limit limit, Offset offset, FeedID ... feeds) throws StreamException {
        RequestOption[] requestOptionArray;
        Preconditions.checkNotNull((Object)feeds, (Object)"No feed ids to filter on");
        CharSequence[] feedIDs = (String[])J8Arrays.stream((Object[])feeds).map(CloudFeed$$Lambda$13.lambdaFactory$()).toArray(CloudFeed$$Lambda$14.lambdaFactory$());
        if (feedIDs.length == 0) {
            RequestOption[] requestOptionArray2 = new RequestOption[2];
            requestOptionArray2[0] = limit;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[1] = offset;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[3];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[2] = new CustomQueryParameter("filter", String.join((CharSequence)",", feedIDs));
        }
        RequestOption[] options = requestOptionArray;
        return this.client.getFollowers(this.id, options).thenApply(CloudFeed$$Lambda$15.lambdaFactory$());
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(FeedID ... feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(limit, DefaultOptions.DEFAULT_OFFSET, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, FeedID ... feedIDs) throws StreamException {
        return this.getFollowed(limit, DefaultOptions.DEFAULT_OFFSET, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Offset offset, FeedID ... feedIDs) throws StreamException {
        return this.getFollowed(DefaultOptions.DEFAULT_LIMIT, offset, feedIDs);
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, Offset offset, Iterable<FeedID> feedIDs) throws StreamException {
        return this.getFollowed(limit, offset, (FeedID[])Iterables.toArray(feedIDs, FeedID.class));
    }

    public final CompletableFuture<List<FollowRelation>> getFollowed(Limit limit, Offset offset, FeedID ... feeds) throws StreamException {
        RequestOption[] requestOptionArray;
        Preconditions.checkNotNull((Object)feeds, (Object)"No feed ids to filter on");
        CharSequence[] feedIDs = (String[])J8Arrays.stream((Object[])feeds).map(CloudFeed$$Lambda$16.lambdaFactory$()).toArray(CloudFeed$$Lambda$17.lambdaFactory$());
        if (feedIDs.length == 0) {
            RequestOption[] requestOptionArray2 = new RequestOption[2];
            requestOptionArray2[0] = limit;
            requestOptionArray = requestOptionArray2;
            requestOptionArray2[1] = offset;
        } else {
            RequestOption[] requestOptionArray3 = new RequestOption[3];
            requestOptionArray3[0] = limit;
            requestOptionArray3[1] = offset;
            requestOptionArray = requestOptionArray3;
            requestOptionArray3[2] = new CustomQueryParameter("filter", String.join((CharSequence)",", feedIDs));
        }
        RequestOption[] options = requestOptionArray;
        return this.client.getFollowed(this.id, options).thenApply(CloudFeed$$Lambda$18.lambdaFactory$());
    }

    public final CompletableFuture<Void> unfollow(CloudFlatFeed feed) throws StreamException {
        return this.unfollow(feed, KeepHistory.NO);
    }

    public final CompletableFuture<Void> unfollow(CloudFlatFeed feed, KeepHistory keepHistory) throws StreamException {
        return this.client.unfollow(this.id, feed.getID(), new io.getstream.core.options.KeepHistory(keepHistory)).thenApply(CloudFeed$$Lambda$19.lambdaFactory$());
    }

    static /* synthetic */ Void lambda$unfollow$18(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ List lambda$getFollowed$17(Response response) {
        try {
            return Serialization.deserializeContainer(response, FollowRelation.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ String[] lambda$getFollowed$16(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$getFollowed$15(FeedID id) {
        return id.toString();
    }

    static /* synthetic */ List lambda$getFollowers$14(Response response) {
        try {
            return Serialization.deserializeContainer(response, FollowRelation.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ String[] lambda$getFollowers$13(int x$0) {
        return new String[x$0];
    }

    static /* synthetic */ String lambda$getFollowers$12(FeedID id) {
        return id.toString();
    }

    static /* synthetic */ Void lambda$follow$11(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$removeActivityByForeignID$10(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Void lambda$removeActivityByID$9(Response response) {
        try {
            return Serialization.deserializeError(response);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ List lambda$addCustomActivities$8(Object[] activities, Response response) {
        try {
            Class<?> element = activities.getClass().getComponentType();
            return Serialization.deserializeContainer(response, "activities", element);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Activity[] lambda$addCustomActivities$7(int x$0) {
        return new Activity[x$0];
    }

    static /* synthetic */ Activity lambda$addCustomActivities$6(Object activity) {
        return Activity.builder().fromCustomActivity(activity).build();
    }

    static /* synthetic */ List lambda$addActivities$5(Response response) {
        try {
            return Serialization.deserializeContainer(response, "activities", Activity.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ List lambda$addCustomActivities$4(CloudFeed this_, Response response) {
        try {
            Class element = (Class)((ParameterizedType)this_.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            return Serialization.deserializeContainer(response, "activities", element);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Activity[] lambda$addCustomActivities$3(int x$0) {
        return new Activity[x$0];
    }

    static /* synthetic */ Activity lambda$addCustomActivities$2(Object activity) {
        return Activity.builder().fromCustomActivity(activity).build();
    }

    static /* synthetic */ Object lambda$addCustomActivity$1(Object activity, Response response) {
        try {
            return Serialization.deserialize(response, activity.getClass());
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }

    static /* synthetic */ Activity lambda$addActivity$0(Response response) {
        try {
            return Serialization.deserialize(response, Activity.class);
        }
        catch (StreamException | IOException e) {
            throw new CompletionException((Throwable)e);
        }
    }
}

