/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.faye.emitter;

import io.getstream.core.faye.emitter.ErrorListener;
import io.getstream.core.faye.emitter.EventEmitter$$Lambda$1;
import io.getstream.core.faye.emitter.EventEmitter$$Lambda$2;
import io.getstream.core.faye.emitter.EventListener;
import io.getstream.core.faye.emitter.ListenerEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class EventEmitter<T> {
    private final Map<String, LinkedList<ListenerEntry<T>>> events = new HashMap<String, LinkedList<ListenerEntry<T>>>();
    private ErrorListener errorListener;
    private boolean mounted = true;

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public boolean isMounted() {
        return this.mounted;
    }

    private void assertMounted() {
        assert (this.isMounted()) : "Tried to use " + this.getClass().getSimpleName() + " after `dispose` was called. Consider checking `isMounted`";
    }

    public void emit(String event, T data) {
        this.assertMounted();
        LinkedList<ListenerEntry<T>> listeners = this.events.get(event);
        if (listeners == null) {
            return;
        }
        boolean didThrow = false;
        ArrayList<ListenerEntry> removables = new ArrayList<ListenerEntry>();
        for (ListenerEntry listenerEntry : listeners) {
            try {
                listenerEntry.getListener().onData(data);
                Integer limit = listenerEntry.getLimit();
                if (limit == null) continue;
                if (limit > 0) {
                    limit = limit - 1;
                    listenerEntry.setLimit(limit);
                }
                if (limit != 0) continue;
                removables.add(listenerEntry);
            }
            catch (Exception e) {
                didThrow = true;
                if (this.errorListener == null) continue;
                this.errorListener.onError(e);
            }
        }
        for (ListenerEntry listenerEntry : removables) {
            listeners.remove(listenerEntry);
        }
        if (didThrow) {
            throw new Error();
        }
    }

    public void on(String event, EventListener<T> listener) {
        this.addListener(event, listener);
    }

    public void on(String event, EventListener<T> listener, int limit) {
        this.addListener(event, listener, limit);
    }

    public void addListener(String event, EventListener<T> listener) {
        this._addListener(event, listener, null);
    }

    public void addListener(String event, EventListener<T> listener, int limit) {
        this._addListener(event, listener, limit);
    }

    void _addListener(String event, EventListener<T> listener, Integer limit) {
        this.assertMounted();
        ListenerEntry<T> entry = new ListenerEntry<T>(listener, limit);
        LinkedList<ListenerEntry<Object>> listeners = this.events.get(event);
        if (listeners == null) {
            listeners = new LinkedList();
        }
        listeners.add(entry);
        this.events.put(event, listeners);
    }

    public void off(String event) {
        this.assertMounted();
        this.events.put(event, new LinkedList());
    }

    public void removeListener(String event, EventListener<T> listener) {
        this.assertMounted();
        LinkedList<ListenerEntry<T>> listeners = this.events.get(event);
        if (listeners == null) {
            return;
        }
        listeners.removeIf(EventEmitter$$Lambda$1.lambdaFactory$(listener));
    }

    public void removeAllListeners() {
        this.assertMounted();
        this.events.clear();
    }

    public boolean hasListeners(String event) throws Exception {
        this.assertMounted();
        LinkedList<ListenerEntry<T>> listeners = this.events.get(event);
        if (listeners == null) {
            throw new Exception("Event not available");
        }
        return !listeners.isEmpty();
    }

    public void dispose() {
        this.assertMounted();
        this.events.values().forEach(EventEmitter$$Lambda$2.lambdaFactory$());
        this.mounted = false;
    }

    static /* synthetic */ boolean lambda$removeListener$0(EventListener listener, ListenerEntry curr) {
        return curr.getListener() == listener;
    }
}

