/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.Preconditions;
import java.util.Objects;

@JsonSerialize(using=ToStringSerializer.class)
public final class FeedID {
    private final String slug;
    private final String userID;

    public FeedID(String slug, String userID) {
        Preconditions.checkNotNull((Object)slug, (Object)"Feed slug can't be null");
        Preconditions.checkArgument((!slug.isEmpty() ? 1 : 0) != 0, (Object)"Feed slug can't be empty");
        Preconditions.checkArgument((!slug.contains(":") ? 1 : 0) != 0, (Object)"Invalid slug");
        Preconditions.checkNotNull((Object)userID, (Object)"Feed user ID can't be null");
        Preconditions.checkArgument((!userID.contains(":") ? 1 : 0) != 0, (Object)"Invalid user ID");
        Preconditions.checkArgument((!userID.isEmpty() ? 1 : 0) != 0, (Object)"User ID can't be empty");
        this.slug = slug;
        this.userID = userID;
    }

    public FeedID(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"Feed ID can't be null");
        Preconditions.checkArgument((boolean)id.contains(":"), (Object)"Invalid feed ID");
        String[] parts = id.split(":");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (Object)"Invalid feed ID");
        this.slug = parts[0];
        this.userID = parts[1];
    }

    public String getSlug() {
        return this.slug;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getClaim() {
        return this.slug + this.userID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeedID feedID = (FeedID)o;
        return Objects.equals(this.slug, feedID.slug) && Objects.equals(this.userID, feedID.userID);
    }

    public int hashCode() {
        return Objects.hash(this.slug, this.userID);
    }

    public String toString() {
        return this.slug + ':' + this.userID;
    }
}

