/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.http;

import com.google.common.base.Preconditions;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Request;
import io.getstream.core.http.RequestBody;
import io.getstream.core.http.Response;
import io.getstream.core.utils.Info;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java8.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public final class OKHTTPClientAdapter
extends HTTPClient {
    private static final String userAgentTemplate = "okhttp3 stream-java2 %s v%s";
    private final OkHttpClient client;

    public OKHTTPClientAdapter() {
        this.client = new OkHttpClient.Builder().followRedirects(false).followSslRedirects(false).build();
    }

    public OKHTTPClientAdapter(OkHttpClient client) {
        Preconditions.checkNotNull((Object)client);
        this.client = client;
    }

    @Override
    public <T> T getImplementation() {
        return (T)this.client;
    }

    private okhttp3.RequestBody buildOkHttpRequestBody(RequestBody body) {
        okhttp3.RequestBody okBody = null;
        switch (body.getType()) {
            case JSON: {
                MediaType mediaType = MediaType.parse((String)body.getType().toString());
                okBody = okhttp3.RequestBody.create((MediaType)mediaType, (byte[])body.getBytes());
                break;
            }
            case MULTI_PART: {
                String mimeType = URLConnection.guessContentTypeFromName(body.getFileName());
                MediaType mediaType = MediaType.parse((String)mimeType);
                MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
                if (body.getBytes() != null) {
                    builder.addFormDataPart("file", body.getFileName(), okhttp3.RequestBody.create((MediaType)mediaType, (byte[])body.getBytes()));
                } else {
                    builder.addFormDataPart("file", body.getFileName(), okhttp3.RequestBody.create((MediaType)mediaType, (File)body.getFile()));
                }
                okBody = builder.build();
            }
        }
        return okBody;
    }

    private okhttp3.Request buildOkHttpRequest(Request request) {
        String version = Info.getProperties().getProperty("version");
        String userAgent = String.format(userAgentTemplate, System.getProperty("os.name"), version);
        Request.Builder builder = new Request.Builder().url(request.getURL()).addHeader("Stream-Auth-Type", "jwt").addHeader("Authorization", request.getToken().toString()).addHeader("User-Agent", userAgent);
        switch (request.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case DELETE: {
                builder.delete();
                break;
            }
            case PUT: {
                builder.put(this.buildOkHttpRequestBody(request.getBody()));
                break;
            }
            case POST: {
                builder.post(this.buildOkHttpRequestBody(request.getBody()));
            }
        }
        return builder.build();
    }

    private Response buildResponse(okhttp3.Response response) {
        InputStream body = response.body() != null ? response.body().byteStream() : null;
        return new Response(response.code(), body);
    }

    @Override
    public CompletableFuture<Response> execute(Request request) {
        final CompletableFuture result = new CompletableFuture();
        this.client.newCall(this.buildOkHttpRequest(request)).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                result.completeExceptionally((Throwable)e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, okhttp3.Response response) {
                try {
                    Response httpResponse = OKHTTPClientAdapter.this.buildResponse(response);
                    result.complete((Object)httpResponse);
                }
                catch (Exception e) {
                    result.completeExceptionally((Throwable)e);
                }
                finally {
                    response.body().close();
                }
            }
        });
        return result;
    }
}

