/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.Set;

public final class ActivityMarker
implements RequestOption {
    private boolean allRead = false;
    private boolean allSeen = false;
    private Set<String> readIDs = Sets.newHashSet();
    private Set<String> seenIDs = Sets.newHashSet();

    public ActivityMarker allRead() {
        this.allRead = true;
        return this;
    }

    public ActivityMarker allSeen() {
        this.allSeen = true;
        return this;
    }

    public ActivityMarker read(String ... activityIDs) {
        if (!this.allRead && activityIDs != null) {
            this.readIDs = Sets.union(this.readIDs, (Set)ImmutableSet.copyOf((Object[])activityIDs));
        }
        return this;
    }

    public ActivityMarker read(Iterable<String> activityIDs) {
        return this.read((String[])Iterables.toArray((Iterable)((Iterable)Preconditions.checkNotNull(activityIDs)), String.class));
    }

    public ActivityMarker seen(String ... activityIDs) {
        if (!this.allSeen && activityIDs != null) {
            this.seenIDs = Sets.union(this.seenIDs, (Set)ImmutableSet.copyOf((Object[])activityIDs));
        }
        return this;
    }

    public ActivityMarker seen(Iterable<String> activityIDs) {
        return this.seen((String[])Iterables.toArray((Iterable)((Iterable)Preconditions.checkNotNull(activityIDs)), String.class));
    }

    @Override
    public void apply(Request.Builder builder) {
        if (this.allRead) {
            builder.addQueryParameter("mark_read", "true");
        } else if (!this.readIDs.isEmpty()) {
            builder.addQueryParameter("mark_read", String.join((CharSequence)",", this.readIDs));
        }
        if (this.allSeen) {
            builder.addQueryParameter("mark_seen", "true");
        } else if (!this.seenIDs.isEmpty()) {
            builder.addQueryParameter("mark_seen", String.join((CharSequence)",", this.seenIDs));
        }
    }
}

