/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.ChannelType;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.FlagService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Flag {
    @JsonProperty(value="created_by_automod")
    @NotNull
    private Boolean createdByAutomod;
    @JsonProperty(value="user")
    @Nullable
    private User user;
    @JsonProperty(value="target_message_id")
    @Nullable
    private String targetMessageId;
    @JsonProperty(value="target_user")
    @Nullable
    private User targetUser;
    @JsonProperty(value="created_at")
    @NotNull
    private Date createdAt;
    @JsonProperty(value="updatedAt")
    @Nullable
    private Date updated_at;
    @JsonProperty(value="reviewed_at")
    @Nullable
    private Date reviewedAt;
    @JsonProperty(value="approved_at")
    @Nullable
    private Date approvedAt;
    @JsonProperty(value="rejected_at")
    @Nullable
    private Date rejectedAt;

    @NotNull
    public static FlagCreateRequestData.FlagCreateRequest create() {
        return new FlagCreateRequestData.FlagCreateRequest();
    }

    @NotNull
    public static FlagDeleteRequestData.FlagDeleteRequest delete() {
        return new FlagDeleteRequestData.FlagDeleteRequest();
    }

    @NotNull
    public static FlagMessageQueryRequestData.FlagMessageQueryRequest queryMessages() {
        return new FlagMessageQueryRequestData.FlagMessageQueryRequest();
    }

    @NotNull
    public static QueryFlagReportsRequestData.QueryFlagReportsRequest queryFlagReports() {
        return new QueryFlagReportsRequestData.QueryFlagReportsRequest();
    }

    @NotNull
    public static ReviewFlagReportRequestData.ReviewFlagReportRequest reviewFlagReport(String id) {
        return new ReviewFlagReportRequestData.ReviewFlagReportRequest(id);
    }

    @NotNull
    public Boolean getCreatedByAutomod() {
        return this.createdByAutomod;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public String getTargetMessageId() {
        return this.targetMessageId;
    }

    @Nullable
    public User getTargetUser() {
        return this.targetUser;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdated_at() {
        return this.updated_at;
    }

    @Nullable
    public Date getReviewedAt() {
        return this.reviewedAt;
    }

    @Nullable
    public Date getApprovedAt() {
        return this.approvedAt;
    }

    @Nullable
    public Date getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonProperty(value="created_by_automod")
    public void setCreatedByAutomod(@NotNull Boolean createdByAutomod) {
        if (createdByAutomod == null) {
            throw new NullPointerException("createdByAutomod is marked non-null but is null");
        }
        this.createdByAutomod = createdByAutomod;
    }

    @JsonProperty(value="user")
    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @JsonProperty(value="target_message_id")
    public void setTargetMessageId(@Nullable String targetMessageId) {
        this.targetMessageId = targetMessageId;
    }

    @JsonProperty(value="target_user")
    public void setTargetUser(@Nullable User targetUser) {
        this.targetUser = targetUser;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@NotNull Date createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updatedAt")
    public void setUpdated_at(@Nullable Date updated_at) {
        this.updated_at = updated_at;
    }

    @JsonProperty(value="reviewed_at")
    public void setReviewedAt(@Nullable Date reviewedAt) {
        this.reviewedAt = reviewedAt;
    }

    @JsonProperty(value="approved_at")
    public void setApprovedAt(@Nullable Date approvedAt) {
        this.approvedAt = approvedAt;
    }

    @JsonProperty(value="rejected_at")
    public void setRejectedAt(@Nullable Date rejectedAt) {
        this.rejectedAt = rejectedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flag)) {
            return false;
        }
        Flag other = (Flag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$createdByAutomod = this.getCreatedByAutomod();
        Boolean other$createdByAutomod = other.getCreatedByAutomod();
        if (this$createdByAutomod == null ? other$createdByAutomod != null : !((Object)this$createdByAutomod).equals(other$createdByAutomod)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$targetMessageId = this.getTargetMessageId();
        String other$targetMessageId = other.getTargetMessageId();
        if (this$targetMessageId == null ? other$targetMessageId != null : !this$targetMessageId.equals(other$targetMessageId)) {
            return false;
        }
        User this$targetUser = this.getTargetUser();
        User other$targetUser = other.getTargetUser();
        if (this$targetUser == null ? other$targetUser != null : !((Object)this$targetUser).equals(other$targetUser)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updated_at = this.getUpdated_at();
        Date other$updated_at = other.getUpdated_at();
        if (this$updated_at == null ? other$updated_at != null : !((Object)this$updated_at).equals(other$updated_at)) {
            return false;
        }
        Date this$reviewedAt = this.getReviewedAt();
        Date other$reviewedAt = other.getReviewedAt();
        if (this$reviewedAt == null ? other$reviewedAt != null : !((Object)this$reviewedAt).equals(other$reviewedAt)) {
            return false;
        }
        Date this$approvedAt = this.getApprovedAt();
        Date other$approvedAt = other.getApprovedAt();
        if (this$approvedAt == null ? other$approvedAt != null : !((Object)this$approvedAt).equals(other$approvedAt)) {
            return false;
        }
        Date this$rejectedAt = this.getRejectedAt();
        Date other$rejectedAt = other.getRejectedAt();
        return !(this$rejectedAt == null ? other$rejectedAt != null : !((Object)this$rejectedAt).equals(other$rejectedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Flag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $createdByAutomod = this.getCreatedByAutomod();
        result = result * 59 + ($createdByAutomod == null ? 43 : ((Object)$createdByAutomod).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $targetMessageId = this.getTargetMessageId();
        result = result * 59 + ($targetMessageId == null ? 43 : $targetMessageId.hashCode());
        User $targetUser = this.getTargetUser();
        result = result * 59 + ($targetUser == null ? 43 : ((Object)$targetUser).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updated_at = this.getUpdated_at();
        result = result * 59 + ($updated_at == null ? 43 : ((Object)$updated_at).hashCode());
        Date $reviewedAt = this.getReviewedAt();
        result = result * 59 + ($reviewedAt == null ? 43 : ((Object)$reviewedAt).hashCode());
        Date $approvedAt = this.getApprovedAt();
        result = result * 59 + ($approvedAt == null ? 43 : ((Object)$approvedAt).hashCode());
        Date $rejectedAt = this.getRejectedAt();
        result = result * 59 + ($rejectedAt == null ? 43 : ((Object)$rejectedAt).hashCode());
        return result;
    }

    public String toString() {
        return "Flag(createdByAutomod=" + this.getCreatedByAutomod() + ", user=" + this.getUser() + ", targetMessageId=" + this.getTargetMessageId() + ", targetUser=" + this.getTargetUser() + ", createdAt=" + this.getCreatedAt() + ", updated_at=" + this.getUpdated_at() + ", reviewedAt=" + this.getReviewedAt() + ", approvedAt=" + this.getApprovedAt() + ", rejectedAt=" + this.getRejectedAt() + ")";
    }

    public static class ReviewFlagReportResponse
    extends StreamResponseObject {
        @JsonProperty(value="flag_report")
        @NotNull
        private ExtendedFlagReport flagReport;

        @NotNull
        public ExtendedFlagReport getFlagReport() {
            return this.flagReport;
        }

        @JsonProperty(value="flag_report")
        public void setFlagReport(@NotNull ExtendedFlagReport flagReport) {
            if (flagReport == null) {
                throw new NullPointerException("flagReport is marked non-null but is null");
            }
            this.flagReport = flagReport;
        }

        @Override
        public String toString() {
            return "Flag.ReviewFlagReportResponse(flagReport=" + this.getFlagReport() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReviewFlagReportResponse)) {
                return false;
            }
            ReviewFlagReportResponse other = (ReviewFlagReportResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtendedFlagReport this$flagReport = this.getFlagReport();
            ExtendedFlagReport other$flagReport = other.getFlagReport();
            return !(this$flagReport == null ? other$flagReport != null : !((Object)this$flagReport).equals(other$flagReport));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReviewFlagReportResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            ExtendedFlagReport $flagReport = this.getFlagReport();
            result = result * 59 + ($flagReport == null ? 43 : ((Object)$flagReport).hashCode());
            return result;
        }
    }

    public static class QueryFlagReportsResponse
    extends StreamResponseObject {
        @JsonProperty(value="flag_reports")
        @NotNull
        private List<FlagReport> flagReports;

        @NotNull
        public List<FlagReport> getFlagReports() {
            return this.flagReports;
        }

        @JsonProperty(value="flag_reports")
        public void setFlagReports(@NotNull List<FlagReport> flagReports) {
            if (flagReports == null) {
                throw new NullPointerException("flagReports is marked non-null but is null");
            }
            this.flagReports = flagReports;
        }

        @Override
        public String toString() {
            return "Flag.QueryFlagReportsResponse(flagReports=" + this.getFlagReports() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryFlagReportsResponse)) {
                return false;
            }
            QueryFlagReportsResponse other = (QueryFlagReportsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<FlagReport> this$flagReports = this.getFlagReports();
            List<FlagReport> other$flagReports = other.getFlagReports();
            return !(this$flagReports == null ? other$flagReports != null : !((Object)this$flagReports).equals(other$flagReports));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof QueryFlagReportsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<FlagReport> $flagReports = this.getFlagReports();
            result = result * 59 + ($flagReports == null ? 43 : ((Object)$flagReports).hashCode());
            return result;
        }
    }

    public static class FlagMessageQueryResponse
    extends StreamResponseObject {
        @JsonProperty(value="flags")
        @NotNull
        private List<MessageFlag> flags;

        @NotNull
        public List<MessageFlag> getFlags() {
            return this.flags;
        }

        @JsonProperty(value="flags")
        public void setFlags(@NotNull List<MessageFlag> flags) {
            if (flags == null) {
                throw new NullPointerException("flags is marked non-null but is null");
            }
            this.flags = flags;
        }

        @Override
        public String toString() {
            return "Flag.FlagMessageQueryResponse(flags=" + this.getFlags() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlagMessageQueryResponse)) {
                return false;
            }
            FlagMessageQueryResponse other = (FlagMessageQueryResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<MessageFlag> this$flags = this.getFlags();
            List<MessageFlag> other$flags = other.getFlags();
            return !(this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof FlagMessageQueryResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<MessageFlag> $flags = this.getFlags();
            result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
            return result;
        }
    }

    public static class FlagDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="flag")
        @NotNull
        private Flag flag;

        @NotNull
        public Flag getFlag() {
            return this.flag;
        }

        @JsonProperty(value="flag")
        public void setFlag(@NotNull Flag flag) {
            if (flag == null) {
                throw new NullPointerException("flag is marked non-null but is null");
            }
            this.flag = flag;
        }

        @Override
        public String toString() {
            return "Flag.FlagDeleteResponse(flag=" + this.getFlag() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlagDeleteResponse)) {
                return false;
            }
            FlagDeleteResponse other = (FlagDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Flag this$flag = this.getFlag();
            Flag other$flag = other.getFlag();
            return !(this$flag == null ? other$flag != null : !((Object)this$flag).equals(other$flag));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof FlagDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Flag $flag = this.getFlag();
            result = result * 59 + ($flag == null ? 43 : ((Object)$flag).hashCode());
            return result;
        }
    }

    public static class FlagCreateResponse
    extends StreamResponseObject {
        @JsonProperty(value="flag")
        @NotNull
        private Flag flag;

        @NotNull
        public Flag getFlag() {
            return this.flag;
        }

        @JsonProperty(value="flag")
        public void setFlag(@NotNull Flag flag) {
            if (flag == null) {
                throw new NullPointerException("flag is marked non-null but is null");
            }
            this.flag = flag;
        }

        @Override
        public String toString() {
            return "Flag.FlagCreateResponse(flag=" + this.getFlag() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlagCreateResponse)) {
                return false;
            }
            FlagCreateResponse other = (FlagCreateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Flag this$flag = this.getFlag();
            Flag other$flag = other.getFlag();
            return !(this$flag == null ? other$flag != null : !((Object)this$flag).equals(other$flag));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof FlagCreateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Flag $flag = this.getFlag();
            result = result * 59 + ($flag == null ? 43 : ((Object)$flag).hashCode());
            return result;
        }
    }

    public static class ReviewFlagReportRequestData {
        @JsonProperty(value="review_result")
        @NotNull
        private String reviewResult;
        @JsonProperty(value="review_details")
        @Nullable
        private Map<String, Object> reviewDetails;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        ReviewFlagReportRequestData(@NotNull String reviewResult, @Nullable Map<String, Object> reviewDetails, @Nullable String userId) {
            if (reviewResult == null) {
                throw new NullPointerException("reviewResult is marked non-null but is null");
            }
            this.reviewResult = reviewResult;
            this.reviewDetails = reviewDetails;
            this.userId = userId;
        }

        public static class ReviewFlagReportRequest
        extends StreamRequest<ReviewFlagReportResponse> {
            private String reviewResult;
            private Map<String, Object> reviewDetails;
            private String userId;
            @NotNull
            private String id;

            public ReviewFlagReportRequest(@NotNull String id) {
                this.id = id;
            }

            @Override
            protected Call<ReviewFlagReportResponse> generateCall(Client client) {
                return client.create(FlagService.class).reviewFlagReport(this.id, this.internalBuild());
            }

            @JsonProperty(value="review_result")
            public ReviewFlagReportRequest reviewResult(@NotNull String reviewResult) {
                this.reviewResult = reviewResult;
                return this;
            }

            @JsonProperty(value="review_details")
            public ReviewFlagReportRequest reviewDetails(@Nullable Map<String, Object> reviewDetails) {
                this.reviewDetails = reviewDetails;
                return this;
            }

            @JsonProperty(value="user_id")
            public ReviewFlagReportRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            public ReviewFlagReportRequestData internalBuild() {
                return new ReviewFlagReportRequestData(this.reviewResult, this.reviewDetails, this.userId);
            }

            public String toString() {
                return "Flag.ReviewFlagReportRequestData.ReviewFlagReportRequest(reviewResult=" + this.reviewResult + ", reviewDetails=" + this.reviewDetails + ", userId=" + this.userId + ")";
            }
        }
    }

    public static class QueryFlagReportsRequestData {
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        QueryFlagReportsRequestData(@Nullable Map<String, Object> filterConditions, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.filterConditions = filterConditions;
            this.limit = limit;
            this.offset = offset;
            this.userId = userId;
            this.user = user;
        }

        public static class QueryFlagReportsRequest
        extends StreamRequest<QueryFlagReportsResponse> {
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private Integer limit;
            private Integer offset;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<QueryFlagReportsResponse> generateCall(Client client) {
                return client.create(FlagService.class).queryFlagReports(this.internalBuild());
            }

            QueryFlagReportsRequest() {
            }

            public QueryFlagReportsRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public QueryFlagReportsRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public QueryFlagReportsRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public QueryFlagReportsRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public QueryFlagReportsRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id")
            public QueryFlagReportsRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public QueryFlagReportsRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public QueryFlagReportsRequestData internalBuild() {
                Map<String, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                return new QueryFlagReportsRequestData(filterConditions, this.limit, this.offset, this.userId, this.user);
            }

            public String toString() {
                return "Flag.QueryFlagReportsRequestData.QueryFlagReportsRequest(filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class FlagMessageQueryRequestData {
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        FlagMessageQueryRequestData(@Nullable Map<String, Object> filterConditions, @Nullable Integer limit, @Nullable Integer offset, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.filterConditions = filterConditions;
            this.limit = limit;
            this.offset = offset;
            this.userId = userId;
            this.user = user;
        }

        public static class FlagMessageQueryRequest
        extends StreamRequest<FlagMessageQueryResponse> {
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private Integer limit;
            private Integer offset;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<FlagMessageQueryResponse> generateCall(Client client) {
                return client.create(FlagService.class).messageQuery(this.internalBuild());
            }

            FlagMessageQueryRequest() {
            }

            public FlagMessageQueryRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public FlagMessageQueryRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public FlagMessageQueryRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public FlagMessageQueryRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public FlagMessageQueryRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="user_id")
            public FlagMessageQueryRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public FlagMessageQueryRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public FlagMessageQueryRequestData internalBuild() {
                Map<String, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                return new FlagMessageQueryRequestData(filterConditions, this.limit, this.offset, this.userId, this.user);
            }

            public String toString() {
                return "Flag.FlagMessageQueryRequestData.FlagMessageQueryRequest(filterConditions$key=" + this.filterConditions$key + ", filterConditions$value=" + this.filterConditions$value + ", limit=" + this.limit + ", offset=" + this.offset + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class FlagDeleteRequestData {
        @JsonProperty(value="target_message_id")
        @Nullable
        private String targetMessageId;
        @JsonProperty(value="target_user_id")
        @Nullable
        private String targetUserId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        FlagDeleteRequestData(@Nullable String targetMessageId, @Nullable String targetUserId, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.targetMessageId = targetMessageId;
            this.targetUserId = targetUserId;
            this.userId = userId;
            this.user = user;
        }

        public static class FlagDeleteRequest
        extends StreamRequest<FlagDeleteResponse> {
            private String targetMessageId;
            private String targetUserId;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<FlagDeleteResponse> generateCall(Client client) {
                return client.create(FlagService.class).delete(this.internalBuild());
            }

            FlagDeleteRequest() {
            }

            @JsonProperty(value="target_message_id")
            public FlagDeleteRequest targetMessageId(@Nullable String targetMessageId) {
                this.targetMessageId = targetMessageId;
                return this;
            }

            @JsonProperty(value="target_user_id")
            public FlagDeleteRequest targetUserId(@Nullable String targetUserId) {
                this.targetUserId = targetUserId;
                return this;
            }

            @JsonProperty(value="user_id")
            public FlagDeleteRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public FlagDeleteRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public FlagDeleteRequestData internalBuild() {
                return new FlagDeleteRequestData(this.targetMessageId, this.targetUserId, this.userId, this.user);
            }

            public String toString() {
                return "Flag.FlagDeleteRequestData.FlagDeleteRequest(targetMessageId=" + this.targetMessageId + ", targetUserId=" + this.targetUserId + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class FlagCreateRequestData {
        @JsonProperty(value="target_message_id")
        @Nullable
        private String targetMessageId;
        @JsonProperty(value="target_user_id")
        @Nullable
        private String targetUserId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        FlagCreateRequestData(@Nullable String targetMessageId, @Nullable String targetUserId, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.targetMessageId = targetMessageId;
            this.targetUserId = targetUserId;
            this.userId = userId;
            this.user = user;
        }

        public static class FlagCreateRequest
        extends StreamRequest<FlagCreateResponse> {
            private String targetMessageId;
            private String targetUserId;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<FlagCreateResponse> generateCall(Client client) {
                return client.create(FlagService.class).create(this.internalBuild());
            }

            FlagCreateRequest() {
            }

            @JsonProperty(value="target_message_id")
            public FlagCreateRequest targetMessageId(@Nullable String targetMessageId) {
                this.targetMessageId = targetMessageId;
                return this;
            }

            @JsonProperty(value="target_user_id")
            public FlagCreateRequest targetUserId(@Nullable String targetUserId) {
                this.targetUserId = targetUserId;
                return this;
            }

            @JsonProperty(value="user_id")
            public FlagCreateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public FlagCreateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public FlagCreateRequestData internalBuild() {
                return new FlagCreateRequestData(this.targetMessageId, this.targetUserId, this.userId, this.user);
            }

            public String toString() {
                return "Flag.FlagCreateRequestData.FlagCreateRequest(targetMessageId=" + this.targetMessageId + ", targetUserId=" + this.targetUserId + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class Thresholds {
        private ChannelType.Threshold explicit;
        private ChannelType.Threshold spam;
        private ChannelType.Threshold toxic;

        public ChannelType.Threshold getExplicit() {
            return this.explicit;
        }

        public ChannelType.Threshold getSpam() {
            return this.spam;
        }

        public ChannelType.Threshold getToxic() {
            return this.toxic;
        }

        public void setExplicit(ChannelType.Threshold explicit) {
            this.explicit = explicit;
        }

        public void setSpam(ChannelType.Threshold spam) {
            this.spam = spam;
        }

        public void setToxic(ChannelType.Threshold toxic) {
            this.toxic = toxic;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Thresholds)) {
                return false;
            }
            Thresholds other = (Thresholds)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ChannelType.Threshold this$explicit = this.getExplicit();
            ChannelType.Threshold other$explicit = other.getExplicit();
            if (this$explicit == null ? other$explicit != null : !((Object)this$explicit).equals(other$explicit)) {
                return false;
            }
            ChannelType.Threshold this$spam = this.getSpam();
            ChannelType.Threshold other$spam = other.getSpam();
            if (this$spam == null ? other$spam != null : !((Object)this$spam).equals(other$spam)) {
                return false;
            }
            ChannelType.Threshold this$toxic = this.getToxic();
            ChannelType.Threshold other$toxic = other.getToxic();
            return !(this$toxic == null ? other$toxic != null : !((Object)this$toxic).equals(other$toxic));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Thresholds;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ChannelType.Threshold $explicit = this.getExplicit();
            result = result * 59 + ($explicit == null ? 43 : ((Object)$explicit).hashCode());
            ChannelType.Threshold $spam = this.getSpam();
            result = result * 59 + ($spam == null ? 43 : ((Object)$spam).hashCode());
            ChannelType.Threshold $toxic = this.getToxic();
            result = result * 59 + ($toxic == null ? 43 : ((Object)$toxic).hashCode());
            return result;
        }

        public String toString() {
            return "Flag.Thresholds(explicit=" + this.getExplicit() + ", spam=" + this.getSpam() + ", toxic=" + this.getToxic() + ")";
        }
    }

    public static class MessageModerationResult {
        @JsonProperty(value="message_id")
        @Nullable
        private String message_id;
        @JsonProperty(value="action")
        @Nullable
        private String action;
        @JsonProperty(value="moderated_by")
        @Nullable
        private String moderatedBy;
        @JsonProperty(value="blocked_word")
        @Nullable
        private String blockedWord;
        @JsonProperty(value="blocklist_name")
        @Nullable
        private String blocklistName;
        @JsonProperty(value="moderation_thresholds")
        @Nullable
        private Thresholds moderationThresholds;
        @JsonProperty(value="ai_moderation_response")
        @Nullable
        private Message.Moderation aiModerationResponse;
        @JsonProperty(value="user_karma")
        @Nullable
        private Integer userKarma;
        @JsonProperty(value="user_bad_karma")
        @Nullable
        private Boolean userBadKarma;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;

        @Nullable
        public String getMessage_id() {
            return this.message_id;
        }

        @Nullable
        public String getAction() {
            return this.action;
        }

        @Nullable
        public String getModeratedBy() {
            return this.moderatedBy;
        }

        @Nullable
        public String getBlockedWord() {
            return this.blockedWord;
        }

        @Nullable
        public String getBlocklistName() {
            return this.blocklistName;
        }

        @Nullable
        public Thresholds getModerationThresholds() {
            return this.moderationThresholds;
        }

        @Nullable
        public Message.Moderation getAiModerationResponse() {
            return this.aiModerationResponse;
        }

        @Nullable
        public Integer getUserKarma() {
            return this.userKarma;
        }

        @Nullable
        public Boolean getUserBadKarma() {
            return this.userBadKarma;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="message_id")
        public void setMessage_id(@Nullable String message_id) {
            this.message_id = message_id;
        }

        @JsonProperty(value="action")
        public void setAction(@Nullable String action) {
            this.action = action;
        }

        @JsonProperty(value="moderated_by")
        public void setModeratedBy(@Nullable String moderatedBy) {
            this.moderatedBy = moderatedBy;
        }

        @JsonProperty(value="blocked_word")
        public void setBlockedWord(@Nullable String blockedWord) {
            this.blockedWord = blockedWord;
        }

        @JsonProperty(value="blocklist_name")
        public void setBlocklistName(@Nullable String blocklistName) {
            this.blocklistName = blocklistName;
        }

        @JsonProperty(value="moderation_thresholds")
        public void setModerationThresholds(@Nullable Thresholds moderationThresholds) {
            this.moderationThresholds = moderationThresholds;
        }

        @JsonProperty(value="ai_moderation_response")
        public void setAiModerationResponse(@Nullable Message.Moderation aiModerationResponse) {
            this.aiModerationResponse = aiModerationResponse;
        }

        @JsonProperty(value="user_karma")
        public void setUserKarma(@Nullable Integer userKarma) {
            this.userKarma = userKarma;
        }

        @JsonProperty(value="user_bad_karma")
        public void setUserBadKarma(@Nullable Boolean userBadKarma) {
            this.userBadKarma = userBadKarma;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageModerationResult)) {
                return false;
            }
            MessageModerationResult other = (MessageModerationResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$userKarma = this.getUserKarma();
            Integer other$userKarma = other.getUserKarma();
            if (this$userKarma == null ? other$userKarma != null : !((Object)this$userKarma).equals(other$userKarma)) {
                return false;
            }
            Boolean this$userBadKarma = this.getUserBadKarma();
            Boolean other$userBadKarma = other.getUserBadKarma();
            if (this$userBadKarma == null ? other$userBadKarma != null : !((Object)this$userBadKarma).equals(other$userBadKarma)) {
                return false;
            }
            String this$message_id = this.getMessage_id();
            String other$message_id = other.getMessage_id();
            if (this$message_id == null ? other$message_id != null : !this$message_id.equals(other$message_id)) {
                return false;
            }
            String this$action = this.getAction();
            String other$action = other.getAction();
            if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
                return false;
            }
            String this$moderatedBy = this.getModeratedBy();
            String other$moderatedBy = other.getModeratedBy();
            if (this$moderatedBy == null ? other$moderatedBy != null : !this$moderatedBy.equals(other$moderatedBy)) {
                return false;
            }
            String this$blockedWord = this.getBlockedWord();
            String other$blockedWord = other.getBlockedWord();
            if (this$blockedWord == null ? other$blockedWord != null : !this$blockedWord.equals(other$blockedWord)) {
                return false;
            }
            String this$blocklistName = this.getBlocklistName();
            String other$blocklistName = other.getBlocklistName();
            if (this$blocklistName == null ? other$blocklistName != null : !this$blocklistName.equals(other$blocklistName)) {
                return false;
            }
            Thresholds this$moderationThresholds = this.getModerationThresholds();
            Thresholds other$moderationThresholds = other.getModerationThresholds();
            if (this$moderationThresholds == null ? other$moderationThresholds != null : !((Object)this$moderationThresholds).equals(other$moderationThresholds)) {
                return false;
            }
            Message.Moderation this$aiModerationResponse = this.getAiModerationResponse();
            Message.Moderation other$aiModerationResponse = other.getAiModerationResponse();
            if (this$aiModerationResponse == null ? other$aiModerationResponse != null : !((Object)this$aiModerationResponse).equals(other$aiModerationResponse)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageModerationResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $userKarma = this.getUserKarma();
            result = result * 59 + ($userKarma == null ? 43 : ((Object)$userKarma).hashCode());
            Boolean $userBadKarma = this.getUserBadKarma();
            result = result * 59 + ($userBadKarma == null ? 43 : ((Object)$userBadKarma).hashCode());
            String $message_id = this.getMessage_id();
            result = result * 59 + ($message_id == null ? 43 : $message_id.hashCode());
            String $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : $action.hashCode());
            String $moderatedBy = this.getModeratedBy();
            result = result * 59 + ($moderatedBy == null ? 43 : $moderatedBy.hashCode());
            String $blockedWord = this.getBlockedWord();
            result = result * 59 + ($blockedWord == null ? 43 : $blockedWord.hashCode());
            String $blocklistName = this.getBlocklistName();
            result = result * 59 + ($blocklistName == null ? 43 : $blocklistName.hashCode());
            Thresholds $moderationThresholds = this.getModerationThresholds();
            result = result * 59 + ($moderationThresholds == null ? 43 : ((Object)$moderationThresholds).hashCode());
            Message.Moderation $aiModerationResponse = this.getAiModerationResponse();
            result = result * 59 + ($aiModerationResponse == null ? 43 : ((Object)$aiModerationResponse).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            return result;
        }

        public String toString() {
            return "Flag.MessageModerationResult(message_id=" + this.getMessage_id() + ", action=" + this.getAction() + ", moderatedBy=" + this.getModeratedBy() + ", blockedWord=" + this.getBlockedWord() + ", blocklistName=" + this.getBlocklistName() + ", moderationThresholds=" + this.getModerationThresholds() + ", aiModerationResponse=" + this.getAiModerationResponse() + ", userKarma=" + this.getUserKarma() + ", userBadKarma=" + this.getUserBadKarma() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
        }
    }

    public static class ExtendedFlagReport
    extends FlagReport {
        @JsonProperty(value="review_result")
        @NotNull
        private String reviewResult;
        @JsonProperty(value="review_details")
        @Nullable
        private Map<String, Object> reviewDetails;

        @NotNull
        public String getReviewResult() {
            return this.reviewResult;
        }

        @Nullable
        public Map<String, Object> getReviewDetails() {
            return this.reviewDetails;
        }

        @JsonProperty(value="review_result")
        public void setReviewResult(@NotNull String reviewResult) {
            if (reviewResult == null) {
                throw new NullPointerException("reviewResult is marked non-null but is null");
            }
            this.reviewResult = reviewResult;
        }

        @JsonProperty(value="review_details")
        public void setReviewDetails(@Nullable Map<String, Object> reviewDetails) {
            this.reviewDetails = reviewDetails;
        }

        @Override
        public String toString() {
            return "Flag.ExtendedFlagReport(reviewResult=" + this.getReviewResult() + ", reviewDetails=" + this.getReviewDetails() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtendedFlagReport)) {
                return false;
            }
            ExtendedFlagReport other = (ExtendedFlagReport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$reviewResult = this.getReviewResult();
            String other$reviewResult = other.getReviewResult();
            if (this$reviewResult == null ? other$reviewResult != null : !this$reviewResult.equals(other$reviewResult)) {
                return false;
            }
            Map<String, Object> this$reviewDetails = this.getReviewDetails();
            Map<String, Object> other$reviewDetails = other.getReviewDetails();
            return !(this$reviewDetails == null ? other$reviewDetails != null : !((Object)this$reviewDetails).equals(other$reviewDetails));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ExtendedFlagReport;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $reviewResult = this.getReviewResult();
            result = result * 59 + ($reviewResult == null ? 43 : $reviewResult.hashCode());
            Map<String, Object> $reviewDetails = this.getReviewDetails();
            result = result * 59 + ($reviewDetails == null ? 43 : ((Object)$reviewDetails).hashCode());
            return result;
        }
    }

    public static class FlagReport {
        @JsonProperty(value="id")
        @NotNull
        private String Id;
        @JsonProperty(value="message")
        @Nullable
        private Message message;
        @JsonProperty(value="flags_count")
        @Nullable
        private Integer flagsCount;
        @JsonProperty(value="message_user_id")
        @Nullable
        private String messageUserId;
        @JsonProperty(value="channel_cid")
        @Nullable
        private String channelCid;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;

        @NotNull
        public String getId() {
            return this.Id;
        }

        @Nullable
        public Message getMessage() {
            return this.message;
        }

        @Nullable
        public Integer getFlagsCount() {
            return this.flagsCount;
        }

        @Nullable
        public String getMessageUserId() {
            return this.messageUserId;
        }

        @Nullable
        public String getChannelCid() {
            return this.channelCid;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="id")
        public void setId(@NotNull String Id) {
            if (Id == null) {
                throw new NullPointerException("Id is marked non-null but is null");
            }
            this.Id = Id;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable Message message) {
            this.message = message;
        }

        @JsonProperty(value="flags_count")
        public void setFlagsCount(@Nullable Integer flagsCount) {
            this.flagsCount = flagsCount;
        }

        @JsonProperty(value="message_user_id")
        public void setMessageUserId(@Nullable String messageUserId) {
            this.messageUserId = messageUserId;
        }

        @JsonProperty(value="channel_cid")
        public void setChannelCid(@Nullable String channelCid) {
            this.channelCid = channelCid;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FlagReport)) {
                return false;
            }
            FlagReport other = (FlagReport)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$flagsCount = this.getFlagsCount();
            Integer other$flagsCount = other.getFlagsCount();
            if (this$flagsCount == null ? other$flagsCount != null : !((Object)this$flagsCount).equals(other$flagsCount)) {
                return false;
            }
            String this$Id = this.getId();
            String other$Id = other.getId();
            if (this$Id == null ? other$Id != null : !this$Id.equals(other$Id)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            String this$messageUserId = this.getMessageUserId();
            String other$messageUserId = other.getMessageUserId();
            if (this$messageUserId == null ? other$messageUserId != null : !this$messageUserId.equals(other$messageUserId)) {
                return false;
            }
            String this$channelCid = this.getChannelCid();
            String other$channelCid = other.getChannelCid();
            if (this$channelCid == null ? other$channelCid != null : !this$channelCid.equals(other$channelCid)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FlagReport;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $flagsCount = this.getFlagsCount();
            result = result * 59 + ($flagsCount == null ? 43 : ((Object)$flagsCount).hashCode());
            String $Id = this.getId();
            result = result * 59 + ($Id == null ? 43 : $Id.hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            String $messageUserId = this.getMessageUserId();
            result = result * 59 + ($messageUserId == null ? 43 : $messageUserId.hashCode());
            String $channelCid = this.getChannelCid();
            result = result * 59 + ($channelCid == null ? 43 : $channelCid.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            return result;
        }

        public String toString() {
            return "Flag.FlagReport(Id=" + this.getId() + ", message=" + this.getMessage() + ", flagsCount=" + this.getFlagsCount() + ", messageUserId=" + this.getMessageUserId() + ", channelCid=" + this.getChannelCid() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
        }
    }

    public static class MessageFlag {
        @JsonProperty(value="created_by_automod")
        @NotNull
        private Boolean createdByAutomod;
        @JsonProperty(value="moderation_result")
        @NotNull
        private MessageModerationResult moderationResult;
        @JsonProperty(value="user")
        @Nullable
        private User user;
        @JsonProperty(value="message")
        @Nullable
        private Message message;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updatedAt")
        @Nullable
        private Date updated_at;
        @JsonProperty(value="reviewed_at")
        @Nullable
        private Date reviewedAt;
        @JsonProperty(value="reviewed_by")
        @Nullable
        private User reviewedBy;
        @JsonProperty(value="approved_at")
        @Nullable
        private Date approvedAt;
        @JsonProperty(value="rejected_at")
        @Nullable
        private Date rejectedAt;

        @NotNull
        public Boolean getCreatedByAutomod() {
            return this.createdByAutomod;
        }

        @NotNull
        public MessageModerationResult getModerationResult() {
            return this.moderationResult;
        }

        @Nullable
        public User getUser() {
            return this.user;
        }

        @Nullable
        public Message getMessage() {
            return this.message;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdated_at() {
            return this.updated_at;
        }

        @Nullable
        public Date getReviewedAt() {
            return this.reviewedAt;
        }

        @Nullable
        public User getReviewedBy() {
            return this.reviewedBy;
        }

        @Nullable
        public Date getApprovedAt() {
            return this.approvedAt;
        }

        @Nullable
        public Date getRejectedAt() {
            return this.rejectedAt;
        }

        @JsonProperty(value="created_by_automod")
        public void setCreatedByAutomod(@NotNull Boolean createdByAutomod) {
            if (createdByAutomod == null) {
                throw new NullPointerException("createdByAutomod is marked non-null but is null");
            }
            this.createdByAutomod = createdByAutomod;
        }

        @JsonProperty(value="moderation_result")
        public void setModerationResult(@NotNull MessageModerationResult moderationResult) {
            if (moderationResult == null) {
                throw new NullPointerException("moderationResult is marked non-null but is null");
            }
            this.moderationResult = moderationResult;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User user) {
            this.user = user;
        }

        @JsonProperty(value="message")
        public void setMessage(@Nullable Message message) {
            this.message = message;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updatedAt")
        public void setUpdated_at(@Nullable Date updated_at) {
            this.updated_at = updated_at;
        }

        @JsonProperty(value="reviewed_at")
        public void setReviewedAt(@Nullable Date reviewedAt) {
            this.reviewedAt = reviewedAt;
        }

        @JsonProperty(value="reviewed_by")
        public void setReviewedBy(@Nullable User reviewedBy) {
            this.reviewedBy = reviewedBy;
        }

        @JsonProperty(value="approved_at")
        public void setApprovedAt(@Nullable Date approvedAt) {
            this.approvedAt = approvedAt;
        }

        @JsonProperty(value="rejected_at")
        public void setRejectedAt(@Nullable Date rejectedAt) {
            this.rejectedAt = rejectedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageFlag)) {
                return false;
            }
            MessageFlag other = (MessageFlag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$createdByAutomod = this.getCreatedByAutomod();
            Boolean other$createdByAutomod = other.getCreatedByAutomod();
            if (this$createdByAutomod == null ? other$createdByAutomod != null : !((Object)this$createdByAutomod).equals(other$createdByAutomod)) {
                return false;
            }
            MessageModerationResult this$moderationResult = this.getModerationResult();
            MessageModerationResult other$moderationResult = other.getModerationResult();
            if (this$moderationResult == null ? other$moderationResult != null : !((Object)this$moderationResult).equals(other$moderationResult)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updated_at = this.getUpdated_at();
            Date other$updated_at = other.getUpdated_at();
            if (this$updated_at == null ? other$updated_at != null : !((Object)this$updated_at).equals(other$updated_at)) {
                return false;
            }
            Date this$reviewedAt = this.getReviewedAt();
            Date other$reviewedAt = other.getReviewedAt();
            if (this$reviewedAt == null ? other$reviewedAt != null : !((Object)this$reviewedAt).equals(other$reviewedAt)) {
                return false;
            }
            User this$reviewedBy = this.getReviewedBy();
            User other$reviewedBy = other.getReviewedBy();
            if (this$reviewedBy == null ? other$reviewedBy != null : !((Object)this$reviewedBy).equals(other$reviewedBy)) {
                return false;
            }
            Date this$approvedAt = this.getApprovedAt();
            Date other$approvedAt = other.getApprovedAt();
            if (this$approvedAt == null ? other$approvedAt != null : !((Object)this$approvedAt).equals(other$approvedAt)) {
                return false;
            }
            Date this$rejectedAt = this.getRejectedAt();
            Date other$rejectedAt = other.getRejectedAt();
            return !(this$rejectedAt == null ? other$rejectedAt != null : !((Object)this$rejectedAt).equals(other$rejectedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageFlag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $createdByAutomod = this.getCreatedByAutomod();
            result = result * 59 + ($createdByAutomod == null ? 43 : ((Object)$createdByAutomod).hashCode());
            MessageModerationResult $moderationResult = this.getModerationResult();
            result = result * 59 + ($moderationResult == null ? 43 : ((Object)$moderationResult).hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updated_at = this.getUpdated_at();
            result = result * 59 + ($updated_at == null ? 43 : ((Object)$updated_at).hashCode());
            Date $reviewedAt = this.getReviewedAt();
            result = result * 59 + ($reviewedAt == null ? 43 : ((Object)$reviewedAt).hashCode());
            User $reviewedBy = this.getReviewedBy();
            result = result * 59 + ($reviewedBy == null ? 43 : ((Object)$reviewedBy).hashCode());
            Date $approvedAt = this.getApprovedAt();
            result = result * 59 + ($approvedAt == null ? 43 : ((Object)$approvedAt).hashCode());
            Date $rejectedAt = this.getRejectedAt();
            result = result * 59 + ($rejectedAt == null ? 43 : ((Object)$rejectedAt).hashCode());
            return result;
        }

        public String toString() {
            return "Flag.MessageFlag(createdByAutomod=" + this.getCreatedByAutomod() + ", moderationResult=" + this.getModerationResult() + ", user=" + this.getUser() + ", message=" + this.getMessage() + ", createdAt=" + this.getCreatedAt() + ", updated_at=" + this.getUpdated_at() + ", reviewedAt=" + this.getReviewedAt() + ", reviewedBy=" + this.getReviewedBy() + ", approvedAt=" + this.getApprovedAt() + ", rejectedAt=" + this.getRejectedAt() + ")";
        }
    }
}

