/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ImportService;
import io.getstream.chat.java.services.framework.Client;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Import {
    @JsonProperty(value="id")
    @Nullable
    private String id;
    @JsonProperty(value="path")
    @Nullable
    private String path;
    @JsonProperty(value="mode")
    @Nullable
    private ImportMode mode;
    @JsonProperty(value="state")
    @Nullable
    private ImportState state;
    @JsonProperty(value="history")
    @Nullable
    private List<ImportHistoryItem> history;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Nullable
    private Date updatedAt;

    @NotNull
    public static CreateImportUrlRequestData.CreateImportUrlRequest createImportUrl(@NotNull String fileName) {
        return new CreateImportUrlRequestData.CreateImportUrlRequest().fileName(fileName);
    }

    @NotNull
    public static CreateImportRequestData.CreateImportRequest createImport(@NotNull String path, @Nullable ImportMode mode) {
        return new CreateImportRequestData.CreateImportRequest().path(path).mode(mode);
    }

    @NotNull
    public static GetImportRequest getImport(@NotNull String id) {
        return new GetImportRequest(id);
    }

    @NotNull
    public static ListImportsRequest listImports(@Nullable Integer limit, @Nullable Integer offset) {
        return new ListImportsRequest(limit, offset);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public ImportMode getMode() {
        return this.mode;
    }

    @Nullable
    public ImportState getState() {
        return this.state;
    }

    @Nullable
    public List<ImportHistoryItem> getHistory() {
        return this.history;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="id")
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @JsonProperty(value="path")
    public void setPath(@Nullable String path) {
        this.path = path;
    }

    @JsonProperty(value="mode")
    public void setMode(@Nullable ImportMode mode) {
        this.mode = mode;
    }

    @JsonProperty(value="state")
    public void setState(@Nullable ImportState state) {
        this.state = state;
    }

    @JsonProperty(value="history")
    public void setHistory(@Nullable List<ImportHistoryItem> history) {
        this.history = history;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Import)) {
            return false;
        }
        Import other = (Import)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        ImportMode this$mode = this.getMode();
        ImportMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        ImportState this$state = this.getState();
        ImportState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        List<ImportHistoryItem> this$history = this.getHistory();
        List<ImportHistoryItem> other$history = other.getHistory();
        if (this$history == null ? other$history != null : !((Object)this$history).equals(other$history)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Import;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        ImportMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        ImportState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        List<ImportHistoryItem> $history = this.getHistory();
        result = result * 59 + ($history == null ? 43 : ((Object)$history).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "Import(id=" + this.getId() + ", path=" + this.getPath() + ", mode=" + this.getMode() + ", state=" + this.getState() + ", history=" + this.getHistory() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public static class ImportHistoryItem {
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="prev_state")
        @NotNull
        private String prevState;
        @JsonProperty(value="next_state")
        @NotNull
        private String nextState;

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public String getPrevState() {
            return this.prevState;
        }

        @NotNull
        public String getNextState() {
            return this.nextState;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="prev_state")
        public void setPrevState(@NotNull String prevState) {
            if (prevState == null) {
                throw new NullPointerException("prevState is marked non-null but is null");
            }
            this.prevState = prevState;
        }

        @JsonProperty(value="next_state")
        public void setNextState(@NotNull String nextState) {
            if (nextState == null) {
                throw new NullPointerException("nextState is marked non-null but is null");
            }
            this.nextState = nextState;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImportHistoryItem)) {
                return false;
            }
            ImportHistoryItem other = (ImportHistoryItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            String this$prevState = this.getPrevState();
            String other$prevState = other.getPrevState();
            if (this$prevState == null ? other$prevState != null : !this$prevState.equals(other$prevState)) {
                return false;
            }
            String this$nextState = this.getNextState();
            String other$nextState = other.getNextState();
            return !(this$nextState == null ? other$nextState != null : !this$nextState.equals(other$nextState));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImportHistoryItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            String $prevState = this.getPrevState();
            result = result * 59 + ($prevState == null ? 43 : $prevState.hashCode());
            String $nextState = this.getNextState();
            result = result * 59 + ($nextState == null ? 43 : $nextState.hashCode());
            return result;
        }

        public String toString() {
            return "Import.ImportHistoryItem(createdAt=" + this.getCreatedAt() + ", prevState=" + this.getPrevState() + ", nextState=" + this.getNextState() + ")";
        }
    }

    public static class ListImportsResponse
    extends StreamResponseObject {
        @JsonProperty(value="import_tasks")
        @NotNull
        private List<Import> importTasks;

        @NotNull
        public List<Import> getImportTasks() {
            return this.importTasks;
        }

        @JsonProperty(value="import_tasks")
        public void setImportTasks(@NotNull List<Import> importTasks) {
            if (importTasks == null) {
                throw new NullPointerException("importTasks is marked non-null but is null");
            }
            this.importTasks = importTasks;
        }

        @Override
        public String toString() {
            return "Import.ListImportsResponse(importTasks=" + this.getImportTasks() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListImportsResponse)) {
                return false;
            }
            ListImportsResponse other = (ListImportsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Import> this$importTasks = this.getImportTasks();
            List<Import> other$importTasks = other.getImportTasks();
            return !(this$importTasks == null ? other$importTasks != null : !((Object)this$importTasks).equals(other$importTasks));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ListImportsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Import> $importTasks = this.getImportTasks();
            result = result * 59 + ($importTasks == null ? 43 : ((Object)$importTasks).hashCode());
            return result;
        }
    }

    public static class GetImportResponse
    extends CreateImportResponse {
    }

    public static class ListImportsRequest
    extends StreamRequest<ListImportsResponse> {
        private final Integer limit;
        private final Integer offset;

        public ListImportsRequest(Integer limit, Integer offset) {
            this.limit = limit;
            this.offset = offset;
        }

        @Override
        protected Call<ListImportsResponse> generateCall(Client client) {
            return client.create(ImportService.class).listImports(this.limit, this.offset);
        }
    }

    public static class GetImportRequest
    extends StreamRequest<GetImportResponse> {
        private final String id;

        public GetImportRequest(String id) {
            this.id = id;
        }

        @Override
        protected Call<GetImportResponse> generateCall(Client client) {
            return client.create(ImportService.class).getImport(this.id);
        }
    }

    public static class CreateImportResponse
    extends StreamResponseObject {
        @JsonProperty(value="import_task")
        @NotNull
        private Import importTask;

        @NotNull
        public Import getImportTask() {
            return this.importTask;
        }

        @JsonProperty(value="import_task")
        public void setImportTask(@NotNull Import importTask) {
            if (importTask == null) {
                throw new NullPointerException("importTask is marked non-null but is null");
            }
            this.importTask = importTask;
        }

        @Override
        public String toString() {
            return "Import.CreateImportResponse(importTask=" + this.getImportTask() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateImportResponse)) {
                return false;
            }
            CreateImportResponse other = (CreateImportResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Import this$importTask = this.getImportTask();
            Import other$importTask = other.getImportTask();
            return !(this$importTask == null ? other$importTask != null : !((Object)this$importTask).equals(other$importTask));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof CreateImportResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Import $importTask = this.getImportTask();
            result = result * 59 + ($importTask == null ? 43 : ((Object)$importTask).hashCode());
            return result;
        }
    }

    public static class CreateImportRequestData {
        @JsonProperty(value="path")
        @NotNull
        private String path;
        @JsonProperty(value="mode")
        @NotNull
        private ImportMode mode;

        CreateImportRequestData(@NotNull String path, @NotNull ImportMode mode) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (mode == null) {
                throw new NullPointerException("mode is marked non-null but is null");
            }
            this.path = path;
            this.mode = mode;
        }

        public static class CreateImportRequest
        extends StreamRequest<CreateImportResponse> {
            private String path;
            private ImportMode mode;

            @Override
            protected Call<CreateImportResponse> generateCall(Client client) {
                return client.create(ImportService.class).createImport(this.internalBuild());
            }

            CreateImportRequest() {
            }

            @JsonProperty(value="path")
            public CreateImportRequest path(@NotNull String path) {
                if (path == null) {
                    throw new NullPointerException("path is marked non-null but is null");
                }
                this.path = path;
                return this;
            }

            @JsonProperty(value="mode")
            public CreateImportRequest mode(@NotNull ImportMode mode) {
                if (mode == null) {
                    throw new NullPointerException("mode is marked non-null but is null");
                }
                this.mode = mode;
                return this;
            }

            public CreateImportRequestData internalBuild() {
                return new CreateImportRequestData(this.path, this.mode);
            }

            public String toString() {
                return "Import.CreateImportRequestData.CreateImportRequest(path=" + this.path + ", mode=" + this.mode + ")";
            }
        }
    }

    public static class CreateImportUrlResponse
    extends StreamResponseObject {
        @JsonProperty(value="upload_url")
        @NotNull
        private String uploadUrl;
        @JsonProperty(value="path")
        @NotNull
        private String path;

        @NotNull
        public String getUploadUrl() {
            return this.uploadUrl;
        }

        @NotNull
        public String getPath() {
            return this.path;
        }

        @JsonProperty(value="upload_url")
        public void setUploadUrl(@NotNull String uploadUrl) {
            if (uploadUrl == null) {
                throw new NullPointerException("uploadUrl is marked non-null but is null");
            }
            this.uploadUrl = uploadUrl;
        }

        @JsonProperty(value="path")
        public void setPath(@NotNull String path) {
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            this.path = path;
        }

        @Override
        public String toString() {
            return "Import.CreateImportUrlResponse(uploadUrl=" + this.getUploadUrl() + ", path=" + this.getPath() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateImportUrlResponse)) {
                return false;
            }
            CreateImportUrlResponse other = (CreateImportUrlResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$uploadUrl = this.getUploadUrl();
            String other$uploadUrl = other.getUploadUrl();
            if (this$uploadUrl == null ? other$uploadUrl != null : !this$uploadUrl.equals(other$uploadUrl)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof CreateImportUrlResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $uploadUrl = this.getUploadUrl();
            result = result * 59 + ($uploadUrl == null ? 43 : $uploadUrl.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }
    }

    public static class CreateImportUrlRequestData {
        @JsonProperty(value="file_name")
        @Nullable
        private String fileName;

        CreateImportUrlRequestData(@Nullable String fileName) {
            this.fileName = fileName;
        }

        public static class CreateImportUrlRequest
        extends StreamRequest<CreateImportUrlResponse> {
            private String fileName;

            @Override
            protected Call<CreateImportUrlResponse> generateCall(Client client) {
                return client.create(ImportService.class).createImportUrl(this.internalBuild());
            }

            CreateImportUrlRequest() {
            }

            @JsonProperty(value="file_name")
            public CreateImportUrlRequest fileName(@Nullable String fileName) {
                this.fileName = fileName;
                return this;
            }

            public CreateImportUrlRequestData internalBuild() {
                return new CreateImportUrlRequestData(this.fileName);
            }

            public String toString() {
                return "Import.CreateImportUrlRequestData.CreateImportUrlRequest(fileName=" + this.fileName + ")";
            }
        }
    }

    public static enum ImportState {
        Uploaded,
        Analyzing,
        AnalyzingFailed,
        WaitingForConfirmation,
        Importing,
        ImportingFailed,
        Completed,
        Failed,
        UNKNOWN;

    }

    public static enum ImportMode {
        Upsert,
        Insert,
        UNKNOWN;

    }
}

