/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.exceptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class StreamException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ResponseData responseData;

    public StreamException(String message, ResponseData responseData) {
        super(message);
        this.responseData = responseData;
    }

    public StreamException(String message, Throwable t) {
        super(message, t);
    }

    public StreamException(Throwable t) {
        super(t);
    }

    public static StreamException build(String issue) {
        return new StreamException(issue, (Throwable)null);
    }

    @Deprecated
    public static StreamException build(ResponseBody responseBody) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            String responseBodyString = responseBody.string();
            try {
                ResponseData responseData = (ResponseData)objectMapper.readValue(responseBodyString, ResponseData.class);
                return new StreamException(responseData.getMessage(), responseData);
            }
            catch (JsonProcessingException e) {
                return new StreamException(responseBodyString, e);
            }
        }
        catch (IOException e) {
            return new StreamException(e);
        }
    }

    public static StreamException build(Response<?> httpResponse) {
        ResponseBody errorBody = httpResponse.errorBody();
        StreamException exception = errorBody != null ? StreamException.build(errorBody) : StreamException.build(String.format("Unexpected server response code %d", httpResponse.code()));
        if (exception.responseData == null) {
            ResponseData responseData = new ResponseData();
            responseData.statusCode = httpResponse.code();
            exception.responseData = responseData;
        }
        return exception;
    }

    public static StreamException build(Throwable t) {
        return new StreamException(t);
    }

    public ResponseData getResponseData() {
        return this.responseData;
    }

    public static class ResponseData {
        @JsonProperty(value="code")
        private Integer code;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="exception_fields")
        private Map<String, String> exceptionFields;
        @JsonProperty(value="StatusCode")
        private Integer statusCode;
        @JsonProperty(value="duration")
        private String duration;
        @JsonProperty(value="more_info")
        private String moreInfo;

        public Integer getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public Map<String, String> getExceptionFields() {
            return this.exceptionFields;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public String getDuration() {
            return this.duration;
        }

        public String getMoreInfo() {
            return this.moreInfo;
        }

        @JsonProperty(value="code")
        public void setCode(Integer code) {
            this.code = code;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="exception_fields")
        public void setExceptionFields(Map<String, String> exceptionFields) {
            this.exceptionFields = exceptionFields;
        }

        @JsonProperty(value="StatusCode")
        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @JsonProperty(value="duration")
        public void setDuration(String duration) {
            this.duration = duration;
        }

        @JsonProperty(value="more_info")
        public void setMoreInfo(String moreInfo) {
            this.moreInfo = moreInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseData)) {
                return false;
            }
            ResponseData other = (ResponseData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Integer this$statusCode = this.getStatusCode();
            Integer other$statusCode = other.getStatusCode();
            if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Map<String, String> this$exceptionFields = this.getExceptionFields();
            Map<String, String> other$exceptionFields = other.getExceptionFields();
            if (this$exceptionFields == null ? other$exceptionFields != null : !((Object)this$exceptionFields).equals(other$exceptionFields)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            String this$moreInfo = this.getMoreInfo();
            String other$moreInfo = other.getMoreInfo();
            return !(this$moreInfo == null ? other$moreInfo != null : !this$moreInfo.equals(other$moreInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Integer $statusCode = this.getStatusCode();
            result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Map<String, String> $exceptionFields = this.getExceptionFields();
            result = result * 59 + ($exceptionFields == null ? 43 : ((Object)$exceptionFields).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            String $moreInfo = this.getMoreInfo();
            result = result * 59 + ($moreInfo == null ? 43 : $moreInfo.hashCode());
            return result;
        }

        public String toString() {
            return "StreamException.ResponseData(code=" + this.getCode() + ", message=" + this.getMessage() + ", exceptionFields=" + this.getExceptionFields() + ", statusCode=" + this.getStatusCode() + ", duration=" + this.getDuration() + ", moreInfo=" + this.getMoreInfo() + ")";
        }
    }
}

