/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Command;
import io.getstream.chat.java.models.RateLimit;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponse;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ChannelTypeService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class ChannelType {
    @JsonProperty(value="name")
    @NotNull
    private String name;
    @JsonProperty(value="typing_events")
    @Nullable
    private Boolean typingEvents;
    @JsonProperty(value="read_events")
    @Nullable
    private Boolean readEvents;
    @JsonProperty(value="reminders")
    @Nullable
    private Boolean reminders;
    @JsonProperty(value="user_message_reminders")
    @Nullable
    private Boolean userMessageReminders;
    @JsonProperty(value="connect_events")
    @Nullable
    private Boolean connectEvents;
    @JsonProperty(value="search")
    @Nullable
    private Boolean search;
    @JsonProperty(value="reactions")
    @Nullable
    private Boolean reactions;
    @JsonProperty(value="replies")
    @Nullable
    private Boolean replies;
    @JsonProperty(value="quotes")
    @Nullable
    private Boolean quotes;
    @JsonProperty(value="uploads")
    @Nullable
    private Boolean uploads;
    @JsonProperty(value="url_enrichment")
    @Nullable
    private Boolean urlEnrichment;
    @JsonProperty(value="custom_events")
    @Nullable
    private Boolean customEvents;
    @JsonProperty(value="mutes")
    @Nullable
    private Boolean mutes;
    @JsonProperty(value="push_notifications")
    @Nullable
    private Boolean pushNotifications;
    @JsonProperty(value="message_retention")
    @Nullable
    private String messageRetention;
    @JsonProperty(value="max_message_length")
    @Nullable
    private Integer maxMessageLength;
    @JsonProperty(value="mark_messages_pending")
    @Nullable
    private Boolean markMessagesPending;
    @JsonProperty(value="automod")
    @Nullable
    private AutoMod automod;
    @JsonProperty(value="automod_behavior")
    @Nullable
    private AutoModBehavior automodBehavior;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Nullable
    private Date updatedAt;
    @JsonProperty(value="blocklist")
    @Nullable
    private String blocklist;
    @JsonProperty(value="blocklist_behavior")
    @Nullable
    private BlocklistBehavior blocklistBehavior;
    @JsonProperty(value="automod_thresholds")
    @Nullable
    private Map<String, Threshold> automodThresholds;
    @JsonProperty(value="roles")
    @Nullable
    private Map<String, List<Right>> roles;
    @JsonProperty(value="permissions")
    @Nullable
    private List<Policy> permissions;
    @JsonProperty(value="grants")
    @Nullable
    private Map<String, List<String>> grants;
    @JsonProperty(value="count_messages")
    @Nullable
    private Boolean countMessages;

    @NotNull
    public static ChannelTypeCreateRequestData.ChannelTypeCreateRequest create() {
        return new ChannelTypeCreateRequestData.ChannelTypeCreateRequest();
    }

    @NotNull
    public static ChannelTypeGetRequest get(String name) {
        return new ChannelTypeGetRequest(name);
    }

    @NotNull
    public static ChannelTypeUpdateRequestData.ChannelTypeUpdateRequest update(@NotNull String name) {
        return new ChannelTypeUpdateRequestData.ChannelTypeUpdateRequest(name);
    }

    @NotNull
    public static ChannelTypeDeleteRequest delete(String name) {
        return new ChannelTypeDeleteRequest(name);
    }

    @NotNull
    public static ChannelTypeListRequest list() throws StreamException {
        return new ChannelTypeListRequest();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getTypingEvents() {
        return this.typingEvents;
    }

    @Nullable
    public Boolean getReadEvents() {
        return this.readEvents;
    }

    @Nullable
    public Boolean getReminders() {
        return this.reminders;
    }

    @Nullable
    public Boolean getUserMessageReminders() {
        return this.userMessageReminders;
    }

    @Nullable
    public Boolean getConnectEvents() {
        return this.connectEvents;
    }

    @Nullable
    public Boolean getSearch() {
        return this.search;
    }

    @Nullable
    public Boolean getReactions() {
        return this.reactions;
    }

    @Nullable
    public Boolean getReplies() {
        return this.replies;
    }

    @Nullable
    public Boolean getQuotes() {
        return this.quotes;
    }

    @Nullable
    public Boolean getUploads() {
        return this.uploads;
    }

    @Nullable
    public Boolean getUrlEnrichment() {
        return this.urlEnrichment;
    }

    @Nullable
    public Boolean getCustomEvents() {
        return this.customEvents;
    }

    @Nullable
    public Boolean getMutes() {
        return this.mutes;
    }

    @Nullable
    public Boolean getPushNotifications() {
        return this.pushNotifications;
    }

    @Nullable
    public String getMessageRetention() {
        return this.messageRetention;
    }

    @Nullable
    public Integer getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nullable
    public Boolean getMarkMessagesPending() {
        return this.markMessagesPending;
    }

    @Nullable
    public AutoMod getAutomod() {
        return this.automod;
    }

    @Nullable
    public AutoModBehavior getAutomodBehavior() {
        return this.automodBehavior;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public String getBlocklist() {
        return this.blocklist;
    }

    @Nullable
    public BlocklistBehavior getBlocklistBehavior() {
        return this.blocklistBehavior;
    }

    @Nullable
    public Map<String, Threshold> getAutomodThresholds() {
        return this.automodThresholds;
    }

    @Nullable
    public Map<String, List<Right>> getRoles() {
        return this.roles;
    }

    @Nullable
    public List<Policy> getPermissions() {
        return this.permissions;
    }

    @Nullable
    public Map<String, List<String>> getGrants() {
        return this.grants;
    }

    @Nullable
    public Boolean getCountMessages() {
        return this.countMessages;
    }

    @JsonProperty(value="name")
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="typing_events")
    public void setTypingEvents(@Nullable Boolean typingEvents) {
        this.typingEvents = typingEvents;
    }

    @JsonProperty(value="read_events")
    public void setReadEvents(@Nullable Boolean readEvents) {
        this.readEvents = readEvents;
    }

    @JsonProperty(value="reminders")
    public void setReminders(@Nullable Boolean reminders) {
        this.reminders = reminders;
    }

    @JsonProperty(value="user_message_reminders")
    public void setUserMessageReminders(@Nullable Boolean userMessageReminders) {
        this.userMessageReminders = userMessageReminders;
    }

    @JsonProperty(value="connect_events")
    public void setConnectEvents(@Nullable Boolean connectEvents) {
        this.connectEvents = connectEvents;
    }

    @JsonProperty(value="search")
    public void setSearch(@Nullable Boolean search) {
        this.search = search;
    }

    @JsonProperty(value="reactions")
    public void setReactions(@Nullable Boolean reactions) {
        this.reactions = reactions;
    }

    @JsonProperty(value="replies")
    public void setReplies(@Nullable Boolean replies) {
        this.replies = replies;
    }

    @JsonProperty(value="quotes")
    public void setQuotes(@Nullable Boolean quotes) {
        this.quotes = quotes;
    }

    @JsonProperty(value="uploads")
    public void setUploads(@Nullable Boolean uploads) {
        this.uploads = uploads;
    }

    @JsonProperty(value="url_enrichment")
    public void setUrlEnrichment(@Nullable Boolean urlEnrichment) {
        this.urlEnrichment = urlEnrichment;
    }

    @JsonProperty(value="custom_events")
    public void setCustomEvents(@Nullable Boolean customEvents) {
        this.customEvents = customEvents;
    }

    @JsonProperty(value="mutes")
    public void setMutes(@Nullable Boolean mutes) {
        this.mutes = mutes;
    }

    @JsonProperty(value="push_notifications")
    public void setPushNotifications(@Nullable Boolean pushNotifications) {
        this.pushNotifications = pushNotifications;
    }

    @JsonProperty(value="message_retention")
    public void setMessageRetention(@Nullable String messageRetention) {
        this.messageRetention = messageRetention;
    }

    @JsonProperty(value="max_message_length")
    public void setMaxMessageLength(@Nullable Integer maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    @JsonProperty(value="mark_messages_pending")
    public void setMarkMessagesPending(@Nullable Boolean markMessagesPending) {
        this.markMessagesPending = markMessagesPending;
    }

    @JsonProperty(value="automod")
    public void setAutomod(@Nullable AutoMod automod) {
        this.automod = automod;
    }

    @JsonProperty(value="automod_behavior")
    public void setAutomodBehavior(@Nullable AutoModBehavior automodBehavior) {
        this.automodBehavior = automodBehavior;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="blocklist")
    public void setBlocklist(@Nullable String blocklist) {
        this.blocklist = blocklist;
    }

    @JsonProperty(value="blocklist_behavior")
    public void setBlocklistBehavior(@Nullable BlocklistBehavior blocklistBehavior) {
        this.blocklistBehavior = blocklistBehavior;
    }

    @JsonProperty(value="automod_thresholds")
    public void setAutomodThresholds(@Nullable Map<String, Threshold> automodThresholds) {
        this.automodThresholds = automodThresholds;
    }

    @JsonProperty(value="roles")
    public void setRoles(@Nullable Map<String, List<Right>> roles) {
        this.roles = roles;
    }

    @JsonProperty(value="permissions")
    public void setPermissions(@Nullable List<Policy> permissions) {
        this.permissions = permissions;
    }

    @JsonProperty(value="grants")
    public void setGrants(@Nullable Map<String, List<String>> grants) {
        this.grants = grants;
    }

    @JsonProperty(value="count_messages")
    public void setCountMessages(@Nullable Boolean countMessages) {
        this.countMessages = countMessages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChannelType)) {
            return false;
        }
        ChannelType other = (ChannelType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$typingEvents = this.getTypingEvents();
        Boolean other$typingEvents = other.getTypingEvents();
        if (this$typingEvents == null ? other$typingEvents != null : !((Object)this$typingEvents).equals(other$typingEvents)) {
            return false;
        }
        Boolean this$readEvents = this.getReadEvents();
        Boolean other$readEvents = other.getReadEvents();
        if (this$readEvents == null ? other$readEvents != null : !((Object)this$readEvents).equals(other$readEvents)) {
            return false;
        }
        Boolean this$reminders = this.getReminders();
        Boolean other$reminders = other.getReminders();
        if (this$reminders == null ? other$reminders != null : !((Object)this$reminders).equals(other$reminders)) {
            return false;
        }
        Boolean this$userMessageReminders = this.getUserMessageReminders();
        Boolean other$userMessageReminders = other.getUserMessageReminders();
        if (this$userMessageReminders == null ? other$userMessageReminders != null : !((Object)this$userMessageReminders).equals(other$userMessageReminders)) {
            return false;
        }
        Boolean this$connectEvents = this.getConnectEvents();
        Boolean other$connectEvents = other.getConnectEvents();
        if (this$connectEvents == null ? other$connectEvents != null : !((Object)this$connectEvents).equals(other$connectEvents)) {
            return false;
        }
        Boolean this$search = this.getSearch();
        Boolean other$search = other.getSearch();
        if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
            return false;
        }
        Boolean this$reactions = this.getReactions();
        Boolean other$reactions = other.getReactions();
        if (this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions)) {
            return false;
        }
        Boolean this$replies = this.getReplies();
        Boolean other$replies = other.getReplies();
        if (this$replies == null ? other$replies != null : !((Object)this$replies).equals(other$replies)) {
            return false;
        }
        Boolean this$quotes = this.getQuotes();
        Boolean other$quotes = other.getQuotes();
        if (this$quotes == null ? other$quotes != null : !((Object)this$quotes).equals(other$quotes)) {
            return false;
        }
        Boolean this$uploads = this.getUploads();
        Boolean other$uploads = other.getUploads();
        if (this$uploads == null ? other$uploads != null : !((Object)this$uploads).equals(other$uploads)) {
            return false;
        }
        Boolean this$urlEnrichment = this.getUrlEnrichment();
        Boolean other$urlEnrichment = other.getUrlEnrichment();
        if (this$urlEnrichment == null ? other$urlEnrichment != null : !((Object)this$urlEnrichment).equals(other$urlEnrichment)) {
            return false;
        }
        Boolean this$customEvents = this.getCustomEvents();
        Boolean other$customEvents = other.getCustomEvents();
        if (this$customEvents == null ? other$customEvents != null : !((Object)this$customEvents).equals(other$customEvents)) {
            return false;
        }
        Boolean this$mutes = this.getMutes();
        Boolean other$mutes = other.getMutes();
        if (this$mutes == null ? other$mutes != null : !((Object)this$mutes).equals(other$mutes)) {
            return false;
        }
        Boolean this$pushNotifications = this.getPushNotifications();
        Boolean other$pushNotifications = other.getPushNotifications();
        if (this$pushNotifications == null ? other$pushNotifications != null : !((Object)this$pushNotifications).equals(other$pushNotifications)) {
            return false;
        }
        Integer this$maxMessageLength = this.getMaxMessageLength();
        Integer other$maxMessageLength = other.getMaxMessageLength();
        if (this$maxMessageLength == null ? other$maxMessageLength != null : !((Object)this$maxMessageLength).equals(other$maxMessageLength)) {
            return false;
        }
        Boolean this$markMessagesPending = this.getMarkMessagesPending();
        Boolean other$markMessagesPending = other.getMarkMessagesPending();
        if (this$markMessagesPending == null ? other$markMessagesPending != null : !((Object)this$markMessagesPending).equals(other$markMessagesPending)) {
            return false;
        }
        Boolean this$countMessages = this.getCountMessages();
        Boolean other$countMessages = other.getCountMessages();
        if (this$countMessages == null ? other$countMessages != null : !((Object)this$countMessages).equals(other$countMessages)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$messageRetention = this.getMessageRetention();
        String other$messageRetention = other.getMessageRetention();
        if (this$messageRetention == null ? other$messageRetention != null : !this$messageRetention.equals(other$messageRetention)) {
            return false;
        }
        AutoMod this$automod = this.getAutomod();
        AutoMod other$automod = other.getAutomod();
        if (this$automod == null ? other$automod != null : !((Object)((Object)this$automod)).equals((Object)other$automod)) {
            return false;
        }
        AutoModBehavior this$automodBehavior = this.getAutomodBehavior();
        AutoModBehavior other$automodBehavior = other.getAutomodBehavior();
        if (this$automodBehavior == null ? other$automodBehavior != null : !((Object)((Object)this$automodBehavior)).equals((Object)other$automodBehavior)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$blocklist = this.getBlocklist();
        String other$blocklist = other.getBlocklist();
        if (this$blocklist == null ? other$blocklist != null : !this$blocklist.equals(other$blocklist)) {
            return false;
        }
        BlocklistBehavior this$blocklistBehavior = this.getBlocklistBehavior();
        BlocklistBehavior other$blocklistBehavior = other.getBlocklistBehavior();
        if (this$blocklistBehavior == null ? other$blocklistBehavior != null : !((Object)((Object)this$blocklistBehavior)).equals((Object)other$blocklistBehavior)) {
            return false;
        }
        Map<String, Threshold> this$automodThresholds = this.getAutomodThresholds();
        Map<String, Threshold> other$automodThresholds = other.getAutomodThresholds();
        if (this$automodThresholds == null ? other$automodThresholds != null : !((Object)this$automodThresholds).equals(other$automodThresholds)) {
            return false;
        }
        Map<String, List<Right>> this$roles = this.getRoles();
        Map<String, List<Right>> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        List<Policy> this$permissions = this.getPermissions();
        List<Policy> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        Map<String, List<String>> this$grants = this.getGrants();
        Map<String, List<String>> other$grants = other.getGrants();
        return !(this$grants == null ? other$grants != null : !((Object)this$grants).equals(other$grants));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChannelType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $typingEvents = this.getTypingEvents();
        result = result * 59 + ($typingEvents == null ? 43 : ((Object)$typingEvents).hashCode());
        Boolean $readEvents = this.getReadEvents();
        result = result * 59 + ($readEvents == null ? 43 : ((Object)$readEvents).hashCode());
        Boolean $reminders = this.getReminders();
        result = result * 59 + ($reminders == null ? 43 : ((Object)$reminders).hashCode());
        Boolean $userMessageReminders = this.getUserMessageReminders();
        result = result * 59 + ($userMessageReminders == null ? 43 : ((Object)$userMessageReminders).hashCode());
        Boolean $connectEvents = this.getConnectEvents();
        result = result * 59 + ($connectEvents == null ? 43 : ((Object)$connectEvents).hashCode());
        Boolean $search = this.getSearch();
        result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
        Boolean $reactions = this.getReactions();
        result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
        Boolean $replies = this.getReplies();
        result = result * 59 + ($replies == null ? 43 : ((Object)$replies).hashCode());
        Boolean $quotes = this.getQuotes();
        result = result * 59 + ($quotes == null ? 43 : ((Object)$quotes).hashCode());
        Boolean $uploads = this.getUploads();
        result = result * 59 + ($uploads == null ? 43 : ((Object)$uploads).hashCode());
        Boolean $urlEnrichment = this.getUrlEnrichment();
        result = result * 59 + ($urlEnrichment == null ? 43 : ((Object)$urlEnrichment).hashCode());
        Boolean $customEvents = this.getCustomEvents();
        result = result * 59 + ($customEvents == null ? 43 : ((Object)$customEvents).hashCode());
        Boolean $mutes = this.getMutes();
        result = result * 59 + ($mutes == null ? 43 : ((Object)$mutes).hashCode());
        Boolean $pushNotifications = this.getPushNotifications();
        result = result * 59 + ($pushNotifications == null ? 43 : ((Object)$pushNotifications).hashCode());
        Integer $maxMessageLength = this.getMaxMessageLength();
        result = result * 59 + ($maxMessageLength == null ? 43 : ((Object)$maxMessageLength).hashCode());
        Boolean $markMessagesPending = this.getMarkMessagesPending();
        result = result * 59 + ($markMessagesPending == null ? 43 : ((Object)$markMessagesPending).hashCode());
        Boolean $countMessages = this.getCountMessages();
        result = result * 59 + ($countMessages == null ? 43 : ((Object)$countMessages).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $messageRetention = this.getMessageRetention();
        result = result * 59 + ($messageRetention == null ? 43 : $messageRetention.hashCode());
        AutoMod $automod = this.getAutomod();
        result = result * 59 + ($automod == null ? 43 : ((Object)((Object)$automod)).hashCode());
        AutoModBehavior $automodBehavior = this.getAutomodBehavior();
        result = result * 59 + ($automodBehavior == null ? 43 : ((Object)((Object)$automodBehavior)).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $blocklist = this.getBlocklist();
        result = result * 59 + ($blocklist == null ? 43 : $blocklist.hashCode());
        BlocklistBehavior $blocklistBehavior = this.getBlocklistBehavior();
        result = result * 59 + ($blocklistBehavior == null ? 43 : ((Object)((Object)$blocklistBehavior)).hashCode());
        Map<String, Threshold> $automodThresholds = this.getAutomodThresholds();
        result = result * 59 + ($automodThresholds == null ? 43 : ((Object)$automodThresholds).hashCode());
        Map<String, List<Right>> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        List<Policy> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        Map<String, List<String>> $grants = this.getGrants();
        result = result * 59 + ($grants == null ? 43 : ((Object)$grants).hashCode());
        return result;
    }

    public String toString() {
        return "ChannelType(name=" + this.getName() + ", typingEvents=" + this.getTypingEvents() + ", readEvents=" + this.getReadEvents() + ", reminders=" + this.getReminders() + ", userMessageReminders=" + this.getUserMessageReminders() + ", connectEvents=" + this.getConnectEvents() + ", search=" + this.getSearch() + ", reactions=" + this.getReactions() + ", replies=" + this.getReplies() + ", quotes=" + this.getQuotes() + ", uploads=" + this.getUploads() + ", urlEnrichment=" + this.getUrlEnrichment() + ", customEvents=" + this.getCustomEvents() + ", mutes=" + this.getMutes() + ", pushNotifications=" + this.getPushNotifications() + ", messageRetention=" + this.getMessageRetention() + ", maxMessageLength=" + this.getMaxMessageLength() + ", markMessagesPending=" + this.getMarkMessagesPending() + ", automod=" + String.valueOf((Object)this.getAutomod()) + ", automodBehavior=" + String.valueOf((Object)this.getAutomodBehavior()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", blocklist=" + this.getBlocklist() + ", blocklistBehavior=" + String.valueOf((Object)this.getBlocklistBehavior()) + ", automodThresholds=" + String.valueOf(this.getAutomodThresholds()) + ", roles=" + String.valueOf(this.getRoles()) + ", permissions=" + String.valueOf(this.getPermissions()) + ", grants=" + String.valueOf(this.getGrants()) + ", countMessages=" + this.getCountMessages() + ")";
    }

    public static class ChannelTypeListResponse
    extends StreamResponseObject {
        @JsonProperty(value="channel_types")
        @NotNull
        private Map<String, ChannelTypeWithCommands> channelTypes;

        @NotNull
        public Map<String, ChannelTypeWithCommands> getChannelTypes() {
            return this.channelTypes;
        }

        @JsonProperty(value="channel_types")
        public void setChannelTypes(@NotNull Map<String, ChannelTypeWithCommands> channelTypes) {
            if (channelTypes == null) {
                throw new NullPointerException("channelTypes is marked non-null but is null");
            }
            this.channelTypes = channelTypes;
        }

        @Override
        public String toString() {
            return "ChannelType.ChannelTypeListResponse(channelTypes=" + String.valueOf(this.getChannelTypes()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeListResponse)) {
                return false;
            }
            ChannelTypeListResponse other = (ChannelTypeListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, ChannelTypeWithCommands> this$channelTypes = this.getChannelTypes();
            Map<String, ChannelTypeWithCommands> other$channelTypes = other.getChannelTypes();
            return !(this$channelTypes == null ? other$channelTypes != null : !((Object)this$channelTypes).equals(other$channelTypes));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, ChannelTypeWithCommands> $channelTypes = this.getChannelTypes();
            result = result * 59 + ($channelTypes == null ? 43 : ((Object)$channelTypes).hashCode());
            return result;
        }
    }

    public static class ChannelTypeUpdateResponse
    extends ChannelTypeWithStringCommands
    implements StreamResponse {
        private RateLimit rateLimit;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;

        public RateLimit getRateLimit() {
            return this.rateLimit;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        public void setRateLimit(RateLimit rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @Override
        public String toString() {
            return "ChannelType.ChannelTypeUpdateResponse(rateLimit=" + String.valueOf(this.getRateLimit()) + ", duration=" + this.getDuration() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeUpdateResponse)) {
                return false;
            }
            ChannelTypeUpdateResponse other = (ChannelTypeUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RateLimit this$rateLimit = this.getRateLimit();
            RateLimit other$rateLimit = other.getRateLimit();
            if (this$rateLimit == null ? other$rateLimit != null : !((Object)this$rateLimit).equals(other$rateLimit)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            RateLimit $rateLimit = this.getRateLimit();
            result = result * 59 + ($rateLimit == null ? 43 : ((Object)$rateLimit).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            return result;
        }
    }

    public static class ChannelTypeGetResponse
    extends ChannelTypeWithCommands
    implements StreamResponse {
        private RateLimit rateLimit;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;

        public RateLimit getRateLimit() {
            return this.rateLimit;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        public void setRateLimit(RateLimit rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @Override
        public String toString() {
            return "ChannelType.ChannelTypeGetResponse(rateLimit=" + String.valueOf(this.getRateLimit()) + ", duration=" + this.getDuration() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeGetResponse)) {
                return false;
            }
            ChannelTypeGetResponse other = (ChannelTypeGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RateLimit this$rateLimit = this.getRateLimit();
            RateLimit other$rateLimit = other.getRateLimit();
            if (this$rateLimit == null ? other$rateLimit != null : !((Object)this$rateLimit).equals(other$rateLimit)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            RateLimit $rateLimit = this.getRateLimit();
            result = result * 59 + ($rateLimit == null ? 43 : ((Object)$rateLimit).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            return result;
        }
    }

    public static class ChannelTypeCreateResponse
    extends ChannelTypeWithStringCommands
    implements StreamResponse {
        private RateLimit rateLimit;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;

        public RateLimit getRateLimit() {
            return this.rateLimit;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        public void setRateLimit(RateLimit rateLimit) {
            this.rateLimit = rateLimit;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @Override
        public String toString() {
            return "ChannelType.ChannelTypeCreateResponse(rateLimit=" + String.valueOf(this.getRateLimit()) + ", duration=" + this.getDuration() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeCreateResponse)) {
                return false;
            }
            ChannelTypeCreateResponse other = (ChannelTypeCreateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RateLimit this$rateLimit = this.getRateLimit();
            RateLimit other$rateLimit = other.getRateLimit();
            if (this$rateLimit == null ? other$rateLimit != null : !((Object)this$rateLimit).equals(other$rateLimit)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeCreateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            RateLimit $rateLimit = this.getRateLimit();
            result = result * 59 + ($rateLimit == null ? 43 : ((Object)$rateLimit).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            return result;
        }
    }

    public static class ChannelTypeListRequest
    extends StreamRequest<ChannelTypeListResponse> {
        @Override
        protected Call<ChannelTypeListResponse> generateCall(Client client) {
            return client.create(ChannelTypeService.class).list();
        }
    }

    public static class ChannelTypeDeleteRequest
    extends StreamRequest<StreamResponseObject> {
        @NotNull
        private String name;

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return client.create(ChannelTypeService.class).delete(this.name);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeDeleteRequest)) {
                return false;
            }
            ChannelTypeDeleteRequest other = (ChannelTypeDeleteRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeDeleteRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public ChannelTypeDeleteRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class ChannelTypeUpdateRequestData {
        @JsonProperty(value="typing_events")
        @Nullable
        protected Boolean typingEvents;
        @JsonProperty(value="read_events")
        @Nullable
        protected Boolean readEvents;
        @JsonProperty(value="reminders")
        @Nullable
        protected Boolean reminders;
        @JsonProperty(value="user_message_reminders")
        @Nullable
        protected Boolean userMessageReminders;
        @JsonProperty(value="connect_events")
        @Nullable
        protected Boolean connectEvents;
        @JsonProperty(value="search")
        @Nullable
        protected Boolean search;
        @JsonProperty(value="reactions")
        @Nullable
        protected Boolean reactions;
        @JsonProperty(value="replies")
        @Nullable
        protected Boolean replies;
        @JsonProperty(value="quotes")
        @Nullable
        protected Boolean quotes;
        @JsonProperty(value="uploads")
        @Nullable
        protected Boolean uploads;
        @JsonProperty(value="url_enrichment")
        @Nullable
        protected Boolean urlEnrichment;
        @JsonProperty(value="custom_events")
        @Nullable
        protected Boolean customEvents;
        @JsonProperty(value="mutes")
        @Nullable
        protected Boolean mutes;
        @JsonProperty(value="push_notifications")
        @Nullable
        protected Boolean pushNotifications;
        @JsonProperty(value="message_retention")
        @Nullable
        protected String messageRetention;
        @JsonProperty(value="max_message_length")
        @Nullable
        protected Integer maxMessageLength;
        @JsonProperty(value="mark_messages_pending")
        @Nullable
        protected Boolean markMessagesPending;
        @JsonProperty(value="automod")
        @Nullable
        protected AutoMod automod;
        @JsonProperty(value="automod_behavior")
        @Nullable
        protected AutoModBehavior automodBehavior;
        @JsonProperty(value="blocklist")
        @Nullable
        protected String blocklist;
        @JsonProperty(value="blocklist_behavior")
        @Nullable
        protected BlocklistBehavior blocklistBehavior;
        @JsonProperty(value="automod_thresholds")
        @Nullable
        protected Map<String, ThresholdRequestObject> automodThresholds;
        @JsonProperty(value="commands")
        @Nullable
        protected List<String> commands;
        @JsonProperty(value="permissions")
        @Nullable
        protected List<PermissionRequestObject> permissions;
        @JsonProperty(value="grants")
        @Nullable
        protected Map<String, List<String>> grants;
        @JsonProperty(value="count_messages")
        @Nullable
        private Boolean countMessages;

        ChannelTypeUpdateRequestData(@Nullable Boolean typingEvents, @Nullable Boolean readEvents, @Nullable Boolean reminders, @Nullable Boolean userMessageReminders, @Nullable Boolean connectEvents, @Nullable Boolean search, @Nullable Boolean reactions, @Nullable Boolean replies, @Nullable Boolean quotes, @Nullable Boolean uploads, @Nullable Boolean urlEnrichment, @Nullable Boolean customEvents, @Nullable Boolean mutes, @Nullable Boolean pushNotifications, @Nullable String messageRetention, @Nullable Integer maxMessageLength, @Nullable Boolean markMessagesPending, @Nullable AutoMod automod, @Nullable AutoModBehavior automodBehavior, @Nullable String blocklist, @Nullable BlocklistBehavior blocklistBehavior, @Nullable Map<String, ThresholdRequestObject> automodThresholds, @Nullable List<String> commands, @Nullable List<PermissionRequestObject> permissions, @Nullable Map<String, List<String>> grants, @Nullable Boolean countMessages) {
            this.typingEvents = typingEvents;
            this.readEvents = readEvents;
            this.reminders = reminders;
            this.userMessageReminders = userMessageReminders;
            this.connectEvents = connectEvents;
            this.search = search;
            this.reactions = reactions;
            this.replies = replies;
            this.quotes = quotes;
            this.uploads = uploads;
            this.urlEnrichment = urlEnrichment;
            this.customEvents = customEvents;
            this.mutes = mutes;
            this.pushNotifications = pushNotifications;
            this.messageRetention = messageRetention;
            this.maxMessageLength = maxMessageLength;
            this.markMessagesPending = markMessagesPending;
            this.automod = automod;
            this.automodBehavior = automodBehavior;
            this.blocklist = blocklist;
            this.blocklistBehavior = blocklistBehavior;
            this.automodThresholds = automodThresholds;
            this.commands = commands;
            this.permissions = permissions;
            this.grants = grants;
            this.countMessages = countMessages;
        }

        @Nullable
        public Boolean getTypingEvents() {
            return this.typingEvents;
        }

        @Nullable
        public Boolean getReadEvents() {
            return this.readEvents;
        }

        @Nullable
        public Boolean getReminders() {
            return this.reminders;
        }

        @Nullable
        public Boolean getUserMessageReminders() {
            return this.userMessageReminders;
        }

        @Nullable
        public Boolean getConnectEvents() {
            return this.connectEvents;
        }

        @Nullable
        public Boolean getSearch() {
            return this.search;
        }

        @Nullable
        public Boolean getReactions() {
            return this.reactions;
        }

        @Nullable
        public Boolean getReplies() {
            return this.replies;
        }

        @Nullable
        public Boolean getQuotes() {
            return this.quotes;
        }

        @Nullable
        public Boolean getUploads() {
            return this.uploads;
        }

        @Nullable
        public Boolean getUrlEnrichment() {
            return this.urlEnrichment;
        }

        @Nullable
        public Boolean getCustomEvents() {
            return this.customEvents;
        }

        @Nullable
        public Boolean getMutes() {
            return this.mutes;
        }

        @Nullable
        public Boolean getPushNotifications() {
            return this.pushNotifications;
        }

        @Nullable
        public String getMessageRetention() {
            return this.messageRetention;
        }

        @Nullable
        public Integer getMaxMessageLength() {
            return this.maxMessageLength;
        }

        @Nullable
        public Boolean getMarkMessagesPending() {
            return this.markMessagesPending;
        }

        @Nullable
        public AutoMod getAutomod() {
            return this.automod;
        }

        @Nullable
        public AutoModBehavior getAutomodBehavior() {
            return this.automodBehavior;
        }

        @Nullable
        public String getBlocklist() {
            return this.blocklist;
        }

        @Nullable
        public BlocklistBehavior getBlocklistBehavior() {
            return this.blocklistBehavior;
        }

        @Nullable
        public Map<String, ThresholdRequestObject> getAutomodThresholds() {
            return this.automodThresholds;
        }

        @Nullable
        public List<String> getCommands() {
            return this.commands;
        }

        @Nullable
        public List<PermissionRequestObject> getPermissions() {
            return this.permissions;
        }

        @Nullable
        public Map<String, List<String>> getGrants() {
            return this.grants;
        }

        @Nullable
        public Boolean getCountMessages() {
            return this.countMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeUpdateRequestData)) {
                return false;
            }
            ChannelTypeUpdateRequestData other = (ChannelTypeUpdateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$typingEvents = this.getTypingEvents();
            Boolean other$typingEvents = other.getTypingEvents();
            if (this$typingEvents == null ? other$typingEvents != null : !((Object)this$typingEvents).equals(other$typingEvents)) {
                return false;
            }
            Boolean this$readEvents = this.getReadEvents();
            Boolean other$readEvents = other.getReadEvents();
            if (this$readEvents == null ? other$readEvents != null : !((Object)this$readEvents).equals(other$readEvents)) {
                return false;
            }
            Boolean this$reminders = this.getReminders();
            Boolean other$reminders = other.getReminders();
            if (this$reminders == null ? other$reminders != null : !((Object)this$reminders).equals(other$reminders)) {
                return false;
            }
            Boolean this$userMessageReminders = this.getUserMessageReminders();
            Boolean other$userMessageReminders = other.getUserMessageReminders();
            if (this$userMessageReminders == null ? other$userMessageReminders != null : !((Object)this$userMessageReminders).equals(other$userMessageReminders)) {
                return false;
            }
            Boolean this$connectEvents = this.getConnectEvents();
            Boolean other$connectEvents = other.getConnectEvents();
            if (this$connectEvents == null ? other$connectEvents != null : !((Object)this$connectEvents).equals(other$connectEvents)) {
                return false;
            }
            Boolean this$search = this.getSearch();
            Boolean other$search = other.getSearch();
            if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
                return false;
            }
            Boolean this$reactions = this.getReactions();
            Boolean other$reactions = other.getReactions();
            if (this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions)) {
                return false;
            }
            Boolean this$replies = this.getReplies();
            Boolean other$replies = other.getReplies();
            if (this$replies == null ? other$replies != null : !((Object)this$replies).equals(other$replies)) {
                return false;
            }
            Boolean this$quotes = this.getQuotes();
            Boolean other$quotes = other.getQuotes();
            if (this$quotes == null ? other$quotes != null : !((Object)this$quotes).equals(other$quotes)) {
                return false;
            }
            Boolean this$uploads = this.getUploads();
            Boolean other$uploads = other.getUploads();
            if (this$uploads == null ? other$uploads != null : !((Object)this$uploads).equals(other$uploads)) {
                return false;
            }
            Boolean this$urlEnrichment = this.getUrlEnrichment();
            Boolean other$urlEnrichment = other.getUrlEnrichment();
            if (this$urlEnrichment == null ? other$urlEnrichment != null : !((Object)this$urlEnrichment).equals(other$urlEnrichment)) {
                return false;
            }
            Boolean this$customEvents = this.getCustomEvents();
            Boolean other$customEvents = other.getCustomEvents();
            if (this$customEvents == null ? other$customEvents != null : !((Object)this$customEvents).equals(other$customEvents)) {
                return false;
            }
            Boolean this$mutes = this.getMutes();
            Boolean other$mutes = other.getMutes();
            if (this$mutes == null ? other$mutes != null : !((Object)this$mutes).equals(other$mutes)) {
                return false;
            }
            Boolean this$pushNotifications = this.getPushNotifications();
            Boolean other$pushNotifications = other.getPushNotifications();
            if (this$pushNotifications == null ? other$pushNotifications != null : !((Object)this$pushNotifications).equals(other$pushNotifications)) {
                return false;
            }
            Integer this$maxMessageLength = this.getMaxMessageLength();
            Integer other$maxMessageLength = other.getMaxMessageLength();
            if (this$maxMessageLength == null ? other$maxMessageLength != null : !((Object)this$maxMessageLength).equals(other$maxMessageLength)) {
                return false;
            }
            Boolean this$markMessagesPending = this.getMarkMessagesPending();
            Boolean other$markMessagesPending = other.getMarkMessagesPending();
            if (this$markMessagesPending == null ? other$markMessagesPending != null : !((Object)this$markMessagesPending).equals(other$markMessagesPending)) {
                return false;
            }
            Boolean this$countMessages = this.getCountMessages();
            Boolean other$countMessages = other.getCountMessages();
            if (this$countMessages == null ? other$countMessages != null : !((Object)this$countMessages).equals(other$countMessages)) {
                return false;
            }
            String this$messageRetention = this.getMessageRetention();
            String other$messageRetention = other.getMessageRetention();
            if (this$messageRetention == null ? other$messageRetention != null : !this$messageRetention.equals(other$messageRetention)) {
                return false;
            }
            AutoMod this$automod = this.getAutomod();
            AutoMod other$automod = other.getAutomod();
            if (this$automod == null ? other$automod != null : !((Object)((Object)this$automod)).equals((Object)other$automod)) {
                return false;
            }
            AutoModBehavior this$automodBehavior = this.getAutomodBehavior();
            AutoModBehavior other$automodBehavior = other.getAutomodBehavior();
            if (this$automodBehavior == null ? other$automodBehavior != null : !((Object)((Object)this$automodBehavior)).equals((Object)other$automodBehavior)) {
                return false;
            }
            String this$blocklist = this.getBlocklist();
            String other$blocklist = other.getBlocklist();
            if (this$blocklist == null ? other$blocklist != null : !this$blocklist.equals(other$blocklist)) {
                return false;
            }
            BlocklistBehavior this$blocklistBehavior = this.getBlocklistBehavior();
            BlocklistBehavior other$blocklistBehavior = other.getBlocklistBehavior();
            if (this$blocklistBehavior == null ? other$blocklistBehavior != null : !((Object)((Object)this$blocklistBehavior)).equals((Object)other$blocklistBehavior)) {
                return false;
            }
            Map<String, ThresholdRequestObject> this$automodThresholds = this.getAutomodThresholds();
            Map<String, ThresholdRequestObject> other$automodThresholds = other.getAutomodThresholds();
            if (this$automodThresholds == null ? other$automodThresholds != null : !((Object)this$automodThresholds).equals(other$automodThresholds)) {
                return false;
            }
            List<String> this$commands = this.getCommands();
            List<String> other$commands = other.getCommands();
            if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
                return false;
            }
            List<PermissionRequestObject> this$permissions = this.getPermissions();
            List<PermissionRequestObject> other$permissions = other.getPermissions();
            if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                return false;
            }
            Map<String, List<String>> this$grants = this.getGrants();
            Map<String, List<String>> other$grants = other.getGrants();
            return !(this$grants == null ? other$grants != null : !((Object)this$grants).equals(other$grants));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeUpdateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $typingEvents = this.getTypingEvents();
            result = result * 59 + ($typingEvents == null ? 43 : ((Object)$typingEvents).hashCode());
            Boolean $readEvents = this.getReadEvents();
            result = result * 59 + ($readEvents == null ? 43 : ((Object)$readEvents).hashCode());
            Boolean $reminders = this.getReminders();
            result = result * 59 + ($reminders == null ? 43 : ((Object)$reminders).hashCode());
            Boolean $userMessageReminders = this.getUserMessageReminders();
            result = result * 59 + ($userMessageReminders == null ? 43 : ((Object)$userMessageReminders).hashCode());
            Boolean $connectEvents = this.getConnectEvents();
            result = result * 59 + ($connectEvents == null ? 43 : ((Object)$connectEvents).hashCode());
            Boolean $search = this.getSearch();
            result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
            Boolean $reactions = this.getReactions();
            result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
            Boolean $replies = this.getReplies();
            result = result * 59 + ($replies == null ? 43 : ((Object)$replies).hashCode());
            Boolean $quotes = this.getQuotes();
            result = result * 59 + ($quotes == null ? 43 : ((Object)$quotes).hashCode());
            Boolean $uploads = this.getUploads();
            result = result * 59 + ($uploads == null ? 43 : ((Object)$uploads).hashCode());
            Boolean $urlEnrichment = this.getUrlEnrichment();
            result = result * 59 + ($urlEnrichment == null ? 43 : ((Object)$urlEnrichment).hashCode());
            Boolean $customEvents = this.getCustomEvents();
            result = result * 59 + ($customEvents == null ? 43 : ((Object)$customEvents).hashCode());
            Boolean $mutes = this.getMutes();
            result = result * 59 + ($mutes == null ? 43 : ((Object)$mutes).hashCode());
            Boolean $pushNotifications = this.getPushNotifications();
            result = result * 59 + ($pushNotifications == null ? 43 : ((Object)$pushNotifications).hashCode());
            Integer $maxMessageLength = this.getMaxMessageLength();
            result = result * 59 + ($maxMessageLength == null ? 43 : ((Object)$maxMessageLength).hashCode());
            Boolean $markMessagesPending = this.getMarkMessagesPending();
            result = result * 59 + ($markMessagesPending == null ? 43 : ((Object)$markMessagesPending).hashCode());
            Boolean $countMessages = this.getCountMessages();
            result = result * 59 + ($countMessages == null ? 43 : ((Object)$countMessages).hashCode());
            String $messageRetention = this.getMessageRetention();
            result = result * 59 + ($messageRetention == null ? 43 : $messageRetention.hashCode());
            AutoMod $automod = this.getAutomod();
            result = result * 59 + ($automod == null ? 43 : ((Object)((Object)$automod)).hashCode());
            AutoModBehavior $automodBehavior = this.getAutomodBehavior();
            result = result * 59 + ($automodBehavior == null ? 43 : ((Object)((Object)$automodBehavior)).hashCode());
            String $blocklist = this.getBlocklist();
            result = result * 59 + ($blocklist == null ? 43 : $blocklist.hashCode());
            BlocklistBehavior $blocklistBehavior = this.getBlocklistBehavior();
            result = result * 59 + ($blocklistBehavior == null ? 43 : ((Object)((Object)$blocklistBehavior)).hashCode());
            Map<String, ThresholdRequestObject> $automodThresholds = this.getAutomodThresholds();
            result = result * 59 + ($automodThresholds == null ? 43 : ((Object)$automodThresholds).hashCode());
            List<String> $commands = this.getCommands();
            result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
            List<PermissionRequestObject> $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
            Map<String, List<String>> $grants = this.getGrants();
            result = result * 59 + ($grants == null ? 43 : ((Object)$grants).hashCode());
            return result;
        }

        public static class ChannelTypeUpdateRequest
        extends StreamRequest<ChannelTypeUpdateResponse> {
            private Boolean typingEvents;
            private Boolean readEvents;
            private Boolean reminders;
            private Boolean userMessageReminders;
            private Boolean connectEvents;
            private Boolean search;
            private Boolean reactions;
            private Boolean replies;
            private Boolean quotes;
            private Boolean uploads;
            private Boolean urlEnrichment;
            private Boolean customEvents;
            private Boolean mutes;
            private Boolean pushNotifications;
            private String messageRetention;
            private Integer maxMessageLength;
            private Boolean markMessagesPending;
            private AutoMod automod;
            private AutoModBehavior automodBehavior;
            private String blocklist;
            private BlocklistBehavior blocklistBehavior;
            private ArrayList<String> automodThresholds$key;
            private ArrayList<ThresholdRequestObject> automodThresholds$value;
            private List<String> commands;
            private ArrayList<PermissionRequestObject> permissions;
            private Map<String, List<String>> grants;
            private Boolean countMessages;
            @NotNull
            private String name;

            private ChannelTypeUpdateRequest(@NotNull String name) {
                this.name = name;
            }

            @Override
            protected Call<ChannelTypeUpdateResponse> generateCall(Client client) {
                return client.create(ChannelTypeService.class).update(this.name, this.internalBuild());
            }

            @JsonProperty(value="typing_events")
            public ChannelTypeUpdateRequest typingEvents(@Nullable Boolean typingEvents) {
                this.typingEvents = typingEvents;
                return this;
            }

            @JsonProperty(value="read_events")
            public ChannelTypeUpdateRequest readEvents(@Nullable Boolean readEvents) {
                this.readEvents = readEvents;
                return this;
            }

            @JsonProperty(value="reminders")
            public ChannelTypeUpdateRequest reminders(@Nullable Boolean reminders) {
                this.reminders = reminders;
                return this;
            }

            @JsonProperty(value="user_message_reminders")
            public ChannelTypeUpdateRequest userMessageReminders(@Nullable Boolean userMessageReminders) {
                this.userMessageReminders = userMessageReminders;
                return this;
            }

            @JsonProperty(value="connect_events")
            public ChannelTypeUpdateRequest connectEvents(@Nullable Boolean connectEvents) {
                this.connectEvents = connectEvents;
                return this;
            }

            @JsonProperty(value="search")
            public ChannelTypeUpdateRequest search(@Nullable Boolean search) {
                this.search = search;
                return this;
            }

            @JsonProperty(value="reactions")
            public ChannelTypeUpdateRequest reactions(@Nullable Boolean reactions) {
                this.reactions = reactions;
                return this;
            }

            @JsonProperty(value="replies")
            public ChannelTypeUpdateRequest replies(@Nullable Boolean replies) {
                this.replies = replies;
                return this;
            }

            @JsonProperty(value="quotes")
            public ChannelTypeUpdateRequest quotes(@Nullable Boolean quotes) {
                this.quotes = quotes;
                return this;
            }

            @JsonProperty(value="uploads")
            public ChannelTypeUpdateRequest uploads(@Nullable Boolean uploads) {
                this.uploads = uploads;
                return this;
            }

            @JsonProperty(value="url_enrichment")
            public ChannelTypeUpdateRequest urlEnrichment(@Nullable Boolean urlEnrichment) {
                this.urlEnrichment = urlEnrichment;
                return this;
            }

            @JsonProperty(value="custom_events")
            public ChannelTypeUpdateRequest customEvents(@Nullable Boolean customEvents) {
                this.customEvents = customEvents;
                return this;
            }

            @JsonProperty(value="mutes")
            public ChannelTypeUpdateRequest mutes(@Nullable Boolean mutes) {
                this.mutes = mutes;
                return this;
            }

            @JsonProperty(value="push_notifications")
            public ChannelTypeUpdateRequest pushNotifications(@Nullable Boolean pushNotifications) {
                this.pushNotifications = pushNotifications;
                return this;
            }

            @JsonProperty(value="message_retention")
            public ChannelTypeUpdateRequest messageRetention(@Nullable String messageRetention) {
                this.messageRetention = messageRetention;
                return this;
            }

            @JsonProperty(value="max_message_length")
            public ChannelTypeUpdateRequest maxMessageLength(@Nullable Integer maxMessageLength) {
                this.maxMessageLength = maxMessageLength;
                return this;
            }

            @JsonProperty(value="mark_messages_pending")
            public ChannelTypeUpdateRequest markMessagesPending(@Nullable Boolean markMessagesPending) {
                this.markMessagesPending = markMessagesPending;
                return this;
            }

            @JsonProperty(value="automod")
            public ChannelTypeUpdateRequest automod(@Nullable AutoMod automod) {
                this.automod = automod;
                return this;
            }

            @JsonProperty(value="automod_behavior")
            public ChannelTypeUpdateRequest automodBehavior(@Nullable AutoModBehavior automodBehavior) {
                this.automodBehavior = automodBehavior;
                return this;
            }

            @JsonProperty(value="blocklist")
            public ChannelTypeUpdateRequest blocklist(@Nullable String blocklist) {
                this.blocklist = blocklist;
                return this;
            }

            @JsonProperty(value="blocklist_behavior")
            public ChannelTypeUpdateRequest blocklistBehavior(@Nullable BlocklistBehavior blocklistBehavior) {
                this.blocklistBehavior = blocklistBehavior;
                return this;
            }

            public ChannelTypeUpdateRequest automodThreshold(String automodThresholdKey, ThresholdRequestObject automodThresholdValue) {
                if (this.automodThresholds$key == null) {
                    this.automodThresholds$key = new ArrayList();
                    this.automodThresholds$value = new ArrayList();
                }
                this.automodThresholds$key.add(automodThresholdKey);
                this.automodThresholds$value.add(automodThresholdValue);
                return this;
            }

            @JsonProperty(value="automod_thresholds")
            public ChannelTypeUpdateRequest automodThresholds(Map<? extends String, ? extends ThresholdRequestObject> automodThresholds) {
                if (automodThresholds == null) {
                    throw new NullPointerException("automodThresholds cannot be null");
                }
                if (this.automodThresholds$key == null) {
                    this.automodThresholds$key = new ArrayList();
                    this.automodThresholds$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends ThresholdRequestObject> $lombokEntry : automodThresholds.entrySet()) {
                    this.automodThresholds$key.add($lombokEntry.getKey());
                    this.automodThresholds$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ChannelTypeUpdateRequest clearAutomodThresholds() {
                if (this.automodThresholds$key != null) {
                    this.automodThresholds$key.clear();
                    this.automodThresholds$value.clear();
                }
                return this;
            }

            @JsonProperty(value="commands")
            public ChannelTypeUpdateRequest commands(@Nullable List<String> commands) {
                this.commands = commands;
                return this;
            }

            public ChannelTypeUpdateRequest permission(PermissionRequestObject permission) {
                if (this.permissions == null) {
                    this.permissions = new ArrayList();
                }
                this.permissions.add(permission);
                return this;
            }

            @JsonProperty(value="permissions")
            public ChannelTypeUpdateRequest permissions(Collection<? extends PermissionRequestObject> permissions) {
                if (permissions == null) {
                    throw new NullPointerException("permissions cannot be null");
                }
                if (this.permissions == null) {
                    this.permissions = new ArrayList();
                }
                this.permissions.addAll(permissions);
                return this;
            }

            public ChannelTypeUpdateRequest clearPermissions() {
                if (this.permissions != null) {
                    this.permissions.clear();
                }
                return this;
            }

            @JsonProperty(value="grants")
            public ChannelTypeUpdateRequest grants(@Nullable Map<String, List<String>> grants) {
                this.grants = grants;
                return this;
            }

            @JsonProperty(value="count_messages")
            public ChannelTypeUpdateRequest countMessages(@Nullable Boolean countMessages) {
                this.countMessages = countMessages;
                return this;
            }

            public ChannelTypeUpdateRequestData internalBuild() {
                List<PermissionRequestObject> permissions;
                Map<Object, Object> automodThresholds;
                switch (this.automodThresholds$key == null ? 0 : this.automodThresholds$key.size()) {
                    case 0: {
                        automodThresholds = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        automodThresholds = Collections.singletonMap(this.automodThresholds$key.get(0), this.automodThresholds$value.get(0));
                        break;
                    }
                    default: {
                        automodThresholds = new LinkedHashMap(this.automodThresholds$key.size() < 0x40000000 ? 1 + this.automodThresholds$key.size() + (this.automodThresholds$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.automodThresholds$key.size(); ++$i) {
                            automodThresholds.put(this.automodThresholds$key.get($i), this.automodThresholds$value.get($i));
                        }
                        automodThresholds = Collections.unmodifiableMap(automodThresholds);
                    }
                }
                switch (this.permissions == null ? 0 : this.permissions.size()) {
                    case 0: {
                        permissions = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        permissions = Collections.singletonList(this.permissions.get(0));
                        break;
                    }
                    default: {
                        permissions = Collections.unmodifiableList(new ArrayList<PermissionRequestObject>(this.permissions));
                    }
                }
                return new ChannelTypeUpdateRequestData(this.typingEvents, this.readEvents, this.reminders, this.userMessageReminders, this.connectEvents, this.search, this.reactions, this.replies, this.quotes, this.uploads, this.urlEnrichment, this.customEvents, this.mutes, this.pushNotifications, this.messageRetention, this.maxMessageLength, this.markMessagesPending, this.automod, this.automodBehavior, this.blocklist, this.blocklistBehavior, automodThresholds, this.commands, permissions, this.grants, this.countMessages);
            }

            public String toString() {
                return "ChannelType.ChannelTypeUpdateRequestData.ChannelTypeUpdateRequest(typingEvents=" + this.typingEvents + ", readEvents=" + this.readEvents + ", reminders=" + this.reminders + ", userMessageReminders=" + this.userMessageReminders + ", connectEvents=" + this.connectEvents + ", search=" + this.search + ", reactions=" + this.reactions + ", replies=" + this.replies + ", quotes=" + this.quotes + ", uploads=" + this.uploads + ", urlEnrichment=" + this.urlEnrichment + ", customEvents=" + this.customEvents + ", mutes=" + this.mutes + ", pushNotifications=" + this.pushNotifications + ", messageRetention=" + this.messageRetention + ", maxMessageLength=" + this.maxMessageLength + ", markMessagesPending=" + this.markMessagesPending + ", automod=" + String.valueOf((Object)this.automod) + ", automodBehavior=" + String.valueOf((Object)this.automodBehavior) + ", blocklist=" + this.blocklist + ", blocklistBehavior=" + String.valueOf((Object)this.blocklistBehavior) + ", automodThresholds$key=" + String.valueOf(this.automodThresholds$key) + ", automodThresholds$value=" + String.valueOf(this.automodThresholds$value) + ", commands=" + String.valueOf(this.commands) + ", permissions=" + String.valueOf(this.permissions) + ", grants=" + String.valueOf(this.grants) + ", countMessages=" + this.countMessages + ")";
            }
        }
    }

    public static class ChannelTypeGetRequest
    extends StreamRequest<ChannelTypeGetResponse> {
        @NotNull
        private String name;

        @Override
        protected Call<ChannelTypeGetResponse> generateCall(Client client) {
            return client.create(ChannelTypeService.class).get(this.name);
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeGetRequest)) {
                return false;
            }
            ChannelTypeGetRequest other = (ChannelTypeGetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeGetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public ChannelTypeGetRequest(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }
    }

    public static class ChannelTypeCreateRequestData {
        @JsonProperty(value="typing_events")
        @Nullable
        protected Boolean typingEvents;
        @JsonProperty(value="read_events")
        @Nullable
        protected Boolean readEvents;
        @JsonProperty(value="reminders")
        @Nullable
        protected Boolean reminders;
        @JsonProperty(value="user_message_reminders")
        @Nullable
        protected Boolean userMessageReminders;
        @JsonProperty(value="connect_events")
        @Nullable
        protected Boolean connectEvents;
        @JsonProperty(value="search")
        @Nullable
        protected Boolean search;
        @JsonProperty(value="reactions")
        @Nullable
        protected Boolean reactions;
        @JsonProperty(value="replies")
        @Nullable
        protected Boolean replies;
        @JsonProperty(value="quotes")
        @Nullable
        protected Boolean quotes;
        @JsonProperty(value="uploads")
        @Nullable
        protected Boolean uploads;
        @JsonProperty(value="url_enrichment")
        @Nullable
        protected Boolean urlEnrichment;
        @JsonProperty(value="custom_events")
        @Nullable
        protected Boolean customEvents;
        @JsonProperty(value="mutes")
        @Nullable
        protected Boolean mutes;
        @JsonProperty(value="push_notifications")
        @Nullable
        protected Boolean pushNotifications;
        @JsonProperty(value="message_retention")
        @Nullable
        protected String messageRetention;
        @JsonProperty(value="max_message_length")
        @Nullable
        protected Integer maxMessageLength;
        @JsonProperty(value="mark_messages_pending")
        @Nullable
        protected Boolean markMessagesPending;
        @JsonProperty(value="automod")
        @Nullable
        protected AutoMod automod;
        @JsonProperty(value="automod_behavior")
        @Nullable
        protected AutoModBehavior automodBehavior;
        @JsonProperty(value="blocklist")
        @Nullable
        protected String blocklist;
        @JsonProperty(value="blocklist_behavior")
        @Nullable
        protected BlocklistBehavior blocklistBehavior;
        @JsonProperty(value="commands")
        @Nullable
        protected List<String> commands;
        @JsonProperty(value="permissions")
        @Nullable
        protected List<PermissionRequestObject> permissions;
        @JsonProperty(value="grants")
        @Nullable
        protected Map<String, List<String>> grants;
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="count_messages")
        @Nullable
        private Boolean countMessages;

        ChannelTypeCreateRequestData(@Nullable Boolean typingEvents, @Nullable Boolean readEvents, @Nullable Boolean reminders, @Nullable Boolean userMessageReminders, @Nullable Boolean connectEvents, @Nullable Boolean search, @Nullable Boolean reactions, @Nullable Boolean replies, @Nullable Boolean quotes, @Nullable Boolean uploads, @Nullable Boolean urlEnrichment, @Nullable Boolean customEvents, @Nullable Boolean mutes, @Nullable Boolean pushNotifications, @Nullable String messageRetention, @Nullable Integer maxMessageLength, @Nullable Boolean markMessagesPending, @Nullable AutoMod automod, @Nullable AutoModBehavior automodBehavior, @Nullable String blocklist, @Nullable BlocklistBehavior blocklistBehavior, @Nullable List<String> commands, @Nullable List<PermissionRequestObject> permissions, @Nullable Map<String, List<String>> grants, @Nullable String name, @Nullable Boolean countMessages) {
            this.typingEvents = typingEvents;
            this.readEvents = readEvents;
            this.reminders = reminders;
            this.userMessageReminders = userMessageReminders;
            this.connectEvents = connectEvents;
            this.search = search;
            this.reactions = reactions;
            this.replies = replies;
            this.quotes = quotes;
            this.uploads = uploads;
            this.urlEnrichment = urlEnrichment;
            this.customEvents = customEvents;
            this.mutes = mutes;
            this.pushNotifications = pushNotifications;
            this.messageRetention = messageRetention;
            this.maxMessageLength = maxMessageLength;
            this.markMessagesPending = markMessagesPending;
            this.automod = automod;
            this.automodBehavior = automodBehavior;
            this.blocklist = blocklist;
            this.blocklistBehavior = blocklistBehavior;
            this.commands = commands;
            this.permissions = permissions;
            this.grants = grants;
            this.name = name;
            this.countMessages = countMessages;
        }

        @Nullable
        public Boolean getTypingEvents() {
            return this.typingEvents;
        }

        @Nullable
        public Boolean getReadEvents() {
            return this.readEvents;
        }

        @Nullable
        public Boolean getReminders() {
            return this.reminders;
        }

        @Nullable
        public Boolean getUserMessageReminders() {
            return this.userMessageReminders;
        }

        @Nullable
        public Boolean getConnectEvents() {
            return this.connectEvents;
        }

        @Nullable
        public Boolean getSearch() {
            return this.search;
        }

        @Nullable
        public Boolean getReactions() {
            return this.reactions;
        }

        @Nullable
        public Boolean getReplies() {
            return this.replies;
        }

        @Nullable
        public Boolean getQuotes() {
            return this.quotes;
        }

        @Nullable
        public Boolean getUploads() {
            return this.uploads;
        }

        @Nullable
        public Boolean getUrlEnrichment() {
            return this.urlEnrichment;
        }

        @Nullable
        public Boolean getCustomEvents() {
            return this.customEvents;
        }

        @Nullable
        public Boolean getMutes() {
            return this.mutes;
        }

        @Nullable
        public Boolean getPushNotifications() {
            return this.pushNotifications;
        }

        @Nullable
        public String getMessageRetention() {
            return this.messageRetention;
        }

        @Nullable
        public Integer getMaxMessageLength() {
            return this.maxMessageLength;
        }

        @Nullable
        public Boolean getMarkMessagesPending() {
            return this.markMessagesPending;
        }

        @Nullable
        public AutoMod getAutomod() {
            return this.automod;
        }

        @Nullable
        public AutoModBehavior getAutomodBehavior() {
            return this.automodBehavior;
        }

        @Nullable
        public String getBlocklist() {
            return this.blocklist;
        }

        @Nullable
        public BlocklistBehavior getBlocklistBehavior() {
            return this.blocklistBehavior;
        }

        @Nullable
        public List<String> getCommands() {
            return this.commands;
        }

        @Nullable
        public List<PermissionRequestObject> getPermissions() {
            return this.permissions;
        }

        @Nullable
        public Map<String, List<String>> getGrants() {
            return this.grants;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public Boolean getCountMessages() {
            return this.countMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeCreateRequestData)) {
                return false;
            }
            ChannelTypeCreateRequestData other = (ChannelTypeCreateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$typingEvents = this.getTypingEvents();
            Boolean other$typingEvents = other.getTypingEvents();
            if (this$typingEvents == null ? other$typingEvents != null : !((Object)this$typingEvents).equals(other$typingEvents)) {
                return false;
            }
            Boolean this$readEvents = this.getReadEvents();
            Boolean other$readEvents = other.getReadEvents();
            if (this$readEvents == null ? other$readEvents != null : !((Object)this$readEvents).equals(other$readEvents)) {
                return false;
            }
            Boolean this$reminders = this.getReminders();
            Boolean other$reminders = other.getReminders();
            if (this$reminders == null ? other$reminders != null : !((Object)this$reminders).equals(other$reminders)) {
                return false;
            }
            Boolean this$userMessageReminders = this.getUserMessageReminders();
            Boolean other$userMessageReminders = other.getUserMessageReminders();
            if (this$userMessageReminders == null ? other$userMessageReminders != null : !((Object)this$userMessageReminders).equals(other$userMessageReminders)) {
                return false;
            }
            Boolean this$connectEvents = this.getConnectEvents();
            Boolean other$connectEvents = other.getConnectEvents();
            if (this$connectEvents == null ? other$connectEvents != null : !((Object)this$connectEvents).equals(other$connectEvents)) {
                return false;
            }
            Boolean this$search = this.getSearch();
            Boolean other$search = other.getSearch();
            if (this$search == null ? other$search != null : !((Object)this$search).equals(other$search)) {
                return false;
            }
            Boolean this$reactions = this.getReactions();
            Boolean other$reactions = other.getReactions();
            if (this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions)) {
                return false;
            }
            Boolean this$replies = this.getReplies();
            Boolean other$replies = other.getReplies();
            if (this$replies == null ? other$replies != null : !((Object)this$replies).equals(other$replies)) {
                return false;
            }
            Boolean this$quotes = this.getQuotes();
            Boolean other$quotes = other.getQuotes();
            if (this$quotes == null ? other$quotes != null : !((Object)this$quotes).equals(other$quotes)) {
                return false;
            }
            Boolean this$uploads = this.getUploads();
            Boolean other$uploads = other.getUploads();
            if (this$uploads == null ? other$uploads != null : !((Object)this$uploads).equals(other$uploads)) {
                return false;
            }
            Boolean this$urlEnrichment = this.getUrlEnrichment();
            Boolean other$urlEnrichment = other.getUrlEnrichment();
            if (this$urlEnrichment == null ? other$urlEnrichment != null : !((Object)this$urlEnrichment).equals(other$urlEnrichment)) {
                return false;
            }
            Boolean this$customEvents = this.getCustomEvents();
            Boolean other$customEvents = other.getCustomEvents();
            if (this$customEvents == null ? other$customEvents != null : !((Object)this$customEvents).equals(other$customEvents)) {
                return false;
            }
            Boolean this$mutes = this.getMutes();
            Boolean other$mutes = other.getMutes();
            if (this$mutes == null ? other$mutes != null : !((Object)this$mutes).equals(other$mutes)) {
                return false;
            }
            Boolean this$pushNotifications = this.getPushNotifications();
            Boolean other$pushNotifications = other.getPushNotifications();
            if (this$pushNotifications == null ? other$pushNotifications != null : !((Object)this$pushNotifications).equals(other$pushNotifications)) {
                return false;
            }
            Integer this$maxMessageLength = this.getMaxMessageLength();
            Integer other$maxMessageLength = other.getMaxMessageLength();
            if (this$maxMessageLength == null ? other$maxMessageLength != null : !((Object)this$maxMessageLength).equals(other$maxMessageLength)) {
                return false;
            }
            Boolean this$markMessagesPending = this.getMarkMessagesPending();
            Boolean other$markMessagesPending = other.getMarkMessagesPending();
            if (this$markMessagesPending == null ? other$markMessagesPending != null : !((Object)this$markMessagesPending).equals(other$markMessagesPending)) {
                return false;
            }
            Boolean this$countMessages = this.getCountMessages();
            Boolean other$countMessages = other.getCountMessages();
            if (this$countMessages == null ? other$countMessages != null : !((Object)this$countMessages).equals(other$countMessages)) {
                return false;
            }
            String this$messageRetention = this.getMessageRetention();
            String other$messageRetention = other.getMessageRetention();
            if (this$messageRetention == null ? other$messageRetention != null : !this$messageRetention.equals(other$messageRetention)) {
                return false;
            }
            AutoMod this$automod = this.getAutomod();
            AutoMod other$automod = other.getAutomod();
            if (this$automod == null ? other$automod != null : !((Object)((Object)this$automod)).equals((Object)other$automod)) {
                return false;
            }
            AutoModBehavior this$automodBehavior = this.getAutomodBehavior();
            AutoModBehavior other$automodBehavior = other.getAutomodBehavior();
            if (this$automodBehavior == null ? other$automodBehavior != null : !((Object)((Object)this$automodBehavior)).equals((Object)other$automodBehavior)) {
                return false;
            }
            String this$blocklist = this.getBlocklist();
            String other$blocklist = other.getBlocklist();
            if (this$blocklist == null ? other$blocklist != null : !this$blocklist.equals(other$blocklist)) {
                return false;
            }
            BlocklistBehavior this$blocklistBehavior = this.getBlocklistBehavior();
            BlocklistBehavior other$blocklistBehavior = other.getBlocklistBehavior();
            if (this$blocklistBehavior == null ? other$blocklistBehavior != null : !((Object)((Object)this$blocklistBehavior)).equals((Object)other$blocklistBehavior)) {
                return false;
            }
            List<String> this$commands = this.getCommands();
            List<String> other$commands = other.getCommands();
            if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
                return false;
            }
            List<PermissionRequestObject> this$permissions = this.getPermissions();
            List<PermissionRequestObject> other$permissions = other.getPermissions();
            if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                return false;
            }
            Map<String, List<String>> this$grants = this.getGrants();
            Map<String, List<String>> other$grants = other.getGrants();
            if (this$grants == null ? other$grants != null : !((Object)this$grants).equals(other$grants)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeCreateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $typingEvents = this.getTypingEvents();
            result = result * 59 + ($typingEvents == null ? 43 : ((Object)$typingEvents).hashCode());
            Boolean $readEvents = this.getReadEvents();
            result = result * 59 + ($readEvents == null ? 43 : ((Object)$readEvents).hashCode());
            Boolean $reminders = this.getReminders();
            result = result * 59 + ($reminders == null ? 43 : ((Object)$reminders).hashCode());
            Boolean $userMessageReminders = this.getUserMessageReminders();
            result = result * 59 + ($userMessageReminders == null ? 43 : ((Object)$userMessageReminders).hashCode());
            Boolean $connectEvents = this.getConnectEvents();
            result = result * 59 + ($connectEvents == null ? 43 : ((Object)$connectEvents).hashCode());
            Boolean $search = this.getSearch();
            result = result * 59 + ($search == null ? 43 : ((Object)$search).hashCode());
            Boolean $reactions = this.getReactions();
            result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
            Boolean $replies = this.getReplies();
            result = result * 59 + ($replies == null ? 43 : ((Object)$replies).hashCode());
            Boolean $quotes = this.getQuotes();
            result = result * 59 + ($quotes == null ? 43 : ((Object)$quotes).hashCode());
            Boolean $uploads = this.getUploads();
            result = result * 59 + ($uploads == null ? 43 : ((Object)$uploads).hashCode());
            Boolean $urlEnrichment = this.getUrlEnrichment();
            result = result * 59 + ($urlEnrichment == null ? 43 : ((Object)$urlEnrichment).hashCode());
            Boolean $customEvents = this.getCustomEvents();
            result = result * 59 + ($customEvents == null ? 43 : ((Object)$customEvents).hashCode());
            Boolean $mutes = this.getMutes();
            result = result * 59 + ($mutes == null ? 43 : ((Object)$mutes).hashCode());
            Boolean $pushNotifications = this.getPushNotifications();
            result = result * 59 + ($pushNotifications == null ? 43 : ((Object)$pushNotifications).hashCode());
            Integer $maxMessageLength = this.getMaxMessageLength();
            result = result * 59 + ($maxMessageLength == null ? 43 : ((Object)$maxMessageLength).hashCode());
            Boolean $markMessagesPending = this.getMarkMessagesPending();
            result = result * 59 + ($markMessagesPending == null ? 43 : ((Object)$markMessagesPending).hashCode());
            Boolean $countMessages = this.getCountMessages();
            result = result * 59 + ($countMessages == null ? 43 : ((Object)$countMessages).hashCode());
            String $messageRetention = this.getMessageRetention();
            result = result * 59 + ($messageRetention == null ? 43 : $messageRetention.hashCode());
            AutoMod $automod = this.getAutomod();
            result = result * 59 + ($automod == null ? 43 : ((Object)((Object)$automod)).hashCode());
            AutoModBehavior $automodBehavior = this.getAutomodBehavior();
            result = result * 59 + ($automodBehavior == null ? 43 : ((Object)((Object)$automodBehavior)).hashCode());
            String $blocklist = this.getBlocklist();
            result = result * 59 + ($blocklist == null ? 43 : $blocklist.hashCode());
            BlocklistBehavior $blocklistBehavior = this.getBlocklistBehavior();
            result = result * 59 + ($blocklistBehavior == null ? 43 : ((Object)((Object)$blocklistBehavior)).hashCode());
            List<String> $commands = this.getCommands();
            result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
            List<PermissionRequestObject> $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
            Map<String, List<String>> $grants = this.getGrants();
            result = result * 59 + ($grants == null ? 43 : ((Object)$grants).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public static class ChannelTypeCreateRequest
        extends StreamRequest<ChannelTypeCreateResponse> {
            private Boolean typingEvents;
            private Boolean readEvents;
            private Boolean reminders;
            private Boolean userMessageReminders;
            private Boolean connectEvents;
            private Boolean search;
            private Boolean reactions;
            private Boolean replies;
            private Boolean quotes;
            private Boolean uploads;
            private Boolean urlEnrichment;
            private Boolean customEvents;
            private Boolean mutes;
            private Boolean pushNotifications;
            private String messageRetention;
            private Integer maxMessageLength;
            private Boolean markMessagesPending;
            private AutoMod automod;
            private AutoModBehavior automodBehavior;
            private String blocklist;
            private BlocklistBehavior blocklistBehavior;
            private List<String> commands;
            private ArrayList<PermissionRequestObject> permissions;
            private Map<String, List<String>> grants;
            private String name;
            private Boolean countMessages;
            private static final boolean DEFAULT_PUSH_NOTIFICATIONS = true;
            private static final AutoModBehavior DEFAULT_MOD_BEHAVIOR = AutoModBehavior.FLAG;
            private static final AutoMod DEFAULT_AUTOMOD = AutoMod.DISABLED;
            private static final String DEFAULT_MESSAGE_RETENTION = "infinite";
            private static final int DEFAULT_MAX_MESSAGE_LENGTH = 5000;

            public ChannelTypeCreateRequest withDefaultConfig() {
                return this.automod(DEFAULT_AUTOMOD).automodBehavior(DEFAULT_MOD_BEHAVIOR).maxMessageLength(5000).messageRetention(DEFAULT_MESSAGE_RETENTION).pushNotifications(true);
            }

            @Override
            protected Call<ChannelTypeCreateResponse> generateCall(Client client) {
                return client.create(ChannelTypeService.class).create(this.internalBuild());
            }

            ChannelTypeCreateRequest() {
            }

            @JsonProperty(value="typing_events")
            public ChannelTypeCreateRequest typingEvents(@Nullable Boolean typingEvents) {
                this.typingEvents = typingEvents;
                return this;
            }

            @JsonProperty(value="read_events")
            public ChannelTypeCreateRequest readEvents(@Nullable Boolean readEvents) {
                this.readEvents = readEvents;
                return this;
            }

            @JsonProperty(value="reminders")
            public ChannelTypeCreateRequest reminders(@Nullable Boolean reminders) {
                this.reminders = reminders;
                return this;
            }

            @JsonProperty(value="user_message_reminders")
            public ChannelTypeCreateRequest userMessageReminders(@Nullable Boolean userMessageReminders) {
                this.userMessageReminders = userMessageReminders;
                return this;
            }

            @JsonProperty(value="connect_events")
            public ChannelTypeCreateRequest connectEvents(@Nullable Boolean connectEvents) {
                this.connectEvents = connectEvents;
                return this;
            }

            @JsonProperty(value="search")
            public ChannelTypeCreateRequest search(@Nullable Boolean search) {
                this.search = search;
                return this;
            }

            @JsonProperty(value="reactions")
            public ChannelTypeCreateRequest reactions(@Nullable Boolean reactions) {
                this.reactions = reactions;
                return this;
            }

            @JsonProperty(value="replies")
            public ChannelTypeCreateRequest replies(@Nullable Boolean replies) {
                this.replies = replies;
                return this;
            }

            @JsonProperty(value="quotes")
            public ChannelTypeCreateRequest quotes(@Nullable Boolean quotes) {
                this.quotes = quotes;
                return this;
            }

            @JsonProperty(value="uploads")
            public ChannelTypeCreateRequest uploads(@Nullable Boolean uploads) {
                this.uploads = uploads;
                return this;
            }

            @JsonProperty(value="url_enrichment")
            public ChannelTypeCreateRequest urlEnrichment(@Nullable Boolean urlEnrichment) {
                this.urlEnrichment = urlEnrichment;
                return this;
            }

            @JsonProperty(value="custom_events")
            public ChannelTypeCreateRequest customEvents(@Nullable Boolean customEvents) {
                this.customEvents = customEvents;
                return this;
            }

            @JsonProperty(value="mutes")
            public ChannelTypeCreateRequest mutes(@Nullable Boolean mutes) {
                this.mutes = mutes;
                return this;
            }

            @JsonProperty(value="push_notifications")
            public ChannelTypeCreateRequest pushNotifications(@Nullable Boolean pushNotifications) {
                this.pushNotifications = pushNotifications;
                return this;
            }

            @JsonProperty(value="message_retention")
            public ChannelTypeCreateRequest messageRetention(@Nullable String messageRetention) {
                this.messageRetention = messageRetention;
                return this;
            }

            @JsonProperty(value="max_message_length")
            public ChannelTypeCreateRequest maxMessageLength(@Nullable Integer maxMessageLength) {
                this.maxMessageLength = maxMessageLength;
                return this;
            }

            @JsonProperty(value="mark_messages_pending")
            public ChannelTypeCreateRequest markMessagesPending(@Nullable Boolean markMessagesPending) {
                this.markMessagesPending = markMessagesPending;
                return this;
            }

            @JsonProperty(value="automod")
            public ChannelTypeCreateRequest automod(@Nullable AutoMod automod) {
                this.automod = automod;
                return this;
            }

            @JsonProperty(value="automod_behavior")
            public ChannelTypeCreateRequest automodBehavior(@Nullable AutoModBehavior automodBehavior) {
                this.automodBehavior = automodBehavior;
                return this;
            }

            @JsonProperty(value="blocklist")
            public ChannelTypeCreateRequest blocklist(@Nullable String blocklist) {
                this.blocklist = blocklist;
                return this;
            }

            @JsonProperty(value="blocklist_behavior")
            public ChannelTypeCreateRequest blocklistBehavior(@Nullable BlocklistBehavior blocklistBehavior) {
                this.blocklistBehavior = blocklistBehavior;
                return this;
            }

            @JsonProperty(value="commands")
            public ChannelTypeCreateRequest commands(@Nullable List<String> commands) {
                this.commands = commands;
                return this;
            }

            public ChannelTypeCreateRequest permission(PermissionRequestObject permission) {
                if (this.permissions == null) {
                    this.permissions = new ArrayList();
                }
                this.permissions.add(permission);
                return this;
            }

            @JsonProperty(value="permissions")
            public ChannelTypeCreateRequest permissions(Collection<? extends PermissionRequestObject> permissions) {
                if (permissions == null) {
                    throw new NullPointerException("permissions cannot be null");
                }
                if (this.permissions == null) {
                    this.permissions = new ArrayList();
                }
                this.permissions.addAll(permissions);
                return this;
            }

            public ChannelTypeCreateRequest clearPermissions() {
                if (this.permissions != null) {
                    this.permissions.clear();
                }
                return this;
            }

            @JsonProperty(value="grants")
            public ChannelTypeCreateRequest grants(@Nullable Map<String, List<String>> grants) {
                this.grants = grants;
                return this;
            }

            @JsonProperty(value="name")
            public ChannelTypeCreateRequest name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="count_messages")
            public ChannelTypeCreateRequest countMessages(@Nullable Boolean countMessages) {
                this.countMessages = countMessages;
                return this;
            }

            public ChannelTypeCreateRequestData internalBuild() {
                List<PermissionRequestObject> permissions;
                switch (this.permissions == null ? 0 : this.permissions.size()) {
                    case 0: {
                        permissions = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        permissions = Collections.singletonList(this.permissions.get(0));
                        break;
                    }
                    default: {
                        permissions = Collections.unmodifiableList(new ArrayList<PermissionRequestObject>(this.permissions));
                    }
                }
                return new ChannelTypeCreateRequestData(this.typingEvents, this.readEvents, this.reminders, this.userMessageReminders, this.connectEvents, this.search, this.reactions, this.replies, this.quotes, this.uploads, this.urlEnrichment, this.customEvents, this.mutes, this.pushNotifications, this.messageRetention, this.maxMessageLength, this.markMessagesPending, this.automod, this.automodBehavior, this.blocklist, this.blocklistBehavior, this.commands, permissions, this.grants, this.name, this.countMessages);
            }

            public String toString() {
                return "ChannelType.ChannelTypeCreateRequestData.ChannelTypeCreateRequest(typingEvents=" + this.typingEvents + ", readEvents=" + this.readEvents + ", reminders=" + this.reminders + ", userMessageReminders=" + this.userMessageReminders + ", connectEvents=" + this.connectEvents + ", search=" + this.search + ", reactions=" + this.reactions + ", replies=" + this.replies + ", quotes=" + this.quotes + ", uploads=" + this.uploads + ", urlEnrichment=" + this.urlEnrichment + ", customEvents=" + this.customEvents + ", mutes=" + this.mutes + ", pushNotifications=" + this.pushNotifications + ", messageRetention=" + this.messageRetention + ", maxMessageLength=" + this.maxMessageLength + ", markMessagesPending=" + this.markMessagesPending + ", automod=" + String.valueOf((Object)this.automod) + ", automodBehavior=" + String.valueOf((Object)this.automodBehavior) + ", blocklist=" + this.blocklist + ", blocklistBehavior=" + String.valueOf((Object)this.blocklistBehavior) + ", commands=" + String.valueOf(this.commands) + ", permissions=" + String.valueOf(this.permissions) + ", grants=" + String.valueOf(this.grants) + ", name=" + this.name + ", countMessages=" + this.countMessages + ")";
            }
        }
    }

    public static class PermissionRequestObject {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="action")
        @Nullable
        private Action action;
        @JsonProperty(value="roles")
        @Nullable
        private List<String> roles;
        @JsonProperty(value="owner")
        @Nullable
        private Boolean owner;
        @JsonProperty(value="priority")
        @Nullable
        private Integer priority;
        @JsonProperty(value="resources")
        @Nullable
        private List<String> resources;

        @Nullable
        public static PermissionRequestObject buildFrom(@Nullable Policy policy) {
            return RequestObjectBuilder.build(PermissionRequestObject.class, policy);
        }

        PermissionRequestObject(@Nullable String name, @Nullable Action action, @Nullable List<String> roles, @Nullable Boolean owner, @Nullable Integer priority, @Nullable List<String> resources) {
            this.name = name;
            this.action = action;
            this.roles = roles;
            this.owner = owner;
            this.priority = priority;
            this.resources = resources;
        }

        public static PermissionRequestObjectBuilder builder() {
            return new PermissionRequestObjectBuilder();
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="action")
        public void setAction(@Nullable Action action) {
            this.action = action;
        }

        @JsonProperty(value="roles")
        public void setRoles(@Nullable List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="owner")
        public void setOwner(@Nullable Boolean owner) {
            this.owner = owner;
        }

        @JsonProperty(value="priority")
        public void setPriority(@Nullable Integer priority) {
            this.priority = priority;
        }

        @JsonProperty(value="resources")
        public void setResources(@Nullable List<String> resources) {
            this.resources = resources;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public Action getAction() {
            return this.action;
        }

        @Nullable
        public List<String> getRoles() {
            return this.roles;
        }

        @Nullable
        public Boolean getOwner() {
            return this.owner;
        }

        @Nullable
        public Integer getPriority() {
            return this.priority;
        }

        @Nullable
        public List<String> getResources() {
            return this.resources;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionRequestObject)) {
                return false;
            }
            PermissionRequestObject other = (PermissionRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$owner = this.getOwner();
            Boolean other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
                return false;
            }
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            List<String> this$roles = this.getRoles();
            List<String> other$roles = other.getRoles();
            if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
                return false;
            }
            List<String> this$resources = this.getResources();
            List<String> other$resources = other.getResources();
            return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PermissionRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            List<String> $roles = this.getRoles();
            result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
            List<String> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            return result;
        }

        public static class PermissionRequestObjectBuilder {
            private String name;
            private Action action;
            private List<String> roles;
            private Boolean owner;
            private Integer priority;
            private List<String> resources;

            PermissionRequestObjectBuilder() {
            }

            @JsonProperty(value="name")
            public PermissionRequestObjectBuilder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="action")
            public PermissionRequestObjectBuilder action(@Nullable Action action) {
                this.action = action;
                return this;
            }

            @JsonProperty(value="roles")
            public PermissionRequestObjectBuilder roles(@Nullable List<String> roles) {
                this.roles = roles;
                return this;
            }

            @JsonProperty(value="owner")
            public PermissionRequestObjectBuilder owner(@Nullable Boolean owner) {
                this.owner = owner;
                return this;
            }

            @JsonProperty(value="priority")
            public PermissionRequestObjectBuilder priority(@Nullable Integer priority) {
                this.priority = priority;
                return this;
            }

            @JsonProperty(value="resources")
            public PermissionRequestObjectBuilder resources(@Nullable List<String> resources) {
                this.resources = resources;
                return this;
            }

            public PermissionRequestObject build() {
                return new PermissionRequestObject(this.name, this.action, this.roles, this.owner, this.priority, this.resources);
            }

            public String toString() {
                return "ChannelType.PermissionRequestObject.PermissionRequestObjectBuilder(name=" + this.name + ", action=" + String.valueOf((Object)this.action) + ", roles=" + String.valueOf(this.roles) + ", owner=" + this.owner + ", priority=" + this.priority + ", resources=" + String.valueOf(this.resources) + ")";
            }
        }
    }

    public static class ThresholdRequestObject {
        @JsonProperty(value="flag")
        @Nullable
        private Integer flag;
        @JsonProperty(value="block")
        @Nullable
        private Integer block;

        @Nullable
        public static ThresholdRequestObject buildFrom(@Nullable Threshold threshold) {
            return RequestObjectBuilder.build(ThresholdRequestObject.class, threshold);
        }

        ThresholdRequestObject(@Nullable Integer flag, @Nullable Integer block) {
            this.flag = flag;
            this.block = block;
        }

        public static ThresholdRequestObjectBuilder builder() {
            return new ThresholdRequestObjectBuilder();
        }

        @JsonProperty(value="flag")
        public void setFlag(@Nullable Integer flag) {
            this.flag = flag;
        }

        @JsonProperty(value="block")
        public void setBlock(@Nullable Integer block) {
            this.block = block;
        }

        @Nullable
        public Integer getFlag() {
            return this.flag;
        }

        @Nullable
        public Integer getBlock() {
            return this.block;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThresholdRequestObject)) {
                return false;
            }
            ThresholdRequestObject other = (ThresholdRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$flag = this.getFlag();
            Integer other$flag = other.getFlag();
            if (this$flag == null ? other$flag != null : !((Object)this$flag).equals(other$flag)) {
                return false;
            }
            Integer this$block = this.getBlock();
            Integer other$block = other.getBlock();
            return !(this$block == null ? other$block != null : !((Object)this$block).equals(other$block));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThresholdRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $flag = this.getFlag();
            result = result * 59 + ($flag == null ? 43 : ((Object)$flag).hashCode());
            Integer $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : ((Object)$block).hashCode());
            return result;
        }

        public static class ThresholdRequestObjectBuilder {
            private Integer flag;
            private Integer block;

            ThresholdRequestObjectBuilder() {
            }

            @JsonProperty(value="flag")
            public ThresholdRequestObjectBuilder flag(@Nullable Integer flag) {
                this.flag = flag;
                return this;
            }

            @JsonProperty(value="block")
            public ThresholdRequestObjectBuilder block(@Nullable Integer block) {
                this.block = block;
                return this;
            }

            public ThresholdRequestObject build() {
                return new ThresholdRequestObject(this.flag, this.block);
            }

            public String toString() {
                return "ChannelType.ThresholdRequestObject.ThresholdRequestObjectBuilder(flag=" + this.flag + ", block=" + this.block + ")";
            }
        }
    }

    public static class ChannelTypeWithCommands
    extends ChannelType {
        @JsonProperty(value="commands")
        @Nullable
        private List<Command> commands;

        @Nullable
        public List<Command> getCommands() {
            return this.commands;
        }

        @JsonProperty(value="commands")
        public void setCommands(@Nullable List<Command> commands) {
            this.commands = commands;
        }

        @Override
        public String toString() {
            return "ChannelType.ChannelTypeWithCommands(commands=" + String.valueOf(this.getCommands()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeWithCommands)) {
                return false;
            }
            ChannelTypeWithCommands other = (ChannelTypeWithCommands)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Command> this$commands = this.getCommands();
            List<Command> other$commands = other.getCommands();
            return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeWithCommands;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Command> $commands = this.getCommands();
            result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
            return result;
        }
    }

    public static class ChannelTypeWithStringCommands
    extends ChannelType {
        @JsonProperty(value="commands")
        @Nullable
        private List<String> commands;

        @Nullable
        public List<String> getCommands() {
            return this.commands;
        }

        @JsonProperty(value="commands")
        public void setCommands(@Nullable List<String> commands) {
            this.commands = commands;
        }

        @Override
        public String toString() {
            return "ChannelType.ChannelTypeWithStringCommands(commands=" + String.valueOf(this.getCommands()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChannelTypeWithStringCommands)) {
                return false;
            }
            ChannelTypeWithStringCommands other = (ChannelTypeWithStringCommands)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<String> this$commands = this.getCommands();
            List<String> other$commands = other.getCommands();
            return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ChannelTypeWithStringCommands;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<String> $commands = this.getCommands();
            result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
            return result;
        }
    }

    public static enum BlocklistBehavior {
        FLAG,
        BLOCK,
        UNKNOWN;

    }

    public static enum AutoModBehavior {
        FLAG,
        BLOCK,
        UNKNOWN;

    }

    public static enum AutoMod {
        DISABLED,
        SIMPLE,
        AI,
        UNKNOWN;

    }

    public static class Right {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="owner")
        @NotNull
        private Boolean owner;
        @JsonProperty(value="same_team")
        @NotNull
        private Boolean sameTeam;
        @JsonProperty(value="custom")
        @NotNull
        private Boolean custom;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Boolean getOwner() {
            return this.owner;
        }

        @NotNull
        public Boolean getSameTeam() {
            return this.sameTeam;
        }

        @NotNull
        public Boolean getCustom() {
            return this.custom;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="owner")
        public void setOwner(@NotNull Boolean owner) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            this.owner = owner;
        }

        @JsonProperty(value="same_team")
        public void setSameTeam(@NotNull Boolean sameTeam) {
            if (sameTeam == null) {
                throw new NullPointerException("sameTeam is marked non-null but is null");
            }
            this.sameTeam = sameTeam;
        }

        @JsonProperty(value="custom")
        public void setCustom(@NotNull Boolean custom) {
            if (custom == null) {
                throw new NullPointerException("custom is marked non-null but is null");
            }
            this.custom = custom;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Right)) {
                return false;
            }
            Right other = (Right)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$owner = this.getOwner();
            Boolean other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
                return false;
            }
            Boolean this$sameTeam = this.getSameTeam();
            Boolean other$sameTeam = other.getSameTeam();
            if (this$sameTeam == null ? other$sameTeam != null : !((Object)this$sameTeam).equals(other$sameTeam)) {
                return false;
            }
            Boolean this$custom = this.getCustom();
            Boolean other$custom = other.getCustom();
            if (this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Right;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
            Boolean $sameTeam = this.getSameTeam();
            result = result * 59 + ($sameTeam == null ? 43 : ((Object)$sameTeam).hashCode());
            Boolean $custom = this.getCustom();
            result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ChannelType.Right(name=" + this.getName() + ", owner=" + this.getOwner() + ", sameTeam=" + this.getSameTeam() + ", custom=" + this.getCustom() + ")";
        }
    }

    public static enum Action {
        DENY,
        ALLOW,
        UNKNOWN;

    }

    public static class Policy {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="action")
        @NotNull
        private Action action;
        @JsonProperty(value="roles")
        @NotNull
        private List<String> roles;
        @JsonProperty(value="owner")
        @NotNull
        private Boolean owner;
        @JsonProperty(value="priority")
        @NotNull
        private Integer priority;
        @JsonProperty(value="resources")
        @NotNull
        private List<String> resources;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public Action getAction() {
            return this.action;
        }

        @NotNull
        public List<String> getRoles() {
            return this.roles;
        }

        @NotNull
        public Boolean getOwner() {
            return this.owner;
        }

        @NotNull
        public Integer getPriority() {
            return this.priority;
        }

        @NotNull
        public List<String> getResources() {
            return this.resources;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="action")
        public void setAction(@NotNull Action action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
        }

        @JsonProperty(value="roles")
        public void setRoles(@NotNull List<String> roles) {
            if (roles == null) {
                throw new NullPointerException("roles is marked non-null but is null");
            }
            this.roles = roles;
        }

        @JsonProperty(value="owner")
        public void setOwner(@NotNull Boolean owner) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            this.owner = owner;
        }

        @JsonProperty(value="priority")
        public void setPriority(@NotNull Integer priority) {
            if (priority == null) {
                throw new NullPointerException("priority is marked non-null but is null");
            }
            this.priority = priority;
        }

        @JsonProperty(value="resources")
        public void setResources(@NotNull List<String> resources) {
            if (resources == null) {
                throw new NullPointerException("resources is marked non-null but is null");
            }
            this.resources = resources;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Policy)) {
                return false;
            }
            Policy other = (Policy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$owner = this.getOwner();
            Boolean other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
                return false;
            }
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            List<String> this$roles = this.getRoles();
            List<String> other$roles = other.getRoles();
            if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
                return false;
            }
            List<String> this$resources = this.getResources();
            List<String> other$resources = other.getResources();
            return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Policy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            List<String> $roles = this.getRoles();
            result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
            List<String> $resources = this.getResources();
            result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
            return result;
        }

        public String toString() {
            return "ChannelType.Policy(name=" + this.getName() + ", action=" + String.valueOf((Object)this.getAction()) + ", roles=" + String.valueOf(this.getRoles()) + ", owner=" + this.getOwner() + ", priority=" + this.getPriority() + ", resources=" + String.valueOf(this.getResources()) + ")";
        }
    }

    public static class Threshold {
        @JsonProperty(value="flag")
        @Nullable
        private Integer flag;
        @JsonProperty(value="block")
        @Nullable
        private Integer block;

        @Nullable
        public Integer getFlag() {
            return this.flag;
        }

        @Nullable
        public Integer getBlock() {
            return this.block;
        }

        @JsonProperty(value="flag")
        public void setFlag(@Nullable Integer flag) {
            this.flag = flag;
        }

        @JsonProperty(value="block")
        public void setBlock(@Nullable Integer block) {
            this.block = block;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Threshold)) {
                return false;
            }
            Threshold other = (Threshold)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$flag = this.getFlag();
            Integer other$flag = other.getFlag();
            if (this$flag == null ? other$flag != null : !((Object)this$flag).equals(other$flag)) {
                return false;
            }
            Integer this$block = this.getBlock();
            Integer other$block = other.getBlock();
            return !(this$block == null ? other$block != null : !((Object)this$block).equals(other$block));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Threshold;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $flag = this.getFlag();
            result = result * 59 + ($flag == null ? 43 : ((Object)$flag).hashCode());
            Integer $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : ((Object)$block).hashCode());
            return result;
        }

        public String toString() {
            return "ChannelType.Threshold(flag=" + this.getFlag() + ", block=" + this.getBlock() + ")";
        }
    }
}

