/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.exceptions.StreamException;
import io.getstream.chat.java.models.Channel;
import io.getstream.chat.java.models.Flag;
import io.getstream.chat.java.models.Language;
import io.getstream.chat.java.models.Reaction;
import io.getstream.chat.java.models.SharedLocation;
import io.getstream.chat.java.models.Sort;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.DefaultFileHandler;
import io.getstream.chat.java.models.framework.FileHandler;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponse;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.MessageService;
import io.getstream.chat.java.services.framework.Client;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Message {
    public static Class<? extends FileHandler> fileHandlerClass = DefaultFileHandler.class;
    @JsonProperty(value="id")
    @NotNull
    private String id;
    @JsonProperty(value="text")
    @Nullable
    private String text;
    @JsonProperty(value="mml")
    @Nullable
    private String mml;
    @JsonProperty(value="command")
    @Nullable
    private String command;
    @JsonProperty(value="html")
    @Nullable
    private String html;
    @JsonProperty(value="type")
    @Nullable
    private MessageType type;
    @JsonProperty(value="silent")
    @Nullable
    private Boolean silent;
    @JsonProperty(value="user")
    @Nullable
    private User user;
    @JsonProperty(value="restricted_visibility")
    @Nullable
    private List<String> restrictedVisibility;
    @JsonProperty(value="attachments")
    @Nullable
    private List<Attachment> attachments;
    @JsonProperty(value="latest_reactions")
    @Nullable
    private List<Reaction> latestReactions;
    @JsonProperty(value="own_reactions")
    @Nullable
    private List<Reaction> ownReactions;
    @JsonProperty(value="reaction_counts")
    @Nullable
    private Map<String, Integer> reactionCounts;
    @JsonProperty(value="reaction_scores")
    @Nullable
    private Map<String, Integer> reactionScores;
    @JsonProperty(value="parent_id")
    @Nullable
    private String parentId;
    @JsonProperty(value="show_in_channel")
    @Nullable
    private Boolean showInChannel;
    @JsonProperty(value="reply_count")
    @Nullable
    private Integer replyCount;
    @JsonProperty(value="deleted_reply_count")
    @Nullable
    private Integer deletedReplyCount;
    @JsonProperty(value="quoted_message_id")
    @Nullable
    private String quotedMessageId;
    @JsonProperty(value="quoted_message")
    @Nullable
    private Message quoted_message;
    @JsonProperty(value="thread_participants")
    @Nullable
    private List<User> threadParticipants;
    @JsonProperty(value="cid")
    @NotNull
    private String cid;
    @JsonProperty(value="mentioned_users")
    @Nullable
    private List<User> mentionedUsers;
    @JsonProperty(value="created_at")
    @Nullable
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Nullable
    private Date updatedAt;
    @JsonProperty(value="deleted_at")
    @Nullable
    private Date deletedAt;
    @JsonProperty(value="shadowed")
    @Nullable
    private Boolean shadowed;
    @JsonProperty(value="image_labels")
    @Nullable
    private Map<String, List<String>> imageLabels;
    @JsonProperty(value="i18n")
    @Nullable
    private Map<String, String> i18n;
    private Boolean before_message_send_failed;
    @JsonProperty(value="pinned")
    @Nullable
    private Boolean pinned;
    @JsonProperty(value="pin_expires")
    @Nullable
    private Date pinExpires;
    @JsonProperty(value="pinned_by")
    @Nullable
    private User pinnedBy;
    @JsonProperty(value="pinned_at")
    @Nullable
    private Date pinnedAt;
    @JsonProperty(value="shared_location")
    @Nullable
    private SharedLocation sharedLocation;
    @JsonProperty(value="member")
    @Nullable
    private Channel.ChannelMember member;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static MessageSendRequestData.MessageSendRequest send(@NotNull String channelType, @NotNull String channelId) {
        return new MessageSendRequestData.MessageSendRequest(channelType, channelId);
    }

    @NotNull
    public static MessageGetRequest get(@NotNull String id) {
        return new MessageGetRequest(id);
    }

    @NotNull
    public static MessageUpdateRequestData.MessageUpdateRequest update(@NotNull String id) {
        return new MessageUpdateRequestData.MessageUpdateRequest(id);
    }

    @NotNull
    public static MessageDeleteRequest delete(@NotNull String id) {
        return new MessageDeleteRequest(id);
    }

    @NotNull
    public static MessageDeleteRequest hardDelete(@NotNull String id) {
        return new MessageDeleteRequest(id).hard(true);
    }

    @NotNull
    public static MessageDeleteRequest deleteForMe(@NotNull String id, @NotNull String userId) {
        return new MessageDeleteRequest(id).deleteForMe(userId);
    }

    @NotNull
    public static MessageSearchRequestData.MessageSearchRequest search() {
        return new MessageSearchRequestData.MessageSearchRequest();
    }

    @NotNull
    public static MessageUploadFileRequest uploadFile(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable String contentType) {
        return new MessageUploadFileRequest(channelType, channelId, userId, contentType);
    }

    @NotNull
    public static MessageUploadImageRequest uploadImage(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String contentType) {
        return new MessageUploadImageRequest(channelType, channelId, userId, contentType);
    }

    @NotNull
    public static MessageDeleteFileRequest deleteFile(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        return new MessageDeleteFileRequest(channelType, channelId, url);
    }

    @NotNull
    public static MessageDeleteImageRequest deleteImage(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
        return new MessageDeleteImageRequest(channelType, channelId, url);
    }

    @NotNull
    public static MessageGetManyRequest getMany(@NotNull String channelType, @NotNull String channelId, @NotNull List<String> messageIds) {
        return new MessageGetManyRequest(channelType, channelId, messageIds);
    }

    @NotNull
    public static MessageGetRepliesRequest getReplies(@NotNull String parentMessageId) {
        return new MessageGetRepliesRequest(parentMessageId);
    }

    @NotNull
    public static MessageRunCommandActionRequestData.MessageRunCommandActionRequest runCommandAction(@NotNull String messageId) {
        return new MessageRunCommandActionRequestData.MessageRunCommandActionRequest(messageId);
    }

    @NotNull
    public static MessageTranslateRequestData.MessageTranslateRequest translate(@NotNull String messageId) {
        return new MessageTranslateRequestData.MessageTranslateRequest(messageId);
    }

    @NotNull
    public static MessageCommitRequestData.MessageCommitRequest commit(@NotNull String messageId) {
        return new MessageCommitRequestData.MessageCommitRequest(messageId);
    }

    @NotNull
    public static Flag.FlagCreateRequestData.FlagCreateRequest flag(@NotNull String messageId) {
        return new Flag.FlagCreateRequestData.FlagCreateRequest().targetMessageId(messageId);
    }

    @NotNull
    public static Flag.FlagDeleteRequestData.FlagDeleteRequest unflag(@NotNull String messageId) {
        return new Flag.FlagDeleteRequestData.FlagDeleteRequest().targetMessageId(messageId);
    }

    @NotNull
    public static Flag.FlagMessageQueryRequestData.FlagMessageQueryRequest queryFlags() {
        return new Flag.FlagMessageQueryRequestData.FlagMessageQueryRequest();
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest partialUpdate(@NotNull String id) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id);
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest pinMessage(@NotNull String id, @NotNull String userId) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id).setValue("pinned", true).userId(userId);
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest pinMessage(@NotNull String id, @NotNull String userId, @NotNull Date expiration) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id).setValue("pinned", true).setValue("pin_expires", expiration).userId(userId);
    }

    @NotNull
    public static MessagePartialUpdateRequestData.MessagePartialUpdateRequest unpinMessage(@NotNull String id, @NotNull String userId) {
        return new MessagePartialUpdateRequestData.MessagePartialUpdateRequest(id).setValue("pinned", false).userId(userId);
    }

    @NotNull
    public static MessageUnblockRequestData.MessageUnblockRequest unblock(@NotNull String messageId) {
        return new MessageUnblockRequestData.MessageUnblockRequest().targetMessageId(messageId);
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public String getMml() {
        return this.mml;
    }

    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Nullable
    public String getHtml() {
        return this.html;
    }

    @Nullable
    public MessageType getType() {
        return this.type;
    }

    @Nullable
    public Boolean getSilent() {
        return this.silent;
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public List<String> getRestrictedVisibility() {
        return this.restrictedVisibility;
    }

    @Nullable
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Nullable
    public List<Reaction> getLatestReactions() {
        return this.latestReactions;
    }

    @Nullable
    public List<Reaction> getOwnReactions() {
        return this.ownReactions;
    }

    @Nullable
    public Map<String, Integer> getReactionCounts() {
        return this.reactionCounts;
    }

    @Nullable
    public Map<String, Integer> getReactionScores() {
        return this.reactionScores;
    }

    @Nullable
    public String getParentId() {
        return this.parentId;
    }

    @Nullable
    public Boolean getShowInChannel() {
        return this.showInChannel;
    }

    @Nullable
    public Integer getReplyCount() {
        return this.replyCount;
    }

    @Nullable
    public Integer getDeletedReplyCount() {
        return this.deletedReplyCount;
    }

    @Nullable
    public String getQuotedMessageId() {
        return this.quotedMessageId;
    }

    @Nullable
    public Message getQuoted_message() {
        return this.quoted_message;
    }

    @Nullable
    public List<User> getThreadParticipants() {
        return this.threadParticipants;
    }

    @NotNull
    public String getCid() {
        return this.cid;
    }

    @Nullable
    public List<User> getMentionedUsers() {
        return this.mentionedUsers;
    }

    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Nullable
    public Date getDeletedAt() {
        return this.deletedAt;
    }

    @Nullable
    public Boolean getShadowed() {
        return this.shadowed;
    }

    @Nullable
    public Map<String, List<String>> getImageLabels() {
        return this.imageLabels;
    }

    @Nullable
    public Map<String, String> getI18n() {
        return this.i18n;
    }

    public Boolean getBefore_message_send_failed() {
        return this.before_message_send_failed;
    }

    @Nullable
    public Boolean getPinned() {
        return this.pinned;
    }

    @Nullable
    public Date getPinExpires() {
        return this.pinExpires;
    }

    @Nullable
    public User getPinnedBy() {
        return this.pinnedBy;
    }

    @Nullable
    public Date getPinnedAt() {
        return this.pinnedAt;
    }

    @Nullable
    public SharedLocation getSharedLocation() {
        return this.sharedLocation;
    }

    @Nullable
    public Channel.ChannelMember getMember() {
        return this.member;
    }

    @JsonProperty(value="id")
    public void setId(@NotNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="text")
    public void setText(@Nullable String text) {
        this.text = text;
    }

    @JsonProperty(value="mml")
    public void setMml(@Nullable String mml) {
        this.mml = mml;
    }

    @JsonProperty(value="command")
    public void setCommand(@Nullable String command) {
        this.command = command;
    }

    @JsonProperty(value="html")
    public void setHtml(@Nullable String html) {
        this.html = html;
    }

    @JsonProperty(value="type")
    public void setType(@Nullable MessageType type) {
        this.type = type;
    }

    @JsonProperty(value="silent")
    public void setSilent(@Nullable Boolean silent) {
        this.silent = silent;
    }

    @JsonProperty(value="user")
    public void setUser(@Nullable User user) {
        this.user = user;
    }

    @JsonProperty(value="restricted_visibility")
    public void setRestrictedVisibility(@Nullable List<String> restrictedVisibility) {
        this.restrictedVisibility = restrictedVisibility;
    }

    @JsonProperty(value="attachments")
    public void setAttachments(@Nullable List<Attachment> attachments) {
        this.attachments = attachments;
    }

    @JsonProperty(value="latest_reactions")
    public void setLatestReactions(@Nullable List<Reaction> latestReactions) {
        this.latestReactions = latestReactions;
    }

    @JsonProperty(value="own_reactions")
    public void setOwnReactions(@Nullable List<Reaction> ownReactions) {
        this.ownReactions = ownReactions;
    }

    @JsonProperty(value="reaction_counts")
    public void setReactionCounts(@Nullable Map<String, Integer> reactionCounts) {
        this.reactionCounts = reactionCounts;
    }

    @JsonProperty(value="reaction_scores")
    public void setReactionScores(@Nullable Map<String, Integer> reactionScores) {
        this.reactionScores = reactionScores;
    }

    @JsonProperty(value="parent_id")
    public void setParentId(@Nullable String parentId) {
        this.parentId = parentId;
    }

    @JsonProperty(value="show_in_channel")
    public void setShowInChannel(@Nullable Boolean showInChannel) {
        this.showInChannel = showInChannel;
    }

    @JsonProperty(value="reply_count")
    public void setReplyCount(@Nullable Integer replyCount) {
        this.replyCount = replyCount;
    }

    @JsonProperty(value="deleted_reply_count")
    public void setDeletedReplyCount(@Nullable Integer deletedReplyCount) {
        this.deletedReplyCount = deletedReplyCount;
    }

    @JsonProperty(value="quoted_message_id")
    public void setQuotedMessageId(@Nullable String quotedMessageId) {
        this.quotedMessageId = quotedMessageId;
    }

    @JsonProperty(value="quoted_message")
    public void setQuoted_message(@Nullable Message quoted_message) {
        this.quoted_message = quoted_message;
    }

    @JsonProperty(value="thread_participants")
    public void setThreadParticipants(@Nullable List<User> threadParticipants) {
        this.threadParticipants = threadParticipants;
    }

    @JsonProperty(value="cid")
    public void setCid(@NotNull String cid) {
        if (cid == null) {
            throw new NullPointerException("cid is marked non-null but is null");
        }
        this.cid = cid;
    }

    @JsonProperty(value="mentioned_users")
    public void setMentionedUsers(@Nullable List<User> mentionedUsers) {
        this.mentionedUsers = mentionedUsers;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@Nullable Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@Nullable Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="deleted_at")
    public void setDeletedAt(@Nullable Date deletedAt) {
        this.deletedAt = deletedAt;
    }

    @JsonProperty(value="shadowed")
    public void setShadowed(@Nullable Boolean shadowed) {
        this.shadowed = shadowed;
    }

    @JsonProperty(value="image_labels")
    public void setImageLabels(@Nullable Map<String, List<String>> imageLabels) {
        this.imageLabels = imageLabels;
    }

    @JsonProperty(value="i18n")
    public void setI18n(@Nullable Map<String, String> i18n) {
        this.i18n = i18n;
    }

    public void setBefore_message_send_failed(Boolean before_message_send_failed) {
        this.before_message_send_failed = before_message_send_failed;
    }

    @JsonProperty(value="pinned")
    public void setPinned(@Nullable Boolean pinned) {
        this.pinned = pinned;
    }

    @JsonProperty(value="pin_expires")
    public void setPinExpires(@Nullable Date pinExpires) {
        this.pinExpires = pinExpires;
    }

    @JsonProperty(value="pinned_by")
    public void setPinnedBy(@Nullable User pinnedBy) {
        this.pinnedBy = pinnedBy;
    }

    @JsonProperty(value="pinned_at")
    public void setPinnedAt(@Nullable Date pinnedAt) {
        this.pinnedAt = pinnedAt;
    }

    @JsonProperty(value="shared_location")
    public void setSharedLocation(@Nullable SharedLocation sharedLocation) {
        this.sharedLocation = sharedLocation;
    }

    @JsonProperty(value="member")
    public void setMember(@Nullable Channel.ChannelMember member) {
        this.member = member;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$silent = this.getSilent();
        Boolean other$silent = other.getSilent();
        if (this$silent == null ? other$silent != null : !((Object)this$silent).equals(other$silent)) {
            return false;
        }
        Boolean this$showInChannel = this.getShowInChannel();
        Boolean other$showInChannel = other.getShowInChannel();
        if (this$showInChannel == null ? other$showInChannel != null : !((Object)this$showInChannel).equals(other$showInChannel)) {
            return false;
        }
        Integer this$replyCount = this.getReplyCount();
        Integer other$replyCount = other.getReplyCount();
        if (this$replyCount == null ? other$replyCount != null : !((Object)this$replyCount).equals(other$replyCount)) {
            return false;
        }
        Integer this$deletedReplyCount = this.getDeletedReplyCount();
        Integer other$deletedReplyCount = other.getDeletedReplyCount();
        if (this$deletedReplyCount == null ? other$deletedReplyCount != null : !((Object)this$deletedReplyCount).equals(other$deletedReplyCount)) {
            return false;
        }
        Boolean this$shadowed = this.getShadowed();
        Boolean other$shadowed = other.getShadowed();
        if (this$shadowed == null ? other$shadowed != null : !((Object)this$shadowed).equals(other$shadowed)) {
            return false;
        }
        Boolean this$before_message_send_failed = this.getBefore_message_send_failed();
        Boolean other$before_message_send_failed = other.getBefore_message_send_failed();
        if (this$before_message_send_failed == null ? other$before_message_send_failed != null : !((Object)this$before_message_send_failed).equals(other$before_message_send_failed)) {
            return false;
        }
        Boolean this$pinned = this.getPinned();
        Boolean other$pinned = other.getPinned();
        if (this$pinned == null ? other$pinned != null : !((Object)this$pinned).equals(other$pinned)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$mml = this.getMml();
        String other$mml = other.getMml();
        if (this$mml == null ? other$mml != null : !this$mml.equals(other$mml)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$html = this.getHtml();
        String other$html = other.getHtml();
        if (this$html == null ? other$html != null : !this$html.equals(other$html)) {
            return false;
        }
        MessageType this$type = this.getType();
        MessageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        List<String> this$restrictedVisibility = this.getRestrictedVisibility();
        List<String> other$restrictedVisibility = other.getRestrictedVisibility();
        if (this$restrictedVisibility == null ? other$restrictedVisibility != null : !((Object)this$restrictedVisibility).equals(other$restrictedVisibility)) {
            return false;
        }
        List<Attachment> this$attachments = this.getAttachments();
        List<Attachment> other$attachments = other.getAttachments();
        if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
            return false;
        }
        List<Reaction> this$latestReactions = this.getLatestReactions();
        List<Reaction> other$latestReactions = other.getLatestReactions();
        if (this$latestReactions == null ? other$latestReactions != null : !((Object)this$latestReactions).equals(other$latestReactions)) {
            return false;
        }
        List<Reaction> this$ownReactions = this.getOwnReactions();
        List<Reaction> other$ownReactions = other.getOwnReactions();
        if (this$ownReactions == null ? other$ownReactions != null : !((Object)this$ownReactions).equals(other$ownReactions)) {
            return false;
        }
        Map<String, Integer> this$reactionCounts = this.getReactionCounts();
        Map<String, Integer> other$reactionCounts = other.getReactionCounts();
        if (this$reactionCounts == null ? other$reactionCounts != null : !((Object)this$reactionCounts).equals(other$reactionCounts)) {
            return false;
        }
        Map<String, Integer> this$reactionScores = this.getReactionScores();
        Map<String, Integer> other$reactionScores = other.getReactionScores();
        if (this$reactionScores == null ? other$reactionScores != null : !((Object)this$reactionScores).equals(other$reactionScores)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$quotedMessageId = this.getQuotedMessageId();
        String other$quotedMessageId = other.getQuotedMessageId();
        if (this$quotedMessageId == null ? other$quotedMessageId != null : !this$quotedMessageId.equals(other$quotedMessageId)) {
            return false;
        }
        Message this$quoted_message = this.getQuoted_message();
        Message other$quoted_message = other.getQuoted_message();
        if (this$quoted_message == null ? other$quoted_message != null : !((Object)this$quoted_message).equals(other$quoted_message)) {
            return false;
        }
        List<User> this$threadParticipants = this.getThreadParticipants();
        List<User> other$threadParticipants = other.getThreadParticipants();
        if (this$threadParticipants == null ? other$threadParticipants != null : !((Object)this$threadParticipants).equals(other$threadParticipants)) {
            return false;
        }
        String this$cid = this.getCid();
        String other$cid = other.getCid();
        if (this$cid == null ? other$cid != null : !this$cid.equals(other$cid)) {
            return false;
        }
        List<User> this$mentionedUsers = this.getMentionedUsers();
        List<User> other$mentionedUsers = other.getMentionedUsers();
        if (this$mentionedUsers == null ? other$mentionedUsers != null : !((Object)this$mentionedUsers).equals(other$mentionedUsers)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Date this$deletedAt = this.getDeletedAt();
        Date other$deletedAt = other.getDeletedAt();
        if (this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt)) {
            return false;
        }
        Map<String, List<String>> this$imageLabels = this.getImageLabels();
        Map<String, List<String>> other$imageLabels = other.getImageLabels();
        if (this$imageLabels == null ? other$imageLabels != null : !((Object)this$imageLabels).equals(other$imageLabels)) {
            return false;
        }
        Map<String, String> this$i18n = this.getI18n();
        Map<String, String> other$i18n = other.getI18n();
        if (this$i18n == null ? other$i18n != null : !((Object)this$i18n).equals(other$i18n)) {
            return false;
        }
        Date this$pinExpires = this.getPinExpires();
        Date other$pinExpires = other.getPinExpires();
        if (this$pinExpires == null ? other$pinExpires != null : !((Object)this$pinExpires).equals(other$pinExpires)) {
            return false;
        }
        User this$pinnedBy = this.getPinnedBy();
        User other$pinnedBy = other.getPinnedBy();
        if (this$pinnedBy == null ? other$pinnedBy != null : !((Object)this$pinnedBy).equals(other$pinnedBy)) {
            return false;
        }
        Date this$pinnedAt = this.getPinnedAt();
        Date other$pinnedAt = other.getPinnedAt();
        if (this$pinnedAt == null ? other$pinnedAt != null : !((Object)this$pinnedAt).equals(other$pinnedAt)) {
            return false;
        }
        SharedLocation this$sharedLocation = this.getSharedLocation();
        SharedLocation other$sharedLocation = other.getSharedLocation();
        if (this$sharedLocation == null ? other$sharedLocation != null : !((Object)this$sharedLocation).equals(other$sharedLocation)) {
            return false;
        }
        Channel.ChannelMember this$member = this.getMember();
        Channel.ChannelMember other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $silent = this.getSilent();
        result = result * 59 + ($silent == null ? 43 : ((Object)$silent).hashCode());
        Boolean $showInChannel = this.getShowInChannel();
        result = result * 59 + ($showInChannel == null ? 43 : ((Object)$showInChannel).hashCode());
        Integer $replyCount = this.getReplyCount();
        result = result * 59 + ($replyCount == null ? 43 : ((Object)$replyCount).hashCode());
        Integer $deletedReplyCount = this.getDeletedReplyCount();
        result = result * 59 + ($deletedReplyCount == null ? 43 : ((Object)$deletedReplyCount).hashCode());
        Boolean $shadowed = this.getShadowed();
        result = result * 59 + ($shadowed == null ? 43 : ((Object)$shadowed).hashCode());
        Boolean $before_message_send_failed = this.getBefore_message_send_failed();
        result = result * 59 + ($before_message_send_failed == null ? 43 : ((Object)$before_message_send_failed).hashCode());
        Boolean $pinned = this.getPinned();
        result = result * 59 + ($pinned == null ? 43 : ((Object)$pinned).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $mml = this.getMml();
        result = result * 59 + ($mml == null ? 43 : $mml.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $html = this.getHtml();
        result = result * 59 + ($html == null ? 43 : $html.hashCode());
        MessageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        List<String> $restrictedVisibility = this.getRestrictedVisibility();
        result = result * 59 + ($restrictedVisibility == null ? 43 : ((Object)$restrictedVisibility).hashCode());
        List<Attachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        List<Reaction> $latestReactions = this.getLatestReactions();
        result = result * 59 + ($latestReactions == null ? 43 : ((Object)$latestReactions).hashCode());
        List<Reaction> $ownReactions = this.getOwnReactions();
        result = result * 59 + ($ownReactions == null ? 43 : ((Object)$ownReactions).hashCode());
        Map<String, Integer> $reactionCounts = this.getReactionCounts();
        result = result * 59 + ($reactionCounts == null ? 43 : ((Object)$reactionCounts).hashCode());
        Map<String, Integer> $reactionScores = this.getReactionScores();
        result = result * 59 + ($reactionScores == null ? 43 : ((Object)$reactionScores).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $quotedMessageId = this.getQuotedMessageId();
        result = result * 59 + ($quotedMessageId == null ? 43 : $quotedMessageId.hashCode());
        Message $quoted_message = this.getQuoted_message();
        result = result * 59 + ($quoted_message == null ? 43 : ((Object)$quoted_message).hashCode());
        List<User> $threadParticipants = this.getThreadParticipants();
        result = result * 59 + ($threadParticipants == null ? 43 : ((Object)$threadParticipants).hashCode());
        String $cid = this.getCid();
        result = result * 59 + ($cid == null ? 43 : $cid.hashCode());
        List<User> $mentionedUsers = this.getMentionedUsers();
        result = result * 59 + ($mentionedUsers == null ? 43 : ((Object)$mentionedUsers).hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Date $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        Map<String, List<String>> $imageLabels = this.getImageLabels();
        result = result * 59 + ($imageLabels == null ? 43 : ((Object)$imageLabels).hashCode());
        Map<String, String> $i18n = this.getI18n();
        result = result * 59 + ($i18n == null ? 43 : ((Object)$i18n).hashCode());
        Date $pinExpires = this.getPinExpires();
        result = result * 59 + ($pinExpires == null ? 43 : ((Object)$pinExpires).hashCode());
        User $pinnedBy = this.getPinnedBy();
        result = result * 59 + ($pinnedBy == null ? 43 : ((Object)$pinnedBy).hashCode());
        Date $pinnedAt = this.getPinnedAt();
        result = result * 59 + ($pinnedAt == null ? 43 : ((Object)$pinnedAt).hashCode());
        SharedLocation $sharedLocation = this.getSharedLocation();
        result = result * 59 + ($sharedLocation == null ? 43 : ((Object)$sharedLocation).hashCode());
        Channel.ChannelMember $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Message(id=" + this.getId() + ", text=" + this.getText() + ", mml=" + this.getMml() + ", command=" + this.getCommand() + ", html=" + this.getHtml() + ", type=" + String.valueOf((Object)this.getType()) + ", silent=" + this.getSilent() + ", user=" + String.valueOf(this.getUser()) + ", restrictedVisibility=" + String.valueOf(this.getRestrictedVisibility()) + ", attachments=" + String.valueOf(this.getAttachments()) + ", latestReactions=" + String.valueOf(this.getLatestReactions()) + ", ownReactions=" + String.valueOf(this.getOwnReactions()) + ", reactionCounts=" + String.valueOf(this.getReactionCounts()) + ", reactionScores=" + String.valueOf(this.getReactionScores()) + ", parentId=" + this.getParentId() + ", showInChannel=" + this.getShowInChannel() + ", replyCount=" + this.getReplyCount() + ", deletedReplyCount=" + this.getDeletedReplyCount() + ", quotedMessageId=" + this.getQuotedMessageId() + ", quoted_message=" + String.valueOf(this.getQuoted_message()) + ", threadParticipants=" + String.valueOf(this.getThreadParticipants()) + ", cid=" + this.getCid() + ", mentionedUsers=" + String.valueOf(this.getMentionedUsers()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ", shadowed=" + this.getShadowed() + ", imageLabels=" + String.valueOf(this.getImageLabels()) + ", i18n=" + String.valueOf(this.getI18n()) + ", before_message_send_failed=" + this.getBefore_message_send_failed() + ", pinned=" + this.getPinned() + ", pinExpires=" + String.valueOf(this.getPinExpires()) + ", pinnedBy=" + String.valueOf(this.getPinnedBy()) + ", pinnedAt=" + String.valueOf(this.getPinnedAt()) + ", sharedLocation=" + String.valueOf(this.getSharedLocation()) + ", member=" + String.valueOf(this.getMember()) + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ")";
    }

    public static class MessagePartialUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessagePartialUpdateResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessagePartialUpdateResponse)) {
                return false;
            }
            MessagePartialUpdateResponse other = (MessagePartialUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessagePartialUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageTranslateResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageTranslateResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageTranslateResponse)) {
                return false;
            }
            MessageTranslateResponse other = (MessageTranslateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageTranslateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageRunCommandActionResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageRunCommandActionResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageRunCommandActionResponse)) {
                return false;
            }
            MessageRunCommandActionResponse other = (MessageRunCommandActionResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageRunCommandActionResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageGetRepliesResponse
    extends StreamResponseObject {
        @JsonProperty(value="messages")
        @NotNull
        private List<Message> messages;

        @NotNull
        public List<Message> getMessages() {
            return this.messages;
        }

        @JsonProperty(value="messages")
        public void setMessages(@NotNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
        }

        @Override
        public String toString() {
            return "Message.MessageGetRepliesResponse(messages=" + String.valueOf(this.getMessages()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetRepliesResponse)) {
                return false;
            }
            MessageGetRepliesResponse other = (MessageGetRepliesResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageGetRepliesResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }
    }

    public static class MessageGetManyResponse
    extends StreamResponseObject {
        @JsonProperty(value="messages")
        @NotNull
        private List<Message> messages;

        @NotNull
        public List<Message> getMessages() {
            return this.messages;
        }

        @JsonProperty(value="messages")
        public void setMessages(@NotNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
        }

        @Override
        public String toString() {
            return "Message.MessageGetManyResponse(messages=" + String.valueOf(this.getMessages()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetManyResponse)) {
                return false;
            }
            MessageGetManyResponse other = (MessageGetManyResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Message> this$messages = this.getMessages();
            List<Message> other$messages = other.getMessages();
            return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageGetManyResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Message> $messages = this.getMessages();
            result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
            return result;
        }
    }

    public static class MessageUploadImageResponse
    implements StreamResponse {
        @JsonProperty(value="file")
        @NotNull
        private String file;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;
        @JsonProperty(value="upload_sizes")
        @Nullable
        private List<ImageSize> uploadSizes;

        @NotNull
        public String getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @Nullable
        public List<ImageSize> getUploadSizes() {
            return this.uploadSizes;
        }

        @JsonProperty(value="file")
        public void setFile(@NotNull String file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        @JsonProperty(value="upload_sizes")
        public void setUploadSizes(@Nullable List<ImageSize> uploadSizes) {
            this.uploadSizes = uploadSizes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUploadImageResponse)) {
                return false;
            }
            MessageUploadImageResponse other = (MessageUploadImageResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
                return false;
            }
            List<ImageSize> this$uploadSizes = this.getUploadSizes();
            List<ImageSize> other$uploadSizes = other.getUploadSizes();
            return !(this$uploadSizes == null ? other$uploadSizes != null : !((Object)this$uploadSizes).equals(other$uploadSizes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUploadImageResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            List<ImageSize> $uploadSizes = this.getUploadSizes();
            result = result * 59 + ($uploadSizes == null ? 43 : ((Object)$uploadSizes).hashCode());
            return result;
        }

        public String toString() {
            return "Message.MessageUploadImageResponse(file=" + this.getFile() + ", duration=" + this.getDuration() + ", uploadSizes=" + String.valueOf(this.getUploadSizes()) + ")";
        }
    }

    public static class MessageUploadFileResponse
    implements StreamResponse {
        @JsonProperty(value="file")
        @NotNull
        private String file;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;

        @NotNull
        public String getFile() {
            return this.file;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @JsonProperty(value="file")
        public void setFile(@NotNull String file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUploadFileResponse)) {
                return false;
            }
            MessageUploadFileResponse other = (MessageUploadFileResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$file = this.getFile();
            String other$file = other.getFile();
            if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUploadFileResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : $file.hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            return result;
        }

        public String toString() {
            return "Message.MessageUploadFileResponse(file=" + this.getFile() + ", duration=" + this.getDuration() + ")";
        }
    }

    public static class MessageSearchResponse
    extends StreamResponseObject {
        @JsonProperty(value="results")
        @NotNull
        private List<SearchResult> results;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="previous")
        @Nullable
        private String previous;

        @NotNull
        public List<SearchResult> getResults() {
            return this.results;
        }

        @Nullable
        public String getNext() {
            return this.next;
        }

        @Nullable
        public String getPrevious() {
            return this.previous;
        }

        @JsonProperty(value="results")
        public void setResults(@NotNull List<SearchResult> results) {
            if (results == null) {
                throw new NullPointerException("results is marked non-null but is null");
            }
            this.results = results;
        }

        @JsonProperty(value="next")
        public void setNext(@Nullable String next) {
            this.next = next;
        }

        @JsonProperty(value="previous")
        public void setPrevious(@Nullable String previous) {
            this.previous = previous;
        }

        @Override
        public String toString() {
            return "Message.MessageSearchResponse(results=" + String.valueOf(this.getResults()) + ", next=" + this.getNext() + ", previous=" + this.getPrevious() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageSearchResponse)) {
                return false;
            }
            MessageSearchResponse other = (MessageSearchResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<SearchResult> this$results = this.getResults();
            List<SearchResult> other$results = other.getResults();
            if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
                return false;
            }
            String this$previous = this.getPrevious();
            String other$previous = other.getPrevious();
            return !(this$previous == null ? other$previous != null : !this$previous.equals(other$previous));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageSearchResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<SearchResult> $results = this.getResults();
            result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            String $previous = this.getPrevious();
            result = result * 59 + ($previous == null ? 43 : $previous.hashCode());
            return result;
        }
    }

    public static class MessageDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageDeleteResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageDeleteResponse)) {
                return false;
            }
            MessageDeleteResponse other = (MessageDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageCommitResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageCommitResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageCommitResponse)) {
                return false;
            }
            MessageCommitResponse other = (MessageCommitResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageCommitResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageUpdateResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageUpdateResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUpdateResponse)) {
                return false;
            }
            MessageUpdateResponse other = (MessageUpdateResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageUpdateResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageGetResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageGetResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetResponse)) {
                return false;
            }
            MessageGetResponse other = (MessageGetResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageGetResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageSendResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @Override
        public String toString() {
            return "Message.MessageSendResponse(message=" + String.valueOf(this.getMessage()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageSendResponse)) {
                return false;
            }
            MessageSendResponse other = (MessageSendResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof MessageSendResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }
    }

    public static class MessageUnblockRequestData {
        @JsonProperty(value="target_message_id")
        @NotNull
        private String targetMessageId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;

        MessageUnblockRequestData(@NotNull String targetMessageId, @Nullable String userId) {
            if (targetMessageId == null) {
                throw new NullPointerException("targetMessageId is marked non-null but is null");
            }
            this.targetMessageId = targetMessageId;
            this.userId = userId;
        }

        @NotNull
        public String getTargetMessageId() {
            return this.targetMessageId;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUnblockRequestData)) {
                return false;
            }
            MessageUnblockRequestData other = (MessageUnblockRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$targetMessageId = this.getTargetMessageId();
            String other$targetMessageId = other.getTargetMessageId();
            if (this$targetMessageId == null ? other$targetMessageId != null : !this$targetMessageId.equals(other$targetMessageId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUnblockRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $targetMessageId = this.getTargetMessageId();
            result = result * 59 + ($targetMessageId == null ? 43 : $targetMessageId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        public static class MessageUnblockRequest
        extends StreamRequest<StreamResponseObject> {
            private String targetMessageId;
            private String userId;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(MessageService.class).unblockMessage(this.internalBuild());
            }

            MessageUnblockRequest() {
            }

            @JsonProperty(value="target_message_id")
            public MessageUnblockRequest targetMessageId(@NotNull String targetMessageId) {
                if (targetMessageId == null) {
                    throw new NullPointerException("targetMessageId is marked non-null but is null");
                }
                this.targetMessageId = targetMessageId;
                return this;
            }

            @JsonProperty(value="user_id")
            public MessageUnblockRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            public MessageUnblockRequestData internalBuild() {
                return new MessageUnblockRequestData(this.targetMessageId, this.userId);
            }

            public String toString() {
                return "Message.MessageUnblockRequestData.MessageUnblockRequest(targetMessageId=" + this.targetMessageId + ", userId=" + this.userId + ")";
            }
        }
    }

    public static class MessagePartialUpdateRequestData {
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="set")
        @Nullable
        private Map<String, Object> setValues;
        @JsonProperty(value="unset")
        @Nullable
        private List<String> unsetValues;

        MessagePartialUpdateRequestData(@Nullable String userId, @Nullable User.UserRequestObject user, @Nullable Map<String, Object> setValues, @Nullable List<String> unsetValues) {
            this.userId = userId;
            this.user = user;
            this.setValues = setValues;
            this.unsetValues = unsetValues;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        @Nullable
        public Map<String, Object> getSetValues() {
            return this.setValues;
        }

        @Nullable
        public List<String> getUnsetValues() {
            return this.unsetValues;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessagePartialUpdateRequestData)) {
                return false;
            }
            MessagePartialUpdateRequestData other = (MessagePartialUpdateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            Map<String, Object> this$setValues = this.getSetValues();
            Map<String, Object> other$setValues = other.getSetValues();
            if (this$setValues == null ? other$setValues != null : !((Object)this$setValues).equals(other$setValues)) {
                return false;
            }
            List<String> this$unsetValues = this.getUnsetValues();
            List<String> other$unsetValues = other.getUnsetValues();
            return !(this$unsetValues == null ? other$unsetValues != null : !((Object)this$unsetValues).equals(other$unsetValues));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessagePartialUpdateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            Map<String, Object> $setValues = this.getSetValues();
            result = result * 59 + ($setValues == null ? 43 : ((Object)$setValues).hashCode());
            List<String> $unsetValues = this.getUnsetValues();
            result = result * 59 + ($unsetValues == null ? 43 : ((Object)$unsetValues).hashCode());
            return result;
        }

        public static class MessagePartialUpdateRequest
        extends StreamRequest<MessagePartialUpdateResponse> {
            private String userId;
            private User.UserRequestObject user;
            private ArrayList<String> setValues$key;
            private ArrayList<Object> setValues$value;
            private ArrayList<String> unsetValues;
            @NotNull
            private String id;

            private MessagePartialUpdateRequest(@NotNull String id) {
                this.id = id;
            }

            @Override
            protected Call<MessagePartialUpdateResponse> generateCall(Client client) {
                return client.create(MessageService.class).partialUpdate(this.id, this.internalBuild());
            }

            @JsonProperty(value="user_id")
            public MessagePartialUpdateRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public MessagePartialUpdateRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public MessagePartialUpdateRequest setValue(String setValueKey, Object setValueValue) {
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                this.setValues$key.add(setValueKey);
                this.setValues$value.add(setValueValue);
                return this;
            }

            @JsonProperty(value="set")
            public MessagePartialUpdateRequest setValues(Map<? extends String, ? extends Object> setValues) {
                if (setValues == null) {
                    throw new NullPointerException("setValues cannot be null");
                }
                if (this.setValues$key == null) {
                    this.setValues$key = new ArrayList();
                    this.setValues$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : setValues.entrySet()) {
                    this.setValues$key.add($lombokEntry.getKey());
                    this.setValues$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessagePartialUpdateRequest clearSetValues() {
                if (this.setValues$key != null) {
                    this.setValues$key.clear();
                    this.setValues$value.clear();
                }
                return this;
            }

            public MessagePartialUpdateRequest unsetValue(String unsetValue) {
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.add(unsetValue);
                return this;
            }

            @JsonProperty(value="unset")
            public MessagePartialUpdateRequest unsetValues(Collection<? extends String> unsetValues) {
                if (unsetValues == null) {
                    throw new NullPointerException("unsetValues cannot be null");
                }
                if (this.unsetValues == null) {
                    this.unsetValues = new ArrayList();
                }
                this.unsetValues.addAll(unsetValues);
                return this;
            }

            public MessagePartialUpdateRequest clearUnsetValues() {
                if (this.unsetValues != null) {
                    this.unsetValues.clear();
                }
                return this;
            }

            public MessagePartialUpdateRequestData internalBuild() {
                List<String> unsetValues;
                Map<String, Object> setValues;
                switch (this.setValues$key == null ? 0 : this.setValues$key.size()) {
                    case 0: {
                        setValues = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        setValues = Collections.singletonMap(this.setValues$key.get(0), this.setValues$value.get(0));
                        break;
                    }
                    default: {
                        setValues = new LinkedHashMap(this.setValues$key.size() < 0x40000000 ? 1 + this.setValues$key.size() + (this.setValues$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.setValues$key.size(); ++$i) {
                            setValues.put(this.setValues$key.get($i), this.setValues$value.get($i));
                        }
                        setValues = Collections.unmodifiableMap(setValues);
                    }
                }
                switch (this.unsetValues == null ? 0 : this.unsetValues.size()) {
                    case 0: {
                        unsetValues = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        unsetValues = Collections.singletonList(this.unsetValues.get(0));
                        break;
                    }
                    default: {
                        unsetValues = Collections.unmodifiableList(new ArrayList<String>(this.unsetValues));
                    }
                }
                return new MessagePartialUpdateRequestData(this.userId, this.user, setValues, unsetValues);
            }

            public String toString() {
                return "Message.MessagePartialUpdateRequestData.MessagePartialUpdateRequest(userId=" + this.userId + ", user=" + String.valueOf(this.user) + ", setValues$key=" + String.valueOf(this.setValues$key) + ", setValues$value=" + String.valueOf(this.setValues$value) + ", unsetValues=" + String.valueOf(this.unsetValues) + ")";
            }
        }
    }

    public static class MessageCommitRequestData {
        MessageCommitRequestData() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageCommitRequestData)) {
                return false;
            }
            MessageCommitRequestData other = (MessageCommitRequestData)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageCommitRequestData;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }

        public static class MessageCommitRequest
        extends StreamRequest<MessageCommitResponse> {
            @NotNull
            private String messageId;

            public MessageCommitRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<MessageCommitResponse> generateCall(Client client) {
                return client.create(MessageService.class).commit(this.messageId);
            }

            public MessageCommitRequestData internalBuild() {
                return new MessageCommitRequestData();
            }

            public String toString() {
                return "Message.MessageCommitRequestData.MessageCommitRequest()";
            }
        }
    }

    public static class MessageTranslateRequestData {
        @JsonProperty(value="language")
        @Nullable
        private Language language;

        MessageTranslateRequestData(@Nullable Language language) {
            this.language = language;
        }

        @Nullable
        public Language getLanguage() {
            return this.language;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageTranslateRequestData)) {
                return false;
            }
            MessageTranslateRequestData other = (MessageTranslateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Language this$language = this.getLanguage();
            Language other$language = other.getLanguage();
            return !(this$language == null ? other$language != null : !((Object)((Object)this$language)).equals((Object)other$language));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageTranslateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Language $language = this.getLanguage();
            result = result * 59 + ($language == null ? 43 : ((Object)((Object)$language)).hashCode());
            return result;
        }

        public static class MessageTranslateRequest
        extends StreamRequest<MessageTranslateResponse> {
            private Language language;
            @NotNull
            private String messageId;

            public MessageTranslateRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<MessageTranslateResponse> generateCall(Client client) {
                return client.create(MessageService.class).translate(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="language")
            public MessageTranslateRequest language(@Nullable Language language) {
                this.language = language;
                return this;
            }

            public MessageTranslateRequestData internalBuild() {
                return new MessageTranslateRequestData(this.language);
            }

            public String toString() {
                return "Message.MessageTranslateRequestData.MessageTranslateRequest(language=" + String.valueOf((Object)this.language) + ")";
            }
        }
    }

    public static class MessageRunCommandActionRequestData {
        @JsonProperty(value="form_data")
        @Nullable
        private Map<String, String> formData;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        MessageRunCommandActionRequestData(@Nullable Map<String, String> formData, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.formData = formData;
            this.userId = userId;
            this.user = user;
        }

        @Nullable
        public Map<String, String> getFormData() {
            return this.formData;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageRunCommandActionRequestData)) {
                return false;
            }
            MessageRunCommandActionRequestData other = (MessageRunCommandActionRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, String> this$formData = this.getFormData();
            Map<String, String> other$formData = other.getFormData();
            if (this$formData == null ? other$formData != null : !((Object)this$formData).equals(other$formData)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            return !(this$user == null ? other$user != null : !((Object)this$user).equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageRunCommandActionRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, String> $formData = this.getFormData();
            result = result * 59 + ($formData == null ? 43 : ((Object)$formData).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            return result;
        }

        public static class MessageRunCommandActionRequest
        extends StreamRequest<MessageRunCommandActionResponse> {
            private Map<String, String> formData;
            private String userId;
            private User.UserRequestObject user;
            @NotNull
            private String messageId;

            public MessageRunCommandActionRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<MessageRunCommandActionResponse> generateCall(Client client) {
                return client.create(MessageService.class).runCommandAction(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="form_data")
            public MessageRunCommandActionRequest formData(@Nullable Map<String, String> formData) {
                this.formData = formData;
                return this;
            }

            @JsonProperty(value="user_id")
            public MessageRunCommandActionRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public MessageRunCommandActionRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public MessageRunCommandActionRequestData internalBuild() {
                return new MessageRunCommandActionRequestData(this.formData, this.userId, this.user);
            }

            public String toString() {
                return "Message.MessageRunCommandActionRequestData.MessageRunCommandActionRequest(formData=" + String.valueOf(this.formData) + ", userId=" + this.userId + ", user=" + String.valueOf(this.user) + ")";
            }
        }
    }

    public static class MessageGetRepliesRequest
    extends StreamRequest<MessageGetRepliesResponse> {
        @NotNull
        private String parentId;
        @Nullable
        private String idGte;
        @Nullable
        private String idGt;
        @Nullable
        private String idLte;
        @Nullable
        private String idLt;
        @Nullable
        private Date createdAtAfterOrEqual;
        @Nullable
        private Date createdAtAfter;
        @Nullable
        private Date createdAtBeforeOrEqual;
        @Nullable
        private Date createdAtBefore;
        @Nullable
        private Integer limit;
        @Nullable
        private Integer offset;

        @NotNull
        public MessageGetRepliesRequest idGte(@Nullable String idGte) {
            this.idGte = idGte;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest idGt(@Nullable String idGt) {
            this.idGt = idGt;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest idLte(@Nullable String idLte) {
            this.idLte = idLte;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest idLt(@Nullable String idLt) {
            this.idLt = idLt;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtAfterOrEqual(@Nullable Date createdAtAfterOrEqual) {
            this.createdAtAfterOrEqual = createdAtAfterOrEqual;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtAfter(@Nullable Date createdAtAfter) {
            this.createdAtAfter = createdAtAfter;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtBeforeOrEqual(@Nullable Date createdAtBeforeOrEqual) {
            this.createdAtBeforeOrEqual = createdAtBeforeOrEqual;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest createdAtBefore(@Nullable Date createdAtBefore) {
            this.createdAtBefore = createdAtBefore;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest limit(@NotNull Integer limit) {
            this.limit = limit;
            return this;
        }

        @NotNull
        public MessageGetRepliesRequest offset(@NotNull Integer offset) {
            this.offset = offset;
            return this;
        }

        @Override
        protected Call<MessageGetRepliesResponse> generateCall(Client client) {
            return client.create(MessageService.class).getReplies(this.parentId, this.idGte, this.idGt, this.idLte, this.idLt, this.createdAtAfterOrEqual, this.createdAtAfter, this.createdAtBeforeOrEqual, this.createdAtBefore);
        }

        @NotNull
        public String getParentId() {
            return this.parentId;
        }

        @Nullable
        public String getIdGte() {
            return this.idGte;
        }

        @Nullable
        public String getIdGt() {
            return this.idGt;
        }

        @Nullable
        public String getIdLte() {
            return this.idLte;
        }

        @Nullable
        public String getIdLt() {
            return this.idLt;
        }

        @Nullable
        public Date getCreatedAtAfterOrEqual() {
            return this.createdAtAfterOrEqual;
        }

        @Nullable
        public Date getCreatedAtAfter() {
            return this.createdAtAfter;
        }

        @Nullable
        public Date getCreatedAtBeforeOrEqual() {
            return this.createdAtBeforeOrEqual;
        }

        @Nullable
        public Date getCreatedAtBefore() {
            return this.createdAtBefore;
        }

        @Nullable
        public Integer getLimit() {
            return this.limit;
        }

        @Nullable
        public Integer getOffset() {
            return this.offset;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetRepliesRequest)) {
                return false;
            }
            MessageGetRepliesRequest other = (MessageGetRepliesRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$limit = this.getLimit();
            Integer other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            Integer this$offset = this.getOffset();
            Integer other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            String this$parentId = this.getParentId();
            String other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
                return false;
            }
            String this$idGte = this.getIdGte();
            String other$idGte = other.getIdGte();
            if (this$idGte == null ? other$idGte != null : !this$idGte.equals(other$idGte)) {
                return false;
            }
            String this$idGt = this.getIdGt();
            String other$idGt = other.getIdGt();
            if (this$idGt == null ? other$idGt != null : !this$idGt.equals(other$idGt)) {
                return false;
            }
            String this$idLte = this.getIdLte();
            String other$idLte = other.getIdLte();
            if (this$idLte == null ? other$idLte != null : !this$idLte.equals(other$idLte)) {
                return false;
            }
            String this$idLt = this.getIdLt();
            String other$idLt = other.getIdLt();
            if (this$idLt == null ? other$idLt != null : !this$idLt.equals(other$idLt)) {
                return false;
            }
            Date this$createdAtAfterOrEqual = this.getCreatedAtAfterOrEqual();
            Date other$createdAtAfterOrEqual = other.getCreatedAtAfterOrEqual();
            if (this$createdAtAfterOrEqual == null ? other$createdAtAfterOrEqual != null : !((Object)this$createdAtAfterOrEqual).equals(other$createdAtAfterOrEqual)) {
                return false;
            }
            Date this$createdAtAfter = this.getCreatedAtAfter();
            Date other$createdAtAfter = other.getCreatedAtAfter();
            if (this$createdAtAfter == null ? other$createdAtAfter != null : !((Object)this$createdAtAfter).equals(other$createdAtAfter)) {
                return false;
            }
            Date this$createdAtBeforeOrEqual = this.getCreatedAtBeforeOrEqual();
            Date other$createdAtBeforeOrEqual = other.getCreatedAtBeforeOrEqual();
            if (this$createdAtBeforeOrEqual == null ? other$createdAtBeforeOrEqual != null : !((Object)this$createdAtBeforeOrEqual).equals(other$createdAtBeforeOrEqual)) {
                return false;
            }
            Date this$createdAtBefore = this.getCreatedAtBefore();
            Date other$createdAtBefore = other.getCreatedAtBefore();
            return !(this$createdAtBefore == null ? other$createdAtBefore != null : !((Object)this$createdAtBefore).equals(other$createdAtBefore));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageGetRepliesRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            Integer $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            String $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            String $idGte = this.getIdGte();
            result = result * 59 + ($idGte == null ? 43 : $idGte.hashCode());
            String $idGt = this.getIdGt();
            result = result * 59 + ($idGt == null ? 43 : $idGt.hashCode());
            String $idLte = this.getIdLte();
            result = result * 59 + ($idLte == null ? 43 : $idLte.hashCode());
            String $idLt = this.getIdLt();
            result = result * 59 + ($idLt == null ? 43 : $idLt.hashCode());
            Date $createdAtAfterOrEqual = this.getCreatedAtAfterOrEqual();
            result = result * 59 + ($createdAtAfterOrEqual == null ? 43 : ((Object)$createdAtAfterOrEqual).hashCode());
            Date $createdAtAfter = this.getCreatedAtAfter();
            result = result * 59 + ($createdAtAfter == null ? 43 : ((Object)$createdAtAfter).hashCode());
            Date $createdAtBeforeOrEqual = this.getCreatedAtBeforeOrEqual();
            result = result * 59 + ($createdAtBeforeOrEqual == null ? 43 : ((Object)$createdAtBeforeOrEqual).hashCode());
            Date $createdAtBefore = this.getCreatedAtBefore();
            result = result * 59 + ($createdAtBefore == null ? 43 : ((Object)$createdAtBefore).hashCode());
            return result;
        }

        public MessageGetRepliesRequest(@NotNull String parentId) {
            if (parentId == null) {
                throw new NullPointerException("parentId is marked non-null but is null");
            }
            this.parentId = parentId;
        }
    }

    public static class MessageGetManyRequest
    extends StreamRequest<MessageGetManyResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private List<String> messageIds;

        @Override
        protected Call<MessageGetManyResponse> generateCall(Client client) {
            return client.create(MessageService.class).getMany(this.channelType, this.channelId, String.join((CharSequence)",", this.messageIds));
        }

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public List<String> getMessageIds() {
            return this.messageIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetManyRequest)) {
                return false;
            }
            MessageGetManyRequest other = (MessageGetManyRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            List<String> this$messageIds = this.getMessageIds();
            List<String> other$messageIds = other.getMessageIds();
            return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageGetManyRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            List<String> $messageIds = this.getMessageIds();
            result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
            return result;
        }

        public MessageGetManyRequest(@NotNull String channelType, @NotNull String channelId, @NotNull List<String> messageIds) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (messageIds == null) {
                throw new NullPointerException("messageIds is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.messageIds = messageIds;
        }
    }

    public static class MessageDeleteImageRequest
    extends FileRequest<StreamResponseObject> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String url;

        @Override
        @NotNull
        public StreamResponseObject request() throws StreamException {
            return this.getFileHandler().deleteImage(this.channelType, this.channelId, this.url);
        }

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageDeleteImageRequest)) {
                return false;
            }
            MessageDeleteImageRequest other = (MessageDeleteImageRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageDeleteImageRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public MessageDeleteImageRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.url = url;
        }
    }

    public static class MessageDeleteFileRequest
    extends FileRequest<StreamResponseObject> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String url;

        @Override
        @NotNull
        public StreamResponseObject request() throws StreamException {
            return this.getFileHandler().deleteFile(this.channelType, this.channelId, this.url);
        }

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageDeleteFileRequest)) {
                return false;
            }
            MessageDeleteFileRequest other = (MessageDeleteFileRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageDeleteFileRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public MessageDeleteFileRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String url) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.url = url;
        }
    }

    public static class MessageUploadImageRequest
    extends FileRequest<MessageUploadImageResponse> {
        @Nullable
        private File file;
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String userId;
        @NotNull
        private String contentType;
        @Nullable
        private List<ImageSizeRequestObject> uploadSizes;

        @NotNull
        public MessageUploadImageRequest file(@NotNull File file) {
            this.file = file;
            return this;
        }

        @NotNull
        public MessageUploadImageRequest uploadSizes(@NotNull List<ImageSizeRequestObject> uploadSizes) {
            this.uploadSizes = uploadSizes;
            return this;
        }

        @Override
        @NotNull
        public MessageUploadImageResponse request() throws StreamException {
            return this.getFileHandler().uploadImage(this.channelType, this.channelId, this.userId, this.file, this.contentType, this.uploadSizes);
        }

        @Nullable
        public File getFile() {
            return this.file;
        }

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public String getUserId() {
            return this.userId;
        }

        @NotNull
        public String getContentType() {
            return this.contentType;
        }

        @Nullable
        public List<ImageSizeRequestObject> getUploadSizes() {
            return this.uploadSizes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUploadImageRequest)) {
                return false;
            }
            MessageUploadImageRequest other = (MessageUploadImageRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            List<ImageSizeRequestObject> this$uploadSizes = this.getUploadSizes();
            List<ImageSizeRequestObject> other$uploadSizes = other.getUploadSizes();
            return !(this$uploadSizes == null ? other$uploadSizes != null : !((Object)this$uploadSizes).equals(other$uploadSizes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUploadImageRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            List<ImageSizeRequestObject> $uploadSizes = this.getUploadSizes();
            result = result * 59 + ($uploadSizes == null ? 43 : ((Object)$uploadSizes).hashCode());
            return result;
        }

        public MessageUploadImageRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @NotNull String contentType) {
            if (channelType == null) {
                throw new NullPointerException("channelType is marked non-null but is null");
            }
            if (channelId == null) {
                throw new NullPointerException("channelId is marked non-null but is null");
            }
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            if (contentType == null) {
                throw new NullPointerException("contentType is marked non-null but is null");
            }
            this.channelType = channelType;
            this.channelId = channelId;
            this.userId = userId;
            this.contentType = contentType;
        }
    }

    public static class MessageUploadFileRequest
    extends FileRequest<MessageUploadFileResponse> {
        @NotNull
        private String channelType;
        @NotNull
        private String channelId;
        @NotNull
        private String userId;
        @Nullable
        private File file;
        @Nullable
        private String contentType;

        private MessageUploadFileRequest(@NotNull String channelType, @NotNull String channelId, @NotNull String userId, @Nullable String contentType) {
            this.channelType = channelType;
            this.channelId = channelId;
            this.userId = userId;
            this.contentType = contentType;
        }

        @NotNull
        public MessageUploadFileRequest file(@NotNull File file) {
            this.file = file;
            return this;
        }

        @Override
        @NotNull
        public MessageUploadFileResponse request() throws StreamException {
            return this.getFileHandler().uploadFile(this.channelType, this.channelId, this.userId, this.file, this.contentType);
        }

        @NotNull
        public String getChannelType() {
            return this.channelType;
        }

        @NotNull
        public String getChannelId() {
            return this.channelId;
        }

        @NotNull
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public File getFile() {
            return this.file;
        }

        @Nullable
        public String getContentType() {
            return this.contentType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUploadFileRequest)) {
                return false;
            }
            MessageUploadFileRequest other = (MessageUploadFileRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$channelType = this.getChannelType();
            String other$channelType = other.getChannelType();
            if (this$channelType == null ? other$channelType != null : !this$channelType.equals(other$channelType)) {
                return false;
            }
            String this$channelId = this.getChannelId();
            String other$channelId = other.getChannelId();
            if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUploadFileRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channelType = this.getChannelType();
            result = result * 59 + ($channelType == null ? 43 : $channelType.hashCode());
            String $channelId = this.getChannelId();
            result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            return result;
        }
    }

    public static abstract class FileRequest<TResponse> {
        private FileHandler fileHandler;

        public FileRequest<TResponse> withFileHandler(FileHandler fileHandler) {
            this.fileHandler = fileHandler;
            return this;
        }

        public abstract TResponse request() throws StreamException;

        public void requestAsync(@Nullable Consumer<TResponse> onSuccess, @Nullable Consumer<StreamException> onError) {
            block3: {
                try {
                    TResponse response = this.request();
                    if (onSuccess == null) {
                        return;
                    }
                    onSuccess.accept(response);
                }
                catch (StreamException ex) {
                    if (onError == null) break block3;
                    onError.accept(ex);
                }
            }
        }

        @NotNull
        protected FileHandler getFileHandler() throws StreamException {
            FileHandler fh = this.fileHandler;
            if (fh != null) {
                return fh;
            }
            try {
                return fileHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw StreamException.build("Your file handler should have a public constructor with no argument");
            }
            catch (InvocationTargetException e) {
                throw StreamException.build(e);
            }
        }
    }

    public static class MessageSearchRequestData {
        @JsonProperty(value="query")
        @Nullable
        private String query;
        @JsonProperty(value="filter_conditions")
        @Nullable
        private Map<String, Object> filterConditions;
        @JsonProperty(value="message_filter_conditions")
        @Nullable
        private Map<String, Object> messageFilterConditions;
        @JsonProperty(value="limit")
        @Nullable
        private Integer limit;
        @JsonProperty(value="offset")
        @Nullable
        private Integer offset;
        @JsonProperty(value="next")
        @Nullable
        private String next;
        @JsonProperty(value="sort")
        @Nullable
        private List<Sort> sorts;

        private MessageSearchRequestData(@Nullable String query, @Nullable Map<String, Object> filterConditions, @Nullable Map<String, Object> messageFilterConditions, @Nullable Integer limit, @Nullable Integer offset, @Nullable String next, @Nullable List<Sort> sorts) {
            if ((query == null || query.isEmpty()) && (messageFilterConditions == null || messageFilterConditions.isEmpty())) {
                throw new IllegalArgumentException("Must specify one of query and message filter conditions");
            }
            if (query != null && !query.isEmpty() && messageFilterConditions != null && !messageFilterConditions.isEmpty()) {
                throw new IllegalArgumentException("Can only specify one of query and message filter conditions");
            }
            if (offset != null && offset > 0 && next != null && !next.isEmpty()) {
                throw new IllegalArgumentException("Cannot use offset with next value");
            }
            this.query = query;
            this.filterConditions = filterConditions;
            this.messageFilterConditions = messageFilterConditions;
            this.limit = limit;
            this.offset = offset;
            this.next = next;
            this.sorts = sorts;
        }

        @Nullable
        public String getQuery() {
            return this.query;
        }

        @Nullable
        public Map<String, Object> getFilterConditions() {
            return this.filterConditions;
        }

        @Nullable
        public Map<String, Object> getMessageFilterConditions() {
            return this.messageFilterConditions;
        }

        @Nullable
        public Integer getLimit() {
            return this.limit;
        }

        @Nullable
        public Integer getOffset() {
            return this.offset;
        }

        @Nullable
        public String getNext() {
            return this.next;
        }

        @Nullable
        public List<Sort> getSorts() {
            return this.sorts;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageSearchRequestData)) {
                return false;
            }
            MessageSearchRequestData other = (MessageSearchRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$limit = this.getLimit();
            Integer other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            Integer this$offset = this.getOffset();
            Integer other$offset = other.getOffset();
            if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            Map<String, Object> this$filterConditions = this.getFilterConditions();
            Map<String, Object> other$filterConditions = other.getFilterConditions();
            if (this$filterConditions == null ? other$filterConditions != null : !((Object)this$filterConditions).equals(other$filterConditions)) {
                return false;
            }
            Map<String, Object> this$messageFilterConditions = this.getMessageFilterConditions();
            Map<String, Object> other$messageFilterConditions = other.getMessageFilterConditions();
            if (this$messageFilterConditions == null ? other$messageFilterConditions != null : !((Object)this$messageFilterConditions).equals(other$messageFilterConditions)) {
                return false;
            }
            String this$next = this.getNext();
            String other$next = other.getNext();
            if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
                return false;
            }
            List<Sort> this$sorts = this.getSorts();
            List<Sort> other$sorts = other.getSorts();
            return !(this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageSearchRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            Integer $offset = this.getOffset();
            result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            Map<String, Object> $filterConditions = this.getFilterConditions();
            result = result * 59 + ($filterConditions == null ? 43 : ((Object)$filterConditions).hashCode());
            Map<String, Object> $messageFilterConditions = this.getMessageFilterConditions();
            result = result * 59 + ($messageFilterConditions == null ? 43 : ((Object)$messageFilterConditions).hashCode());
            String $next = this.getNext();
            result = result * 59 + ($next == null ? 43 : $next.hashCode());
            List<Sort> $sorts = this.getSorts();
            result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
            return result;
        }

        public static class MessageSearchRequest
        extends StreamRequest<MessageSearchResponse> {
            private String query;
            private ArrayList<String> filterConditions$key;
            private ArrayList<Object> filterConditions$value;
            private ArrayList<String> messageFilterConditions$key;
            private ArrayList<Object> messageFilterConditions$value;
            private Integer limit;
            private Integer offset;
            private String next;
            private ArrayList<Sort> sorts;

            @Override
            protected Call<MessageSearchResponse> generateCall(Client client) {
                return client.create(MessageService.class).search(this.internalBuild());
            }

            MessageSearchRequest() {
            }

            @JsonProperty(value="query")
            public MessageSearchRequest query(@Nullable String query) {
                this.query = query;
                return this;
            }

            public MessageSearchRequest filterCondition(String filterConditionKey, Object filterConditionValue) {
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                this.filterConditions$key.add(filterConditionKey);
                this.filterConditions$value.add(filterConditionValue);
                return this;
            }

            @JsonProperty(value="filter_conditions")
            public MessageSearchRequest filterConditions(Map<? extends String, ? extends Object> filterConditions) {
                if (filterConditions == null) {
                    throw new NullPointerException("filterConditions cannot be null");
                }
                if (this.filterConditions$key == null) {
                    this.filterConditions$key = new ArrayList();
                    this.filterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : filterConditions.entrySet()) {
                    this.filterConditions$key.add($lombokEntry.getKey());
                    this.filterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageSearchRequest clearFilterConditions() {
                if (this.filterConditions$key != null) {
                    this.filterConditions$key.clear();
                    this.filterConditions$value.clear();
                }
                return this;
            }

            public MessageSearchRequest messageFilterCondition(String messageFilterConditionKey, Object messageFilterConditionValue) {
                if (this.messageFilterConditions$key == null) {
                    this.messageFilterConditions$key = new ArrayList();
                    this.messageFilterConditions$value = new ArrayList();
                }
                this.messageFilterConditions$key.add(messageFilterConditionKey);
                this.messageFilterConditions$value.add(messageFilterConditionValue);
                return this;
            }

            @JsonProperty(value="message_filter_conditions")
            public MessageSearchRequest messageFilterConditions(Map<? extends String, ? extends Object> messageFilterConditions) {
                if (messageFilterConditions == null) {
                    throw new NullPointerException("messageFilterConditions cannot be null");
                }
                if (this.messageFilterConditions$key == null) {
                    this.messageFilterConditions$key = new ArrayList();
                    this.messageFilterConditions$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : messageFilterConditions.entrySet()) {
                    this.messageFilterConditions$key.add($lombokEntry.getKey());
                    this.messageFilterConditions$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageSearchRequest clearMessageFilterConditions() {
                if (this.messageFilterConditions$key != null) {
                    this.messageFilterConditions$key.clear();
                    this.messageFilterConditions$value.clear();
                }
                return this;
            }

            @JsonProperty(value="limit")
            public MessageSearchRequest limit(@Nullable Integer limit) {
                this.limit = limit;
                return this;
            }

            @JsonProperty(value="offset")
            public MessageSearchRequest offset(@Nullable Integer offset) {
                this.offset = offset;
                return this;
            }

            @JsonProperty(value="next")
            public MessageSearchRequest next(@Nullable String next) {
                this.next = next;
                return this;
            }

            public MessageSearchRequest sort(Sort sort) {
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.add(sort);
                return this;
            }

            @JsonProperty(value="sort")
            public MessageSearchRequest sorts(Collection<? extends Sort> sorts) {
                if (sorts == null) {
                    throw new NullPointerException("sorts cannot be null");
                }
                if (this.sorts == null) {
                    this.sorts = new ArrayList();
                }
                this.sorts.addAll(sorts);
                return this;
            }

            public MessageSearchRequest clearSorts() {
                if (this.sorts != null) {
                    this.sorts.clear();
                }
                return this;
            }

            public MessageSearchRequestData internalBuild() {
                List<Sort> sorts;
                Map<String, Object> messageFilterConditions;
                Map<Object, Object> filterConditions;
                switch (this.filterConditions$key == null ? 0 : this.filterConditions$key.size()) {
                    case 0: {
                        filterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        filterConditions = Collections.singletonMap(this.filterConditions$key.get(0), this.filterConditions$value.get(0));
                        break;
                    }
                    default: {
                        filterConditions = new LinkedHashMap(this.filterConditions$key.size() < 0x40000000 ? 1 + this.filterConditions$key.size() + (this.filterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.filterConditions$key.size(); ++$i) {
                            filterConditions.put(this.filterConditions$key.get($i), this.filterConditions$value.get($i));
                        }
                        filterConditions = Collections.unmodifiableMap(filterConditions);
                    }
                }
                switch (this.messageFilterConditions$key == null ? 0 : this.messageFilterConditions$key.size()) {
                    case 0: {
                        messageFilterConditions = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        messageFilterConditions = Collections.singletonMap(this.messageFilterConditions$key.get(0), this.messageFilterConditions$value.get(0));
                        break;
                    }
                    default: {
                        messageFilterConditions = new LinkedHashMap(this.messageFilterConditions$key.size() < 0x40000000 ? 1 + this.messageFilterConditions$key.size() + (this.messageFilterConditions$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.messageFilterConditions$key.size(); ++$i) {
                            messageFilterConditions.put(this.messageFilterConditions$key.get($i), this.messageFilterConditions$value.get($i));
                        }
                        messageFilterConditions = Collections.unmodifiableMap(messageFilterConditions);
                    }
                }
                switch (this.sorts == null ? 0 : this.sorts.size()) {
                    case 0: {
                        sorts = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        sorts = Collections.singletonList(this.sorts.get(0));
                        break;
                    }
                    default: {
                        sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                    }
                }
                return new MessageSearchRequestData(this.query, filterConditions, messageFilterConditions, this.limit, this.offset, this.next, sorts);
            }

            public String toString() {
                return "Message.MessageSearchRequestData.MessageSearchRequest(query=" + this.query + ", filterConditions$key=" + String.valueOf(this.filterConditions$key) + ", filterConditions$value=" + String.valueOf(this.filterConditions$value) + ", messageFilterConditions$key=" + String.valueOf(this.messageFilterConditions$key) + ", messageFilterConditions$value=" + String.valueOf(this.messageFilterConditions$value) + ", limit=" + this.limit + ", offset=" + this.offset + ", next=" + this.next + ", sorts=" + String.valueOf(this.sorts) + ")";
            }
        }
    }

    public static class MessageDeleteRequest
    extends StreamRequest<MessageDeleteResponse> {
        @NotNull
        private String id;
        @Nullable
        private Boolean hard;
        @Nullable
        private String deletedBy;
        @Nullable
        private Boolean deleteForMe;

        @NotNull
        public MessageDeleteRequest hard(@NotNull Boolean hard) {
            this.hard = hard;
            return this;
        }

        @NotNull
        public MessageDeleteRequest deletedBy(@NotNull String deletedBy) {
            this.deletedBy = deletedBy;
            return this;
        }

        @NotNull
        public MessageDeleteRequest deleteForMe(@NotNull String userId) {
            this.deleteForMe = true;
            this.deletedBy = userId;
            return this;
        }

        @Override
        protected Call<MessageDeleteResponse> generateCall(Client client) {
            return client.create(MessageService.class).delete(this.id, this.hard, this.deletedBy, this.deleteForMe);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @Nullable
        public Boolean getHard() {
            return this.hard;
        }

        @Nullable
        public String getDeletedBy() {
            return this.deletedBy;
        }

        @Nullable
        public Boolean getDeleteForMe() {
            return this.deleteForMe;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageDeleteRequest)) {
                return false;
            }
            MessageDeleteRequest other = (MessageDeleteRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$hard = this.getHard();
            Boolean other$hard = other.getHard();
            if (this$hard == null ? other$hard != null : !((Object)this$hard).equals(other$hard)) {
                return false;
            }
            Boolean this$deleteForMe = this.getDeleteForMe();
            Boolean other$deleteForMe = other.getDeleteForMe();
            if (this$deleteForMe == null ? other$deleteForMe != null : !((Object)this$deleteForMe).equals(other$deleteForMe)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$deletedBy = this.getDeletedBy();
            String other$deletedBy = other.getDeletedBy();
            return !(this$deletedBy == null ? other$deletedBy != null : !this$deletedBy.equals(other$deletedBy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageDeleteRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $hard = this.getHard();
            result = result * 59 + ($hard == null ? 43 : ((Object)$hard).hashCode());
            Boolean $deleteForMe = this.getDeleteForMe();
            result = result * 59 + ($deleteForMe == null ? 43 : ((Object)$deleteForMe).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $deletedBy = this.getDeletedBy();
            result = result * 59 + ($deletedBy == null ? 43 : $deletedBy.hashCode());
            return result;
        }

        public MessageDeleteRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class MessageUpdateRequestData {
        @JsonProperty(value="message")
        @Nullable
        private MessageRequestObject message;

        MessageUpdateRequestData(@Nullable MessageRequestObject message) {
            this.message = message;
        }

        @Nullable
        public MessageRequestObject getMessage() {
            return this.message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageUpdateRequestData)) {
                return false;
            }
            MessageUpdateRequestData other = (MessageUpdateRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            MessageRequestObject this$message = this.getMessage();
            MessageRequestObject other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageUpdateRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MessageRequestObject $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }

        public static class MessageUpdateRequest
        extends StreamRequest<MessageUpdateResponse> {
            private MessageRequestObject message;
            @NotNull
            private String id;

            private MessageUpdateRequest(@NotNull String id) {
                this.id = id;
            }

            @Override
            protected Call<MessageUpdateResponse> generateCall(Client client) {
                return client.create(MessageService.class).update(this.id, this.internalBuild());
            }

            @JsonProperty(value="message")
            public MessageUpdateRequest message(@Nullable MessageRequestObject message) {
                this.message = message;
                return this;
            }

            public MessageUpdateRequestData internalBuild() {
                return new MessageUpdateRequestData(this.message);
            }

            public String toString() {
                return "Message.MessageUpdateRequestData.MessageUpdateRequest(message=" + String.valueOf(this.message) + ")";
            }
        }
    }

    public static class MessageGetRequest
    extends StreamRequest<MessageGetResponse> {
        @NotNull
        private String id;
        @Nullable
        private Boolean showDeletedMessages;

        @NotNull
        public MessageGetRequest showDeletedMessages(@NotNull Boolean showDeletedMessages) {
            this.showDeletedMessages = showDeletedMessages;
            return this;
        }

        @Override
        protected Call<MessageGetResponse> generateCall(Client client) {
            return client.create(MessageService.class).get(this.id, this.showDeletedMessages);
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @Nullable
        public Boolean getShowDeletedMessages() {
            return this.showDeletedMessages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageGetRequest)) {
                return false;
            }
            MessageGetRequest other = (MessageGetRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$showDeletedMessages = this.getShowDeletedMessages();
            Boolean other$showDeletedMessages = other.getShowDeletedMessages();
            if (this$showDeletedMessages == null ? other$showDeletedMessages != null : !((Object)this$showDeletedMessages).equals(other$showDeletedMessages)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageGetRequest;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $showDeletedMessages = this.getShowDeletedMessages();
            result = result * 59 + ($showDeletedMessages == null ? 43 : ((Object)$showDeletedMessages).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public MessageGetRequest(@NotNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }
    }

    public static class MessageSendRequestData {
        @JsonProperty(value="message")
        @Nullable
        private MessageRequestObject message;
        @JsonProperty(value="skip_push")
        @Nullable
        private Boolean skipPush;
        @JsonProperty(value="is_pending_message")
        @Nullable
        private Boolean isPendingMessage;
        @JsonProperty(value="pending")
        @Nullable
        private Boolean pending;
        @JsonProperty(value="force_moderation")
        @Nullable
        private Boolean forceModeration;
        @JsonProperty(value="pending_message_metadata")
        @Nullable
        private Map<String, Object> pendingMessageMetadata;

        MessageSendRequestData(@Nullable MessageRequestObject message, @Nullable Boolean skipPush, @Nullable Boolean isPendingMessage, @Nullable Boolean pending, @Nullable Boolean forceModeration, @Nullable Map<String, Object> pendingMessageMetadata) {
            this.message = message;
            this.skipPush = skipPush;
            this.isPendingMessage = isPendingMessage;
            this.pending = pending;
            this.forceModeration = forceModeration;
            this.pendingMessageMetadata = pendingMessageMetadata;
        }

        @Nullable
        public MessageRequestObject getMessage() {
            return this.message;
        }

        @Nullable
        public Boolean getSkipPush() {
            return this.skipPush;
        }

        @Nullable
        public Boolean getIsPendingMessage() {
            return this.isPendingMessage;
        }

        @Nullable
        public Boolean getPending() {
            return this.pending;
        }

        @Nullable
        public Boolean getForceModeration() {
            return this.forceModeration;
        }

        @Nullable
        public Map<String, Object> getPendingMessageMetadata() {
            return this.pendingMessageMetadata;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageSendRequestData)) {
                return false;
            }
            MessageSendRequestData other = (MessageSendRequestData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$skipPush = this.getSkipPush();
            Boolean other$skipPush = other.getSkipPush();
            if (this$skipPush == null ? other$skipPush != null : !((Object)this$skipPush).equals(other$skipPush)) {
                return false;
            }
            Boolean this$isPendingMessage = this.getIsPendingMessage();
            Boolean other$isPendingMessage = other.getIsPendingMessage();
            if (this$isPendingMessage == null ? other$isPendingMessage != null : !((Object)this$isPendingMessage).equals(other$isPendingMessage)) {
                return false;
            }
            Boolean this$pending = this.getPending();
            Boolean other$pending = other.getPending();
            if (this$pending == null ? other$pending != null : !((Object)this$pending).equals(other$pending)) {
                return false;
            }
            Boolean this$forceModeration = this.getForceModeration();
            Boolean other$forceModeration = other.getForceModeration();
            if (this$forceModeration == null ? other$forceModeration != null : !((Object)this$forceModeration).equals(other$forceModeration)) {
                return false;
            }
            MessageRequestObject this$message = this.getMessage();
            MessageRequestObject other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Map<String, Object> this$pendingMessageMetadata = this.getPendingMessageMetadata();
            Map<String, Object> other$pendingMessageMetadata = other.getPendingMessageMetadata();
            return !(this$pendingMessageMetadata == null ? other$pendingMessageMetadata != null : !((Object)this$pendingMessageMetadata).equals(other$pendingMessageMetadata));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageSendRequestData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $skipPush = this.getSkipPush();
            result = result * 59 + ($skipPush == null ? 43 : ((Object)$skipPush).hashCode());
            Boolean $isPendingMessage = this.getIsPendingMessage();
            result = result * 59 + ($isPendingMessage == null ? 43 : ((Object)$isPendingMessage).hashCode());
            Boolean $pending = this.getPending();
            result = result * 59 + ($pending == null ? 43 : ((Object)$pending).hashCode());
            Boolean $forceModeration = this.getForceModeration();
            result = result * 59 + ($forceModeration == null ? 43 : ((Object)$forceModeration).hashCode());
            MessageRequestObject $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Map<String, Object> $pendingMessageMetadata = this.getPendingMessageMetadata();
            result = result * 59 + ($pendingMessageMetadata == null ? 43 : ((Object)$pendingMessageMetadata).hashCode());
            return result;
        }

        public static class MessageSendRequest
        extends StreamRequest<MessageSendResponse> {
            private MessageRequestObject message;
            private Boolean skipPush;
            private Boolean isPendingMessage;
            private Boolean pending;
            private Boolean forceModeration;
            private Map<String, Object> pendingMessageMetadata;
            @NotNull
            private String channelId;
            @NotNull
            private String channelType;

            private MessageSendRequest(@NotNull String channelType, @NotNull String channelId) {
                this.channelType = channelType;
                this.channelId = channelId;
            }

            @Override
            protected Call<MessageSendResponse> generateCall(Client client) {
                return client.create(MessageService.class).send(this.channelType, this.channelId, this.internalBuild());
            }

            @JsonProperty(value="message")
            public MessageSendRequest message(@Nullable MessageRequestObject message) {
                this.message = message;
                return this;
            }

            @JsonProperty(value="skip_push")
            public MessageSendRequest skipPush(@Nullable Boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            @JsonProperty(value="is_pending_message")
            public MessageSendRequest isPendingMessage(@Nullable Boolean isPendingMessage) {
                this.isPendingMessage = isPendingMessage;
                return this;
            }

            @JsonProperty(value="pending")
            public MessageSendRequest pending(@Nullable Boolean pending) {
                this.pending = pending;
                return this;
            }

            @JsonProperty(value="force_moderation")
            public MessageSendRequest forceModeration(@Nullable Boolean forceModeration) {
                this.forceModeration = forceModeration;
                return this;
            }

            @JsonProperty(value="pending_message_metadata")
            public MessageSendRequest pendingMessageMetadata(@Nullable Map<String, Object> pendingMessageMetadata) {
                this.pendingMessageMetadata = pendingMessageMetadata;
                return this;
            }

            public MessageSendRequestData internalBuild() {
                return new MessageSendRequestData(this.message, this.skipPush, this.isPendingMessage, this.pending, this.forceModeration, this.pendingMessageMetadata);
            }

            public String toString() {
                return "Message.MessageSendRequestData.MessageSendRequest(message=" + String.valueOf(this.message) + ", skipPush=" + this.skipPush + ", isPendingMessage=" + this.isPendingMessage + ", pending=" + this.pending + ", forceModeration=" + this.forceModeration + ", pendingMessageMetadata=" + String.valueOf(this.pendingMessageMetadata) + ")";
            }
        }
    }

    public static class ModerationRequestObject {
        @JsonProperty(value="toxic")
        @Nullable
        private Integer toxic;
        @JsonProperty(value="explicit")
        @Nullable
        private Integer explicit;
        @JsonProperty(value="spam")
        @Nullable
        private Integer spam;

        @Nullable
        public static ModerationRequestObject buildFrom(@Nullable Moderation moderation) {
            return RequestObjectBuilder.build(ModerationRequestObject.class, moderation);
        }

        ModerationRequestObject(@Nullable Integer toxic, @Nullable Integer explicit, @Nullable Integer spam) {
            this.toxic = toxic;
            this.explicit = explicit;
            this.spam = spam;
        }

        public static ModerationRequestObjectBuilder builder() {
            return new ModerationRequestObjectBuilder();
        }

        @JsonProperty(value="toxic")
        public void setToxic(@Nullable Integer toxic) {
            this.toxic = toxic;
        }

        @JsonProperty(value="explicit")
        public void setExplicit(@Nullable Integer explicit) {
            this.explicit = explicit;
        }

        @JsonProperty(value="spam")
        public void setSpam(@Nullable Integer spam) {
            this.spam = spam;
        }

        @Nullable
        public Integer getToxic() {
            return this.toxic;
        }

        @Nullable
        public Integer getExplicit() {
            return this.explicit;
        }

        @Nullable
        public Integer getSpam() {
            return this.spam;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModerationRequestObject)) {
                return false;
            }
            ModerationRequestObject other = (ModerationRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$toxic = this.getToxic();
            Integer other$toxic = other.getToxic();
            if (this$toxic == null ? other$toxic != null : !((Object)this$toxic).equals(other$toxic)) {
                return false;
            }
            Integer this$explicit = this.getExplicit();
            Integer other$explicit = other.getExplicit();
            if (this$explicit == null ? other$explicit != null : !((Object)this$explicit).equals(other$explicit)) {
                return false;
            }
            Integer this$spam = this.getSpam();
            Integer other$spam = other.getSpam();
            return !(this$spam == null ? other$spam != null : !((Object)this$spam).equals(other$spam));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModerationRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $toxic = this.getToxic();
            result = result * 59 + ($toxic == null ? 43 : ((Object)$toxic).hashCode());
            Integer $explicit = this.getExplicit();
            result = result * 59 + ($explicit == null ? 43 : ((Object)$explicit).hashCode());
            Integer $spam = this.getSpam();
            result = result * 59 + ($spam == null ? 43 : ((Object)$spam).hashCode());
            return result;
        }

        public static class ModerationRequestObjectBuilder {
            private Integer toxic;
            private Integer explicit;
            private Integer spam;

            ModerationRequestObjectBuilder() {
            }

            @JsonProperty(value="toxic")
            public ModerationRequestObjectBuilder toxic(@Nullable Integer toxic) {
                this.toxic = toxic;
                return this;
            }

            @JsonProperty(value="explicit")
            public ModerationRequestObjectBuilder explicit(@Nullable Integer explicit) {
                this.explicit = explicit;
                return this;
            }

            @JsonProperty(value="spam")
            public ModerationRequestObjectBuilder spam(@Nullable Integer spam) {
                this.spam = spam;
                return this;
            }

            public ModerationRequestObject build() {
                return new ModerationRequestObject(this.toxic, this.explicit, this.spam);
            }

            public String toString() {
                return "Message.ModerationRequestObject.ModerationRequestObjectBuilder(toxic=" + this.toxic + ", explicit=" + this.explicit + ", spam=" + this.spam + ")";
            }
        }
    }

    public static class ImageSizeRequestObject {
        @JsonProperty(value="crop")
        @Nullable
        private Crop crop;
        @JsonProperty(value="resize")
        @Nullable
        private Resize resize;
        @JsonProperty(value="height")
        @Nullable
        private Integer height;
        @JsonProperty(value="width")
        @Nullable
        private Integer width;

        @Nullable
        public static ImageSizeRequestObject buildFrom(@Nullable ImageSize imageSize) {
            return RequestObjectBuilder.build(ImageSizeRequestObject.class, imageSize);
        }

        ImageSizeRequestObject(@Nullable Crop crop, @Nullable Resize resize, @Nullable Integer height, @Nullable Integer width) {
            this.crop = crop;
            this.resize = resize;
            this.height = height;
            this.width = width;
        }

        public static ImageSizeRequestObjectBuilder builder() {
            return new ImageSizeRequestObjectBuilder();
        }

        @JsonProperty(value="crop")
        public void setCrop(@Nullable Crop crop) {
            this.crop = crop;
        }

        @JsonProperty(value="resize")
        public void setResize(@Nullable Resize resize) {
            this.resize = resize;
        }

        @JsonProperty(value="height")
        public void setHeight(@Nullable Integer height) {
            this.height = height;
        }

        @JsonProperty(value="width")
        public void setWidth(@Nullable Integer width) {
            this.width = width;
        }

        @Nullable
        public Crop getCrop() {
            return this.crop;
        }

        @Nullable
        public Resize getResize() {
            return this.resize;
        }

        @Nullable
        public Integer getHeight() {
            return this.height;
        }

        @Nullable
        public Integer getWidth() {
            return this.width;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageSizeRequestObject)) {
                return false;
            }
            ImageSizeRequestObject other = (ImageSizeRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$height = this.getHeight();
            Integer other$height = other.getHeight();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Integer this$width = this.getWidth();
            Integer other$width = other.getWidth();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Crop this$crop = this.getCrop();
            Crop other$crop = other.getCrop();
            if (this$crop == null ? other$crop != null : !((Object)((Object)this$crop)).equals((Object)other$crop)) {
                return false;
            }
            Resize this$resize = this.getResize();
            Resize other$resize = other.getResize();
            return !(this$resize == null ? other$resize != null : !((Object)((Object)this$resize)).equals((Object)other$resize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageSizeRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $height = this.getHeight();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Integer $width = this.getWidth();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Crop $crop = this.getCrop();
            result = result * 59 + ($crop == null ? 43 : ((Object)((Object)$crop)).hashCode());
            Resize $resize = this.getResize();
            result = result * 59 + ($resize == null ? 43 : ((Object)((Object)$resize)).hashCode());
            return result;
        }

        public static class ImageSizeRequestObjectBuilder {
            private Crop crop;
            private Resize resize;
            private Integer height;
            private Integer width;

            ImageSizeRequestObjectBuilder() {
            }

            @JsonProperty(value="crop")
            public ImageSizeRequestObjectBuilder crop(@Nullable Crop crop) {
                this.crop = crop;
                return this;
            }

            @JsonProperty(value="resize")
            public ImageSizeRequestObjectBuilder resize(@Nullable Resize resize) {
                this.resize = resize;
                return this;
            }

            @JsonProperty(value="height")
            public ImageSizeRequestObjectBuilder height(@Nullable Integer height) {
                this.height = height;
                return this;
            }

            @JsonProperty(value="width")
            public ImageSizeRequestObjectBuilder width(@Nullable Integer width) {
                this.width = width;
                return this;
            }

            public ImageSizeRequestObject build() {
                return new ImageSizeRequestObject(this.crop, this.resize, this.height, this.width);
            }

            public String toString() {
                return "Message.ImageSizeRequestObject.ImageSizeRequestObjectBuilder(crop=" + String.valueOf((Object)this.crop) + ", resize=" + String.valueOf((Object)this.resize) + ", height=" + this.height + ", width=" + this.width + ")";
            }
        }
    }

    public static class FieldRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="value")
        @Nullable
        private String value;
        @JsonProperty(value="short")
        @Nullable
        private Boolean shortField;

        @Nullable
        public static FieldRequestObject buildFrom(@Nullable Field field) {
            return RequestObjectBuilder.build(FieldRequestObject.class, field);
        }

        FieldRequestObject(@Nullable String type, @Nullable String value, @Nullable Boolean shortField) {
            this.type = type;
            this.value = value;
            this.shortField = shortField;
        }

        public static FieldRequestObjectBuilder builder() {
            return new FieldRequestObjectBuilder();
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@Nullable String value) {
            this.value = value;
        }

        @JsonProperty(value="short")
        public void setShortField(@Nullable Boolean shortField) {
            this.shortField = shortField;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        @Nullable
        public Boolean getShortField() {
            return this.shortField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldRequestObject)) {
                return false;
            }
            FieldRequestObject other = (FieldRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$shortField = this.getShortField();
            Boolean other$shortField = other.getShortField();
            if (this$shortField == null ? other$shortField != null : !((Object)this$shortField).equals(other$shortField)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $shortField = this.getShortField();
            result = result * 59 + ($shortField == null ? 43 : ((Object)$shortField).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public static class FieldRequestObjectBuilder {
            private String type;
            private String value;
            private Boolean shortField;

            FieldRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public FieldRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="value")
            public FieldRequestObjectBuilder value(@Nullable String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="short")
            public FieldRequestObjectBuilder shortField(@Nullable Boolean shortField) {
                this.shortField = shortField;
                return this;
            }

            public FieldRequestObject build() {
                return new FieldRequestObject(this.type, this.value, this.shortField);
            }

            public String toString() {
                return "Message.FieldRequestObject.FieldRequestObjectBuilder(type=" + this.type + ", value=" + this.value + ", shortField=" + this.shortField + ")";
            }
        }
    }

    public static class ActionRequestObject {
        @JsonProperty(value="name")
        @Nullable
        private String name;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="style")
        @Nullable
        private String style;
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="value")
        @Nullable
        private String value;

        @Nullable
        public static ActionRequestObject buildFrom(@Nullable Action action) {
            return RequestObjectBuilder.build(ActionRequestObject.class, action);
        }

        ActionRequestObject(@Nullable String name, @Nullable String text, @Nullable String style, @Nullable String type, @Nullable String value) {
            this.name = name;
            this.text = text;
            this.style = style;
            this.type = type;
            this.value = value;
        }

        public static ActionRequestObjectBuilder builder() {
            return new ActionRequestObjectBuilder();
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="style")
        public void setStyle(@Nullable String style) {
            this.style = style;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@Nullable String value) {
            this.value = value;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public String getStyle() {
            return this.style;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ActionRequestObject)) {
                return false;
            }
            ActionRequestObject other = (ActionRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$style = this.getStyle();
            String other$style = other.getStyle();
            if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ActionRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $style = this.getStyle();
            result = result * 59 + ($style == null ? 43 : $style.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public static class ActionRequestObjectBuilder {
            private String name;
            private String text;
            private String style;
            private String type;
            private String value;

            ActionRequestObjectBuilder() {
            }

            @JsonProperty(value="name")
            public ActionRequestObjectBuilder name(@Nullable String name) {
                this.name = name;
                return this;
            }

            @JsonProperty(value="text")
            public ActionRequestObjectBuilder text(@Nullable String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="style")
            public ActionRequestObjectBuilder style(@Nullable String style) {
                this.style = style;
                return this;
            }

            @JsonProperty(value="type")
            public ActionRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="value")
            public ActionRequestObjectBuilder value(@Nullable String value) {
                this.value = value;
                return this;
            }

            public ActionRequestObject build() {
                return new ActionRequestObject(this.name, this.text, this.style, this.type, this.value);
            }

            public String toString() {
                return "Message.ActionRequestObject.ActionRequestObjectBuilder(name=" + this.name + ", text=" + this.text + ", style=" + this.style + ", type=" + this.type + ", value=" + this.value + ")";
            }
        }
    }

    public static class AttachmentRequestObject {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="fallback")
        @Nullable
        private String fallback;
        @JsonProperty(value="color")
        @Nullable
        private String color;
        @JsonProperty(value="pretext")
        @Nullable
        private String pretext;
        @JsonProperty(value="author_name")
        @Nullable
        private String authorName;
        @JsonProperty(value="author_link")
        @Nullable
        private String authorLink;
        @JsonProperty(value="author_icon")
        @Nullable
        private String authorIcon;
        @JsonProperty(value="title")
        @Nullable
        private String title;
        @JsonProperty(value="title_link")
        @Nullable
        private String titleLink;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="image_url")
        @Nullable
        private String imageURL;
        @JsonProperty(value="thumb_url")
        @Nullable
        private String thumbURL;
        @JsonProperty(value="footer")
        @Nullable
        private String footer;
        @JsonProperty(value="footer_icon")
        @Nullable
        private String footerIcon;
        @JsonProperty(value="actions")
        @Nullable
        private List<ActionRequestObject> actions;
        @JsonProperty(value="fields")
        @Nullable
        private List<FieldRequestObject> fields;
        @JsonProperty(value="asset_url")
        @Nullable
        private String assetURL;
        @JsonProperty(value="og_scrape_url")
        @Nullable
        private String ogScrapeURL;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static AttachmentRequestObject buildFrom(@Nullable Attachment attachment) {
            return RequestObjectBuilder.build(AttachmentRequestObject.class, attachment);
        }

        AttachmentRequestObject(@Nullable String type, @Nullable String fallback, @Nullable String color, @Nullable String pretext, @Nullable String authorName, @Nullable String authorLink, @Nullable String authorIcon, @Nullable String title, @Nullable String titleLink, @Nullable String text, @Nullable String imageURL, @Nullable String thumbURL, @Nullable String footer, @Nullable String footerIcon, @Nullable List<ActionRequestObject> actions, @Nullable List<FieldRequestObject> fields, @Nullable String assetURL, @Nullable String ogScrapeURL, @Nullable Map<String, Object> additionalFields) {
            this.type = type;
            this.fallback = fallback;
            this.color = color;
            this.pretext = pretext;
            this.authorName = authorName;
            this.authorLink = authorLink;
            this.authorIcon = authorIcon;
            this.title = title;
            this.titleLink = titleLink;
            this.text = text;
            this.imageURL = imageURL;
            this.thumbURL = thumbURL;
            this.footer = footer;
            this.footerIcon = footerIcon;
            this.actions = actions;
            this.fields = fields;
            this.assetURL = assetURL;
            this.ogScrapeURL = ogScrapeURL;
            this.additionalFields = additionalFields;
        }

        public static AttachmentRequestObjectBuilder builder() {
            return new AttachmentRequestObjectBuilder();
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="fallback")
        public void setFallback(@Nullable String fallback) {
            this.fallback = fallback;
        }

        @JsonProperty(value="color")
        public void setColor(@Nullable String color) {
            this.color = color;
        }

        @JsonProperty(value="pretext")
        public void setPretext(@Nullable String pretext) {
            this.pretext = pretext;
        }

        @JsonProperty(value="author_name")
        public void setAuthorName(@Nullable String authorName) {
            this.authorName = authorName;
        }

        @JsonProperty(value="author_link")
        public void setAuthorLink(@Nullable String authorLink) {
            this.authorLink = authorLink;
        }

        @JsonProperty(value="author_icon")
        public void setAuthorIcon(@Nullable String authorIcon) {
            this.authorIcon = authorIcon;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="title_link")
        public void setTitleLink(@Nullable String titleLink) {
            this.titleLink = titleLink;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageURL(@Nullable String imageURL) {
            this.imageURL = imageURL;
        }

        @JsonProperty(value="thumb_url")
        public void setThumbURL(@Nullable String thumbURL) {
            this.thumbURL = thumbURL;
        }

        @JsonProperty(value="footer")
        public void setFooter(@Nullable String footer) {
            this.footer = footer;
        }

        @JsonProperty(value="footer_icon")
        public void setFooterIcon(@Nullable String footerIcon) {
            this.footerIcon = footerIcon;
        }

        @JsonProperty(value="actions")
        public void setActions(@Nullable List<ActionRequestObject> actions) {
            this.actions = actions;
        }

        @JsonProperty(value="fields")
        public void setFields(@Nullable List<FieldRequestObject> fields) {
            this.fields = fields;
        }

        @JsonProperty(value="asset_url")
        public void setAssetURL(@Nullable String assetURL) {
            this.assetURL = assetURL;
        }

        @JsonProperty(value="og_scrape_url")
        public void setOgScrapeURL(@Nullable String ogScrapeURL) {
            this.ogScrapeURL = ogScrapeURL;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getFallback() {
            return this.fallback;
        }

        @Nullable
        public String getColor() {
            return this.color;
        }

        @Nullable
        public String getPretext() {
            return this.pretext;
        }

        @Nullable
        public String getAuthorName() {
            return this.authorName;
        }

        @Nullable
        public String getAuthorLink() {
            return this.authorLink;
        }

        @Nullable
        public String getAuthorIcon() {
            return this.authorIcon;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getTitleLink() {
            return this.titleLink;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public String getImageURL() {
            return this.imageURL;
        }

        @Nullable
        public String getThumbURL() {
            return this.thumbURL;
        }

        @Nullable
        public String getFooter() {
            return this.footer;
        }

        @Nullable
        public String getFooterIcon() {
            return this.footerIcon;
        }

        @Nullable
        public List<ActionRequestObject> getActions() {
            return this.actions;
        }

        @Nullable
        public List<FieldRequestObject> getFields() {
            return this.fields;
        }

        @Nullable
        public String getAssetURL() {
            return this.assetURL;
        }

        @Nullable
        public String getOgScrapeURL() {
            return this.ogScrapeURL;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttachmentRequestObject)) {
                return false;
            }
            AttachmentRequestObject other = (AttachmentRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$fallback = this.getFallback();
            String other$fallback = other.getFallback();
            if (this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            String this$pretext = this.getPretext();
            String other$pretext = other.getPretext();
            if (this$pretext == null ? other$pretext != null : !this$pretext.equals(other$pretext)) {
                return false;
            }
            String this$authorName = this.getAuthorName();
            String other$authorName = other.getAuthorName();
            if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
                return false;
            }
            String this$authorLink = this.getAuthorLink();
            String other$authorLink = other.getAuthorLink();
            if (this$authorLink == null ? other$authorLink != null : !this$authorLink.equals(other$authorLink)) {
                return false;
            }
            String this$authorIcon = this.getAuthorIcon();
            String other$authorIcon = other.getAuthorIcon();
            if (this$authorIcon == null ? other$authorIcon != null : !this$authorIcon.equals(other$authorIcon)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$titleLink = this.getTitleLink();
            String other$titleLink = other.getTitleLink();
            if (this$titleLink == null ? other$titleLink != null : !this$titleLink.equals(other$titleLink)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$imageURL = this.getImageURL();
            String other$imageURL = other.getImageURL();
            if (this$imageURL == null ? other$imageURL != null : !this$imageURL.equals(other$imageURL)) {
                return false;
            }
            String this$thumbURL = this.getThumbURL();
            String other$thumbURL = other.getThumbURL();
            if (this$thumbURL == null ? other$thumbURL != null : !this$thumbURL.equals(other$thumbURL)) {
                return false;
            }
            String this$footer = this.getFooter();
            String other$footer = other.getFooter();
            if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
                return false;
            }
            String this$footerIcon = this.getFooterIcon();
            String other$footerIcon = other.getFooterIcon();
            if (this$footerIcon == null ? other$footerIcon != null : !this$footerIcon.equals(other$footerIcon)) {
                return false;
            }
            List<ActionRequestObject> this$actions = this.getActions();
            List<ActionRequestObject> other$actions = other.getActions();
            if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
                return false;
            }
            List<FieldRequestObject> this$fields = this.getFields();
            List<FieldRequestObject> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$assetURL = this.getAssetURL();
            String other$assetURL = other.getAssetURL();
            if (this$assetURL == null ? other$assetURL != null : !this$assetURL.equals(other$assetURL)) {
                return false;
            }
            String this$ogScrapeURL = this.getOgScrapeURL();
            String other$ogScrapeURL = other.getOgScrapeURL();
            if (this$ogScrapeURL == null ? other$ogScrapeURL != null : !this$ogScrapeURL.equals(other$ogScrapeURL)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AttachmentRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $fallback = this.getFallback();
            result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            String $pretext = this.getPretext();
            result = result * 59 + ($pretext == null ? 43 : $pretext.hashCode());
            String $authorName = this.getAuthorName();
            result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
            String $authorLink = this.getAuthorLink();
            result = result * 59 + ($authorLink == null ? 43 : $authorLink.hashCode());
            String $authorIcon = this.getAuthorIcon();
            result = result * 59 + ($authorIcon == null ? 43 : $authorIcon.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $titleLink = this.getTitleLink();
            result = result * 59 + ($titleLink == null ? 43 : $titleLink.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $imageURL = this.getImageURL();
            result = result * 59 + ($imageURL == null ? 43 : $imageURL.hashCode());
            String $thumbURL = this.getThumbURL();
            result = result * 59 + ($thumbURL == null ? 43 : $thumbURL.hashCode());
            String $footer = this.getFooter();
            result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
            String $footerIcon = this.getFooterIcon();
            result = result * 59 + ($footerIcon == null ? 43 : $footerIcon.hashCode());
            List<ActionRequestObject> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            List<FieldRequestObject> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $assetURL = this.getAssetURL();
            result = result * 59 + ($assetURL == null ? 43 : $assetURL.hashCode());
            String $ogScrapeURL = this.getOgScrapeURL();
            result = result * 59 + ($ogScrapeURL == null ? 43 : $ogScrapeURL.hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public static class AttachmentRequestObjectBuilder {
            private String type;
            private String fallback;
            private String color;
            private String pretext;
            private String authorName;
            private String authorLink;
            private String authorIcon;
            private String title;
            private String titleLink;
            private String text;
            private String imageURL;
            private String thumbURL;
            private String footer;
            private String footerIcon;
            private ArrayList<ActionRequestObject> actions;
            private ArrayList<FieldRequestObject> fields;
            private String assetURL;
            private String ogScrapeURL;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            AttachmentRequestObjectBuilder() {
            }

            @JsonProperty(value="type")
            public AttachmentRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="fallback")
            public AttachmentRequestObjectBuilder fallback(@Nullable String fallback) {
                this.fallback = fallback;
                return this;
            }

            @JsonProperty(value="color")
            public AttachmentRequestObjectBuilder color(@Nullable String color) {
                this.color = color;
                return this;
            }

            @JsonProperty(value="pretext")
            public AttachmentRequestObjectBuilder pretext(@Nullable String pretext) {
                this.pretext = pretext;
                return this;
            }

            @JsonProperty(value="author_name")
            public AttachmentRequestObjectBuilder authorName(@Nullable String authorName) {
                this.authorName = authorName;
                return this;
            }

            @JsonProperty(value="author_link")
            public AttachmentRequestObjectBuilder authorLink(@Nullable String authorLink) {
                this.authorLink = authorLink;
                return this;
            }

            @JsonProperty(value="author_icon")
            public AttachmentRequestObjectBuilder authorIcon(@Nullable String authorIcon) {
                this.authorIcon = authorIcon;
                return this;
            }

            @JsonProperty(value="title")
            public AttachmentRequestObjectBuilder title(@Nullable String title) {
                this.title = title;
                return this;
            }

            @JsonProperty(value="title_link")
            public AttachmentRequestObjectBuilder titleLink(@Nullable String titleLink) {
                this.titleLink = titleLink;
                return this;
            }

            @JsonProperty(value="text")
            public AttachmentRequestObjectBuilder text(@Nullable String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="image_url")
            public AttachmentRequestObjectBuilder imageURL(@Nullable String imageURL) {
                this.imageURL = imageURL;
                return this;
            }

            @JsonProperty(value="thumb_url")
            public AttachmentRequestObjectBuilder thumbURL(@Nullable String thumbURL) {
                this.thumbURL = thumbURL;
                return this;
            }

            @JsonProperty(value="footer")
            public AttachmentRequestObjectBuilder footer(@Nullable String footer) {
                this.footer = footer;
                return this;
            }

            @JsonProperty(value="footer_icon")
            public AttachmentRequestObjectBuilder footerIcon(@Nullable String footerIcon) {
                this.footerIcon = footerIcon;
                return this;
            }

            public AttachmentRequestObjectBuilder action(ActionRequestObject action) {
                if (this.actions == null) {
                    this.actions = new ArrayList();
                }
                this.actions.add(action);
                return this;
            }

            @JsonProperty(value="actions")
            public AttachmentRequestObjectBuilder actions(Collection<? extends ActionRequestObject> actions) {
                if (actions == null) {
                    throw new NullPointerException("actions cannot be null");
                }
                if (this.actions == null) {
                    this.actions = new ArrayList();
                }
                this.actions.addAll(actions);
                return this;
            }

            public AttachmentRequestObjectBuilder clearActions() {
                if (this.actions != null) {
                    this.actions.clear();
                }
                return this;
            }

            public AttachmentRequestObjectBuilder field(FieldRequestObject field) {
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.add(field);
                return this;
            }

            @JsonProperty(value="fields")
            public AttachmentRequestObjectBuilder fields(Collection<? extends FieldRequestObject> fields) {
                if (fields == null) {
                    throw new NullPointerException("fields cannot be null");
                }
                if (this.fields == null) {
                    this.fields = new ArrayList();
                }
                this.fields.addAll(fields);
                return this;
            }

            public AttachmentRequestObjectBuilder clearFields() {
                if (this.fields != null) {
                    this.fields.clear();
                }
                return this;
            }

            @JsonProperty(value="asset_url")
            public AttachmentRequestObjectBuilder assetURL(@Nullable String assetURL) {
                this.assetURL = assetURL;
                return this;
            }

            @JsonProperty(value="og_scrape_url")
            public AttachmentRequestObjectBuilder ogScrapeURL(@Nullable String ogScrapeURL) {
                this.ogScrapeURL = ogScrapeURL;
                return this;
            }

            public AttachmentRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public AttachmentRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public AttachmentRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public AttachmentRequestObject build() {
                Map<Object, Object> additionalFields;
                List<FieldRequestObject> fields;
                List<ActionRequestObject> actions;
                switch (this.actions == null ? 0 : this.actions.size()) {
                    case 0: {
                        actions = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        actions = Collections.singletonList(this.actions.get(0));
                        break;
                    }
                    default: {
                        actions = Collections.unmodifiableList(new ArrayList<ActionRequestObject>(this.actions));
                    }
                }
                switch (this.fields == null ? 0 : this.fields.size()) {
                    case 0: {
                        fields = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        fields = Collections.singletonList(this.fields.get(0));
                        break;
                    }
                    default: {
                        fields = Collections.unmodifiableList(new ArrayList<FieldRequestObject>(this.fields));
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new AttachmentRequestObject(this.type, this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageURL, this.thumbURL, this.footer, this.footerIcon, actions, fields, this.assetURL, this.ogScrapeURL, additionalFields);
            }

            public String toString() {
                return "Message.AttachmentRequestObject.AttachmentRequestObjectBuilder(type=" + this.type + ", fallback=" + this.fallback + ", color=" + this.color + ", pretext=" + this.pretext + ", authorName=" + this.authorName + ", authorLink=" + this.authorLink + ", authorIcon=" + this.authorIcon + ", title=" + this.title + ", titleLink=" + this.titleLink + ", text=" + this.text + ", imageURL=" + this.imageURL + ", thumbURL=" + this.thumbURL + ", footer=" + this.footer + ", footerIcon=" + this.footerIcon + ", actions=" + String.valueOf(this.actions) + ", fields=" + String.valueOf(this.fields) + ", assetURL=" + this.assetURL + ", ogScrapeURL=" + this.ogScrapeURL + ", additionalFields$key=" + String.valueOf(this.additionalFields$key) + ", additionalFields$value=" + String.valueOf(this.additionalFields$value) + ")";
            }
        }
    }

    public static class MessageRequestObject {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="type")
        @Nullable
        private MessageType type;
        @JsonProperty(value="mml")
        @Nullable
        private String mml;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="restricted_visibility")
        @Nullable
        private List<String> restrictedVisibility;
        @JsonProperty(value="parent_id")
        @Nullable
        private String parentId;
        @JsonProperty(value="attachments")
        @Nullable
        private List<AttachmentRequestObject> attachments;
        @JsonProperty(value="show_in_channel")
        @Nullable
        private Boolean showInChannel;
        @JsonProperty(value="mentioned_users")
        @Nullable
        private List<String> mentionedUsers;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="html")
        @Nullable
        private String html;
        @JsonProperty(value="reaction_scores")
        @Nullable
        private Map<String, Integer> reactionScores;
        @JsonProperty(value="quoted_message_id")
        @Nullable
        private String quotedMessageId;
        @JsonProperty(value="cid")
        @Nullable
        private String cId;
        @JsonProperty(value="silent")
        @Nullable
        private Boolean silent;
        @JsonProperty(value="pinned")
        @Nullable
        private Boolean pinned;
        @JsonProperty(value="pin_expires")
        @Nullable
        private Date pinExpires;
        @JsonProperty(value="pinned_by")
        @Nullable
        private User.UserRequestObject pinnedBy;
        @JsonProperty(value="pinned_at")
        @Nullable
        private Date pinnedAt;
        @JsonProperty(value="shared_location")
        @Nullable
        private SharedLocation sharedLocation;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @NotNull
        public MessageRequestObject setSharedLocation(@Nullable SharedLocation sharedLocation) {
            this.sharedLocation = sharedLocation;
            return this;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static MessageRequestObject buildFrom(@Nullable Message message) {
            return RequestObjectBuilder.build(MessageRequestObject.class, message);
        }

        MessageRequestObject(@Nullable String id, @Nullable String text, @Nullable MessageType type, @Nullable String mml, @Nullable User.UserRequestObject user, @Nullable List<String> restrictedVisibility, @Nullable String parentId, @Nullable List<AttachmentRequestObject> attachments, @Nullable Boolean showInChannel, @Nullable List<String> mentionedUsers, @Nullable String userId, @Nullable String html, @Nullable Map<String, Integer> reactionScores, @Nullable String quotedMessageId, @Nullable String cId, @Nullable Boolean silent, @Nullable Boolean pinned, @Nullable Date pinExpires, @Nullable User.UserRequestObject pinnedBy, @Nullable Date pinnedAt, @Nullable SharedLocation sharedLocation, @Nullable Map<String, Object> additionalFields) {
            this.id = id;
            this.text = text;
            this.type = type;
            this.mml = mml;
            this.user = user;
            this.restrictedVisibility = restrictedVisibility;
            this.parentId = parentId;
            this.attachments = attachments;
            this.showInChannel = showInChannel;
            this.mentionedUsers = mentionedUsers;
            this.userId = userId;
            this.html = html;
            this.reactionScores = reactionScores;
            this.quotedMessageId = quotedMessageId;
            this.cId = cId;
            this.silent = silent;
            this.pinned = pinned;
            this.pinExpires = pinExpires;
            this.pinnedBy = pinnedBy;
            this.pinnedAt = pinnedAt;
            this.sharedLocation = sharedLocation;
            this.additionalFields = additionalFields;
        }

        public static MessageRequestObjectBuilder builder() {
            return new MessageRequestObjectBuilder();
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable MessageType type) {
            this.type = type;
        }

        @JsonProperty(value="mml")
        public void setMml(@Nullable String mml) {
            this.mml = mml;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User.UserRequestObject user) {
            this.user = user;
        }

        @JsonProperty(value="restricted_visibility")
        public void setRestrictedVisibility(@Nullable List<String> restrictedVisibility) {
            this.restrictedVisibility = restrictedVisibility;
        }

        @JsonProperty(value="parent_id")
        public void setParentId(@Nullable String parentId) {
            this.parentId = parentId;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(@Nullable List<AttachmentRequestObject> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="show_in_channel")
        public void setShowInChannel(@Nullable Boolean showInChannel) {
            this.showInChannel = showInChannel;
        }

        @JsonProperty(value="mentioned_users")
        public void setMentionedUsers(@Nullable List<String> mentionedUsers) {
            this.mentionedUsers = mentionedUsers;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="html")
        public void setHtml(@Nullable String html) {
            this.html = html;
        }

        @JsonProperty(value="reaction_scores")
        public void setReactionScores(@Nullable Map<String, Integer> reactionScores) {
            this.reactionScores = reactionScores;
        }

        @JsonProperty(value="quoted_message_id")
        public void setQuotedMessageId(@Nullable String quotedMessageId) {
            this.quotedMessageId = quotedMessageId;
        }

        @JsonProperty(value="cid")
        public void setCId(@Nullable String cId) {
            this.cId = cId;
        }

        @JsonProperty(value="silent")
        public void setSilent(@Nullable Boolean silent) {
            this.silent = silent;
        }

        @JsonProperty(value="pinned")
        public void setPinned(@Nullable Boolean pinned) {
            this.pinned = pinned;
        }

        @JsonProperty(value="pin_expires")
        public void setPinExpires(@Nullable Date pinExpires) {
            this.pinExpires = pinExpires;
        }

        @JsonProperty(value="pinned_by")
        public void setPinnedBy(@Nullable User.UserRequestObject pinnedBy) {
            this.pinnedBy = pinnedBy;
        }

        @JsonProperty(value="pinned_at")
        public void setPinnedAt(@Nullable Date pinnedAt) {
            this.pinnedAt = pinnedAt;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public MessageType getType() {
            return this.type;
        }

        @Nullable
        public String getMml() {
            return this.mml;
        }

        @Nullable
        public User.UserRequestObject getUser() {
            return this.user;
        }

        @Nullable
        public List<String> getRestrictedVisibility() {
            return this.restrictedVisibility;
        }

        @Nullable
        public String getParentId() {
            return this.parentId;
        }

        @Nullable
        public List<AttachmentRequestObject> getAttachments() {
            return this.attachments;
        }

        @Nullable
        public Boolean getShowInChannel() {
            return this.showInChannel;
        }

        @Nullable
        public List<String> getMentionedUsers() {
            return this.mentionedUsers;
        }

        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Nullable
        public String getHtml() {
            return this.html;
        }

        @Nullable
        public Map<String, Integer> getReactionScores() {
            return this.reactionScores;
        }

        @Nullable
        public String getQuotedMessageId() {
            return this.quotedMessageId;
        }

        @Nullable
        public String getCId() {
            return this.cId;
        }

        @Nullable
        public Boolean getSilent() {
            return this.silent;
        }

        @Nullable
        public Boolean getPinned() {
            return this.pinned;
        }

        @Nullable
        public Date getPinExpires() {
            return this.pinExpires;
        }

        @Nullable
        public User.UserRequestObject getPinnedBy() {
            return this.pinnedBy;
        }

        @Nullable
        public Date getPinnedAt() {
            return this.pinnedAt;
        }

        @Nullable
        public SharedLocation getSharedLocation() {
            return this.sharedLocation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageRequestObject)) {
                return false;
            }
            MessageRequestObject other = (MessageRequestObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$showInChannel = this.getShowInChannel();
            Boolean other$showInChannel = other.getShowInChannel();
            if (this$showInChannel == null ? other$showInChannel != null : !((Object)this$showInChannel).equals(other$showInChannel)) {
                return false;
            }
            Boolean this$silent = this.getSilent();
            Boolean other$silent = other.getSilent();
            if (this$silent == null ? other$silent != null : !((Object)this$silent).equals(other$silent)) {
                return false;
            }
            Boolean this$pinned = this.getPinned();
            Boolean other$pinned = other.getPinned();
            if (this$pinned == null ? other$pinned != null : !((Object)this$pinned).equals(other$pinned)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            MessageType this$type = this.getType();
            MessageType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$mml = this.getMml();
            String other$mml = other.getMml();
            if (this$mml == null ? other$mml != null : !this$mml.equals(other$mml)) {
                return false;
            }
            User.UserRequestObject this$user = this.getUser();
            User.UserRequestObject other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            List<String> this$restrictedVisibility = this.getRestrictedVisibility();
            List<String> other$restrictedVisibility = other.getRestrictedVisibility();
            if (this$restrictedVisibility == null ? other$restrictedVisibility != null : !((Object)this$restrictedVisibility).equals(other$restrictedVisibility)) {
                return false;
            }
            String this$parentId = this.getParentId();
            String other$parentId = other.getParentId();
            if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
                return false;
            }
            List<AttachmentRequestObject> this$attachments = this.getAttachments();
            List<AttachmentRequestObject> other$attachments = other.getAttachments();
            if (this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments)) {
                return false;
            }
            List<String> this$mentionedUsers = this.getMentionedUsers();
            List<String> other$mentionedUsers = other.getMentionedUsers();
            if (this$mentionedUsers == null ? other$mentionedUsers != null : !((Object)this$mentionedUsers).equals(other$mentionedUsers)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$html = this.getHtml();
            String other$html = other.getHtml();
            if (this$html == null ? other$html != null : !this$html.equals(other$html)) {
                return false;
            }
            Map<String, Integer> this$reactionScores = this.getReactionScores();
            Map<String, Integer> other$reactionScores = other.getReactionScores();
            if (this$reactionScores == null ? other$reactionScores != null : !((Object)this$reactionScores).equals(other$reactionScores)) {
                return false;
            }
            String this$quotedMessageId = this.getQuotedMessageId();
            String other$quotedMessageId = other.getQuotedMessageId();
            if (this$quotedMessageId == null ? other$quotedMessageId != null : !this$quotedMessageId.equals(other$quotedMessageId)) {
                return false;
            }
            String this$cId = this.getCId();
            String other$cId = other.getCId();
            if (this$cId == null ? other$cId != null : !this$cId.equals(other$cId)) {
                return false;
            }
            Date this$pinExpires = this.getPinExpires();
            Date other$pinExpires = other.getPinExpires();
            if (this$pinExpires == null ? other$pinExpires != null : !((Object)this$pinExpires).equals(other$pinExpires)) {
                return false;
            }
            User.UserRequestObject this$pinnedBy = this.getPinnedBy();
            User.UserRequestObject other$pinnedBy = other.getPinnedBy();
            if (this$pinnedBy == null ? other$pinnedBy != null : !((Object)this$pinnedBy).equals(other$pinnedBy)) {
                return false;
            }
            Date this$pinnedAt = this.getPinnedAt();
            Date other$pinnedAt = other.getPinnedAt();
            if (this$pinnedAt == null ? other$pinnedAt != null : !((Object)this$pinnedAt).equals(other$pinnedAt)) {
                return false;
            }
            SharedLocation this$sharedLocation = this.getSharedLocation();
            SharedLocation other$sharedLocation = other.getSharedLocation();
            if (this$sharedLocation == null ? other$sharedLocation != null : !((Object)this$sharedLocation).equals(other$sharedLocation)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MessageRequestObject;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $showInChannel = this.getShowInChannel();
            result = result * 59 + ($showInChannel == null ? 43 : ((Object)$showInChannel).hashCode());
            Boolean $silent = this.getSilent();
            result = result * 59 + ($silent == null ? 43 : ((Object)$silent).hashCode());
            Boolean $pinned = this.getPinned();
            result = result * 59 + ($pinned == null ? 43 : ((Object)$pinned).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            MessageType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $mml = this.getMml();
            result = result * 59 + ($mml == null ? 43 : $mml.hashCode());
            User.UserRequestObject $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            List<String> $restrictedVisibility = this.getRestrictedVisibility();
            result = result * 59 + ($restrictedVisibility == null ? 43 : ((Object)$restrictedVisibility).hashCode());
            String $parentId = this.getParentId();
            result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
            List<AttachmentRequestObject> $attachments = this.getAttachments();
            result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
            List<String> $mentionedUsers = this.getMentionedUsers();
            result = result * 59 + ($mentionedUsers == null ? 43 : ((Object)$mentionedUsers).hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $html = this.getHtml();
            result = result * 59 + ($html == null ? 43 : $html.hashCode());
            Map<String, Integer> $reactionScores = this.getReactionScores();
            result = result * 59 + ($reactionScores == null ? 43 : ((Object)$reactionScores).hashCode());
            String $quotedMessageId = this.getQuotedMessageId();
            result = result * 59 + ($quotedMessageId == null ? 43 : $quotedMessageId.hashCode());
            String $cId = this.getCId();
            result = result * 59 + ($cId == null ? 43 : $cId.hashCode());
            Date $pinExpires = this.getPinExpires();
            result = result * 59 + ($pinExpires == null ? 43 : ((Object)$pinExpires).hashCode());
            User.UserRequestObject $pinnedBy = this.getPinnedBy();
            result = result * 59 + ($pinnedBy == null ? 43 : ((Object)$pinnedBy).hashCode());
            Date $pinnedAt = this.getPinnedAt();
            result = result * 59 + ($pinnedAt == null ? 43 : ((Object)$pinnedAt).hashCode());
            SharedLocation $sharedLocation = this.getSharedLocation();
            result = result * 59 + ($sharedLocation == null ? 43 : ((Object)$sharedLocation).hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public static class MessageRequestObjectBuilder {
            private String id;
            private String text;
            private MessageType type;
            private String mml;
            private User.UserRequestObject user;
            private List<String> restrictedVisibility;
            private String parentId;
            private ArrayList<AttachmentRequestObject> attachments;
            private Boolean showInChannel;
            private List<String> mentionedUsers;
            private String userId;
            private String html;
            private ArrayList<String> reactionScores$key;
            private ArrayList<Integer> reactionScores$value;
            private String quotedMessageId;
            private String cId;
            private Boolean silent;
            private Boolean pinned;
            private Date pinExpires;
            private User.UserRequestObject pinnedBy;
            private Date pinnedAt;
            private SharedLocation sharedLocation;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            MessageRequestObjectBuilder() {
            }

            @JsonProperty(value="id")
            public MessageRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="text")
            public MessageRequestObjectBuilder text(@Nullable String text) {
                this.text = text;
                return this;
            }

            @JsonProperty(value="type")
            public MessageRequestObjectBuilder type(@Nullable MessageType type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="mml")
            public MessageRequestObjectBuilder mml(@Nullable String mml) {
                this.mml = mml;
                return this;
            }

            @JsonProperty(value="user")
            public MessageRequestObjectBuilder user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="restricted_visibility")
            public MessageRequestObjectBuilder restrictedVisibility(@Nullable List<String> restrictedVisibility) {
                this.restrictedVisibility = restrictedVisibility;
                return this;
            }

            @JsonProperty(value="parent_id")
            public MessageRequestObjectBuilder parentId(@Nullable String parentId) {
                this.parentId = parentId;
                return this;
            }

            public MessageRequestObjectBuilder attachment(AttachmentRequestObject attachment) {
                if (this.attachments == null) {
                    this.attachments = new ArrayList();
                }
                this.attachments.add(attachment);
                return this;
            }

            @JsonProperty(value="attachments")
            public MessageRequestObjectBuilder attachments(Collection<? extends AttachmentRequestObject> attachments) {
                if (attachments == null) {
                    throw new NullPointerException("attachments cannot be null");
                }
                if (this.attachments == null) {
                    this.attachments = new ArrayList();
                }
                this.attachments.addAll(attachments);
                return this;
            }

            public MessageRequestObjectBuilder clearAttachments() {
                if (this.attachments != null) {
                    this.attachments.clear();
                }
                return this;
            }

            @JsonProperty(value="show_in_channel")
            public MessageRequestObjectBuilder showInChannel(@Nullable Boolean showInChannel) {
                this.showInChannel = showInChannel;
                return this;
            }

            @JsonProperty(value="mentioned_users")
            public MessageRequestObjectBuilder mentionedUsers(@Nullable List<String> mentionedUsers) {
                this.mentionedUsers = mentionedUsers;
                return this;
            }

            @JsonProperty(value="user_id")
            public MessageRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="html")
            public MessageRequestObjectBuilder html(@Nullable String html) {
                this.html = html;
                return this;
            }

            public MessageRequestObjectBuilder reactionScore(String reactionScoreKey, Integer reactionScoreValue) {
                if (this.reactionScores$key == null) {
                    this.reactionScores$key = new ArrayList();
                    this.reactionScores$value = new ArrayList();
                }
                this.reactionScores$key.add(reactionScoreKey);
                this.reactionScores$value.add(reactionScoreValue);
                return this;
            }

            @JsonProperty(value="reaction_scores")
            public MessageRequestObjectBuilder reactionScores(Map<? extends String, ? extends Integer> reactionScores) {
                if (reactionScores == null) {
                    throw new NullPointerException("reactionScores cannot be null");
                }
                if (this.reactionScores$key == null) {
                    this.reactionScores$key = new ArrayList();
                    this.reactionScores$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Integer> $lombokEntry : reactionScores.entrySet()) {
                    this.reactionScores$key.add($lombokEntry.getKey());
                    this.reactionScores$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageRequestObjectBuilder clearReactionScores() {
                if (this.reactionScores$key != null) {
                    this.reactionScores$key.clear();
                    this.reactionScores$value.clear();
                }
                return this;
            }

            @JsonProperty(value="quoted_message_id")
            public MessageRequestObjectBuilder quotedMessageId(@Nullable String quotedMessageId) {
                this.quotedMessageId = quotedMessageId;
                return this;
            }

            @JsonProperty(value="cid")
            public MessageRequestObjectBuilder cId(@Nullable String cId) {
                this.cId = cId;
                return this;
            }

            @JsonProperty(value="silent")
            public MessageRequestObjectBuilder silent(@Nullable Boolean silent) {
                this.silent = silent;
                return this;
            }

            @JsonProperty(value="pinned")
            public MessageRequestObjectBuilder pinned(@Nullable Boolean pinned) {
                this.pinned = pinned;
                return this;
            }

            @JsonProperty(value="pin_expires")
            public MessageRequestObjectBuilder pinExpires(@Nullable Date pinExpires) {
                this.pinExpires = pinExpires;
                return this;
            }

            @JsonProperty(value="pinned_by")
            public MessageRequestObjectBuilder pinnedBy(@Nullable User.UserRequestObject pinnedBy) {
                this.pinnedBy = pinnedBy;
                return this;
            }

            @JsonProperty(value="pinned_at")
            public MessageRequestObjectBuilder pinnedAt(@Nullable Date pinnedAt) {
                this.pinnedAt = pinnedAt;
                return this;
            }

            @JsonProperty(value="shared_location")
            public MessageRequestObjectBuilder sharedLocation(@Nullable SharedLocation sharedLocation) {
                this.sharedLocation = sharedLocation;
                return this;
            }

            public MessageRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public MessageRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public MessageRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public MessageRequestObject build() {
                Map<Object, Object> additionalFields;
                Map<Object, Object> reactionScores;
                List<AttachmentRequestObject> attachments;
                switch (this.attachments == null ? 0 : this.attachments.size()) {
                    case 0: {
                        attachments = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        attachments = Collections.singletonList(this.attachments.get(0));
                        break;
                    }
                    default: {
                        attachments = Collections.unmodifiableList(new ArrayList<AttachmentRequestObject>(this.attachments));
                    }
                }
                switch (this.reactionScores$key == null ? 0 : this.reactionScores$key.size()) {
                    case 0: {
                        reactionScores = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        reactionScores = Collections.singletonMap(this.reactionScores$key.get(0), this.reactionScores$value.get(0));
                        break;
                    }
                    default: {
                        reactionScores = new LinkedHashMap(this.reactionScores$key.size() < 0x40000000 ? 1 + this.reactionScores$key.size() + (this.reactionScores$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.reactionScores$key.size(); ++$i) {
                            reactionScores.put(this.reactionScores$key.get($i), this.reactionScores$value.get($i));
                        }
                        reactionScores = Collections.unmodifiableMap(reactionScores);
                    }
                }
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new MessageRequestObject(this.id, this.text, this.type, this.mml, this.user, this.restrictedVisibility, this.parentId, attachments, this.showInChannel, this.mentionedUsers, this.userId, this.html, reactionScores, this.quotedMessageId, this.cId, this.silent, this.pinned, this.pinExpires, this.pinnedBy, this.pinnedAt, this.sharedLocation, additionalFields);
            }

            public String toString() {
                return "Message.MessageRequestObject.MessageRequestObjectBuilder(id=" + this.id + ", text=" + this.text + ", type=" + String.valueOf((Object)this.type) + ", mml=" + this.mml + ", user=" + String.valueOf(this.user) + ", restrictedVisibility=" + String.valueOf(this.restrictedVisibility) + ", parentId=" + this.parentId + ", attachments=" + String.valueOf(this.attachments) + ", showInChannel=" + this.showInChannel + ", mentionedUsers=" + String.valueOf(this.mentionedUsers) + ", userId=" + this.userId + ", html=" + this.html + ", reactionScores$key=" + String.valueOf(this.reactionScores$key) + ", reactionScores$value=" + String.valueOf(this.reactionScores$value) + ", quotedMessageId=" + this.quotedMessageId + ", cId=" + this.cId + ", silent=" + this.silent + ", pinned=" + this.pinned + ", pinExpires=" + String.valueOf(this.pinExpires) + ", pinnedBy=" + String.valueOf(this.pinnedBy) + ", pinnedAt=" + String.valueOf(this.pinnedAt) + ", sharedLocation=" + String.valueOf(this.sharedLocation) + ", additionalFields$key=" + String.valueOf(this.additionalFields$key) + ", additionalFields$value=" + String.valueOf(this.additionalFields$value) + ")";
            }
        }
    }

    public static class Moderation {
        @JsonProperty(value="toxic")
        @Nullable
        private Integer toxic;
        @JsonProperty(value="explicit")
        @Nullable
        private Integer explicit;
        @JsonProperty(value="spam")
        @Nullable
        private Integer spam;

        @Nullable
        public Integer getToxic() {
            return this.toxic;
        }

        @Nullable
        public Integer getExplicit() {
            return this.explicit;
        }

        @Nullable
        public Integer getSpam() {
            return this.spam;
        }

        @JsonProperty(value="toxic")
        public void setToxic(@Nullable Integer toxic) {
            this.toxic = toxic;
        }

        @JsonProperty(value="explicit")
        public void setExplicit(@Nullable Integer explicit) {
            this.explicit = explicit;
        }

        @JsonProperty(value="spam")
        public void setSpam(@Nullable Integer spam) {
            this.spam = spam;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Moderation)) {
                return false;
            }
            Moderation other = (Moderation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$toxic = this.getToxic();
            Integer other$toxic = other.getToxic();
            if (this$toxic == null ? other$toxic != null : !((Object)this$toxic).equals(other$toxic)) {
                return false;
            }
            Integer this$explicit = this.getExplicit();
            Integer other$explicit = other.getExplicit();
            if (this$explicit == null ? other$explicit != null : !((Object)this$explicit).equals(other$explicit)) {
                return false;
            }
            Integer this$spam = this.getSpam();
            Integer other$spam = other.getSpam();
            return !(this$spam == null ? other$spam != null : !((Object)this$spam).equals(other$spam));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Moderation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $toxic = this.getToxic();
            result = result * 59 + ($toxic == null ? 43 : ((Object)$toxic).hashCode());
            Integer $explicit = this.getExplicit();
            result = result * 59 + ($explicit == null ? 43 : ((Object)$explicit).hashCode());
            Integer $spam = this.getSpam();
            result = result * 59 + ($spam == null ? 43 : ((Object)$spam).hashCode());
            return result;
        }

        public String toString() {
            return "Message.Moderation(toxic=" + this.getToxic() + ", explicit=" + this.getExplicit() + ", spam=" + this.getSpam() + ")";
        }
    }

    public static enum Resize {
        CLIP,
        CROP,
        SCALE,
        FILL,
        UNKNOWN;

    }

    public static enum Crop {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        CENTER,
        UNKNOWN;

    }

    public static class ImageSize {
        @JsonProperty(value="crop")
        @Nullable
        private Crop crop;
        @JsonProperty(value="resize")
        @Nullable
        private Resize resize;
        @JsonProperty(value="height")
        @Nullable
        private Integer height;
        @JsonProperty(value="width")
        @Nullable
        private Integer width;

        @Nullable
        public Crop getCrop() {
            return this.crop;
        }

        @Nullable
        public Resize getResize() {
            return this.resize;
        }

        @Nullable
        public Integer getHeight() {
            return this.height;
        }

        @Nullable
        public Integer getWidth() {
            return this.width;
        }

        @JsonProperty(value="crop")
        public void setCrop(@Nullable Crop crop) {
            this.crop = crop;
        }

        @JsonProperty(value="resize")
        public void setResize(@Nullable Resize resize) {
            this.resize = resize;
        }

        @JsonProperty(value="height")
        public void setHeight(@Nullable Integer height) {
            this.height = height;
        }

        @JsonProperty(value="width")
        public void setWidth(@Nullable Integer width) {
            this.width = width;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageSize)) {
                return false;
            }
            ImageSize other = (ImageSize)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$height = this.getHeight();
            Integer other$height = other.getHeight();
            if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
                return false;
            }
            Integer this$width = this.getWidth();
            Integer other$width = other.getWidth();
            if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
                return false;
            }
            Crop this$crop = this.getCrop();
            Crop other$crop = other.getCrop();
            if (this$crop == null ? other$crop != null : !((Object)((Object)this$crop)).equals((Object)other$crop)) {
                return false;
            }
            Resize this$resize = this.getResize();
            Resize other$resize = other.getResize();
            return !(this$resize == null ? other$resize != null : !((Object)((Object)this$resize)).equals((Object)other$resize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageSize;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $height = this.getHeight();
            result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
            Integer $width = this.getWidth();
            result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
            Crop $crop = this.getCrop();
            result = result * 59 + ($crop == null ? 43 : ((Object)((Object)$crop)).hashCode());
            Resize $resize = this.getResize();
            result = result * 59 + ($resize == null ? 43 : ((Object)((Object)$resize)).hashCode());
            return result;
        }

        public String toString() {
            return "Message.ImageSize(crop=" + String.valueOf((Object)this.getCrop()) + ", resize=" + String.valueOf((Object)this.getResize()) + ", height=" + this.getHeight() + ", width=" + this.getWidth() + ")";
        }
    }

    public static class SearchResultMessage
    extends Message {
        @JsonProperty(value="channel")
        @NotNull
        private Channel channel;

        @NotNull
        public Channel getChannel() {
            return this.channel;
        }

        @JsonProperty(value="channel")
        public void setChannel(@NotNull Channel channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
        }

        @Override
        public String toString() {
            return "Message.SearchResultMessage(channel=" + String.valueOf(this.getChannel()) + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchResultMessage)) {
                return false;
            }
            SearchResultMessage other = (SearchResultMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Channel this$channel = this.getChannel();
            Channel other$channel = other.getChannel();
            return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof SearchResultMessage;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Channel $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
            return result;
        }
    }

    public static class SearchResult {
        @JsonProperty(value="message")
        @NotNull
        private SearchResultMessage message;

        @NotNull
        public SearchResultMessage getMessage() {
            return this.message;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull SearchResultMessage message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchResult)) {
                return false;
            }
            SearchResult other = (SearchResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SearchResultMessage this$message = this.getMessage();
            SearchResultMessage other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SearchResultMessage $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            return result;
        }

        public String toString() {
            return "Message.SearchResult(message=" + String.valueOf(this.getMessage()) + ")";
        }
    }

    public static class Field {
        @JsonProperty(value="type")
        @NotNull
        private String type;
        @JsonProperty(value="value")
        @NotNull
        private String value;
        @JsonProperty(value="short")
        @NotNull
        private Boolean shortField;

        @NotNull
        public String getType() {
            return this.type;
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        @NotNull
        public Boolean getShortField() {
            return this.shortField;
        }

        @JsonProperty(value="type")
        public void setType(@NotNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @JsonProperty(value="short")
        public void setShortField(@NotNull Boolean shortField) {
            if (shortField == null) {
                throw new NullPointerException("shortField is marked non-null but is null");
            }
            this.shortField = shortField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$shortField = this.getShortField();
            Boolean other$shortField = other.getShortField();
            if (this$shortField == null ? other$shortField != null : !((Object)this$shortField).equals(other$shortField)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Field;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $shortField = this.getShortField();
            result = result * 59 + ($shortField == null ? 43 : ((Object)$shortField).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Message.Field(type=" + this.getType() + ", value=" + this.getValue() + ", shortField=" + this.getShortField() + ")";
        }
    }

    public static class Action {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="text")
        @NotNull
        private String text;
        @JsonProperty(value="style")
        @NotNull
        private String style;
        @JsonProperty(value="type")
        @NotNull
        private String type;
        @JsonProperty(value="value")
        @NotNull
        private String value;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        @NotNull
        public String getStyle() {
            return this.style;
        }

        @NotNull
        public String getType() {
            return this.type;
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="text")
        public void setText(@NotNull String text) {
            if (text == null) {
                throw new NullPointerException("text is marked non-null but is null");
            }
            this.text = text;
        }

        @JsonProperty(value="style")
        public void setStyle(@NotNull String style) {
            if (style == null) {
                throw new NullPointerException("style is marked non-null but is null");
            }
            this.style = style;
        }

        @JsonProperty(value="type")
        public void setType(@NotNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @JsonProperty(value="value")
        public void setValue(@NotNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$style = this.getStyle();
            String other$style = other.getStyle();
            if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $style = this.getStyle();
            result = result * 59 + ($style == null ? 43 : $style.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Message.Action(name=" + this.getName() + ", text=" + this.getText() + ", style=" + this.getStyle() + ", type=" + this.getType() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Attachment {
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="fallback")
        @Nullable
        private String fallback;
        @JsonProperty(value="color")
        @Nullable
        private String color;
        @JsonProperty(value="pretext")
        @Nullable
        private String pretext;
        @JsonProperty(value="author_name")
        @Nullable
        private String authorName;
        @JsonProperty(value="author_link")
        @Nullable
        private String authorLink;
        @JsonProperty(value="author_icon")
        @Nullable
        private String authorIcon;
        @JsonProperty(value="title")
        @Nullable
        private String title;
        @JsonProperty(value="title_link")
        @Nullable
        private String titleLink;
        @JsonProperty(value="text")
        @Nullable
        private String text;
        @JsonProperty(value="image_url")
        @Nullable
        private String imageURL;
        @JsonProperty(value="thumb_url")
        @Nullable
        private String thumbURL;
        @JsonProperty(value="footer")
        @Nullable
        private String footer;
        @JsonProperty(value="footer_icon")
        @Nullable
        private String footerIcon;
        @JsonProperty(value="actions")
        @Nullable
        private List<Action> actions;
        @JsonProperty(value="fields")
        @Nullable
        private List<Field> fields;
        @JsonProperty(value="asset_url")
        @Nullable
        private String assetURL;
        @JsonProperty(value="og_scrape_url")
        @Nullable
        private String ogScrapeURL;
        @JsonIgnore
        @NotNull
        private Map<String, Object> additionalFields = new HashMap<String, Object>();

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getFallback() {
            return this.fallback;
        }

        @Nullable
        public String getColor() {
            return this.color;
        }

        @Nullable
        public String getPretext() {
            return this.pretext;
        }

        @Nullable
        public String getAuthorName() {
            return this.authorName;
        }

        @Nullable
        public String getAuthorLink() {
            return this.authorLink;
        }

        @Nullable
        public String getAuthorIcon() {
            return this.authorIcon;
        }

        @Nullable
        public String getTitle() {
            return this.title;
        }

        @Nullable
        public String getTitleLink() {
            return this.titleLink;
        }

        @Nullable
        public String getText() {
            return this.text;
        }

        @Nullable
        public String getImageURL() {
            return this.imageURL;
        }

        @Nullable
        public String getThumbURL() {
            return this.thumbURL;
        }

        @Nullable
        public String getFooter() {
            return this.footer;
        }

        @Nullable
        public String getFooterIcon() {
            return this.footerIcon;
        }

        @Nullable
        public List<Action> getActions() {
            return this.actions;
        }

        @Nullable
        public List<Field> getFields() {
            return this.fields;
        }

        @Nullable
        public String getAssetURL() {
            return this.assetURL;
        }

        @Nullable
        public String getOgScrapeURL() {
            return this.ogScrapeURL;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="fallback")
        public void setFallback(@Nullable String fallback) {
            this.fallback = fallback;
        }

        @JsonProperty(value="color")
        public void setColor(@Nullable String color) {
            this.color = color;
        }

        @JsonProperty(value="pretext")
        public void setPretext(@Nullable String pretext) {
            this.pretext = pretext;
        }

        @JsonProperty(value="author_name")
        public void setAuthorName(@Nullable String authorName) {
            this.authorName = authorName;
        }

        @JsonProperty(value="author_link")
        public void setAuthorLink(@Nullable String authorLink) {
            this.authorLink = authorLink;
        }

        @JsonProperty(value="author_icon")
        public void setAuthorIcon(@Nullable String authorIcon) {
            this.authorIcon = authorIcon;
        }

        @JsonProperty(value="title")
        public void setTitle(@Nullable String title) {
            this.title = title;
        }

        @JsonProperty(value="title_link")
        public void setTitleLink(@Nullable String titleLink) {
            this.titleLink = titleLink;
        }

        @JsonProperty(value="text")
        public void setText(@Nullable String text) {
            this.text = text;
        }

        @JsonProperty(value="image_url")
        public void setImageURL(@Nullable String imageURL) {
            this.imageURL = imageURL;
        }

        @JsonProperty(value="thumb_url")
        public void setThumbURL(@Nullable String thumbURL) {
            this.thumbURL = thumbURL;
        }

        @JsonProperty(value="footer")
        public void setFooter(@Nullable String footer) {
            this.footer = footer;
        }

        @JsonProperty(value="footer_icon")
        public void setFooterIcon(@Nullable String footerIcon) {
            this.footerIcon = footerIcon;
        }

        @JsonProperty(value="actions")
        public void setActions(@Nullable List<Action> actions) {
            this.actions = actions;
        }

        @JsonProperty(value="fields")
        public void setFields(@Nullable List<Field> fields) {
            this.fields = fields;
        }

        @JsonProperty(value="asset_url")
        public void setAssetURL(@Nullable String assetURL) {
            this.assetURL = assetURL;
        }

        @JsonProperty(value="og_scrape_url")
        public void setOgScrapeURL(@Nullable String ogScrapeURL) {
            this.ogScrapeURL = ogScrapeURL;
        }

        @JsonIgnore
        public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
            if (additionalFields == null) {
                throw new NullPointerException("additionalFields is marked non-null but is null");
            }
            this.additionalFields = additionalFields;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attachment)) {
                return false;
            }
            Attachment other = (Attachment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$fallback = this.getFallback();
            String other$fallback = other.getFallback();
            if (this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback)) {
                return false;
            }
            String this$color = this.getColor();
            String other$color = other.getColor();
            if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
                return false;
            }
            String this$pretext = this.getPretext();
            String other$pretext = other.getPretext();
            if (this$pretext == null ? other$pretext != null : !this$pretext.equals(other$pretext)) {
                return false;
            }
            String this$authorName = this.getAuthorName();
            String other$authorName = other.getAuthorName();
            if (this$authorName == null ? other$authorName != null : !this$authorName.equals(other$authorName)) {
                return false;
            }
            String this$authorLink = this.getAuthorLink();
            String other$authorLink = other.getAuthorLink();
            if (this$authorLink == null ? other$authorLink != null : !this$authorLink.equals(other$authorLink)) {
                return false;
            }
            String this$authorIcon = this.getAuthorIcon();
            String other$authorIcon = other.getAuthorIcon();
            if (this$authorIcon == null ? other$authorIcon != null : !this$authorIcon.equals(other$authorIcon)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$titleLink = this.getTitleLink();
            String other$titleLink = other.getTitleLink();
            if (this$titleLink == null ? other$titleLink != null : !this$titleLink.equals(other$titleLink)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            String this$imageURL = this.getImageURL();
            String other$imageURL = other.getImageURL();
            if (this$imageURL == null ? other$imageURL != null : !this$imageURL.equals(other$imageURL)) {
                return false;
            }
            String this$thumbURL = this.getThumbURL();
            String other$thumbURL = other.getThumbURL();
            if (this$thumbURL == null ? other$thumbURL != null : !this$thumbURL.equals(other$thumbURL)) {
                return false;
            }
            String this$footer = this.getFooter();
            String other$footer = other.getFooter();
            if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
                return false;
            }
            String this$footerIcon = this.getFooterIcon();
            String other$footerIcon = other.getFooterIcon();
            if (this$footerIcon == null ? other$footerIcon != null : !this$footerIcon.equals(other$footerIcon)) {
                return false;
            }
            List<Action> this$actions = this.getActions();
            List<Action> other$actions = other.getActions();
            if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
                return false;
            }
            List<Field> this$fields = this.getFields();
            List<Field> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$assetURL = this.getAssetURL();
            String other$assetURL = other.getAssetURL();
            if (this$assetURL == null ? other$assetURL != null : !this$assetURL.equals(other$assetURL)) {
                return false;
            }
            String this$ogScrapeURL = this.getOgScrapeURL();
            String other$ogScrapeURL = other.getOgScrapeURL();
            if (this$ogScrapeURL == null ? other$ogScrapeURL != null : !this$ogScrapeURL.equals(other$ogScrapeURL)) {
                return false;
            }
            Map<String, Object> this$additionalFields = this.getAdditionalFields();
            Map<String, Object> other$additionalFields = other.getAdditionalFields();
            return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attachment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $fallback = this.getFallback();
            result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
            String $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : $color.hashCode());
            String $pretext = this.getPretext();
            result = result * 59 + ($pretext == null ? 43 : $pretext.hashCode());
            String $authorName = this.getAuthorName();
            result = result * 59 + ($authorName == null ? 43 : $authorName.hashCode());
            String $authorLink = this.getAuthorLink();
            result = result * 59 + ($authorLink == null ? 43 : $authorLink.hashCode());
            String $authorIcon = this.getAuthorIcon();
            result = result * 59 + ($authorIcon == null ? 43 : $authorIcon.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $titleLink = this.getTitleLink();
            result = result * 59 + ($titleLink == null ? 43 : $titleLink.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            String $imageURL = this.getImageURL();
            result = result * 59 + ($imageURL == null ? 43 : $imageURL.hashCode());
            String $thumbURL = this.getThumbURL();
            result = result * 59 + ($thumbURL == null ? 43 : $thumbURL.hashCode());
            String $footer = this.getFooter();
            result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
            String $footerIcon = this.getFooterIcon();
            result = result * 59 + ($footerIcon == null ? 43 : $footerIcon.hashCode());
            List<Action> $actions = this.getActions();
            result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
            List<Field> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $assetURL = this.getAssetURL();
            result = result * 59 + ($assetURL == null ? 43 : $assetURL.hashCode());
            String $ogScrapeURL = this.getOgScrapeURL();
            result = result * 59 + ($ogScrapeURL == null ? 43 : $ogScrapeURL.hashCode());
            Map<String, Object> $additionalFields = this.getAdditionalFields();
            result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
            return result;
        }

        public String toString() {
            return "Message.Attachment(type=" + this.getType() + ", fallback=" + this.getFallback() + ", color=" + this.getColor() + ", pretext=" + this.getPretext() + ", authorName=" + this.getAuthorName() + ", authorLink=" + this.getAuthorLink() + ", authorIcon=" + this.getAuthorIcon() + ", title=" + this.getTitle() + ", titleLink=" + this.getTitleLink() + ", text=" + this.getText() + ", imageURL=" + this.getImageURL() + ", thumbURL=" + this.getThumbURL() + ", footer=" + this.getFooter() + ", footerIcon=" + this.getFooterIcon() + ", actions=" + String.valueOf(this.getActions()) + ", fields=" + String.valueOf(this.getFields()) + ", assetURL=" + this.getAssetURL() + ", ogScrapeURL=" + this.getOgScrapeURL() + ", additionalFields=" + String.valueOf(this.getAdditionalFields()) + ")";
        }
    }

    public static enum MessageType {
        REGULAR,
        EPHEMERAL,
        ERROR,
        REPLY,
        SYSTEM,
        DELETED,
        UNKNOWN;

    }
}

