/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.services.framework;

import io.getstream.chat.java.services.framework.UserToken;
import io.getstream.chat.java.services.framework.internal.TokenInjectionException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import okhttp3.Call;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;

class UserTokenCallRewriter<TService>
implements InvocationHandler {
    private static volatile Field rawCallField;
    private final Call.Factory callFactory;
    private final TService delegate;
    private final UserToken token;

    UserTokenCallRewriter(@NotNull Call.Factory callFactory, @NotNull TService delegate, @NotNull UserToken token) {
        this.callFactory = callFactory;
        this.delegate = delegate;
        this.token = token;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke(this.delegate, args);
        if (result instanceof retrofit2.Call) {
            return this.injectTokenIntoCall((retrofit2.Call)result);
        }
        throw new TokenInjectionException("Method " + method.getName() + " on " + this.delegate.getClass().getName() + " did not return retrofit2.Call<?>. User token injection requires all service methods to return Call<?>.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private retrofit2.Call<?> injectTokenIntoCall(retrofit2.Call<?> originalCall) throws TokenInjectionException {
        retrofit2.Call clonedCall = originalCall.clone();
        try {
            if (rawCallField == null) {
                Class<UserTokenCallRewriter> clazz = UserTokenCallRewriter.class;
                // MONITORENTER : io.getstream.chat.java.services.framework.UserTokenCallRewriter.class
                if (rawCallField == null) {
                    rawCallField = clonedCall.getClass().getDeclaredField("rawCall");
                    rawCallField.setAccessible(true);
                }
                // MONITOREXIT : clazz
            }
            Request newRequest = originalCall.request().newBuilder().tag(UserToken.class, (Object)this.token).build();
            Call newOkHttpCall = this.callFactory.newCall(newRequest);
            rawCallField.set(clonedCall, newOkHttpCall);
            return clonedCall;
        }
        catch (NoSuchFieldException e) {
            throw new TokenInjectionException("Retrofit internal structure changed. Field 'rawCall' not found in " + clonedCall.getClass().getName() + ". Update client implementation.", e);
        }
        catch (IllegalAccessException e) {
            throw new TokenInjectionException("Failed to inject token into call", e);
        }
    }
}

