/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.getstream.chat.java.models.ChannelType;
import io.getstream.chat.java.models.RateLimit;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponse;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.AppService;
import io.getstream.chat.java.services.framework.Client;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class App
extends StreamResponseObject {
    @JsonProperty(value="app")
    @Nullable
    private AppConfig app;

    @NotNull
    public static AppGetRequest get() {
        return new AppGetRequest();
    }

    @NotNull
    public static AppUpdateRequestData.AppUpdateRequest update() {
        return new AppUpdateRequestData.AppUpdateRequest();
    }

    @NotNull
    public static AppGetRateLimitsRequest getRateLimits() {
        return new AppGetRateLimitsRequest();
    }

    @NotNull
    public static AppCheckSqsRequestData.AppCheckSqsRequest checkSqs() {
        return new AppCheckSqsRequestData.AppCheckSqsRequest();
    }

    @NotNull
    public static AppCheckSnsRequestData.AppCheckSnsRequest checkSns() {
        return new AppCheckSnsRequestData.AppCheckSnsRequest();
    }

    @NotNull
    public static AppCheckPushRequestData.AppCheckPushRequest checkPush() {
        return new AppCheckPushRequestData.AppCheckPushRequest();
    }

    @NotNull
    public static AppRevokeTokensRequest revokeTokens(@Nullable Date revokeTokensIssuedBefore) {
        return new AppRevokeTokensRequest(revokeTokensIssuedBefore);
    }

    @NotNull
    public static PushProviderRequestData.PushProviderRequest upsertPushProvider() {
        return new PushProviderRequestData.PushProviderRequest();
    }

    @NotNull
    public static ListPushProvidersRequest listPushProviders() {
        return new ListPushProvidersRequest();
    }

    @NotNull
    public static DeletePushProviderRequest deletePushProvider(@NotNull String providerType, @NotNull String name) {
        return new DeletePushProviderRequest(providerType, name);
    }

    public boolean verifyWebhook(@NotNull String body, @NotNull String signature) {
        return App.verifyWebhookSignature(body, signature);
    }

    public static boolean verifyWebhookSignature(@NotNull String apiSecret, @NotNull String body, @NotNull String signature) {
        try {
            SecretKeySpec sk = new SecretKeySpec(apiSecret.getBytes(), "HmacSHA256");
            Mac mac = Mac.getInstance(sk.getAlgorithm());
            mac.init(sk);
            byte[] hmac = mac.doFinal(body.getBytes(StandardCharsets.UTF_8));
            return App.bytesToHex(hmac).equals(signature);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Should not happen. Could not find HmacSHA256", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("error building signature, invalid key", e);
        }
    }

    public static boolean verifyWebhookSignature(@NotNull String body, @NotNull String signature) {
        String apiSecret = Client.getInstance().getApiSecret();
        return App.verifyWebhookSignature(apiSecret, body, signature);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Nullable
    public AppConfig getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    public void setApp(@Nullable AppConfig app) {
        this.app = app;
    }

    @Override
    public String toString() {
        return "App(app=" + this.getApp() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof App)) {
            return false;
        }
        App other = (App)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AppConfig this$app = this.getApp();
        AppConfig other$app = other.getApp();
        return !(this$app == null ? other$app != null : !((Object)this$app).equals(other$app));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof App;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AppConfig $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : ((Object)$app).hashCode());
        return result;
    }

    public static class AppGetRequest
    extends StreamRequest<App> {
        @Override
        protected Call<App> generateCall(Client client) {
            return client.create(AppService.class).get();
        }
    }

    public static class AppUpdateRequestData {
        @JsonProperty(value="disable_auth_checks")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean disableAuthChecks;
        @JsonProperty(value="disable_permissions_checks")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean disablePermissionsChecks;
        @JsonProperty(value="apn_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private APNConfigRequestObject aPNConfig;
        @JsonProperty(value="firebase_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private FirebaseConfigRequestObject firebaseConfig;
        @JsonProperty(value="huawei_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private HuaweiConfigRequestObject huaweiConfig;
        @JsonProperty(value="push_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private PushConfigRequestObject pushConfig;
        @JsonProperty(value="user_search_disallowed_roles")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private List<String> userSearchDisallowedRoles;
        @JsonProperty(value="custom_action_handler_url")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String customActionHandlerUrl;
        @JsonProperty(value="reminders_interval")
        @NotNull
        private int remindersInterval;
        @JsonProperty(value="enforce_unique_usernames")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String enforceUniqueUsernames;
        @JsonProperty(value="permission_version")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private PermissionVersion permissionVersion;
        @JsonProperty(value="file_upload_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private FileUploadConfigRequestObject fileUploadConfig;
        @JsonProperty(value="image_upload_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private FileUploadConfigRequestObject imageUploadConfig;
        @JsonProperty(value="before_message_send_hook_url")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String beforeMessageSendHookUrl;
        @JsonProperty(value="auto_translation_enabled")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean autoTranslationEnabled;
        @JsonProperty(value="image_moderation_enabled")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean imageModerationEnabled;
        @JsonProperty(value="image_moderation_labels")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private List<String> imageModerationLabels;
        @JsonProperty(value="async_url_enrich_enabled")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean asyncURLEnrichEnabled;
        @JsonProperty(value="async_moderation_config")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private AsyncModerationConfigRequestObject asyncModerationConfig;
        @JsonProperty(value="sqs_url")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String sqsUrl;
        @JsonProperty(value="sqs_key")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String sqsKey;
        @JsonProperty(value="sqs_secret")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String sqsSecret;
        @JsonProperty(value="sns_topic_arn")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String snsTopicArn;
        @JsonProperty(value="sns_key")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String snsKey;
        @JsonProperty(value="sns_secret")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String snsSecret;
        @JsonProperty(value="webhook_url")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private String webhookURL;
        @JsonProperty(value="webhook_events")
        @Nullable
        private List<String> webhookEvents;
        @JsonProperty(value="multi_tenant_enabled")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean multiTenantEnabled;
        @JsonProperty(value="revoke_tokens_issued_before")
        @Nullable
        private Date revokeTokensIssuedBefore;
        @JsonProperty(value="channel_hide_members_only")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean channelHideMembersOnly;
        @JsonProperty(value="migrate_permissions_to_v2")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Nullable
        private Boolean migratePermissionsToV2;
        @JsonProperty(value="grants")
        @Nullable
        private Map<String, List<String>> grants;

        AppUpdateRequestData(@Nullable Boolean disableAuthChecks, @Nullable Boolean disablePermissionsChecks, @Nullable APNConfigRequestObject aPNConfig, @Nullable FirebaseConfigRequestObject firebaseConfig, @Nullable HuaweiConfigRequestObject huaweiConfig, @Nullable PushConfigRequestObject pushConfig, @Nullable List<String> userSearchDisallowedRoles, @Nullable String customActionHandlerUrl, @NotNull int remindersInterval, @Nullable String enforceUniqueUsernames, @Nullable PermissionVersion permissionVersion, @Nullable FileUploadConfigRequestObject fileUploadConfig, @Nullable FileUploadConfigRequestObject imageUploadConfig, @Nullable String beforeMessageSendHookUrl, @Nullable Boolean autoTranslationEnabled, @Nullable Boolean imageModerationEnabled, @Nullable List<String> imageModerationLabels, @Nullable Boolean asyncURLEnrichEnabled, @Nullable AsyncModerationConfigRequestObject asyncModerationConfig, @Nullable String sqsUrl, @Nullable String sqsKey, @Nullable String sqsSecret, @Nullable String snsTopicArn, @Nullable String snsKey, @Nullable String snsSecret, @Nullable String webhookURL, @Nullable List<String> webhookEvents, @Nullable Boolean multiTenantEnabled, @Nullable Date revokeTokensIssuedBefore, @Nullable Boolean channelHideMembersOnly, @Nullable Boolean migratePermissionsToV2, @Nullable Map<String, List<String>> grants) {
            this.disableAuthChecks = disableAuthChecks;
            this.disablePermissionsChecks = disablePermissionsChecks;
            this.aPNConfig = aPNConfig;
            this.firebaseConfig = firebaseConfig;
            this.huaweiConfig = huaweiConfig;
            this.pushConfig = pushConfig;
            this.userSearchDisallowedRoles = userSearchDisallowedRoles;
            this.customActionHandlerUrl = customActionHandlerUrl;
            this.remindersInterval = remindersInterval;
            this.enforceUniqueUsernames = enforceUniqueUsernames;
            this.permissionVersion = permissionVersion;
            this.fileUploadConfig = fileUploadConfig;
            this.imageUploadConfig = imageUploadConfig;
            this.beforeMessageSendHookUrl = beforeMessageSendHookUrl;
            this.autoTranslationEnabled = autoTranslationEnabled;
            this.imageModerationEnabled = imageModerationEnabled;
            this.imageModerationLabels = imageModerationLabels;
            this.asyncURLEnrichEnabled = asyncURLEnrichEnabled;
            this.asyncModerationConfig = asyncModerationConfig;
            this.sqsUrl = sqsUrl;
            this.sqsKey = sqsKey;
            this.sqsSecret = sqsSecret;
            this.snsTopicArn = snsTopicArn;
            this.snsKey = snsKey;
            this.snsSecret = snsSecret;
            this.webhookURL = webhookURL;
            this.webhookEvents = webhookEvents;
            this.multiTenantEnabled = multiTenantEnabled;
            this.revokeTokensIssuedBefore = revokeTokensIssuedBefore;
            this.channelHideMembersOnly = channelHideMembersOnly;
            this.migratePermissionsToV2 = migratePermissionsToV2;
            this.grants = grants;
        }

        public static class AppUpdateRequest
        extends StreamRequest<StreamResponseObject> {
            private Boolean disableAuthChecks;
            private Boolean disablePermissionsChecks;
            private APNConfigRequestObject aPNConfig;
            private FirebaseConfigRequestObject firebaseConfig;
            private HuaweiConfigRequestObject huaweiConfig;
            private PushConfigRequestObject pushConfig;
            private List<String> userSearchDisallowedRoles;
            private String customActionHandlerUrl;
            private int remindersInterval;
            private String enforceUniqueUsernames;
            private PermissionVersion permissionVersion;
            private FileUploadConfigRequestObject fileUploadConfig;
            private FileUploadConfigRequestObject imageUploadConfig;
            private String beforeMessageSendHookUrl;
            private Boolean autoTranslationEnabled;
            private Boolean imageModerationEnabled;
            private List<String> imageModerationLabels;
            private Boolean asyncURLEnrichEnabled;
            private AsyncModerationConfigRequestObject asyncModerationConfig;
            private String sqsUrl;
            private String sqsKey;
            private String sqsSecret;
            private String snsTopicArn;
            private String snsKey;
            private String snsSecret;
            private String webhookURL;
            private List<String> webhookEvents;
            private Boolean multiTenantEnabled;
            private Date revokeTokensIssuedBefore;
            private Boolean channelHideMembersOnly;
            private Boolean migratePermissionsToV2;
            private Map<String, List<String>> grants;

            @Override
            protected Call<StreamResponseObject> generateCall(Client client) {
                return client.create(AppService.class).update(this.internalBuild());
            }

            AppUpdateRequest() {
            }

            @JsonProperty(value="disable_auth_checks")
            public AppUpdateRequest disableAuthChecks(@Nullable Boolean disableAuthChecks) {
                this.disableAuthChecks = disableAuthChecks;
                return this;
            }

            @JsonProperty(value="disable_permissions_checks")
            public AppUpdateRequest disablePermissionsChecks(@Nullable Boolean disablePermissionsChecks) {
                this.disablePermissionsChecks = disablePermissionsChecks;
                return this;
            }

            @JsonProperty(value="apn_config")
            public AppUpdateRequest aPNConfig(@Nullable APNConfigRequestObject aPNConfig) {
                this.aPNConfig = aPNConfig;
                return this;
            }

            @JsonProperty(value="firebase_config")
            public AppUpdateRequest firebaseConfig(@Nullable FirebaseConfigRequestObject firebaseConfig) {
                this.firebaseConfig = firebaseConfig;
                return this;
            }

            @JsonProperty(value="huawei_config")
            public AppUpdateRequest huaweiConfig(@Nullable HuaweiConfigRequestObject huaweiConfig) {
                this.huaweiConfig = huaweiConfig;
                return this;
            }

            @JsonProperty(value="push_config")
            public AppUpdateRequest pushConfig(@Nullable PushConfigRequestObject pushConfig) {
                this.pushConfig = pushConfig;
                return this;
            }

            @JsonProperty(value="user_search_disallowed_roles")
            public AppUpdateRequest userSearchDisallowedRoles(@Nullable List<String> userSearchDisallowedRoles) {
                this.userSearchDisallowedRoles = userSearchDisallowedRoles;
                return this;
            }

            @JsonProperty(value="custom_action_handler_url")
            public AppUpdateRequest customActionHandlerUrl(@Nullable String customActionHandlerUrl) {
                this.customActionHandlerUrl = customActionHandlerUrl;
                return this;
            }

            @JsonProperty(value="reminders_interval")
            public AppUpdateRequest remindersInterval(@NotNull int remindersInterval) {
                this.remindersInterval = remindersInterval;
                return this;
            }

            @JsonProperty(value="enforce_unique_usernames")
            public AppUpdateRequest enforceUniqueUsernames(@Nullable String enforceUniqueUsernames) {
                this.enforceUniqueUsernames = enforceUniqueUsernames;
                return this;
            }

            @JsonProperty(value="permission_version")
            public AppUpdateRequest permissionVersion(@Nullable PermissionVersion permissionVersion) {
                this.permissionVersion = permissionVersion;
                return this;
            }

            @JsonProperty(value="file_upload_config")
            public AppUpdateRequest fileUploadConfig(@Nullable FileUploadConfigRequestObject fileUploadConfig) {
                this.fileUploadConfig = fileUploadConfig;
                return this;
            }

            @JsonProperty(value="image_upload_config")
            public AppUpdateRequest imageUploadConfig(@Nullable FileUploadConfigRequestObject imageUploadConfig) {
                this.imageUploadConfig = imageUploadConfig;
                return this;
            }

            @JsonProperty(value="before_message_send_hook_url")
            public AppUpdateRequest beforeMessageSendHookUrl(@Nullable String beforeMessageSendHookUrl) {
                this.beforeMessageSendHookUrl = beforeMessageSendHookUrl;
                return this;
            }

            @JsonProperty(value="auto_translation_enabled")
            public AppUpdateRequest autoTranslationEnabled(@Nullable Boolean autoTranslationEnabled) {
                this.autoTranslationEnabled = autoTranslationEnabled;
                return this;
            }

            @JsonProperty(value="image_moderation_enabled")
            public AppUpdateRequest imageModerationEnabled(@Nullable Boolean imageModerationEnabled) {
                this.imageModerationEnabled = imageModerationEnabled;
                return this;
            }

            @JsonProperty(value="image_moderation_labels")
            public AppUpdateRequest imageModerationLabels(@Nullable List<String> imageModerationLabels) {
                this.imageModerationLabels = imageModerationLabels;
                return this;
            }

            @JsonProperty(value="async_url_enrich_enabled")
            public AppUpdateRequest asyncURLEnrichEnabled(@Nullable Boolean asyncURLEnrichEnabled) {
                this.asyncURLEnrichEnabled = asyncURLEnrichEnabled;
                return this;
            }

            @JsonProperty(value="async_moderation_config")
            public AppUpdateRequest asyncModerationConfig(@Nullable AsyncModerationConfigRequestObject asyncModerationConfig) {
                this.asyncModerationConfig = asyncModerationConfig;
                return this;
            }

            @JsonProperty(value="sqs_url")
            public AppUpdateRequest sqsUrl(@Nullable String sqsUrl) {
                this.sqsUrl = sqsUrl;
                return this;
            }

            @JsonProperty(value="sqs_key")
            public AppUpdateRequest sqsKey(@Nullable String sqsKey) {
                this.sqsKey = sqsKey;
                return this;
            }

            @JsonProperty(value="sqs_secret")
            public AppUpdateRequest sqsSecret(@Nullable String sqsSecret) {
                this.sqsSecret = sqsSecret;
                return this;
            }

            @JsonProperty(value="sns_topic_arn")
            public AppUpdateRequest snsTopicArn(@Nullable String snsTopicArn) {
                this.snsTopicArn = snsTopicArn;
                return this;
            }

            @JsonProperty(value="sns_key")
            public AppUpdateRequest snsKey(@Nullable String snsKey) {
                this.snsKey = snsKey;
                return this;
            }

            @JsonProperty(value="sns_secret")
            public AppUpdateRequest snsSecret(@Nullable String snsSecret) {
                this.snsSecret = snsSecret;
                return this;
            }

            @JsonProperty(value="webhook_url")
            public AppUpdateRequest webhookURL(@Nullable String webhookURL) {
                this.webhookURL = webhookURL;
                return this;
            }

            @JsonProperty(value="webhook_events")
            public AppUpdateRequest webhookEvents(@Nullable List<String> webhookEvents) {
                this.webhookEvents = webhookEvents;
                return this;
            }

            @JsonProperty(value="multi_tenant_enabled")
            public AppUpdateRequest multiTenantEnabled(@Nullable Boolean multiTenantEnabled) {
                this.multiTenantEnabled = multiTenantEnabled;
                return this;
            }

            @JsonProperty(value="revoke_tokens_issued_before")
            public AppUpdateRequest revokeTokensIssuedBefore(@Nullable Date revokeTokensIssuedBefore) {
                this.revokeTokensIssuedBefore = revokeTokensIssuedBefore;
                return this;
            }

            @JsonProperty(value="channel_hide_members_only")
            public AppUpdateRequest channelHideMembersOnly(@Nullable Boolean channelHideMembersOnly) {
                this.channelHideMembersOnly = channelHideMembersOnly;
                return this;
            }

            @JsonProperty(value="migrate_permissions_to_v2")
            public AppUpdateRequest migratePermissionsToV2(@Nullable Boolean migratePermissionsToV2) {
                this.migratePermissionsToV2 = migratePermissionsToV2;
                return this;
            }

            @JsonProperty(value="grants")
            public AppUpdateRequest grants(@Nullable Map<String, List<String>> grants) {
                this.grants = grants;
                return this;
            }

            public AppUpdateRequestData internalBuild() {
                return new AppUpdateRequestData(this.disableAuthChecks, this.disablePermissionsChecks, this.aPNConfig, this.firebaseConfig, this.huaweiConfig, this.pushConfig, this.userSearchDisallowedRoles, this.customActionHandlerUrl, this.remindersInterval, this.enforceUniqueUsernames, this.permissionVersion, this.fileUploadConfig, this.imageUploadConfig, this.beforeMessageSendHookUrl, this.autoTranslationEnabled, this.imageModerationEnabled, this.imageModerationLabels, this.asyncURLEnrichEnabled, this.asyncModerationConfig, this.sqsUrl, this.sqsKey, this.sqsSecret, this.snsTopicArn, this.snsKey, this.snsSecret, this.webhookURL, this.webhookEvents, this.multiTenantEnabled, this.revokeTokensIssuedBefore, this.channelHideMembersOnly, this.migratePermissionsToV2, this.grants);
            }

            public String toString() {
                return "App.AppUpdateRequestData.AppUpdateRequest(disableAuthChecks=" + this.disableAuthChecks + ", disablePermissionsChecks=" + this.disablePermissionsChecks + ", aPNConfig=" + this.aPNConfig + ", firebaseConfig=" + this.firebaseConfig + ", huaweiConfig=" + this.huaweiConfig + ", pushConfig=" + this.pushConfig + ", userSearchDisallowedRoles=" + this.userSearchDisallowedRoles + ", customActionHandlerUrl=" + this.customActionHandlerUrl + ", remindersInterval=" + this.remindersInterval + ", enforceUniqueUsernames=" + this.enforceUniqueUsernames + ", permissionVersion=" + this.permissionVersion + ", fileUploadConfig=" + this.fileUploadConfig + ", imageUploadConfig=" + this.imageUploadConfig + ", beforeMessageSendHookUrl=" + this.beforeMessageSendHookUrl + ", autoTranslationEnabled=" + this.autoTranslationEnabled + ", imageModerationEnabled=" + this.imageModerationEnabled + ", imageModerationLabels=" + this.imageModerationLabels + ", asyncURLEnrichEnabled=" + this.asyncURLEnrichEnabled + ", asyncModerationConfig=" + this.asyncModerationConfig + ", sqsUrl=" + this.sqsUrl + ", sqsKey=" + this.sqsKey + ", sqsSecret=" + this.sqsSecret + ", snsTopicArn=" + this.snsTopicArn + ", snsKey=" + this.snsKey + ", snsSecret=" + this.snsSecret + ", webhookURL=" + this.webhookURL + ", webhookEvents=" + this.webhookEvents + ", multiTenantEnabled=" + this.multiTenantEnabled + ", revokeTokensIssuedBefore=" + this.revokeTokensIssuedBefore + ", channelHideMembersOnly=" + this.channelHideMembersOnly + ", migratePermissionsToV2=" + this.migratePermissionsToV2 + ", grants=" + this.grants + ")";
            }
        }
    }

    public static class AppGetRateLimitsRequest
    extends StreamRequest<AppGetRateLimitsResponse> {
        @Nullable
        private Boolean serverSide;
        @Nullable
        private Boolean android;
        @Nullable
        private Boolean ios;
        @Nullable
        private Boolean web;
        @Nullable
        private List<String> endpoints = new ArrayList<String>();

        @NotNull
        public AppGetRateLimitsRequest serverSide(@NotNull Boolean serverSide) {
            this.serverSide = serverSide;
            return this;
        }

        @NotNull
        public AppGetRateLimitsRequest android(@NotNull Boolean android) {
            this.android = android;
            return this;
        }

        @NotNull
        public AppGetRateLimitsRequest ios(@NotNull Boolean ios) {
            this.ios = ios;
            return this;
        }

        @NotNull
        public AppGetRateLimitsRequest web(@NotNull Boolean web) {
            this.web = web;
            return this;
        }

        @NotNull
        public AppGetRateLimitsRequest endpoints(@NotNull List<String> endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        @NotNull
        public AppGetRateLimitsRequest endpoint(@NotNull String endpoint) {
            this.endpoints.add(endpoint);
            return this;
        }

        @Override
        protected Call<AppGetRateLimitsResponse> generateCall(Client client) {
            return client.create(AppService.class).getRateLimits(this.serverSide, this.android, this.ios, this.web, this.endpoints == null ? null : String.join((CharSequence)",", this.endpoints));
        }
    }

    public static class AppCheckSqsRequestData {
        @JsonProperty(value="sqs_url")
        @Nullable
        private String sqsUrl;
        @JsonProperty(value="sqs_key")
        @Nullable
        private String sqsKey;
        @JsonProperty(value="sqs_secret")
        @Nullable
        private String sqsSecret;

        AppCheckSqsRequestData(@Nullable String sqsUrl, @Nullable String sqsKey, @Nullable String sqsSecret) {
            this.sqsUrl = sqsUrl;
            this.sqsKey = sqsKey;
            this.sqsSecret = sqsSecret;
        }

        public static class AppCheckSqsRequest
        extends StreamRequest<AppCheckSqsResponse> {
            private String sqsUrl;
            private String sqsKey;
            private String sqsSecret;

            @Override
            protected Call<AppCheckSqsResponse> generateCall(Client client) {
                return client.create(AppService.class).checkSqs(this.internalBuild());
            }

            AppCheckSqsRequest() {
            }

            @JsonProperty(value="sqs_url")
            public AppCheckSqsRequest sqsUrl(@Nullable String sqsUrl) {
                this.sqsUrl = sqsUrl;
                return this;
            }

            @JsonProperty(value="sqs_key")
            public AppCheckSqsRequest sqsKey(@Nullable String sqsKey) {
                this.sqsKey = sqsKey;
                return this;
            }

            @JsonProperty(value="sqs_secret")
            public AppCheckSqsRequest sqsSecret(@Nullable String sqsSecret) {
                this.sqsSecret = sqsSecret;
                return this;
            }

            public AppCheckSqsRequestData internalBuild() {
                return new AppCheckSqsRequestData(this.sqsUrl, this.sqsKey, this.sqsSecret);
            }

            public String toString() {
                return "App.AppCheckSqsRequestData.AppCheckSqsRequest(sqsUrl=" + this.sqsUrl + ", sqsKey=" + this.sqsKey + ", sqsSecret=" + this.sqsSecret + ")";
            }
        }
    }

    public static class AppCheckSnsRequestData {
        @JsonProperty(value="sns_topic_arn")
        @Nullable
        private String snsTopicArn;
        @JsonProperty(value="sns_key")
        @Nullable
        private String snsKey;
        @JsonProperty(value="sns_secret")
        @Nullable
        private String snsSecret;

        AppCheckSnsRequestData(@Nullable String snsTopicArn, @Nullable String snsKey, @Nullable String snsSecret) {
            this.snsTopicArn = snsTopicArn;
            this.snsKey = snsKey;
            this.snsSecret = snsSecret;
        }

        public static class AppCheckSnsRequest
        extends StreamRequest<AppCheckSnsResponse> {
            private String snsTopicArn;
            private String snsKey;
            private String snsSecret;

            @Override
            protected Call<AppCheckSnsResponse> generateCall(Client client) {
                return client.create(AppService.class).checkSns(this.internalBuild());
            }

            AppCheckSnsRequest() {
            }

            @JsonProperty(value="sns_topic_arn")
            public AppCheckSnsRequest snsTopicArn(@Nullable String snsTopicArn) {
                this.snsTopicArn = snsTopicArn;
                return this;
            }

            @JsonProperty(value="sns_key")
            public AppCheckSnsRequest snsKey(@Nullable String snsKey) {
                this.snsKey = snsKey;
                return this;
            }

            @JsonProperty(value="sns_secret")
            public AppCheckSnsRequest snsSecret(@Nullable String snsSecret) {
                this.snsSecret = snsSecret;
                return this;
            }

            public AppCheckSnsRequestData internalBuild() {
                return new AppCheckSnsRequestData(this.snsTopicArn, this.snsKey, this.snsSecret);
            }

            public String toString() {
                return "App.AppCheckSnsRequestData.AppCheckSnsRequest(snsTopicArn=" + this.snsTopicArn + ", snsKey=" + this.snsKey + ", snsSecret=" + this.snsSecret + ")";
            }
        }
    }

    public static class AppCheckPushRequestData {
        @JsonProperty(value="message_id")
        @Nullable
        private String messageId;
        @JsonProperty(value="apn_template")
        @Nullable
        private String apnTemplate;
        @JsonProperty(value="firebase_template")
        @Nullable
        private String firebaseTemplate;
        @JsonProperty(value="firebase_data_template")
        @Nullable
        private String firebaseDataTemplate;
        @JsonProperty(value="skip_devices")
        @Nullable
        private Boolean skipDevices;
        @JsonProperty(value="push_provider_name")
        @Nullable
        private String pushProviderName;
        @JsonProperty(value="push_provider_type")
        @Nullable
        private PushProviderType pushProviderType;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;

        AppCheckPushRequestData(@Nullable String messageId, @Nullable String apnTemplate, @Nullable String firebaseTemplate, @Nullable String firebaseDataTemplate, @Nullable Boolean skipDevices, @Nullable String pushProviderName, @Nullable PushProviderType pushProviderType, @Nullable String userId, @Nullable User.UserRequestObject user) {
            this.messageId = messageId;
            this.apnTemplate = apnTemplate;
            this.firebaseTemplate = firebaseTemplate;
            this.firebaseDataTemplate = firebaseDataTemplate;
            this.skipDevices = skipDevices;
            this.pushProviderName = pushProviderName;
            this.pushProviderType = pushProviderType;
            this.userId = userId;
            this.user = user;
        }

        public static class AppCheckPushRequest
        extends StreamRequest<AppCheckPushResponse> {
            private String messageId;
            private String apnTemplate;
            private String firebaseTemplate;
            private String firebaseDataTemplate;
            private Boolean skipDevices;
            private String pushProviderName;
            private PushProviderType pushProviderType;
            private String userId;
            private User.UserRequestObject user;

            @Override
            protected Call<AppCheckPushResponse> generateCall(Client client) {
                return client.create(AppService.class).checkPush(this.internalBuild());
            }

            AppCheckPushRequest() {
            }

            @JsonProperty(value="message_id")
            public AppCheckPushRequest messageId(@Nullable String messageId) {
                this.messageId = messageId;
                return this;
            }

            @JsonProperty(value="apn_template")
            public AppCheckPushRequest apnTemplate(@Nullable String apnTemplate) {
                this.apnTemplate = apnTemplate;
                return this;
            }

            @JsonProperty(value="firebase_template")
            public AppCheckPushRequest firebaseTemplate(@Nullable String firebaseTemplate) {
                this.firebaseTemplate = firebaseTemplate;
                return this;
            }

            @JsonProperty(value="firebase_data_template")
            public AppCheckPushRequest firebaseDataTemplate(@Nullable String firebaseDataTemplate) {
                this.firebaseDataTemplate = firebaseDataTemplate;
                return this;
            }

            @JsonProperty(value="skip_devices")
            public AppCheckPushRequest skipDevices(@Nullable Boolean skipDevices) {
                this.skipDevices = skipDevices;
                return this;
            }

            @JsonProperty(value="push_provider_name")
            public AppCheckPushRequest pushProviderName(@Nullable String pushProviderName) {
                this.pushProviderName = pushProviderName;
                return this;
            }

            @JsonProperty(value="push_provider_type")
            public AppCheckPushRequest pushProviderType(@Nullable PushProviderType pushProviderType) {
                this.pushProviderType = pushProviderType;
                return this;
            }

            @JsonProperty(value="user_id")
            public AppCheckPushRequest userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public AppCheckPushRequest user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            public AppCheckPushRequestData internalBuild() {
                return new AppCheckPushRequestData(this.messageId, this.apnTemplate, this.firebaseTemplate, this.firebaseDataTemplate, this.skipDevices, this.pushProviderName, this.pushProviderType, this.userId, this.user);
            }

            public String toString() {
                return "App.AppCheckPushRequestData.AppCheckPushRequest(messageId=" + this.messageId + ", apnTemplate=" + this.apnTemplate + ", firebaseTemplate=" + this.firebaseTemplate + ", firebaseDataTemplate=" + this.firebaseDataTemplate + ", skipDevices=" + this.skipDevices + ", pushProviderName=" + this.pushProviderName + ", pushProviderType=" + this.pushProviderType + ", userId=" + this.userId + ", user=" + this.user + ")";
            }
        }
    }

    public static class AppRevokeTokensRequest
    extends StreamRequest<StreamResponseObject> {
        @Nullable
        private Date revokeTokensIssuedBefore;

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return new AppUpdateRequestData.AppUpdateRequest().revokeTokensIssuedBefore(this.revokeTokensIssuedBefore).generateCall(client);
        }

        public AppRevokeTokensRequest(@Nullable Date revokeTokensIssuedBefore) {
            this.revokeTokensIssuedBefore = revokeTokensIssuedBefore;
        }
    }

    public static class PushProviderRequestData {
        @JsonProperty(value="push_provider")
        private PushProvider pushProvider;

        PushProviderRequestData(PushProvider pushProvider) {
            this.pushProvider = pushProvider;
        }

        public static class PushProviderRequest
        extends StreamRequest<UpsertPushProviderResponse> {
            private PushProvider pushProvider;

            @Override
            protected Call<UpsertPushProviderResponse> generateCall(Client client) {
                return client.create(AppService.class).upsertPushProvider(this.internalBuild());
            }

            PushProviderRequest() {
            }

            @JsonProperty(value="push_provider")
            public PushProviderRequest pushProvider(PushProvider pushProvider) {
                this.pushProvider = pushProvider;
                return this;
            }

            public PushProviderRequestData internalBuild() {
                return new PushProviderRequestData(this.pushProvider);
            }

            public String toString() {
                return "App.PushProviderRequestData.PushProviderRequest(pushProvider=" + this.pushProvider + ")";
            }
        }
    }

    public static class ListPushProvidersRequest
    extends StreamRequest<ListPushProviderResponse> {
        @Override
        protected Call<ListPushProviderResponse> generateCall(Client client) {
            return client.create(AppService.class).listPushProviders();
        }
    }

    public static class DeletePushProviderRequest
    extends StreamRequest<StreamResponseObject> {
        private String providerType;
        private String name;

        public DeletePushProviderRequest(@NotNull String providerType, @NotNull String name) {
            this.providerType = providerType;
            this.name = name;
        }

        @Override
        protected Call<StreamResponseObject> generateCall(Client client) {
            return client.create(AppService.class).deletePushProvider(this.providerType, this.name);
        }
    }

    public static class AppConfig {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="organization")
        @NotNull
        private String organizationName;
        @JsonProperty(value="webhook_url")
        @NotNull
        private String webhookURL;
        @JsonProperty(value="suspended_explanation")
        @NotNull
        private String suspendedExplanation;
        @JsonProperty(value="push_notifications")
        @NotNull
        private PushNotificationFields pushNotifications;
        @JsonProperty(value="channel_configs")
        @NotNull
        private Map<String, ChannelType.ChannelTypeWithStringCommands> channelConfigs;
        @JsonProperty(value="policies")
        @NotNull
        private Map<String, Policy[]> policies;
        @JsonProperty(value="suspended")
        @NotNull
        private Boolean suspended;
        @JsonProperty(value="disable_auth_checks")
        @NotNull
        private Boolean disableAuth;
        @JsonProperty(value="disable_permissions_checks")
        @NotNull
        private Boolean disablePermissions;
        @JsonProperty(value="multi_tenant_enabled")
        @NotNull
        private Boolean multiTenantEnabled;
        @JsonProperty(value="permission_version")
        @NotNull
        private String permissionVersion;
        @JsonProperty(value="user_search_disallowed_roles")
        @Nullable
        private List<String> userSearchDisallowedRoles;
        @JsonProperty(value="image_moderation_enabled")
        @NotNull
        private Boolean imageModerationEnabled;
        @JsonProperty(value="image_moderation_labels")
        @Nullable
        private List<String> imageModerationLabels;
        @JsonProperty(value="custom_action_handler_url")
        @Nullable
        private String customActionHandlerUrl;
        @JsonProperty(value="async_url_enrich_enabled")
        @NotNull
        private Boolean asyncURLEnrichEnabled;
        @JsonProperty(value="reminders_interval")
        @NotNull
        private int remindersInterval;
        @JsonProperty(value="enforce_unique_usernames")
        @JsonDeserialize(using=EnforceUniqueUsernamesDeserializer.class)
        @Nullable
        private EnforceUniqueUsernames enforceUniqueUsernames;
        @JsonProperty(value="sqs_url")
        @Nullable
        private String sqsUrl;
        @JsonProperty(value="sqs_key")
        @Nullable
        private String sqsKey;
        @JsonProperty(value="sqs_secret")
        @Nullable
        private String sqsSecret;
        @JsonProperty(value="sns_topic_arn")
        @Nullable
        private String snsTopicArn;
        @JsonProperty(value="sns_key")
        @Nullable
        private String snsKey;
        @JsonProperty(value="sns_secret")
        @Nullable
        private String snsSecret;
        @JsonProperty(value="file_upload_config")
        @Nullable
        private FileUploadConfig fileUploadConfig;
        @JsonProperty(value="image_upload_config")
        @Nullable
        private FileUploadConfig imageUploadConfig;
        @JsonProperty(value="before_message_send_hook_url")
        @Nullable
        private String beforeMessageSendHookUrl;
        @JsonProperty(value="auto_translation_enabled")
        @Nullable
        private Boolean autoTranslationEnabled;
        @JsonProperty(value="revoke_tokens_issued_before")
        @Nullable
        private Date revokeTokensIssuedBefore;
        @JsonProperty(value="grants")
        @Nullable
        private Map<String, List<String>> grants;
        @JsonProperty(value="webhook_events")
        @Nullable
        private List<String> webhookEvents;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getOrganizationName() {
            return this.organizationName;
        }

        @NotNull
        public String getWebhookURL() {
            return this.webhookURL;
        }

        @NotNull
        public String getSuspendedExplanation() {
            return this.suspendedExplanation;
        }

        @NotNull
        public PushNotificationFields getPushNotifications() {
            return this.pushNotifications;
        }

        @NotNull
        public Map<String, ChannelType.ChannelTypeWithStringCommands> getChannelConfigs() {
            return this.channelConfigs;
        }

        @NotNull
        public Map<String, Policy[]> getPolicies() {
            return this.policies;
        }

        @NotNull
        public Boolean getSuspended() {
            return this.suspended;
        }

        @NotNull
        public Boolean getDisableAuth() {
            return this.disableAuth;
        }

        @NotNull
        public Boolean getDisablePermissions() {
            return this.disablePermissions;
        }

        @NotNull
        public Boolean getMultiTenantEnabled() {
            return this.multiTenantEnabled;
        }

        @NotNull
        public String getPermissionVersion() {
            return this.permissionVersion;
        }

        @Nullable
        public List<String> getUserSearchDisallowedRoles() {
            return this.userSearchDisallowedRoles;
        }

        @NotNull
        public Boolean getImageModerationEnabled() {
            return this.imageModerationEnabled;
        }

        @Nullable
        public List<String> getImageModerationLabels() {
            return this.imageModerationLabels;
        }

        @Nullable
        public String getCustomActionHandlerUrl() {
            return this.customActionHandlerUrl;
        }

        @NotNull
        public Boolean getAsyncURLEnrichEnabled() {
            return this.asyncURLEnrichEnabled;
        }

        @NotNull
        public int getRemindersInterval() {
            return this.remindersInterval;
        }

        @Nullable
        public EnforceUniqueUsernames getEnforceUniqueUsernames() {
            return this.enforceUniqueUsernames;
        }

        @Nullable
        public String getSqsUrl() {
            return this.sqsUrl;
        }

        @Nullable
        public String getSqsKey() {
            return this.sqsKey;
        }

        @Nullable
        public String getSqsSecret() {
            return this.sqsSecret;
        }

        @Nullable
        public String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        @Nullable
        public String getSnsKey() {
            return this.snsKey;
        }

        @Nullable
        public String getSnsSecret() {
            return this.snsSecret;
        }

        @Nullable
        public FileUploadConfig getFileUploadConfig() {
            return this.fileUploadConfig;
        }

        @Nullable
        public FileUploadConfig getImageUploadConfig() {
            return this.imageUploadConfig;
        }

        @Nullable
        public String getBeforeMessageSendHookUrl() {
            return this.beforeMessageSendHookUrl;
        }

        @Nullable
        public Boolean getAutoTranslationEnabled() {
            return this.autoTranslationEnabled;
        }

        @Nullable
        public Date getRevokeTokensIssuedBefore() {
            return this.revokeTokensIssuedBefore;
        }

        @Nullable
        public Map<String, List<String>> getGrants() {
            return this.grants;
        }

        @Nullable
        public List<String> getWebhookEvents() {
            return this.webhookEvents;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="organization")
        public void setOrganizationName(@NotNull String organizationName) {
            if (organizationName == null) {
                throw new NullPointerException("organizationName is marked non-null but is null");
            }
            this.organizationName = organizationName;
        }

        @JsonProperty(value="webhook_url")
        public void setWebhookURL(@NotNull String webhookURL) {
            if (webhookURL == null) {
                throw new NullPointerException("webhookURL is marked non-null but is null");
            }
            this.webhookURL = webhookURL;
        }

        @JsonProperty(value="suspended_explanation")
        public void setSuspendedExplanation(@NotNull String suspendedExplanation) {
            if (suspendedExplanation == null) {
                throw new NullPointerException("suspendedExplanation is marked non-null but is null");
            }
            this.suspendedExplanation = suspendedExplanation;
        }

        @JsonProperty(value="push_notifications")
        public void setPushNotifications(@NotNull PushNotificationFields pushNotifications) {
            if (pushNotifications == null) {
                throw new NullPointerException("pushNotifications is marked non-null but is null");
            }
            this.pushNotifications = pushNotifications;
        }

        @JsonProperty(value="channel_configs")
        public void setChannelConfigs(@NotNull Map<String, ChannelType.ChannelTypeWithStringCommands> channelConfigs) {
            if (channelConfigs == null) {
                throw new NullPointerException("channelConfigs is marked non-null but is null");
            }
            this.channelConfigs = channelConfigs;
        }

        @JsonProperty(value="policies")
        public void setPolicies(@NotNull Map<String, Policy[]> policies) {
            if (policies == null) {
                throw new NullPointerException("policies is marked non-null but is null");
            }
            this.policies = policies;
        }

        @JsonProperty(value="suspended")
        public void setSuspended(@NotNull Boolean suspended) {
            if (suspended == null) {
                throw new NullPointerException("suspended is marked non-null but is null");
            }
            this.suspended = suspended;
        }

        @JsonProperty(value="disable_auth_checks")
        public void setDisableAuth(@NotNull Boolean disableAuth) {
            if (disableAuth == null) {
                throw new NullPointerException("disableAuth is marked non-null but is null");
            }
            this.disableAuth = disableAuth;
        }

        @JsonProperty(value="disable_permissions_checks")
        public void setDisablePermissions(@NotNull Boolean disablePermissions) {
            if (disablePermissions == null) {
                throw new NullPointerException("disablePermissions is marked non-null but is null");
            }
            this.disablePermissions = disablePermissions;
        }

        @JsonProperty(value="multi_tenant_enabled")
        public void setMultiTenantEnabled(@NotNull Boolean multiTenantEnabled) {
            if (multiTenantEnabled == null) {
                throw new NullPointerException("multiTenantEnabled is marked non-null but is null");
            }
            this.multiTenantEnabled = multiTenantEnabled;
        }

        @JsonProperty(value="permission_version")
        public void setPermissionVersion(@NotNull String permissionVersion) {
            if (permissionVersion == null) {
                throw new NullPointerException("permissionVersion is marked non-null but is null");
            }
            this.permissionVersion = permissionVersion;
        }

        @JsonProperty(value="user_search_disallowed_roles")
        public void setUserSearchDisallowedRoles(@Nullable List<String> userSearchDisallowedRoles) {
            this.userSearchDisallowedRoles = userSearchDisallowedRoles;
        }

        @JsonProperty(value="image_moderation_enabled")
        public void setImageModerationEnabled(@NotNull Boolean imageModerationEnabled) {
            if (imageModerationEnabled == null) {
                throw new NullPointerException("imageModerationEnabled is marked non-null but is null");
            }
            this.imageModerationEnabled = imageModerationEnabled;
        }

        @JsonProperty(value="image_moderation_labels")
        public void setImageModerationLabels(@Nullable List<String> imageModerationLabels) {
            this.imageModerationLabels = imageModerationLabels;
        }

        @JsonProperty(value="custom_action_handler_url")
        public void setCustomActionHandlerUrl(@Nullable String customActionHandlerUrl) {
            this.customActionHandlerUrl = customActionHandlerUrl;
        }

        @JsonProperty(value="async_url_enrich_enabled")
        public void setAsyncURLEnrichEnabled(@NotNull Boolean asyncURLEnrichEnabled) {
            if (asyncURLEnrichEnabled == null) {
                throw new NullPointerException("asyncURLEnrichEnabled is marked non-null but is null");
            }
            this.asyncURLEnrichEnabled = asyncURLEnrichEnabled;
        }

        @JsonProperty(value="reminders_interval")
        public void setRemindersInterval(@NotNull int remindersInterval) {
            this.remindersInterval = remindersInterval;
        }

        @JsonProperty(value="enforce_unique_usernames")
        @JsonDeserialize(using=EnforceUniqueUsernamesDeserializer.class)
        public void setEnforceUniqueUsernames(@Nullable EnforceUniqueUsernames enforceUniqueUsernames) {
            this.enforceUniqueUsernames = enforceUniqueUsernames;
        }

        @JsonProperty(value="sqs_url")
        public void setSqsUrl(@Nullable String sqsUrl) {
            this.sqsUrl = sqsUrl;
        }

        @JsonProperty(value="sqs_key")
        public void setSqsKey(@Nullable String sqsKey) {
            this.sqsKey = sqsKey;
        }

        @JsonProperty(value="sqs_secret")
        public void setSqsSecret(@Nullable String sqsSecret) {
            this.sqsSecret = sqsSecret;
        }

        @JsonProperty(value="sns_topic_arn")
        public void setSnsTopicArn(@Nullable String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @JsonProperty(value="sns_key")
        public void setSnsKey(@Nullable String snsKey) {
            this.snsKey = snsKey;
        }

        @JsonProperty(value="sns_secret")
        public void setSnsSecret(@Nullable String snsSecret) {
            this.snsSecret = snsSecret;
        }

        @JsonProperty(value="file_upload_config")
        public void setFileUploadConfig(@Nullable FileUploadConfig fileUploadConfig) {
            this.fileUploadConfig = fileUploadConfig;
        }

        @JsonProperty(value="image_upload_config")
        public void setImageUploadConfig(@Nullable FileUploadConfig imageUploadConfig) {
            this.imageUploadConfig = imageUploadConfig;
        }

        @JsonProperty(value="before_message_send_hook_url")
        public void setBeforeMessageSendHookUrl(@Nullable String beforeMessageSendHookUrl) {
            this.beforeMessageSendHookUrl = beforeMessageSendHookUrl;
        }

        @JsonProperty(value="auto_translation_enabled")
        public void setAutoTranslationEnabled(@Nullable Boolean autoTranslationEnabled) {
            this.autoTranslationEnabled = autoTranslationEnabled;
        }

        @JsonProperty(value="revoke_tokens_issued_before")
        public void setRevokeTokensIssuedBefore(@Nullable Date revokeTokensIssuedBefore) {
            this.revokeTokensIssuedBefore = revokeTokensIssuedBefore;
        }

        @JsonProperty(value="grants")
        public void setGrants(@Nullable Map<String, List<String>> grants) {
            this.grants = grants;
        }

        @JsonProperty(value="webhook_events")
        public void setWebhookEvents(@Nullable List<String> webhookEvents) {
            this.webhookEvents = webhookEvents;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppConfig)) {
                return false;
            }
            AppConfig other = (AppConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRemindersInterval() != other.getRemindersInterval()) {
                return false;
            }
            Boolean this$suspended = this.getSuspended();
            Boolean other$suspended = other.getSuspended();
            if (this$suspended == null ? other$suspended != null : !((Object)this$suspended).equals(other$suspended)) {
                return false;
            }
            Boolean this$disableAuth = this.getDisableAuth();
            Boolean other$disableAuth = other.getDisableAuth();
            if (this$disableAuth == null ? other$disableAuth != null : !((Object)this$disableAuth).equals(other$disableAuth)) {
                return false;
            }
            Boolean this$disablePermissions = this.getDisablePermissions();
            Boolean other$disablePermissions = other.getDisablePermissions();
            if (this$disablePermissions == null ? other$disablePermissions != null : !((Object)this$disablePermissions).equals(other$disablePermissions)) {
                return false;
            }
            Boolean this$multiTenantEnabled = this.getMultiTenantEnabled();
            Boolean other$multiTenantEnabled = other.getMultiTenantEnabled();
            if (this$multiTenantEnabled == null ? other$multiTenantEnabled != null : !((Object)this$multiTenantEnabled).equals(other$multiTenantEnabled)) {
                return false;
            }
            Boolean this$imageModerationEnabled = this.getImageModerationEnabled();
            Boolean other$imageModerationEnabled = other.getImageModerationEnabled();
            if (this$imageModerationEnabled == null ? other$imageModerationEnabled != null : !((Object)this$imageModerationEnabled).equals(other$imageModerationEnabled)) {
                return false;
            }
            Boolean this$asyncURLEnrichEnabled = this.getAsyncURLEnrichEnabled();
            Boolean other$asyncURLEnrichEnabled = other.getAsyncURLEnrichEnabled();
            if (this$asyncURLEnrichEnabled == null ? other$asyncURLEnrichEnabled != null : !((Object)this$asyncURLEnrichEnabled).equals(other$asyncURLEnrichEnabled)) {
                return false;
            }
            Boolean this$autoTranslationEnabled = this.getAutoTranslationEnabled();
            Boolean other$autoTranslationEnabled = other.getAutoTranslationEnabled();
            if (this$autoTranslationEnabled == null ? other$autoTranslationEnabled != null : !((Object)this$autoTranslationEnabled).equals(other$autoTranslationEnabled)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$organizationName = this.getOrganizationName();
            String other$organizationName = other.getOrganizationName();
            if (this$organizationName == null ? other$organizationName != null : !this$organizationName.equals(other$organizationName)) {
                return false;
            }
            String this$webhookURL = this.getWebhookURL();
            String other$webhookURL = other.getWebhookURL();
            if (this$webhookURL == null ? other$webhookURL != null : !this$webhookURL.equals(other$webhookURL)) {
                return false;
            }
            String this$suspendedExplanation = this.getSuspendedExplanation();
            String other$suspendedExplanation = other.getSuspendedExplanation();
            if (this$suspendedExplanation == null ? other$suspendedExplanation != null : !this$suspendedExplanation.equals(other$suspendedExplanation)) {
                return false;
            }
            PushNotificationFields this$pushNotifications = this.getPushNotifications();
            PushNotificationFields other$pushNotifications = other.getPushNotifications();
            if (this$pushNotifications == null ? other$pushNotifications != null : !((Object)this$pushNotifications).equals(other$pushNotifications)) {
                return false;
            }
            Map<String, ChannelType.ChannelTypeWithStringCommands> this$channelConfigs = this.getChannelConfigs();
            Map<String, ChannelType.ChannelTypeWithStringCommands> other$channelConfigs = other.getChannelConfigs();
            if (this$channelConfigs == null ? other$channelConfigs != null : !((Object)this$channelConfigs).equals(other$channelConfigs)) {
                return false;
            }
            Map<String, Policy[]> this$policies = this.getPolicies();
            Map<String, Policy[]> other$policies = other.getPolicies();
            if (this$policies == null ? other$policies != null : !((Object)this$policies).equals(other$policies)) {
                return false;
            }
            String this$permissionVersion = this.getPermissionVersion();
            String other$permissionVersion = other.getPermissionVersion();
            if (this$permissionVersion == null ? other$permissionVersion != null : !this$permissionVersion.equals(other$permissionVersion)) {
                return false;
            }
            List<String> this$userSearchDisallowedRoles = this.getUserSearchDisallowedRoles();
            List<String> other$userSearchDisallowedRoles = other.getUserSearchDisallowedRoles();
            if (this$userSearchDisallowedRoles == null ? other$userSearchDisallowedRoles != null : !((Object)this$userSearchDisallowedRoles).equals(other$userSearchDisallowedRoles)) {
                return false;
            }
            List<String> this$imageModerationLabels = this.getImageModerationLabels();
            List<String> other$imageModerationLabels = other.getImageModerationLabels();
            if (this$imageModerationLabels == null ? other$imageModerationLabels != null : !((Object)this$imageModerationLabels).equals(other$imageModerationLabels)) {
                return false;
            }
            String this$customActionHandlerUrl = this.getCustomActionHandlerUrl();
            String other$customActionHandlerUrl = other.getCustomActionHandlerUrl();
            if (this$customActionHandlerUrl == null ? other$customActionHandlerUrl != null : !this$customActionHandlerUrl.equals(other$customActionHandlerUrl)) {
                return false;
            }
            EnforceUniqueUsernames this$enforceUniqueUsernames = this.getEnforceUniqueUsernames();
            EnforceUniqueUsernames other$enforceUniqueUsernames = other.getEnforceUniqueUsernames();
            if (this$enforceUniqueUsernames == null ? other$enforceUniqueUsernames != null : !((Object)((Object)this$enforceUniqueUsernames)).equals((Object)other$enforceUniqueUsernames)) {
                return false;
            }
            String this$sqsUrl = this.getSqsUrl();
            String other$sqsUrl = other.getSqsUrl();
            if (this$sqsUrl == null ? other$sqsUrl != null : !this$sqsUrl.equals(other$sqsUrl)) {
                return false;
            }
            String this$sqsKey = this.getSqsKey();
            String other$sqsKey = other.getSqsKey();
            if (this$sqsKey == null ? other$sqsKey != null : !this$sqsKey.equals(other$sqsKey)) {
                return false;
            }
            String this$sqsSecret = this.getSqsSecret();
            String other$sqsSecret = other.getSqsSecret();
            if (this$sqsSecret == null ? other$sqsSecret != null : !this$sqsSecret.equals(other$sqsSecret)) {
                return false;
            }
            String this$snsTopicArn = this.getSnsTopicArn();
            String other$snsTopicArn = other.getSnsTopicArn();
            if (this$snsTopicArn == null ? other$snsTopicArn != null : !this$snsTopicArn.equals(other$snsTopicArn)) {
                return false;
            }
            String this$snsKey = this.getSnsKey();
            String other$snsKey = other.getSnsKey();
            if (this$snsKey == null ? other$snsKey != null : !this$snsKey.equals(other$snsKey)) {
                return false;
            }
            String this$snsSecret = this.getSnsSecret();
            String other$snsSecret = other.getSnsSecret();
            if (this$snsSecret == null ? other$snsSecret != null : !this$snsSecret.equals(other$snsSecret)) {
                return false;
            }
            FileUploadConfig this$fileUploadConfig = this.getFileUploadConfig();
            FileUploadConfig other$fileUploadConfig = other.getFileUploadConfig();
            if (this$fileUploadConfig == null ? other$fileUploadConfig != null : !((Object)this$fileUploadConfig).equals(other$fileUploadConfig)) {
                return false;
            }
            FileUploadConfig this$imageUploadConfig = this.getImageUploadConfig();
            FileUploadConfig other$imageUploadConfig = other.getImageUploadConfig();
            if (this$imageUploadConfig == null ? other$imageUploadConfig != null : !((Object)this$imageUploadConfig).equals(other$imageUploadConfig)) {
                return false;
            }
            String this$beforeMessageSendHookUrl = this.getBeforeMessageSendHookUrl();
            String other$beforeMessageSendHookUrl = other.getBeforeMessageSendHookUrl();
            if (this$beforeMessageSendHookUrl == null ? other$beforeMessageSendHookUrl != null : !this$beforeMessageSendHookUrl.equals(other$beforeMessageSendHookUrl)) {
                return false;
            }
            Date this$revokeTokensIssuedBefore = this.getRevokeTokensIssuedBefore();
            Date other$revokeTokensIssuedBefore = other.getRevokeTokensIssuedBefore();
            if (this$revokeTokensIssuedBefore == null ? other$revokeTokensIssuedBefore != null : !((Object)this$revokeTokensIssuedBefore).equals(other$revokeTokensIssuedBefore)) {
                return false;
            }
            Map<String, List<String>> this$grants = this.getGrants();
            Map<String, List<String>> other$grants = other.getGrants();
            if (this$grants == null ? other$grants != null : !((Object)this$grants).equals(other$grants)) {
                return false;
            }
            List<String> this$webhookEvents = this.getWebhookEvents();
            List<String> other$webhookEvents = other.getWebhookEvents();
            return !(this$webhookEvents == null ? other$webhookEvents != null : !((Object)this$webhookEvents).equals(other$webhookEvents));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRemindersInterval();
            Boolean $suspended = this.getSuspended();
            result = result * 59 + ($suspended == null ? 43 : ((Object)$suspended).hashCode());
            Boolean $disableAuth = this.getDisableAuth();
            result = result * 59 + ($disableAuth == null ? 43 : ((Object)$disableAuth).hashCode());
            Boolean $disablePermissions = this.getDisablePermissions();
            result = result * 59 + ($disablePermissions == null ? 43 : ((Object)$disablePermissions).hashCode());
            Boolean $multiTenantEnabled = this.getMultiTenantEnabled();
            result = result * 59 + ($multiTenantEnabled == null ? 43 : ((Object)$multiTenantEnabled).hashCode());
            Boolean $imageModerationEnabled = this.getImageModerationEnabled();
            result = result * 59 + ($imageModerationEnabled == null ? 43 : ((Object)$imageModerationEnabled).hashCode());
            Boolean $asyncURLEnrichEnabled = this.getAsyncURLEnrichEnabled();
            result = result * 59 + ($asyncURLEnrichEnabled == null ? 43 : ((Object)$asyncURLEnrichEnabled).hashCode());
            Boolean $autoTranslationEnabled = this.getAutoTranslationEnabled();
            result = result * 59 + ($autoTranslationEnabled == null ? 43 : ((Object)$autoTranslationEnabled).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $organizationName = this.getOrganizationName();
            result = result * 59 + ($organizationName == null ? 43 : $organizationName.hashCode());
            String $webhookURL = this.getWebhookURL();
            result = result * 59 + ($webhookURL == null ? 43 : $webhookURL.hashCode());
            String $suspendedExplanation = this.getSuspendedExplanation();
            result = result * 59 + ($suspendedExplanation == null ? 43 : $suspendedExplanation.hashCode());
            PushNotificationFields $pushNotifications = this.getPushNotifications();
            result = result * 59 + ($pushNotifications == null ? 43 : ((Object)$pushNotifications).hashCode());
            Map<String, ChannelType.ChannelTypeWithStringCommands> $channelConfigs = this.getChannelConfigs();
            result = result * 59 + ($channelConfigs == null ? 43 : ((Object)$channelConfigs).hashCode());
            Map<String, Policy[]> $policies = this.getPolicies();
            result = result * 59 + ($policies == null ? 43 : ((Object)$policies).hashCode());
            String $permissionVersion = this.getPermissionVersion();
            result = result * 59 + ($permissionVersion == null ? 43 : $permissionVersion.hashCode());
            List<String> $userSearchDisallowedRoles = this.getUserSearchDisallowedRoles();
            result = result * 59 + ($userSearchDisallowedRoles == null ? 43 : ((Object)$userSearchDisallowedRoles).hashCode());
            List<String> $imageModerationLabels = this.getImageModerationLabels();
            result = result * 59 + ($imageModerationLabels == null ? 43 : ((Object)$imageModerationLabels).hashCode());
            String $customActionHandlerUrl = this.getCustomActionHandlerUrl();
            result = result * 59 + ($customActionHandlerUrl == null ? 43 : $customActionHandlerUrl.hashCode());
            EnforceUniqueUsernames $enforceUniqueUsernames = this.getEnforceUniqueUsernames();
            result = result * 59 + ($enforceUniqueUsernames == null ? 43 : ((Object)((Object)$enforceUniqueUsernames)).hashCode());
            String $sqsUrl = this.getSqsUrl();
            result = result * 59 + ($sqsUrl == null ? 43 : $sqsUrl.hashCode());
            String $sqsKey = this.getSqsKey();
            result = result * 59 + ($sqsKey == null ? 43 : $sqsKey.hashCode());
            String $sqsSecret = this.getSqsSecret();
            result = result * 59 + ($sqsSecret == null ? 43 : $sqsSecret.hashCode());
            String $snsTopicArn = this.getSnsTopicArn();
            result = result * 59 + ($snsTopicArn == null ? 43 : $snsTopicArn.hashCode());
            String $snsKey = this.getSnsKey();
            result = result * 59 + ($snsKey == null ? 43 : $snsKey.hashCode());
            String $snsSecret = this.getSnsSecret();
            result = result * 59 + ($snsSecret == null ? 43 : $snsSecret.hashCode());
            FileUploadConfig $fileUploadConfig = this.getFileUploadConfig();
            result = result * 59 + ($fileUploadConfig == null ? 43 : ((Object)$fileUploadConfig).hashCode());
            FileUploadConfig $imageUploadConfig = this.getImageUploadConfig();
            result = result * 59 + ($imageUploadConfig == null ? 43 : ((Object)$imageUploadConfig).hashCode());
            String $beforeMessageSendHookUrl = this.getBeforeMessageSendHookUrl();
            result = result * 59 + ($beforeMessageSendHookUrl == null ? 43 : $beforeMessageSendHookUrl.hashCode());
            Date $revokeTokensIssuedBefore = this.getRevokeTokensIssuedBefore();
            result = result * 59 + ($revokeTokensIssuedBefore == null ? 43 : ((Object)$revokeTokensIssuedBefore).hashCode());
            Map<String, List<String>> $grants = this.getGrants();
            result = result * 59 + ($grants == null ? 43 : ((Object)$grants).hashCode());
            List<String> $webhookEvents = this.getWebhookEvents();
            result = result * 59 + ($webhookEvents == null ? 43 : ((Object)$webhookEvents).hashCode());
            return result;
        }

        public String toString() {
            return "App.AppConfig(name=" + this.getName() + ", organizationName=" + this.getOrganizationName() + ", webhookURL=" + this.getWebhookURL() + ", suspendedExplanation=" + this.getSuspendedExplanation() + ", pushNotifications=" + this.getPushNotifications() + ", channelConfigs=" + this.getChannelConfigs() + ", policies=" + this.getPolicies() + ", suspended=" + this.getSuspended() + ", disableAuth=" + this.getDisableAuth() + ", disablePermissions=" + this.getDisablePermissions() + ", multiTenantEnabled=" + this.getMultiTenantEnabled() + ", permissionVersion=" + this.getPermissionVersion() + ", userSearchDisallowedRoles=" + this.getUserSearchDisallowedRoles() + ", imageModerationEnabled=" + this.getImageModerationEnabled() + ", imageModerationLabels=" + this.getImageModerationLabels() + ", customActionHandlerUrl=" + this.getCustomActionHandlerUrl() + ", asyncURLEnrichEnabled=" + this.getAsyncURLEnrichEnabled() + ", remindersInterval=" + this.getRemindersInterval() + ", enforceUniqueUsernames=" + this.getEnforceUniqueUsernames() + ", sqsUrl=" + this.getSqsUrl() + ", sqsKey=" + this.getSqsKey() + ", sqsSecret=" + this.getSqsSecret() + ", snsTopicArn=" + this.getSnsTopicArn() + ", snsKey=" + this.getSnsKey() + ", snsSecret=" + this.getSnsSecret() + ", fileUploadConfig=" + this.getFileUploadConfig() + ", imageUploadConfig=" + this.getImageUploadConfig() + ", beforeMessageSendHookUrl=" + this.getBeforeMessageSendHookUrl() + ", autoTranslationEnabled=" + this.getAutoTranslationEnabled() + ", revokeTokensIssuedBefore=" + this.getRevokeTokensIssuedBefore() + ", grants=" + this.getGrants() + ", webhookEvents=" + this.getWebhookEvents() + ")";
        }
    }

    public static class ListPushProviderResponse
    extends StreamResponseObject {
        @JsonProperty(value="push_providers")
        @NotNull
        private List<PushProvider> pushProviders;

        @NotNull
        public List<PushProvider> getPushProviders() {
            return this.pushProviders;
        }

        @JsonProperty(value="push_providers")
        public void setPushProviders(@NotNull List<PushProvider> pushProviders) {
            if (pushProviders == null) {
                throw new NullPointerException("pushProviders is marked non-null but is null");
            }
            this.pushProviders = pushProviders;
        }

        @Override
        public String toString() {
            return "App.ListPushProviderResponse(pushProviders=" + this.getPushProviders() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListPushProviderResponse)) {
                return false;
            }
            ListPushProviderResponse other = (ListPushProviderResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<PushProvider> this$pushProviders = this.getPushProviders();
            List<PushProvider> other$pushProviders = other.getPushProviders();
            return !(this$pushProviders == null ? other$pushProviders != null : !((Object)this$pushProviders).equals(other$pushProviders));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ListPushProviderResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<PushProvider> $pushProviders = this.getPushProviders();
            result = result * 59 + ($pushProviders == null ? 43 : ((Object)$pushProviders).hashCode());
            return result;
        }
    }

    public static class UpsertPushProviderResponse
    extends StreamResponseObject {
        @JsonProperty(value="push_provider")
        @NotNull
        private PushProvider pushProvider;

        @NotNull
        public PushProvider getPushProvider() {
            return this.pushProvider;
        }

        @JsonProperty(value="push_provider")
        public void setPushProvider(@NotNull PushProvider pushProvider) {
            if (pushProvider == null) {
                throw new NullPointerException("pushProvider is marked non-null but is null");
            }
            this.pushProvider = pushProvider;
        }

        @Override
        public String toString() {
            return "App.UpsertPushProviderResponse(pushProvider=" + this.getPushProvider() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpsertPushProviderResponse)) {
                return false;
            }
            UpsertPushProviderResponse other = (UpsertPushProviderResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PushProvider this$pushProvider = this.getPushProvider();
            PushProvider other$pushProvider = other.getPushProvider();
            return !(this$pushProvider == null ? other$pushProvider != null : !((Object)this$pushProvider).equals(other$pushProvider));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof UpsertPushProviderResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            PushProvider $pushProvider = this.getPushProvider();
            result = result * 59 + ($pushProvider == null ? 43 : ((Object)$pushProvider).hashCode());
            return result;
        }
    }

    public static class AppCheckPushResponse
    extends StreamResponseObject {
        @JsonProperty(value="device_errors")
        @Nullable
        private Map<String, DeviceError> deviceErrors;
        @JsonProperty(value="general_errors")
        @Nullable
        private List<String> generalErrors;
        @JsonProperty(value="skip_devices")
        @Nullable
        private Boolean skipDevices;
        @JsonProperty(value="rendered_apn_template")
        @NotNull
        private String renderedApnTemplate;
        @JsonProperty(value="rendered_firebase_template")
        @NotNull
        private String renderedFirebaseTemplate;
        @JsonProperty(value="rendered_message")
        @NotNull
        private Map<String, String> renderedMessage;

        @Nullable
        public Map<String, DeviceError> getDeviceErrors() {
            return this.deviceErrors;
        }

        @Nullable
        public List<String> getGeneralErrors() {
            return this.generalErrors;
        }

        @Nullable
        public Boolean getSkipDevices() {
            return this.skipDevices;
        }

        @NotNull
        public String getRenderedApnTemplate() {
            return this.renderedApnTemplate;
        }

        @NotNull
        public String getRenderedFirebaseTemplate() {
            return this.renderedFirebaseTemplate;
        }

        @NotNull
        public Map<String, String> getRenderedMessage() {
            return this.renderedMessage;
        }

        @JsonProperty(value="device_errors")
        public void setDeviceErrors(@Nullable Map<String, DeviceError> deviceErrors) {
            this.deviceErrors = deviceErrors;
        }

        @JsonProperty(value="general_errors")
        public void setGeneralErrors(@Nullable List<String> generalErrors) {
            this.generalErrors = generalErrors;
        }

        @JsonProperty(value="skip_devices")
        public void setSkipDevices(@Nullable Boolean skipDevices) {
            this.skipDevices = skipDevices;
        }

        @JsonProperty(value="rendered_apn_template")
        public void setRenderedApnTemplate(@NotNull String renderedApnTemplate) {
            if (renderedApnTemplate == null) {
                throw new NullPointerException("renderedApnTemplate is marked non-null but is null");
            }
            this.renderedApnTemplate = renderedApnTemplate;
        }

        @JsonProperty(value="rendered_firebase_template")
        public void setRenderedFirebaseTemplate(@NotNull String renderedFirebaseTemplate) {
            if (renderedFirebaseTemplate == null) {
                throw new NullPointerException("renderedFirebaseTemplate is marked non-null but is null");
            }
            this.renderedFirebaseTemplate = renderedFirebaseTemplate;
        }

        @JsonProperty(value="rendered_message")
        public void setRenderedMessage(@NotNull Map<String, String> renderedMessage) {
            if (renderedMessage == null) {
                throw new NullPointerException("renderedMessage is marked non-null but is null");
            }
            this.renderedMessage = renderedMessage;
        }

        @Override
        public String toString() {
            return "App.AppCheckPushResponse(deviceErrors=" + this.getDeviceErrors() + ", generalErrors=" + this.getGeneralErrors() + ", skipDevices=" + this.getSkipDevices() + ", renderedApnTemplate=" + this.getRenderedApnTemplate() + ", renderedFirebaseTemplate=" + this.getRenderedFirebaseTemplate() + ", renderedMessage=" + this.getRenderedMessage() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppCheckPushResponse)) {
                return false;
            }
            AppCheckPushResponse other = (AppCheckPushResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Boolean this$skipDevices = this.getSkipDevices();
            Boolean other$skipDevices = other.getSkipDevices();
            if (this$skipDevices == null ? other$skipDevices != null : !((Object)this$skipDevices).equals(other$skipDevices)) {
                return false;
            }
            Map<String, DeviceError> this$deviceErrors = this.getDeviceErrors();
            Map<String, DeviceError> other$deviceErrors = other.getDeviceErrors();
            if (this$deviceErrors == null ? other$deviceErrors != null : !((Object)this$deviceErrors).equals(other$deviceErrors)) {
                return false;
            }
            List<String> this$generalErrors = this.getGeneralErrors();
            List<String> other$generalErrors = other.getGeneralErrors();
            if (this$generalErrors == null ? other$generalErrors != null : !((Object)this$generalErrors).equals(other$generalErrors)) {
                return false;
            }
            String this$renderedApnTemplate = this.getRenderedApnTemplate();
            String other$renderedApnTemplate = other.getRenderedApnTemplate();
            if (this$renderedApnTemplate == null ? other$renderedApnTemplate != null : !this$renderedApnTemplate.equals(other$renderedApnTemplate)) {
                return false;
            }
            String this$renderedFirebaseTemplate = this.getRenderedFirebaseTemplate();
            String other$renderedFirebaseTemplate = other.getRenderedFirebaseTemplate();
            if (this$renderedFirebaseTemplate == null ? other$renderedFirebaseTemplate != null : !this$renderedFirebaseTemplate.equals(other$renderedFirebaseTemplate)) {
                return false;
            }
            Map<String, String> this$renderedMessage = this.getRenderedMessage();
            Map<String, String> other$renderedMessage = other.getRenderedMessage();
            return !(this$renderedMessage == null ? other$renderedMessage != null : !((Object)this$renderedMessage).equals(other$renderedMessage));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AppCheckPushResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Boolean $skipDevices = this.getSkipDevices();
            result = result * 59 + ($skipDevices == null ? 43 : ((Object)$skipDevices).hashCode());
            Map<String, DeviceError> $deviceErrors = this.getDeviceErrors();
            result = result * 59 + ($deviceErrors == null ? 43 : ((Object)$deviceErrors).hashCode());
            List<String> $generalErrors = this.getGeneralErrors();
            result = result * 59 + ($generalErrors == null ? 43 : ((Object)$generalErrors).hashCode());
            String $renderedApnTemplate = this.getRenderedApnTemplate();
            result = result * 59 + ($renderedApnTemplate == null ? 43 : $renderedApnTemplate.hashCode());
            String $renderedFirebaseTemplate = this.getRenderedFirebaseTemplate();
            result = result * 59 + ($renderedFirebaseTemplate == null ? 43 : $renderedFirebaseTemplate.hashCode());
            Map<String, String> $renderedMessage = this.getRenderedMessage();
            result = result * 59 + ($renderedMessage == null ? 43 : ((Object)$renderedMessage).hashCode());
            return result;
        }
    }

    public static class AppCheckSnsResponse
    extends StreamResponseObject {
        @JsonProperty(value="status")
        @NotNull
        private Status status;
        @JsonProperty(value="error")
        @Nullable
        private String error;
        @JsonProperty(value="data")
        @Nullable
        private Map<String, Object> data;

        @NotNull
        public Status getStatus() {
            return this.status;
        }

        @Nullable
        public String getError() {
            return this.error;
        }

        @Nullable
        public Map<String, Object> getData() {
            return this.data;
        }

        @JsonProperty(value="status")
        public void setStatus(@NotNull Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="data")
        public void setData(@Nullable Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return "App.AppCheckSnsResponse(status=" + this.getStatus() + ", error=" + this.getError() + ", data=" + this.getData() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppCheckSnsResponse)) {
                return false;
            }
            AppCheckSnsResponse other = (AppCheckSnsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            Map<String, Object> this$data = this.getData();
            Map<String, Object> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AppCheckSnsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            Map<String, Object> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public static enum Status {
            OK,
            ERROR,
            UNKNOWN;

        }
    }

    public static class AppCheckSqsResponse
    extends StreamResponseObject {
        @JsonProperty(value="status")
        @NotNull
        private Status status;
        @JsonProperty(value="error")
        @Nullable
        private String error;
        @JsonProperty(value="data")
        @Nullable
        private Map<String, Object> data;

        @NotNull
        public Status getStatus() {
            return this.status;
        }

        @Nullable
        public String getError() {
            return this.error;
        }

        @Nullable
        public Map<String, Object> getData() {
            return this.data;
        }

        @JsonProperty(value="status")
        public void setStatus(@NotNull Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked non-null but is null");
            }
            this.status = status;
        }

        @JsonProperty(value="error")
        public void setError(@Nullable String error) {
            this.error = error;
        }

        @JsonProperty(value="data")
        public void setData(@Nullable Map<String, Object> data) {
            this.data = data;
        }

        @Override
        public String toString() {
            return "App.AppCheckSqsResponse(status=" + this.getStatus() + ", error=" + this.getError() + ", data=" + this.getData() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppCheckSqsResponse)) {
                return false;
            }
            AppCheckSqsResponse other = (AppCheckSqsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Status this$status = this.getStatus();
            Status other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            Map<String, Object> this$data = this.getData();
            Map<String, Object> other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof AppCheckSqsResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Status $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            Map<String, Object> $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public static enum Status {
            OK,
            ERROR,
            UNKNOWN;

        }
    }

    public static class AppGetRateLimitsResponse
    implements StreamResponse {
        @JsonProperty(value="server_side")
        @NotNull
        private Map<String, RateLimit> serverSide;
        @JsonProperty(value="android")
        @NotNull
        private Map<String, RateLimit> android;
        @JsonProperty(value="ios")
        @NotNull
        private Map<String, RateLimit> ios;
        @JsonProperty(value="web")
        @NotNull
        private Map<String, RateLimit> web;
        @JsonProperty(value="duration")
        @NotNull
        private String duration;

        @NotNull
        public Map<String, RateLimit> getServerSide() {
            return this.serverSide;
        }

        @NotNull
        public Map<String, RateLimit> getAndroid() {
            return this.android;
        }

        @NotNull
        public Map<String, RateLimit> getIos() {
            return this.ios;
        }

        @NotNull
        public Map<String, RateLimit> getWeb() {
            return this.web;
        }

        @Override
        @NotNull
        public String getDuration() {
            return this.duration;
        }

        @JsonProperty(value="server_side")
        public void setServerSide(@NotNull Map<String, RateLimit> serverSide) {
            if (serverSide == null) {
                throw new NullPointerException("serverSide is marked non-null but is null");
            }
            this.serverSide = serverSide;
        }

        @JsonProperty(value="android")
        public void setAndroid(@NotNull Map<String, RateLimit> android) {
            if (android == null) {
                throw new NullPointerException("android is marked non-null but is null");
            }
            this.android = android;
        }

        @JsonProperty(value="ios")
        public void setIos(@NotNull Map<String, RateLimit> ios) {
            if (ios == null) {
                throw new NullPointerException("ios is marked non-null but is null");
            }
            this.ios = ios;
        }

        @JsonProperty(value="web")
        public void setWeb(@NotNull Map<String, RateLimit> web) {
            if (web == null) {
                throw new NullPointerException("web is marked non-null but is null");
            }
            this.web = web;
        }

        @Override
        @JsonProperty(value="duration")
        public void setDuration(@NotNull String duration) {
            if (duration == null) {
                throw new NullPointerException("duration is marked non-null but is null");
            }
            this.duration = duration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppGetRateLimitsResponse)) {
                return false;
            }
            AppGetRateLimitsResponse other = (AppGetRateLimitsResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, RateLimit> this$serverSide = this.getServerSide();
            Map<String, RateLimit> other$serverSide = other.getServerSide();
            if (this$serverSide == null ? other$serverSide != null : !((Object)this$serverSide).equals(other$serverSide)) {
                return false;
            }
            Map<String, RateLimit> this$android = this.getAndroid();
            Map<String, RateLimit> other$android = other.getAndroid();
            if (this$android == null ? other$android != null : !((Object)this$android).equals(other$android)) {
                return false;
            }
            Map<String, RateLimit> this$ios = this.getIos();
            Map<String, RateLimit> other$ios = other.getIos();
            if (this$ios == null ? other$ios != null : !((Object)this$ios).equals(other$ios)) {
                return false;
            }
            Map<String, RateLimit> this$web = this.getWeb();
            Map<String, RateLimit> other$web = other.getWeb();
            if (this$web == null ? other$web != null : !((Object)this$web).equals(other$web)) {
                return false;
            }
            String this$duration = this.getDuration();
            String other$duration = other.getDuration();
            return !(this$duration == null ? other$duration != null : !this$duration.equals(other$duration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AppGetRateLimitsResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, RateLimit> $serverSide = this.getServerSide();
            result = result * 59 + ($serverSide == null ? 43 : ((Object)$serverSide).hashCode());
            Map<String, RateLimit> $android = this.getAndroid();
            result = result * 59 + ($android == null ? 43 : ((Object)$android).hashCode());
            Map<String, RateLimit> $ios = this.getIos();
            result = result * 59 + ($ios == null ? 43 : ((Object)$ios).hashCode());
            Map<String, RateLimit> $web = this.getWeb();
            result = result * 59 + ($web == null ? 43 : ((Object)$web).hashCode());
            String $duration = this.getDuration();
            result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
            return result;
        }

        public String toString() {
            return "App.AppGetRateLimitsResponse(serverSide=" + this.getServerSide() + ", android=" + this.getAndroid() + ", ios=" + this.getIos() + ", web=" + this.getWeb() + ", duration=" + this.getDuration() + ")";
        }
    }

    public static class PushProvider {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="type")
        @NotNull
        private PushProviderType type;
        @JsonProperty(value="description")
        @Nullable
        private String description;
        @JsonProperty(value="disabled_at")
        @Nullable
        private Date disabledAt;
        @JsonProperty(value="disabled_reason")
        @Nullable
        private String disabledReason;
        @JsonProperty(value="apn_auth_key")
        @Nullable
        private String apnAuthKey;
        @JsonProperty(value="apn_key_id")
        @Nullable
        private String apnKeyId;
        @JsonProperty(value="apn_team_id")
        @Nullable
        private String apnTeamId;
        @JsonProperty(value="apn_topic")
        @Nullable
        private String apnTopic;
        @JsonProperty(value="firebase_credentials")
        @Nullable
        private String firebaseCredentials;
        @JsonProperty(value="firebase_apn_template")
        @Nullable
        private String firebaseApnTemplate;
        @JsonProperty(value="huawei_app_id")
        @Nullable
        private String huaweiAppId;
        @JsonProperty(value="huawei_app_secret")
        @Nullable
        private String huaweiAppSecret;
        @JsonProperty(value="xiaomi_package_name")
        @Nullable
        private String xiaomiPackageName;
        @JsonProperty(value="xiaomi_app_secret")
        @Nullable
        private String xiaomiAppSecret;
        @JsonProperty(value="created_at")
        @Nullable
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @Nullable
        private Date updatedAt;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public PushProviderType getType() {
            return this.type;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public Date getDisabledAt() {
            return this.disabledAt;
        }

        @Nullable
        public String getDisabledReason() {
            return this.disabledReason;
        }

        @Nullable
        public String getApnAuthKey() {
            return this.apnAuthKey;
        }

        @Nullable
        public String getApnKeyId() {
            return this.apnKeyId;
        }

        @Nullable
        public String getApnTeamId() {
            return this.apnTeamId;
        }

        @Nullable
        public String getApnTopic() {
            return this.apnTopic;
        }

        @Nullable
        public String getFirebaseCredentials() {
            return this.firebaseCredentials;
        }

        @Nullable
        public String getFirebaseApnTemplate() {
            return this.firebaseApnTemplate;
        }

        @Nullable
        public String getHuaweiAppId() {
            return this.huaweiAppId;
        }

        @Nullable
        public String getHuaweiAppSecret() {
            return this.huaweiAppSecret;
        }

        @Nullable
        public String getXiaomiPackageName() {
            return this.xiaomiPackageName;
        }

        @Nullable
        public String getXiaomiAppSecret() {
            return this.xiaomiAppSecret;
        }

        @Nullable
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @Nullable
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(@NotNull PushProviderType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="disabled_at")
        public void setDisabledAt(@Nullable Date disabledAt) {
            this.disabledAt = disabledAt;
        }

        @JsonProperty(value="disabled_reason")
        public void setDisabledReason(@Nullable String disabledReason) {
            this.disabledReason = disabledReason;
        }

        @JsonProperty(value="apn_auth_key")
        public void setApnAuthKey(@Nullable String apnAuthKey) {
            this.apnAuthKey = apnAuthKey;
        }

        @JsonProperty(value="apn_key_id")
        public void setApnKeyId(@Nullable String apnKeyId) {
            this.apnKeyId = apnKeyId;
        }

        @JsonProperty(value="apn_team_id")
        public void setApnTeamId(@Nullable String apnTeamId) {
            this.apnTeamId = apnTeamId;
        }

        @JsonProperty(value="apn_topic")
        public void setApnTopic(@Nullable String apnTopic) {
            this.apnTopic = apnTopic;
        }

        @JsonProperty(value="firebase_credentials")
        public void setFirebaseCredentials(@Nullable String firebaseCredentials) {
            this.firebaseCredentials = firebaseCredentials;
        }

        @JsonProperty(value="firebase_apn_template")
        public void setFirebaseApnTemplate(@Nullable String firebaseApnTemplate) {
            this.firebaseApnTemplate = firebaseApnTemplate;
        }

        @JsonProperty(value="huawei_app_id")
        public void setHuaweiAppId(@Nullable String huaweiAppId) {
            this.huaweiAppId = huaweiAppId;
        }

        @JsonProperty(value="huawei_app_secret")
        public void setHuaweiAppSecret(@Nullable String huaweiAppSecret) {
            this.huaweiAppSecret = huaweiAppSecret;
        }

        @JsonProperty(value="xiaomi_package_name")
        public void setXiaomiPackageName(@Nullable String xiaomiPackageName) {
            this.xiaomiPackageName = xiaomiPackageName;
        }

        @JsonProperty(value="xiaomi_app_secret")
        public void setXiaomiAppSecret(@Nullable String xiaomiAppSecret) {
            this.xiaomiAppSecret = xiaomiAppSecret;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@Nullable Date createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@Nullable Date updatedAt) {
            this.updatedAt = updatedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PushProvider)) {
                return false;
            }
            PushProvider other = (PushProvider)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            PushProviderType this$type = this.getType();
            PushProviderType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Date this$disabledAt = this.getDisabledAt();
            Date other$disabledAt = other.getDisabledAt();
            if (this$disabledAt == null ? other$disabledAt != null : !((Object)this$disabledAt).equals(other$disabledAt)) {
                return false;
            }
            String this$disabledReason = this.getDisabledReason();
            String other$disabledReason = other.getDisabledReason();
            if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                return false;
            }
            String this$apnAuthKey = this.getApnAuthKey();
            String other$apnAuthKey = other.getApnAuthKey();
            if (this$apnAuthKey == null ? other$apnAuthKey != null : !this$apnAuthKey.equals(other$apnAuthKey)) {
                return false;
            }
            String this$apnKeyId = this.getApnKeyId();
            String other$apnKeyId = other.getApnKeyId();
            if (this$apnKeyId == null ? other$apnKeyId != null : !this$apnKeyId.equals(other$apnKeyId)) {
                return false;
            }
            String this$apnTeamId = this.getApnTeamId();
            String other$apnTeamId = other.getApnTeamId();
            if (this$apnTeamId == null ? other$apnTeamId != null : !this$apnTeamId.equals(other$apnTeamId)) {
                return false;
            }
            String this$apnTopic = this.getApnTopic();
            String other$apnTopic = other.getApnTopic();
            if (this$apnTopic == null ? other$apnTopic != null : !this$apnTopic.equals(other$apnTopic)) {
                return false;
            }
            String this$firebaseCredentials = this.getFirebaseCredentials();
            String other$firebaseCredentials = other.getFirebaseCredentials();
            if (this$firebaseCredentials == null ? other$firebaseCredentials != null : !this$firebaseCredentials.equals(other$firebaseCredentials)) {
                return false;
            }
            String this$firebaseApnTemplate = this.getFirebaseApnTemplate();
            String other$firebaseApnTemplate = other.getFirebaseApnTemplate();
            if (this$firebaseApnTemplate == null ? other$firebaseApnTemplate != null : !this$firebaseApnTemplate.equals(other$firebaseApnTemplate)) {
                return false;
            }
            String this$huaweiAppId = this.getHuaweiAppId();
            String other$huaweiAppId = other.getHuaweiAppId();
            if (this$huaweiAppId == null ? other$huaweiAppId != null : !this$huaweiAppId.equals(other$huaweiAppId)) {
                return false;
            }
            String this$huaweiAppSecret = this.getHuaweiAppSecret();
            String other$huaweiAppSecret = other.getHuaweiAppSecret();
            if (this$huaweiAppSecret == null ? other$huaweiAppSecret != null : !this$huaweiAppSecret.equals(other$huaweiAppSecret)) {
                return false;
            }
            String this$xiaomiPackageName = this.getXiaomiPackageName();
            String other$xiaomiPackageName = other.getXiaomiPackageName();
            if (this$xiaomiPackageName == null ? other$xiaomiPackageName != null : !this$xiaomiPackageName.equals(other$xiaomiPackageName)) {
                return false;
            }
            String this$xiaomiAppSecret = this.getXiaomiAppSecret();
            String other$xiaomiAppSecret = other.getXiaomiAppSecret();
            if (this$xiaomiAppSecret == null ? other$xiaomiAppSecret != null : !this$xiaomiAppSecret.equals(other$xiaomiAppSecret)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PushProvider;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            PushProviderType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Date $disabledAt = this.getDisabledAt();
            result = result * 59 + ($disabledAt == null ? 43 : ((Object)$disabledAt).hashCode());
            String $disabledReason = this.getDisabledReason();
            result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
            String $apnAuthKey = this.getApnAuthKey();
            result = result * 59 + ($apnAuthKey == null ? 43 : $apnAuthKey.hashCode());
            String $apnKeyId = this.getApnKeyId();
            result = result * 59 + ($apnKeyId == null ? 43 : $apnKeyId.hashCode());
            String $apnTeamId = this.getApnTeamId();
            result = result * 59 + ($apnTeamId == null ? 43 : $apnTeamId.hashCode());
            String $apnTopic = this.getApnTopic();
            result = result * 59 + ($apnTopic == null ? 43 : $apnTopic.hashCode());
            String $firebaseCredentials = this.getFirebaseCredentials();
            result = result * 59 + ($firebaseCredentials == null ? 43 : $firebaseCredentials.hashCode());
            String $firebaseApnTemplate = this.getFirebaseApnTemplate();
            result = result * 59 + ($firebaseApnTemplate == null ? 43 : $firebaseApnTemplate.hashCode());
            String $huaweiAppId = this.getHuaweiAppId();
            result = result * 59 + ($huaweiAppId == null ? 43 : $huaweiAppId.hashCode());
            String $huaweiAppSecret = this.getHuaweiAppSecret();
            result = result * 59 + ($huaweiAppSecret == null ? 43 : $huaweiAppSecret.hashCode());
            String $xiaomiPackageName = this.getXiaomiPackageName();
            result = result * 59 + ($xiaomiPackageName == null ? 43 : $xiaomiPackageName.hashCode());
            String $xiaomiAppSecret = this.getXiaomiAppSecret();
            result = result * 59 + ($xiaomiAppSecret == null ? 43 : $xiaomiAppSecret.hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            return result;
        }

        public String toString() {
            return "App.PushProvider(name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", disabledAt=" + this.getDisabledAt() + ", disabledReason=" + this.getDisabledReason() + ", apnAuthKey=" + this.getApnAuthKey() + ", apnKeyId=" + this.getApnKeyId() + ", apnTeamId=" + this.getApnTeamId() + ", apnTopic=" + this.getApnTopic() + ", firebaseCredentials=" + this.getFirebaseCredentials() + ", firebaseApnTemplate=" + this.getFirebaseApnTemplate() + ", huaweiAppId=" + this.getHuaweiAppId() + ", huaweiAppSecret=" + this.getHuaweiAppSecret() + ", xiaomiPackageName=" + this.getXiaomiPackageName() + ", xiaomiAppSecret=" + this.getXiaomiAppSecret() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
        }
    }

    public static class PushConfigRequestObject {
        @JsonProperty(value="version")
        @Nullable
        private PushVersion version;
        @JsonProperty(value="offline_only")
        @Nullable
        private Boolean offlineOnly;

        @Nullable
        public static PushConfigRequestObject buildFrom(@Nullable PushVersion pushVersion) {
            return PushConfigRequestObject.builder().version(pushVersion).build();
        }

        PushConfigRequestObject(@Nullable PushVersion version, @Nullable Boolean offlineOnly) {
            this.version = version;
            this.offlineOnly = offlineOnly;
        }

        public static PushConfigRequestObjectBuilder builder() {
            return new PushConfigRequestObjectBuilder();
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable PushVersion version) {
            this.version = version;
        }

        @JsonProperty(value="offline_only")
        public void setOfflineOnly(@Nullable Boolean offlineOnly) {
            this.offlineOnly = offlineOnly;
        }

        public static class PushConfigRequestObjectBuilder {
            private PushVersion version;
            private Boolean offlineOnly;

            PushConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="version")
            public PushConfigRequestObjectBuilder version(@Nullable PushVersion version) {
                this.version = version;
                return this;
            }

            @JsonProperty(value="offline_only")
            public PushConfigRequestObjectBuilder offlineOnly(@Nullable Boolean offlineOnly) {
                this.offlineOnly = offlineOnly;
                return this;
            }

            public PushConfigRequestObject build() {
                return new PushConfigRequestObject(this.version, this.offlineOnly);
            }

            public String toString() {
                return "App.PushConfigRequestObject.PushConfigRequestObjectBuilder(version=" + this.version + ", offlineOnly=" + this.offlineOnly + ")";
            }
        }
    }

    public static class HuaweiConfigRequestObject {
        @JsonProperty(value="id")
        @Nullable
        private String id;
        @JsonProperty(value="secret")
        @Nullable
        private String secret;

        HuaweiConfigRequestObject(@Nullable String id, @Nullable String secret) {
            this.id = id;
            this.secret = secret;
        }

        public static HuaweiConfigRequestObjectBuilder builder() {
            return new HuaweiConfigRequestObjectBuilder();
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="secret")
        public void setSecret(@Nullable String secret) {
            this.secret = secret;
        }

        public static class HuaweiConfigRequestObjectBuilder {
            private String id;
            private String secret;

            HuaweiConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="id")
            public HuaweiConfigRequestObjectBuilder id(@Nullable String id) {
                this.id = id;
                return this;
            }

            @JsonProperty(value="secret")
            public HuaweiConfigRequestObjectBuilder secret(@Nullable String secret) {
                this.secret = secret;
                return this;
            }

            public HuaweiConfigRequestObject build() {
                return new HuaweiConfigRequestObject(this.id, this.secret);
            }

            public String toString() {
                return "App.HuaweiConfigRequestObject.HuaweiConfigRequestObjectBuilder(id=" + this.id + ", secret=" + this.secret + ")";
            }
        }
    }

    public static class FirebaseConfigRequestObject {
        @JsonProperty(value="server_key")
        @Nullable
        private String serverKey;
        @JsonProperty(value="credentials_json")
        @Nullable
        private String credentialsJson;
        @JsonProperty(value="notification_template")
        @Nullable
        private String notificationTemplate;
        @JsonProperty(value="data_template")
        @Nullable
        private String dataTemplate;
        @JsonProperty(value="apn_template")
        @Nullable
        private String apnTemplate;

        @Nullable
        public static FirebaseConfigRequestObject buildFrom(@Nullable FirebaseConfig firebaseConfig) {
            return RequestObjectBuilder.build(FirebaseConfigRequestObject.class, firebaseConfig);
        }

        FirebaseConfigRequestObject(@Nullable String serverKey, @Nullable String credentialsJson, @Nullable String notificationTemplate, @Nullable String dataTemplate, @Nullable String apnTemplate) {
            this.serverKey = serverKey;
            this.credentialsJson = credentialsJson;
            this.notificationTemplate = notificationTemplate;
            this.dataTemplate = dataTemplate;
            this.apnTemplate = apnTemplate;
        }

        public static FirebaseConfigRequestObjectBuilder builder() {
            return new FirebaseConfigRequestObjectBuilder();
        }

        @JsonProperty(value="server_key")
        public void setServerKey(@Nullable String serverKey) {
            this.serverKey = serverKey;
        }

        @JsonProperty(value="credentials_json")
        public void setCredentialsJson(@Nullable String credentialsJson) {
            this.credentialsJson = credentialsJson;
        }

        @JsonProperty(value="notification_template")
        public void setNotificationTemplate(@Nullable String notificationTemplate) {
            this.notificationTemplate = notificationTemplate;
        }

        @JsonProperty(value="data_template")
        public void setDataTemplate(@Nullable String dataTemplate) {
            this.dataTemplate = dataTemplate;
        }

        @JsonProperty(value="apn_template")
        public void setApnTemplate(@Nullable String apnTemplate) {
            this.apnTemplate = apnTemplate;
        }

        public static class FirebaseConfigRequestObjectBuilder {
            private String serverKey;
            private String credentialsJson;
            private String notificationTemplate;
            private String dataTemplate;
            private String apnTemplate;

            FirebaseConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="server_key")
            public FirebaseConfigRequestObjectBuilder serverKey(@Nullable String serverKey) {
                this.serverKey = serverKey;
                return this;
            }

            @JsonProperty(value="credentials_json")
            public FirebaseConfigRequestObjectBuilder credentialsJson(@Nullable String credentialsJson) {
                this.credentialsJson = credentialsJson;
                return this;
            }

            @JsonProperty(value="notification_template")
            public FirebaseConfigRequestObjectBuilder notificationTemplate(@Nullable String notificationTemplate) {
                this.notificationTemplate = notificationTemplate;
                return this;
            }

            @JsonProperty(value="data_template")
            public FirebaseConfigRequestObjectBuilder dataTemplate(@Nullable String dataTemplate) {
                this.dataTemplate = dataTemplate;
                return this;
            }

            @JsonProperty(value="apn_template")
            public FirebaseConfigRequestObjectBuilder apnTemplate(@Nullable String apnTemplate) {
                this.apnTemplate = apnTemplate;
                return this;
            }

            public FirebaseConfigRequestObject build() {
                return new FirebaseConfigRequestObject(this.serverKey, this.credentialsJson, this.notificationTemplate, this.dataTemplate, this.apnTemplate);
            }

            public String toString() {
                return "App.FirebaseConfigRequestObject.FirebaseConfigRequestObjectBuilder(serverKey=" + this.serverKey + ", credentialsJson=" + this.credentialsJson + ", notificationTemplate=" + this.notificationTemplate + ", dataTemplate=" + this.dataTemplate + ", apnTemplate=" + this.apnTemplate + ")";
            }
        }
    }

    public static class APNConfigRequestObject {
        @JsonProperty(value="development")
        @Nullable
        private Boolean development;
        @JsonProperty(value="auth_type")
        @Nullable
        private AuthenticationType authType;
        @JsonProperty(value="auth_key")
        @Nullable
        private byte[] authKey;
        @JsonProperty(value="notification_template")
        @Nullable
        private String notificationTemplate;
        @JsonProperty(value="host")
        @Nullable
        private String host;
        @JsonProperty(value="bundle_Id")
        @Nullable
        private String bundleId;
        @JsonProperty(value="team_Id")
        @Nullable
        private String teamId;
        @JsonProperty(value="key_Id")
        @Nullable
        private String keyId;
        @JsonProperty(value="p12_cert")
        @Nullable
        private String p12Cert;

        @Nullable
        public static APNConfigRequestObject buildFrom(@Nullable APNConfig aPNConfig) {
            return RequestObjectBuilder.build(APNConfigRequestObject.class, aPNConfig);
        }

        APNConfigRequestObject(@Nullable Boolean development, @Nullable AuthenticationType authType, @Nullable byte[] authKey, @Nullable String notificationTemplate, @Nullable String host, @Nullable String bundleId, @Nullable String teamId, @Nullable String keyId, @Nullable String p12Cert) {
            this.development = development;
            this.authType = authType;
            this.authKey = authKey;
            this.notificationTemplate = notificationTemplate;
            this.host = host;
            this.bundleId = bundleId;
            this.teamId = teamId;
            this.keyId = keyId;
            this.p12Cert = p12Cert;
        }

        public static APNConfigRequestObjectBuilder builder() {
            return new APNConfigRequestObjectBuilder();
        }

        @JsonProperty(value="development")
        public void setDevelopment(@Nullable Boolean development) {
            this.development = development;
        }

        @JsonProperty(value="auth_type")
        public void setAuthType(@Nullable AuthenticationType authType) {
            this.authType = authType;
        }

        @JsonProperty(value="auth_key")
        public void setAuthKey(@Nullable byte[] authKey) {
            this.authKey = authKey;
        }

        @JsonProperty(value="notification_template")
        public void setNotificationTemplate(@Nullable String notificationTemplate) {
            this.notificationTemplate = notificationTemplate;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="bundle_Id")
        public void setBundleId(@Nullable String bundleId) {
            this.bundleId = bundleId;
        }

        @JsonProperty(value="team_Id")
        public void setTeamId(@Nullable String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="key_Id")
        public void setKeyId(@Nullable String keyId) {
            this.keyId = keyId;
        }

        @JsonProperty(value="p12_cert")
        public void setP12Cert(@Nullable String p12Cert) {
            this.p12Cert = p12Cert;
        }

        public static class APNConfigRequestObjectBuilder {
            private Boolean development;
            private AuthenticationType authType;
            private byte[] authKey;
            private String notificationTemplate;
            private String host;
            private String bundleId;
            private String teamId;
            private String keyId;
            private String p12Cert;

            APNConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="development")
            public APNConfigRequestObjectBuilder development(@Nullable Boolean development) {
                this.development = development;
                return this;
            }

            @JsonProperty(value="auth_type")
            public APNConfigRequestObjectBuilder authType(@Nullable AuthenticationType authType) {
                this.authType = authType;
                return this;
            }

            @JsonProperty(value="auth_key")
            public APNConfigRequestObjectBuilder authKey(@Nullable byte[] authKey) {
                this.authKey = authKey;
                return this;
            }

            @JsonProperty(value="notification_template")
            public APNConfigRequestObjectBuilder notificationTemplate(@Nullable String notificationTemplate) {
                this.notificationTemplate = notificationTemplate;
                return this;
            }

            @JsonProperty(value="host")
            public APNConfigRequestObjectBuilder host(@Nullable String host) {
                this.host = host;
                return this;
            }

            @JsonProperty(value="bundle_Id")
            public APNConfigRequestObjectBuilder bundleId(@Nullable String bundleId) {
                this.bundleId = bundleId;
                return this;
            }

            @JsonProperty(value="team_Id")
            public APNConfigRequestObjectBuilder teamId(@Nullable String teamId) {
                this.teamId = teamId;
                return this;
            }

            @JsonProperty(value="key_Id")
            public APNConfigRequestObjectBuilder keyId(@Nullable String keyId) {
                this.keyId = keyId;
                return this;
            }

            @JsonProperty(value="p12_cert")
            public APNConfigRequestObjectBuilder p12Cert(@Nullable String p12Cert) {
                this.p12Cert = p12Cert;
                return this;
            }

            public APNConfigRequestObject build() {
                return new APNConfigRequestObject(this.development, this.authType, this.authKey, this.notificationTemplate, this.host, this.bundleId, this.teamId, this.keyId, this.p12Cert);
            }

            public String toString() {
                return "App.APNConfigRequestObject.APNConfigRequestObjectBuilder(development=" + this.development + ", authType=" + this.authType + ", authKey=" + Arrays.toString(this.authKey) + ", notificationTemplate=" + this.notificationTemplate + ", host=" + this.host + ", bundleId=" + this.bundleId + ", teamId=" + this.teamId + ", keyId=" + this.keyId + ", p12Cert=" + this.p12Cert + ")";
            }
        }
    }

    public static class FileUploadConfigRequestObject {
        @JsonProperty(value="allowed_file_extensions")
        @Nullable
        private List<String> allowedFileExtensions;
        @JsonProperty(value="blocked_file_extensions")
        @Nullable
        private List<String> blockedFileExtensions;
        @JsonProperty(value="allowed_mime_types")
        @Nullable
        private List<String> allowedMimeTypes;
        @JsonProperty(value="blocked_mime_types")
        @Nullable
        private List<String> blockedMimeTypes;

        @Nullable
        public static FileUploadConfigRequestObject buildFrom(@Nullable FileUploadConfig fileUploadConfig) {
            return RequestObjectBuilder.build(FileUploadConfigRequestObject.class, fileUploadConfig);
        }

        FileUploadConfigRequestObject(@Nullable List<String> allowedFileExtensions, @Nullable List<String> blockedFileExtensions, @Nullable List<String> allowedMimeTypes, @Nullable List<String> blockedMimeTypes) {
            this.allowedFileExtensions = allowedFileExtensions;
            this.blockedFileExtensions = blockedFileExtensions;
            this.allowedMimeTypes = allowedMimeTypes;
            this.blockedMimeTypes = blockedMimeTypes;
        }

        public static FileUploadConfigRequestObjectBuilder builder() {
            return new FileUploadConfigRequestObjectBuilder();
        }

        @JsonProperty(value="allowed_file_extensions")
        public void setAllowedFileExtensions(@Nullable List<String> allowedFileExtensions) {
            this.allowedFileExtensions = allowedFileExtensions;
        }

        @JsonProperty(value="blocked_file_extensions")
        public void setBlockedFileExtensions(@Nullable List<String> blockedFileExtensions) {
            this.blockedFileExtensions = blockedFileExtensions;
        }

        @JsonProperty(value="allowed_mime_types")
        public void setAllowedMimeTypes(@Nullable List<String> allowedMimeTypes) {
            this.allowedMimeTypes = allowedMimeTypes;
        }

        @JsonProperty(value="blocked_mime_types")
        public void setBlockedMimeTypes(@Nullable List<String> blockedMimeTypes) {
            this.blockedMimeTypes = blockedMimeTypes;
        }

        public static class FileUploadConfigRequestObjectBuilder {
            private List<String> allowedFileExtensions;
            private List<String> blockedFileExtensions;
            private List<String> allowedMimeTypes;
            private List<String> blockedMimeTypes;

            FileUploadConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="allowed_file_extensions")
            public FileUploadConfigRequestObjectBuilder allowedFileExtensions(@Nullable List<String> allowedFileExtensions) {
                this.allowedFileExtensions = allowedFileExtensions;
                return this;
            }

            @JsonProperty(value="blocked_file_extensions")
            public FileUploadConfigRequestObjectBuilder blockedFileExtensions(@Nullable List<String> blockedFileExtensions) {
                this.blockedFileExtensions = blockedFileExtensions;
                return this;
            }

            @JsonProperty(value="allowed_mime_types")
            public FileUploadConfigRequestObjectBuilder allowedMimeTypes(@Nullable List<String> allowedMimeTypes) {
                this.allowedMimeTypes = allowedMimeTypes;
                return this;
            }

            @JsonProperty(value="blocked_mime_types")
            public FileUploadConfigRequestObjectBuilder blockedMimeTypes(@Nullable List<String> blockedMimeTypes) {
                this.blockedMimeTypes = blockedMimeTypes;
                return this;
            }

            public FileUploadConfigRequestObject build() {
                return new FileUploadConfigRequestObject(this.allowedFileExtensions, this.blockedFileExtensions, this.allowedMimeTypes, this.blockedMimeTypes);
            }

            public String toString() {
                return "App.FileUploadConfigRequestObject.FileUploadConfigRequestObjectBuilder(allowedFileExtensions=" + this.allowedFileExtensions + ", blockedFileExtensions=" + this.blockedFileExtensions + ", allowedMimeTypes=" + this.allowedMimeTypes + ", blockedMimeTypes=" + this.blockedMimeTypes + ")";
            }
        }
    }

    public static class AsyncModerationConfigRequestObject {
        @JsonProperty(value="callback")
        @Nullable
        private AsyncModerationCallback callback;
        @JsonProperty(value="timeout_ms")
        @Nullable
        private Number timeoutMs;

        AsyncModerationConfigRequestObject(@Nullable AsyncModerationCallback callback, @Nullable Number timeoutMs) {
            this.callback = callback;
            this.timeoutMs = timeoutMs;
        }

        public static AsyncModerationConfigRequestObjectBuilder builder() {
            return new AsyncModerationConfigRequestObjectBuilder();
        }

        @JsonProperty(value="callback")
        public void setCallback(@Nullable AsyncModerationCallback callback) {
            this.callback = callback;
        }

        @JsonProperty(value="timeout_ms")
        public void setTimeoutMs(@Nullable Number timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public static class AsyncModerationConfigRequestObjectBuilder {
            private AsyncModerationCallback callback;
            private Number timeoutMs;

            AsyncModerationConfigRequestObjectBuilder() {
            }

            @JsonProperty(value="callback")
            public AsyncModerationConfigRequestObjectBuilder callback(@Nullable AsyncModerationCallback callback) {
                this.callback = callback;
                return this;
            }

            @JsonProperty(value="timeout_ms")
            public AsyncModerationConfigRequestObjectBuilder timeoutMs(@Nullable Number timeoutMs) {
                this.timeoutMs = timeoutMs;
                return this;
            }

            public AsyncModerationConfigRequestObject build() {
                return new AsyncModerationConfigRequestObject(this.callback, this.timeoutMs);
            }

            public String toString() {
                return "App.AsyncModerationConfigRequestObject.AsyncModerationConfigRequestObjectBuilder(callback=" + this.callback + ", timeoutMs=" + this.timeoutMs + ")";
            }
        }
    }

    public static class AsyncModerationCallback {
        @JsonProperty(value="mode")
        @Nullable
        private String mode;
        @JsonProperty(value="server_url")
        @Nullable
        private String serverUrl;

        AsyncModerationCallback(@Nullable String mode, @Nullable String serverUrl) {
            this.mode = mode;
            this.serverUrl = serverUrl;
        }

        public static AsyncModerationCallbackBuilder builder() {
            return new AsyncModerationCallbackBuilder();
        }

        @JsonProperty(value="mode")
        public void setMode(@Nullable String mode) {
            this.mode = mode;
        }

        @JsonProperty(value="server_url")
        public void setServerUrl(@Nullable String serverUrl) {
            this.serverUrl = serverUrl;
        }

        public static class AsyncModerationCallbackBuilder {
            private String mode;
            private String serverUrl;

            AsyncModerationCallbackBuilder() {
            }

            @JsonProperty(value="mode")
            public AsyncModerationCallbackBuilder mode(@Nullable String mode) {
                this.mode = mode;
                return this;
            }

            @JsonProperty(value="server_url")
            public AsyncModerationCallbackBuilder serverUrl(@Nullable String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            public AsyncModerationCallback build() {
                return new AsyncModerationCallback(this.mode, this.serverUrl);
            }

            public String toString() {
                return "App.AsyncModerationCallback.AsyncModerationCallbackBuilder(mode=" + this.mode + ", serverUrl=" + this.serverUrl + ")";
            }
        }
    }

    public static class DeviceError {
        @JsonProperty(value="provider")
        @NotNull
        private String provider;
        @JsonProperty(value="provider_name")
        @NotNull
        private String providerName;
        @JsonProperty(value="error_message")
        @NotNull
        private String errorMessage;

        @NotNull
        public String getProvider() {
            return this.provider;
        }

        @NotNull
        public String getProviderName() {
            return this.providerName;
        }

        @NotNull
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @JsonProperty(value="provider")
        public void setProvider(@NotNull String provider) {
            if (provider == null) {
                throw new NullPointerException("provider is marked non-null but is null");
            }
            this.provider = provider;
        }

        @JsonProperty(value="provider_name")
        public void setProviderName(@NotNull String providerName) {
            if (providerName == null) {
                throw new NullPointerException("providerName is marked non-null but is null");
            }
            this.providerName = providerName;
        }

        @JsonProperty(value="error_message")
        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new NullPointerException("errorMessage is marked non-null but is null");
            }
            this.errorMessage = errorMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeviceError)) {
                return false;
            }
            DeviceError other = (DeviceError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$provider = this.getProvider();
            String other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            String this$providerName = this.getProviderName();
            String other$providerName = other.getProviderName();
            if (this$providerName == null ? other$providerName != null : !this$providerName.equals(other$providerName)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DeviceError;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            String $providerName = this.getProviderName();
            result = result * 59 + ($providerName == null ? 43 : $providerName.hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        public String toString() {
            return "App.DeviceError(provider=" + this.getProvider() + ", providerName=" + this.getProviderName() + ", errorMessage=" + this.getErrorMessage() + ")";
        }
    }

    public static class FileUploadConfig {
        @JsonProperty(value="allowed_file_extensions")
        @Nullable
        private List<String> allowedFileExtensions;
        @JsonProperty(value="blocked_file_extensions")
        @Nullable
        private List<String> blockedFileExtensions;
        @JsonProperty(value="allowed_mime_types")
        @Nullable
        private List<String> allowedMimeTypes;
        @JsonProperty(value="blocked_mime_types")
        @Nullable
        private List<String> blockedMimeTypes;

        @Nullable
        public List<String> getAllowedFileExtensions() {
            return this.allowedFileExtensions;
        }

        @Nullable
        public List<String> getBlockedFileExtensions() {
            return this.blockedFileExtensions;
        }

        @Nullable
        public List<String> getAllowedMimeTypes() {
            return this.allowedMimeTypes;
        }

        @Nullable
        public List<String> getBlockedMimeTypes() {
            return this.blockedMimeTypes;
        }

        @JsonProperty(value="allowed_file_extensions")
        public void setAllowedFileExtensions(@Nullable List<String> allowedFileExtensions) {
            this.allowedFileExtensions = allowedFileExtensions;
        }

        @JsonProperty(value="blocked_file_extensions")
        public void setBlockedFileExtensions(@Nullable List<String> blockedFileExtensions) {
            this.blockedFileExtensions = blockedFileExtensions;
        }

        @JsonProperty(value="allowed_mime_types")
        public void setAllowedMimeTypes(@Nullable List<String> allowedMimeTypes) {
            this.allowedMimeTypes = allowedMimeTypes;
        }

        @JsonProperty(value="blocked_mime_types")
        public void setBlockedMimeTypes(@Nullable List<String> blockedMimeTypes) {
            this.blockedMimeTypes = blockedMimeTypes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileUploadConfig)) {
                return false;
            }
            FileUploadConfig other = (FileUploadConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$allowedFileExtensions = this.getAllowedFileExtensions();
            List<String> other$allowedFileExtensions = other.getAllowedFileExtensions();
            if (this$allowedFileExtensions == null ? other$allowedFileExtensions != null : !((Object)this$allowedFileExtensions).equals(other$allowedFileExtensions)) {
                return false;
            }
            List<String> this$blockedFileExtensions = this.getBlockedFileExtensions();
            List<String> other$blockedFileExtensions = other.getBlockedFileExtensions();
            if (this$blockedFileExtensions == null ? other$blockedFileExtensions != null : !((Object)this$blockedFileExtensions).equals(other$blockedFileExtensions)) {
                return false;
            }
            List<String> this$allowedMimeTypes = this.getAllowedMimeTypes();
            List<String> other$allowedMimeTypes = other.getAllowedMimeTypes();
            if (this$allowedMimeTypes == null ? other$allowedMimeTypes != null : !((Object)this$allowedMimeTypes).equals(other$allowedMimeTypes)) {
                return false;
            }
            List<String> this$blockedMimeTypes = this.getBlockedMimeTypes();
            List<String> other$blockedMimeTypes = other.getBlockedMimeTypes();
            return !(this$blockedMimeTypes == null ? other$blockedMimeTypes != null : !((Object)this$blockedMimeTypes).equals(other$blockedMimeTypes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileUploadConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $allowedFileExtensions = this.getAllowedFileExtensions();
            result = result * 59 + ($allowedFileExtensions == null ? 43 : ((Object)$allowedFileExtensions).hashCode());
            List<String> $blockedFileExtensions = this.getBlockedFileExtensions();
            result = result * 59 + ($blockedFileExtensions == null ? 43 : ((Object)$blockedFileExtensions).hashCode());
            List<String> $allowedMimeTypes = this.getAllowedMimeTypes();
            result = result * 59 + ($allowedMimeTypes == null ? 43 : ((Object)$allowedMimeTypes).hashCode());
            List<String> $blockedMimeTypes = this.getBlockedMimeTypes();
            result = result * 59 + ($blockedMimeTypes == null ? 43 : ((Object)$blockedMimeTypes).hashCode());
            return result;
        }

        public String toString() {
            return "App.FileUploadConfig(allowedFileExtensions=" + this.getAllowedFileExtensions() + ", blockedFileExtensions=" + this.getBlockedFileExtensions() + ", allowedMimeTypes=" + this.getAllowedMimeTypes() + ", blockedMimeTypes=" + this.getBlockedMimeTypes() + ")";
        }
    }

    public static class EnforceUniqueUsernamesDeserializer
    extends JsonDeserializer<EnforceUniqueUsernames> {
        public EnforceUniqueUsernames deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            String jsonString = (String)jsonParser.readValueAs(String.class);
            if (jsonString == null || jsonString.equals("")) {
                return null;
            }
            for (EnforceUniqueUsernames enumValue : EnforceUniqueUsernames.values()) {
                try {
                    if (!jsonString.equals(EnforceUniqueUsernames.class.getField(enumValue.name()).getAnnotation(JsonProperty.class).value())) continue;
                    return enumValue;
                }
                catch (NoSuchFieldException | SecurityException e) {
                    throw deserializationContext.instantiationException(EnforceUniqueUsernames.class, "Should not happen");
                }
            }
            throw deserializationContext.instantiationException(EnforceUniqueUsernames.class, "Unparseable value for EnforceUniqueUsernames: " + jsonString);
        }
    }

    public static enum EnforceUniqueUsernames {
        NO,
        APP,
        TEAM,
        UNKNOWN;

    }

    public static enum AuthenticationType {
        CERTIFICATE,
        TOKEN,
        UNKNOWN;

    }

    public static enum PushVersion {
        V1,
        V2,
        UNKNOWN;

    }

    public static enum PermissionVersion {
        V1,
        V2,
        UNKNOWN;

    }

    public static class Policy {
        @JsonProperty(value="name")
        @NotNull
        private String name;
        @JsonProperty(value="roles")
        @Nullable
        private List<String> roles;
        @JsonProperty(value="action")
        @NotNull
        private Integer action;
        @JsonProperty(value="owner")
        @NotNull
        private Boolean owner;
        @JsonProperty(value="priority")
        @NotNull
        private Integer priority;
        @JsonProperty(value="created_at")
        @NotNull
        private Date createdAt;
        @JsonProperty(value="updated_at")
        @NotNull
        private Date updatedAt;

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public List<String> getRoles() {
            return this.roles;
        }

        @NotNull
        public Integer getAction() {
            return this.action;
        }

        @NotNull
        public Boolean getOwner() {
            return this.owner;
        }

        @NotNull
        public Integer getPriority() {
            return this.priority;
        }

        @NotNull
        public Date getCreatedAt() {
            return this.createdAt;
        }

        @NotNull
        public Date getUpdatedAt() {
            return this.updatedAt;
        }

        @JsonProperty(value="name")
        public void setName(@NotNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
        }

        @JsonProperty(value="roles")
        public void setRoles(@Nullable List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="action")
        public void setAction(@NotNull Integer action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
        }

        @JsonProperty(value="owner")
        public void setOwner(@NotNull Boolean owner) {
            if (owner == null) {
                throw new NullPointerException("owner is marked non-null but is null");
            }
            this.owner = owner;
        }

        @JsonProperty(value="priority")
        public void setPriority(@NotNull Integer priority) {
            if (priority == null) {
                throw new NullPointerException("priority is marked non-null but is null");
            }
            this.priority = priority;
        }

        @JsonProperty(value="created_at")
        public void setCreatedAt(@NotNull Date createdAt) {
            if (createdAt == null) {
                throw new NullPointerException("createdAt is marked non-null but is null");
            }
            this.createdAt = createdAt;
        }

        @JsonProperty(value="updated_at")
        public void setUpdatedAt(@NotNull Date updatedAt) {
            if (updatedAt == null) {
                throw new NullPointerException("updatedAt is marked non-null but is null");
            }
            this.updatedAt = updatedAt;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Policy)) {
                return false;
            }
            Policy other = (Policy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$action = this.getAction();
            Integer other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
                return false;
            }
            Boolean this$owner = this.getOwner();
            Boolean other$owner = other.getOwner();
            if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
                return false;
            }
            Integer this$priority = this.getPriority();
            Integer other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<String> this$roles = this.getRoles();
            List<String> other$roles = other.getRoles();
            if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
                return false;
            }
            Date this$createdAt = this.getCreatedAt();
            Date other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            Date this$updatedAt = this.getUpdatedAt();
            Date other$updatedAt = other.getUpdatedAt();
            return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Policy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
            Boolean $owner = this.getOwner();
            result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
            Integer $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<String> $roles = this.getRoles();
            result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
            Date $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            Date $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            return result;
        }

        public String toString() {
            return "App.Policy(name=" + this.getName() + ", roles=" + this.getRoles() + ", action=" + this.getAction() + ", owner=" + this.getOwner() + ", priority=" + this.getPriority() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ")";
        }
    }

    public static class PushNotificationFields {
        @JsonProperty(value="version")
        @NotNull
        private PushVersion version;
        @JsonProperty(value="offline_only")
        @NotNull
        private Boolean offlineOnly;
        @JsonProperty(value="apn")
        @NotNull
        private APNConfig aPNConfig;
        @JsonProperty(value="firebase")
        @NotNull
        private FirebaseConfig firebaseConfig;
        @JsonProperty(value="huawei")
        @NotNull
        private HuaweiConfig huaweiConfig;
        @JsonProperty(value="providers")
        @NotNull
        private List<PushProvider> providers;

        @NotNull
        public PushVersion getVersion() {
            return this.version;
        }

        @NotNull
        public Boolean getOfflineOnly() {
            return this.offlineOnly;
        }

        @NotNull
        public APNConfig getAPNConfig() {
            return this.aPNConfig;
        }

        @NotNull
        public FirebaseConfig getFirebaseConfig() {
            return this.firebaseConfig;
        }

        @NotNull
        public HuaweiConfig getHuaweiConfig() {
            return this.huaweiConfig;
        }

        @NotNull
        public List<PushProvider> getProviders() {
            return this.providers;
        }

        @JsonProperty(value="version")
        public void setVersion(@NotNull PushVersion version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.version = version;
        }

        @JsonProperty(value="offline_only")
        public void setOfflineOnly(@NotNull Boolean offlineOnly) {
            if (offlineOnly == null) {
                throw new NullPointerException("offlineOnly is marked non-null but is null");
            }
            this.offlineOnly = offlineOnly;
        }

        @JsonProperty(value="apn")
        public void setAPNConfig(@NotNull APNConfig aPNConfig) {
            if (aPNConfig == null) {
                throw new NullPointerException("aPNConfig is marked non-null but is null");
            }
            this.aPNConfig = aPNConfig;
        }

        @JsonProperty(value="firebase")
        public void setFirebaseConfig(@NotNull FirebaseConfig firebaseConfig) {
            if (firebaseConfig == null) {
                throw new NullPointerException("firebaseConfig is marked non-null but is null");
            }
            this.firebaseConfig = firebaseConfig;
        }

        @JsonProperty(value="huawei")
        public void setHuaweiConfig(@NotNull HuaweiConfig huaweiConfig) {
            if (huaweiConfig == null) {
                throw new NullPointerException("huaweiConfig is marked non-null but is null");
            }
            this.huaweiConfig = huaweiConfig;
        }

        @JsonProperty(value="providers")
        public void setProviders(@NotNull List<PushProvider> providers) {
            if (providers == null) {
                throw new NullPointerException("providers is marked non-null but is null");
            }
            this.providers = providers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PushNotificationFields)) {
                return false;
            }
            PushNotificationFields other = (PushNotificationFields)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$offlineOnly = this.getOfflineOnly();
            Boolean other$offlineOnly = other.getOfflineOnly();
            if (this$offlineOnly == null ? other$offlineOnly != null : !((Object)this$offlineOnly).equals(other$offlineOnly)) {
                return false;
            }
            PushVersion this$version = this.getVersion();
            PushVersion other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
                return false;
            }
            APNConfig this$aPNConfig = this.getAPNConfig();
            APNConfig other$aPNConfig = other.getAPNConfig();
            if (this$aPNConfig == null ? other$aPNConfig != null : !((Object)this$aPNConfig).equals(other$aPNConfig)) {
                return false;
            }
            FirebaseConfig this$firebaseConfig = this.getFirebaseConfig();
            FirebaseConfig other$firebaseConfig = other.getFirebaseConfig();
            if (this$firebaseConfig == null ? other$firebaseConfig != null : !((Object)this$firebaseConfig).equals(other$firebaseConfig)) {
                return false;
            }
            HuaweiConfig this$huaweiConfig = this.getHuaweiConfig();
            HuaweiConfig other$huaweiConfig = other.getHuaweiConfig();
            if (this$huaweiConfig == null ? other$huaweiConfig != null : !((Object)this$huaweiConfig).equals(other$huaweiConfig)) {
                return false;
            }
            List<PushProvider> this$providers = this.getProviders();
            List<PushProvider> other$providers = other.getProviders();
            return !(this$providers == null ? other$providers != null : !((Object)this$providers).equals(other$providers));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PushNotificationFields;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $offlineOnly = this.getOfflineOnly();
            result = result * 59 + ($offlineOnly == null ? 43 : ((Object)$offlineOnly).hashCode());
            PushVersion $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
            APNConfig $aPNConfig = this.getAPNConfig();
            result = result * 59 + ($aPNConfig == null ? 43 : ((Object)$aPNConfig).hashCode());
            FirebaseConfig $firebaseConfig = this.getFirebaseConfig();
            result = result * 59 + ($firebaseConfig == null ? 43 : ((Object)$firebaseConfig).hashCode());
            HuaweiConfig $huaweiConfig = this.getHuaweiConfig();
            result = result * 59 + ($huaweiConfig == null ? 43 : ((Object)$huaweiConfig).hashCode());
            List<PushProvider> $providers = this.getProviders();
            result = result * 59 + ($providers == null ? 43 : ((Object)$providers).hashCode());
            return result;
        }

        public String toString() {
            return "App.PushNotificationFields(version=" + this.getVersion() + ", offlineOnly=" + this.getOfflineOnly() + ", aPNConfig=" + this.getAPNConfig() + ", firebaseConfig=" + this.getFirebaseConfig() + ", huaweiConfig=" + this.getHuaweiConfig() + ", providers=" + this.getProviders() + ")";
        }
    }

    public static enum PushProviderType {
        Firebase,
        Apn,
        Xiaomi,
        Huawei,
        UNKNOWN;

    }

    public static class HuaweiConfig {
        @JsonProperty(value="enabled")
        @NotNull
        private Boolean enabled;

        @NotNull
        public Boolean getEnabled() {
            return this.enabled;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(@NotNull Boolean enabled) {
            if (enabled == null) {
                throw new NullPointerException("enabled is marked non-null but is null");
            }
            this.enabled = enabled;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HuaweiConfig)) {
                return false;
            }
            HuaweiConfig other = (HuaweiConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            return !(this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HuaweiConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            return result;
        }

        public String toString() {
            return "App.HuaweiConfig(enabled=" + this.getEnabled() + ")";
        }
    }

    public static class FirebaseConfig {
        @JsonProperty(value="enabled")
        @NotNull
        private Boolean enabled;
        @JsonProperty(value="notification_template")
        @NotNull
        private String notificationTemplate;
        @JsonProperty(value="data_template")
        @NotNull
        private String dataTemplate;
        @JsonProperty(value="apn_template")
        @NotNull
        private String apnTemplate;

        @NotNull
        public Boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public String getNotificationTemplate() {
            return this.notificationTemplate;
        }

        @NotNull
        public String getDataTemplate() {
            return this.dataTemplate;
        }

        @NotNull
        public String getApnTemplate() {
            return this.apnTemplate;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(@NotNull Boolean enabled) {
            if (enabled == null) {
                throw new NullPointerException("enabled is marked non-null but is null");
            }
            this.enabled = enabled;
        }

        @JsonProperty(value="notification_template")
        public void setNotificationTemplate(@NotNull String notificationTemplate) {
            if (notificationTemplate == null) {
                throw new NullPointerException("notificationTemplate is marked non-null but is null");
            }
            this.notificationTemplate = notificationTemplate;
        }

        @JsonProperty(value="data_template")
        public void setDataTemplate(@NotNull String dataTemplate) {
            if (dataTemplate == null) {
                throw new NullPointerException("dataTemplate is marked non-null but is null");
            }
            this.dataTemplate = dataTemplate;
        }

        @JsonProperty(value="apn_template")
        public void setApnTemplate(@NotNull String apnTemplate) {
            if (apnTemplate == null) {
                throw new NullPointerException("apnTemplate is marked non-null but is null");
            }
            this.apnTemplate = apnTemplate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FirebaseConfig)) {
                return false;
            }
            FirebaseConfig other = (FirebaseConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            String this$notificationTemplate = this.getNotificationTemplate();
            String other$notificationTemplate = other.getNotificationTemplate();
            if (this$notificationTemplate == null ? other$notificationTemplate != null : !this$notificationTemplate.equals(other$notificationTemplate)) {
                return false;
            }
            String this$dataTemplate = this.getDataTemplate();
            String other$dataTemplate = other.getDataTemplate();
            if (this$dataTemplate == null ? other$dataTemplate != null : !this$dataTemplate.equals(other$dataTemplate)) {
                return false;
            }
            String this$apnTemplate = this.getApnTemplate();
            String other$apnTemplate = other.getApnTemplate();
            return !(this$apnTemplate == null ? other$apnTemplate != null : !this$apnTemplate.equals(other$apnTemplate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FirebaseConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            String $notificationTemplate = this.getNotificationTemplate();
            result = result * 59 + ($notificationTemplate == null ? 43 : $notificationTemplate.hashCode());
            String $dataTemplate = this.getDataTemplate();
            result = result * 59 + ($dataTemplate == null ? 43 : $dataTemplate.hashCode());
            String $apnTemplate = this.getApnTemplate();
            result = result * 59 + ($apnTemplate == null ? 43 : $apnTemplate.hashCode());
            return result;
        }

        public String toString() {
            return "App.FirebaseConfig(enabled=" + this.getEnabled() + ", notificationTemplate=" + this.getNotificationTemplate() + ", dataTemplate=" + this.getDataTemplate() + ", apnTemplate=" + this.getApnTemplate() + ")";
        }
    }

    public static class APNConfig {
        @JsonProperty(value="enabled")
        @NotNull
        private Boolean enabled;
        @JsonProperty(value="development")
        @NotNull
        private Boolean development;
        @JsonProperty(value="auth_type")
        @Nullable
        private AuthenticationType authType;
        @JsonProperty(value="auth_key")
        @Nullable
        private byte[] authKey;
        @JsonProperty(value="notification_template")
        @NotNull
        private String notificationTemplate;
        @JsonProperty(value="host")
        @Nullable
        private String host;
        @JsonProperty(value="bundle_Id")
        @Nullable
        private String bundleId;
        @JsonProperty(value="team_Id")
        @Nullable
        private String teamId;
        @JsonProperty(value="key_Id")
        @Nullable
        private String keyId;

        @NotNull
        public Boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public Boolean getDevelopment() {
            return this.development;
        }

        @Nullable
        public AuthenticationType getAuthType() {
            return this.authType;
        }

        @Nullable
        public byte[] getAuthKey() {
            return this.authKey;
        }

        @NotNull
        public String getNotificationTemplate() {
            return this.notificationTemplate;
        }

        @Nullable
        public String getHost() {
            return this.host;
        }

        @Nullable
        public String getBundleId() {
            return this.bundleId;
        }

        @Nullable
        public String getTeamId() {
            return this.teamId;
        }

        @Nullable
        public String getKeyId() {
            return this.keyId;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(@NotNull Boolean enabled) {
            if (enabled == null) {
                throw new NullPointerException("enabled is marked non-null but is null");
            }
            this.enabled = enabled;
        }

        @JsonProperty(value="development")
        public void setDevelopment(@NotNull Boolean development) {
            if (development == null) {
                throw new NullPointerException("development is marked non-null but is null");
            }
            this.development = development;
        }

        @JsonProperty(value="auth_type")
        public void setAuthType(@Nullable AuthenticationType authType) {
            this.authType = authType;
        }

        @JsonProperty(value="auth_key")
        public void setAuthKey(@Nullable byte[] authKey) {
            this.authKey = authKey;
        }

        @JsonProperty(value="notification_template")
        public void setNotificationTemplate(@NotNull String notificationTemplate) {
            if (notificationTemplate == null) {
                throw new NullPointerException("notificationTemplate is marked non-null but is null");
            }
            this.notificationTemplate = notificationTemplate;
        }

        @JsonProperty(value="host")
        public void setHost(@Nullable String host) {
            this.host = host;
        }

        @JsonProperty(value="bundle_Id")
        public void setBundleId(@Nullable String bundleId) {
            this.bundleId = bundleId;
        }

        @JsonProperty(value="team_Id")
        public void setTeamId(@Nullable String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="key_Id")
        public void setKeyId(@Nullable String keyId) {
            this.keyId = keyId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof APNConfig)) {
                return false;
            }
            APNConfig other = (APNConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Boolean this$development = this.getDevelopment();
            Boolean other$development = other.getDevelopment();
            if (this$development == null ? other$development != null : !((Object)this$development).equals(other$development)) {
                return false;
            }
            AuthenticationType this$authType = this.getAuthType();
            AuthenticationType other$authType = other.getAuthType();
            if (this$authType == null ? other$authType != null : !((Object)((Object)this$authType)).equals((Object)other$authType)) {
                return false;
            }
            if (!Arrays.equals(this.getAuthKey(), other.getAuthKey())) {
                return false;
            }
            String this$notificationTemplate = this.getNotificationTemplate();
            String other$notificationTemplate = other.getNotificationTemplate();
            if (this$notificationTemplate == null ? other$notificationTemplate != null : !this$notificationTemplate.equals(other$notificationTemplate)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$bundleId = this.getBundleId();
            String other$bundleId = other.getBundleId();
            if (this$bundleId == null ? other$bundleId != null : !this$bundleId.equals(other$bundleId)) {
                return false;
            }
            String this$teamId = this.getTeamId();
            String other$teamId = other.getTeamId();
            if (this$teamId == null ? other$teamId != null : !this$teamId.equals(other$teamId)) {
                return false;
            }
            String this$keyId = this.getKeyId();
            String other$keyId = other.getKeyId();
            return !(this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof APNConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Boolean $development = this.getDevelopment();
            result = result * 59 + ($development == null ? 43 : ((Object)$development).hashCode());
            AuthenticationType $authType = this.getAuthType();
            result = result * 59 + ($authType == null ? 43 : ((Object)((Object)$authType)).hashCode());
            result = result * 59 + Arrays.hashCode(this.getAuthKey());
            String $notificationTemplate = this.getNotificationTemplate();
            result = result * 59 + ($notificationTemplate == null ? 43 : $notificationTemplate.hashCode());
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $bundleId = this.getBundleId();
            result = result * 59 + ($bundleId == null ? 43 : $bundleId.hashCode());
            String $teamId = this.getTeamId();
            result = result * 59 + ($teamId == null ? 43 : $teamId.hashCode());
            String $keyId = this.getKeyId();
            result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
            return result;
        }

        public String toString() {
            return "App.APNConfig(enabled=" + this.getEnabled() + ", development=" + this.getDevelopment() + ", authType=" + this.getAuthType() + ", authKey=" + Arrays.toString(this.getAuthKey()) + ", notificationTemplate=" + this.getNotificationTemplate() + ", host=" + this.getHost() + ", bundleId=" + this.getBundleId() + ", teamId=" + this.getTeamId() + ", keyId=" + this.getKeyId() + ")";
        }
    }
}

