/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.chat.java.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.getstream.chat.java.models.Message;
import io.getstream.chat.java.models.User;
import io.getstream.chat.java.models.framework.RequestObjectBuilder;
import io.getstream.chat.java.models.framework.StreamRequest;
import io.getstream.chat.java.models.framework.StreamResponseObject;
import io.getstream.chat.java.services.ReactionService;
import io.getstream.chat.java.services.framework.Client;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;

public class Reaction {
    @JsonProperty(value="message_id")
    @NotNull
    private String messageId;
    @JsonProperty(value="user_id")
    @NotNull
    private String userId;
    @JsonProperty(value="type")
    @NotNull
    private String type;
    @JsonProperty(value="score")
    @Nullable
    private Integer score;
    @JsonProperty(value="created_at")
    @NotNull
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @NotNull
    private Date updatedAt;
    @JsonIgnore
    @NotNull
    private Map<String, Object> additionalFields = new HashMap<String, Object>();

    @JsonAnyGetter
    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    @JsonAnySetter
    public void setAdditionalField(String name, Object value) {
        this.additionalFields.put(name, value);
    }

    @NotNull
    public static ReactionSendRequestData.ReactionSendRequest send(@NotNull String messageId) {
        return new ReactionSendRequestData.ReactionSendRequest(messageId);
    }

    @NotNull
    public static ReactionDeleteRequest delete(@NotNull String messageId, @NotNull String type) {
        return new ReactionDeleteRequest(messageId, type);
    }

    @NotNull
    public static ReactionListRequest list(@NotNull String messageId) {
        return new ReactionListRequest(messageId);
    }

    @NotNull
    public String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public String getUserId() {
        return this.userId;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public Integer getScore() {
        return this.score;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(@NotNull String messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NotNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="type")
    public void setType(@NotNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="score")
    public void setScore(@Nullable Integer score) {
        this.score = score;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(@NotNull Date createdAt) {
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    public void setUpdatedAt(@NotNull Date updatedAt) {
        if (updatedAt == null) {
            throw new NullPointerException("updatedAt is marked non-null but is null");
        }
        this.updatedAt = updatedAt;
    }

    @JsonIgnore
    public void setAdditionalFields(@NotNull Map<String, Object> additionalFields) {
        if (additionalFields == null) {
            throw new NullPointerException("additionalFields is marked non-null but is null");
        }
        this.additionalFields = additionalFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Reaction)) {
            return false;
        }
        Reaction other = (Reaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$score = this.getScore();
        Integer other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Date this$updatedAt = this.getUpdatedAt();
        Date other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Map<String, Object> this$additionalFields = this.getAdditionalFields();
        Map<String, Object> other$additionalFields = other.getAdditionalFields();
        return !(this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Reaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Date $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Map<String, Object> $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        return result;
    }

    public String toString() {
        return "Reaction(messageId=" + this.getMessageId() + ", userId=" + this.getUserId() + ", type=" + this.getType() + ", score=" + this.getScore() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", additionalFields=" + this.getAdditionalFields() + ")";
    }

    public static class ReactionSendRequestData {
        @JsonProperty(value="reaction")
        @Nullable
        private ReactionRequestObject reaction;
        @JsonProperty(value="enforce_unique")
        @Nullable
        private Boolean enforceUnique;
        @JsonProperty(value="skip_push")
        @Nullable
        private Boolean skipPush;

        ReactionSendRequestData(@Nullable ReactionRequestObject reaction, @Nullable Boolean enforceUnique, @Nullable Boolean skipPush) {
            this.reaction = reaction;
            this.enforceUnique = enforceUnique;
            this.skipPush = skipPush;
        }

        public static class ReactionSendRequest
        extends StreamRequest<ReactionSendResponse> {
            private ReactionRequestObject reaction;
            private Boolean enforceUnique;
            private Boolean skipPush;
            @NotNull
            private String messageId;

            private ReactionSendRequest(@NotNull String messageId) {
                this.messageId = messageId;
            }

            @Override
            protected Call<ReactionSendResponse> generateCall(Client client) {
                return client.create(ReactionService.class).send(this.messageId, this.internalBuild());
            }

            @JsonProperty(value="reaction")
            public ReactionSendRequest reaction(@Nullable ReactionRequestObject reaction) {
                this.reaction = reaction;
                return this;
            }

            @JsonProperty(value="enforce_unique")
            public ReactionSendRequest enforceUnique(@Nullable Boolean enforceUnique) {
                this.enforceUnique = enforceUnique;
                return this;
            }

            @JsonProperty(value="skip_push")
            public ReactionSendRequest skipPush(@Nullable Boolean skipPush) {
                this.skipPush = skipPush;
                return this;
            }

            public ReactionSendRequestData internalBuild() {
                return new ReactionSendRequestData(this.reaction, this.enforceUnique, this.skipPush);
            }

            public String toString() {
                return "Reaction.ReactionSendRequestData.ReactionSendRequest(reaction=" + this.reaction + ", enforceUnique=" + this.enforceUnique + ", skipPush=" + this.skipPush + ")";
            }
        }
    }

    public static class ReactionDeleteRequest
    extends StreamRequest<ReactionDeleteResponse> {
        @NotNull
        private String messageId;
        @NotNull
        private String type;
        @Nullable
        private String userId;

        public ReactionDeleteRequest userId(@NotNull String userId) {
            this.userId = userId;
            return this;
        }

        @Override
        protected Call<ReactionDeleteResponse> generateCall(Client client) {
            return client.create(ReactionService.class).delete(this.messageId, this.type, this.userId);
        }

        public ReactionDeleteRequest(@NotNull String messageId, @NotNull String type) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.messageId = messageId;
            this.type = type;
        }
    }

    public static class ReactionListRequest
    extends StreamRequest<ReactionListResponse> {
        @NotNull
        private String messageId;
        @Nullable
        private Integer limit;
        @Nullable
        private Integer offset;

        @NotNull
        public ReactionListRequest limit(@NotNull Integer limit) {
            this.limit = limit;
            return this;
        }

        @NotNull
        public ReactionListRequest offset(@NotNull Integer offset) {
            this.offset = offset;
            return this;
        }

        @Override
        protected Call<ReactionListResponse> generateCall(Client client) {
            return client.create(ReactionService.class).list(this.messageId);
        }

        public ReactionListRequest(@NotNull String messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
        }
    }

    public static class ReactionListResponse
    extends StreamResponseObject {
        @JsonProperty(value="reactions")
        @NotNull
        private List<Reaction> reactions;

        @NotNull
        public List<Reaction> getReactions() {
            return this.reactions;
        }

        @JsonProperty(value="reactions")
        public void setReactions(@NotNull List<Reaction> reactions) {
            if (reactions == null) {
                throw new NullPointerException("reactions is marked non-null but is null");
            }
            this.reactions = reactions;
        }

        @Override
        public String toString() {
            return "Reaction.ReactionListResponse(reactions=" + this.getReactions() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReactionListResponse)) {
                return false;
            }
            ReactionListResponse other = (ReactionListResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<Reaction> this$reactions = this.getReactions();
            List<Reaction> other$reactions = other.getReactions();
            return !(this$reactions == null ? other$reactions != null : !((Object)this$reactions).equals(other$reactions));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReactionListResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<Reaction> $reactions = this.getReactions();
            result = result * 59 + ($reactions == null ? 43 : ((Object)$reactions).hashCode());
            return result;
        }
    }

    public static class ReactionDeleteResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;
        @JsonProperty(value="reaction")
        @NotNull
        private Reaction reaction;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @NotNull
        public Reaction getReaction() {
            return this.reaction;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @JsonProperty(value="reaction")
        public void setReaction(@NotNull Reaction reaction) {
            if (reaction == null) {
                throw new NullPointerException("reaction is marked non-null but is null");
            }
            this.reaction = reaction;
        }

        @Override
        public String toString() {
            return "Reaction.ReactionDeleteResponse(message=" + this.getMessage() + ", reaction=" + this.getReaction() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReactionDeleteResponse)) {
                return false;
            }
            ReactionDeleteResponse other = (ReactionDeleteResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Reaction this$reaction = this.getReaction();
            Reaction other$reaction = other.getReaction();
            return !(this$reaction == null ? other$reaction != null : !((Object)this$reaction).equals(other$reaction));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReactionDeleteResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Reaction $reaction = this.getReaction();
            result = result * 59 + ($reaction == null ? 43 : ((Object)$reaction).hashCode());
            return result;
        }
    }

    public static class ReactionSendResponse
    extends StreamResponseObject {
        @JsonProperty(value="message")
        @NotNull
        private Message message;
        @JsonProperty(value="reaction")
        @NotNull
        private Reaction reaction;

        @NotNull
        public Message getMessage() {
            return this.message;
        }

        @NotNull
        public Reaction getReaction() {
            return this.reaction;
        }

        @JsonProperty(value="message")
        public void setMessage(@NotNull Message message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
        }

        @JsonProperty(value="reaction")
        public void setReaction(@NotNull Reaction reaction) {
            if (reaction == null) {
                throw new NullPointerException("reaction is marked non-null but is null");
            }
            this.reaction = reaction;
        }

        @Override
        public String toString() {
            return "Reaction.ReactionSendResponse(message=" + this.getMessage() + ", reaction=" + this.getReaction() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReactionSendResponse)) {
                return false;
            }
            ReactionSendResponse other = (ReactionSendResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
                return false;
            }
            Reaction this$reaction = this.getReaction();
            Reaction other$reaction = other.getReaction();
            return !(this$reaction == null ? other$reaction != null : !((Object)this$reaction).equals(other$reaction));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ReactionSendResponse;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
            Reaction $reaction = this.getReaction();
            result = result * 59 + ($reaction == null ? 43 : ((Object)$reaction).hashCode());
            return result;
        }
    }

    public static class ReactionRequestObject {
        @JsonProperty(value="message_id")
        @Nullable
        private String messageId;
        @JsonProperty(value="user_id")
        @Nullable
        private String userId;
        @JsonProperty(value="user")
        @Nullable
        private User.UserRequestObject user;
        @JsonProperty(value="type")
        @Nullable
        private String type;
        @JsonProperty(value="score")
        @Nullable
        private Integer score;
        @JsonIgnore
        @Nullable
        private Map<String, Object> additionalFields;

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonAnySetter
        public void setAdditionalField(String name, Object value) {
            this.additionalFields.put(name, value);
        }

        @Nullable
        public static ReactionRequestObject buildFrom(@Nullable Reaction reaction) {
            return RequestObjectBuilder.build(ReactionRequestObject.class, reaction);
        }

        ReactionRequestObject(@Nullable String messageId, @Nullable String userId, @Nullable User.UserRequestObject user, @Nullable String type, @Nullable Integer score, @Nullable Map<String, Object> additionalFields) {
            this.messageId = messageId;
            this.userId = userId;
            this.user = user;
            this.type = type;
            this.score = score;
            this.additionalFields = additionalFields;
        }

        public static ReactionRequestObjectBuilder builder() {
            return new ReactionRequestObjectBuilder();
        }

        @JsonProperty(value="message_id")
        public void setMessageId(@Nullable String messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="user_id")
        public void setUserId(@Nullable String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="user")
        public void setUser(@Nullable User.UserRequestObject user) {
            this.user = user;
        }

        @JsonProperty(value="type")
        public void setType(@Nullable String type) {
            this.type = type;
        }

        @JsonProperty(value="score")
        public void setScore(@Nullable Integer score) {
            this.score = score;
        }

        @JsonIgnore
        public void setAdditionalFields(@Nullable Map<String, Object> additionalFields) {
            this.additionalFields = additionalFields;
        }

        public static class ReactionRequestObjectBuilder {
            private String messageId;
            private String userId;
            private User.UserRequestObject user;
            private String type;
            private Integer score;
            private ArrayList<String> additionalFields$key;
            private ArrayList<Object> additionalFields$value;

            ReactionRequestObjectBuilder() {
            }

            @JsonProperty(value="message_id")
            public ReactionRequestObjectBuilder messageId(@Nullable String messageId) {
                this.messageId = messageId;
                return this;
            }

            @JsonProperty(value="user_id")
            public ReactionRequestObjectBuilder userId(@Nullable String userId) {
                this.userId = userId;
                return this;
            }

            @JsonProperty(value="user")
            public ReactionRequestObjectBuilder user(@Nullable User.UserRequestObject user) {
                this.user = user;
                return this;
            }

            @JsonProperty(value="type")
            public ReactionRequestObjectBuilder type(@Nullable String type) {
                this.type = type;
                return this;
            }

            @JsonProperty(value="score")
            public ReactionRequestObjectBuilder score(@Nullable Integer score) {
                this.score = score;
                return this;
            }

            public ReactionRequestObjectBuilder additionalField(String additionalFieldKey, Object additionalFieldValue) {
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                this.additionalFields$key.add(additionalFieldKey);
                this.additionalFields$value.add(additionalFieldValue);
                return this;
            }

            @JsonIgnore
            public ReactionRequestObjectBuilder additionalFields(Map<? extends String, ? extends Object> additionalFields) {
                if (additionalFields == null) {
                    throw new NullPointerException("additionalFields cannot be null");
                }
                if (this.additionalFields$key == null) {
                    this.additionalFields$key = new ArrayList();
                    this.additionalFields$value = new ArrayList();
                }
                for (Map.Entry<? extends String, ? extends Object> $lombokEntry : additionalFields.entrySet()) {
                    this.additionalFields$key.add($lombokEntry.getKey());
                    this.additionalFields$value.add($lombokEntry.getValue());
                }
                return this;
            }

            public ReactionRequestObjectBuilder clearAdditionalFields() {
                if (this.additionalFields$key != null) {
                    this.additionalFields$key.clear();
                    this.additionalFields$value.clear();
                }
                return this;
            }

            public ReactionRequestObject build() {
                Map<String, Object> additionalFields;
                switch (this.additionalFields$key == null ? 0 : this.additionalFields$key.size()) {
                    case 0: {
                        additionalFields = Collections.emptyMap();
                        break;
                    }
                    case 1: {
                        additionalFields = Collections.singletonMap(this.additionalFields$key.get(0), this.additionalFields$value.get(0));
                        break;
                    }
                    default: {
                        additionalFields = new LinkedHashMap(this.additionalFields$key.size() < 0x40000000 ? 1 + this.additionalFields$key.size() + (this.additionalFields$key.size() - 3) / 3 : Integer.MAX_VALUE);
                        for (int $i = 0; $i < this.additionalFields$key.size(); ++$i) {
                            additionalFields.put(this.additionalFields$key.get($i), this.additionalFields$value.get($i));
                        }
                        additionalFields = Collections.unmodifiableMap(additionalFields);
                    }
                }
                return new ReactionRequestObject(this.messageId, this.userId, this.user, this.type, this.score, additionalFields);
            }

            public String toString() {
                return "Reaction.ReactionRequestObject.ReactionRequestObjectBuilder(messageId=" + this.messageId + ", userId=" + this.userId + ", user=" + this.user + ", type=" + this.type + ", score=" + this.score + ", additionalFields$key=" + this.additionalFields$key + ", additionalFields$value=" + this.additionalFields$value + ")";
            }
        }
    }
}

