/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.bosslibrary.boss_utils;

import io.papermc.bosslibrary.custom_entities.CustomBoss;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class BossHealthBar {
    private final CustomBoss boss;
    private BossBar bossBar;
    private final int chargeTicks;
    private int currentTick;

    public BossHealthBar(CustomBoss boss, int chargeTicks) {
        this.chargeTicks = chargeTicks;
        this.currentTick = chargeTicks;
        this.boss = boss;
        this.bossBar = Bukkit.createBossBar((String)boss.getBossName(), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        this.bossBar.addFlag(BarFlag.DARKEN_SKY);
    }

    public void updateBossBar() {
        if (this.currentTick >= 0) {
            this.bossBar.setProgress((double)(1.0f - (float)this.currentTick-- / (float)this.chargeTicks));
        } else {
            this.bossBar.setProgress(this.boss.getSlimeHitbox().getHealth() / this.boss.getHitbox().getMaxHealth());
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.bossBar.getPlayers().contains(player)) continue;
            this.bossBar.addPlayer(player);
        }
    }

    public void stopBossbar() {
        this.bossBar.removeAll();
    }
}

