/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.bosslibrary.builders;

import io.papermc.bosslibrary.BossLibraryManager;
import io.papermc.bosslibrary.baseclasses.CustomBoss;
import io.papermc.paper.threadedregions.scheduler.EntityScheduler;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.plugin.Plugin;

public class HitboxBuilder {
    private final Random random = new Random();
    private final Interaction interaction;
    private double width = 1.0;
    private double height = 1.0;

    public HitboxBuilder(CustomBoss boss) {
        this.interaction = (Interaction)boss.getLocation().getWorld().spawn(boss.getLocation(), Interaction.class);
        this.interaction.setResponsive(true);
        EntityScheduler scheduler = this.interaction.getScheduler();
        scheduler.runAtFixedRate((Plugin)BossLibraryManager.getMainInstance(), scheduledTask -> {
            for (Entity entity : this.interaction.getNearbyEntities(this.width / 2.0, this.height, this.width / 2.0)) {
                if (!(entity instanceof AbstractArrow)) continue;
                AbstractArrow arrow = (AbstractArrow)entity;
                float motionMultiplier = (float)arrow.getVelocity().length();
                int arrowDamage = (int)Math.ceil((double)motionMultiplier * arrow.getDamage());
                if (arrow.isCritical()) {
                    long criticalMultiplier = this.random.nextInt(arrowDamage / 2 + 2);
                    arrowDamage = (int)((long)arrowDamage + criticalMultiplier);
                }
                arrow.remove();
            }
        }, () -> {}, 1L, 1L);
    }

    public void teleport(Location location) {
        this.interaction.teleport(location);
    }

    public void setHeight(float height) {
        this.interaction.setInteractionHeight(height);
        this.height = height;
    }

    public void setWidth(float width) {
        this.interaction.setInteractionWidth(width);
        this.width = width;
    }

    public void remove() {
        this.interaction.remove();
    }
}

