/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.bosslibrary.baseclasses;

import com.google.common.base.Preconditions;
import io.papermc.bosslibrary.baseclasses.BaseEntity;
import io.papermc.bosslibrary.keys.Keys;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public abstract class CustomBoss
extends BaseEntity {
    private final PersistentDataContainer container = this.getTemplateEntity().getPersistentDataContainer();
    private final BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
    private String bossName;

    public CustomBoss(Location location, double health) {
        super(location);
        this.bossBar.addFlag(BarFlag.DARKEN_SKY);
        this.setMaxHealth(health);
        this.setHealth(health);
    }

    public float getMaxHealth() {
        return ((Float)this.container.getOrDefault(Keys.BOSS_MAX_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public float getHealth() {
        return ((Float)this.container.getOrDefault(Keys.BOSS_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setMaxHealth(double health) {
        this.container.set(Keys.BOSS_MAX_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf((float)health));
    }

    public void setHealth(double health) {
        Preconditions.checkArgument((health >= 0.0 && health <= (double)this.getMaxHealth() ? 1 : 0) != 0);
        this.container.set(Keys.BOSS_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf((float)health));
        if (this.getHealth() <= 0.0f) {
            this.remove();
        }
    }

    public void damage(double damage) {
        this.setHealth((double)this.getHealth() - damage);
    }

    public String getBossBarName() {
        return this.bossName;
    }

    public void setBossBarName(String bossBarName) {
        this.bossName = bossBarName;
        this.bossBar.setTitle(this.bossName);
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    @Override
    public void update() {
        BossBar bossBar = this.bossBar;
        bossBar.setProgress((double)(this.getHealth() / this.getMaxHealth()));
        for (Player player : this.getLocation().getWorld().getPlayers()) {
            if (bossBar.getPlayers().contains(player)) continue;
            bossBar.addPlayer(player);
            this.tick();
        }
    }

    @Override
    public void remove() {
        this.bossBar.removeAll();
        super.remove();
    }

    public abstract void tick();
}

