/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.bosslibrary.baseclasses;

import com.google.common.base.Preconditions;
import io.papermc.bosslibrary.baseclasses.CustomEntityImpl;
import io.papermc.bosslibrary.interfaces.CustomBehavior;
import io.papermc.bosslibrary.keys.Keys;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.java.JavaPlugin;

public final class Boss
extends CustomEntityImpl {
    private final PersistentDataContainer container = this.getTemplateEntity().getPersistentDataContainer();
    private final BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
    private int immunityFrames = 10;
    private String bossName;

    public Boss(JavaPlugin main, Location location, CustomBehavior mainBehavior, double health) {
        super(main, location, mainBehavior);
        this.setMaxHealth(health);
        this.setHealth(health);
    }

    public double getHealth() {
        return ((Float)this.container.getOrDefault(Keys.BOSS_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setHealth(double health) {
        Preconditions.checkArgument((health >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0);
        this.container.set(Keys.BOSS_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf((float)health));
        if (this.getHealth() <= 0.0) {
            this.remove();
        }
    }

    public double getMaxHealth() {
        return ((Float)this.container.getOrDefault(Keys.BOSS_MAX_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setMaxHealth(double maxHealth) {
        this.container.set(Keys.BOSS_MAX_HEALTH, PersistentDataType.FLOAT, (Object)Float.valueOf((float)maxHealth));
    }

    public int getImmunityFrames() {
        return this.immunityFrames;
    }

    public void setImmunityFrames(int immunityFrames) {
        this.immunityFrames = immunityFrames;
    }

    public String getBossName() {
        return this.bossName;
    }

    public void setBossName(String bossName) {
        this.bossName = bossName;
        this.bossBar.setTitle(this.bossName);
    }

    public void damage(double damage) {
        this.setHealth(this.getHealth() - damage);
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    @Override
    protected void tick() {
        this.bossBar.setProgress(this.getHealth() / this.getMaxHealth());
        for (Player player : this.getLocation().getWorld().getPlayers()) {
            if (this.bossBar.getPlayers().contains(player)) continue;
            this.bossBar.addPlayer(player);
        }
    }
}

