/*
 * Decompiled with CFR 0.152.
 */
package io.github.alejomc26.baseclasses;

import io.github.alejomc26.baseclasses.CustomEntityImpl;
import io.github.alejomc26.bone.Bone;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public final class CustomProjectile
extends CustomEntityImpl {
    private final Location spawnLocation;
    private final Bone display;
    private double contactDamage = 1.0;
    private double attackRadius = 0.4;
    private Consumer<CustomProjectile> onTouchFunction;

    public CustomProjectile(Location location) {
        super(location);
        this.display = new Bone(location);
        this.spawnLocation = location.clone();
    }

    @Override
    public void teleport(Location location) {
        super.teleport(location);
        this.display.teleport(location);
    }

    @Override
    public void remove() {
        super.remove();
        this.display.remove();
    }

    public Bone getBoneBuilder() {
        return this.display;
    }

    public double getAttackRadius() {
        return this.attackRadius;
    }

    public void setAttackRadius(double radius) {
        this.attackRadius = radius;
    }

    public double getContactDamage() {
        return this.contactDamage;
    }

    public void setContactDamage(double contactDamage) {
        this.contactDamage = contactDamage;
    }

    public void setTouchBlockFunction(Consumer<CustomProjectile> function) {
        this.onTouchFunction = function;
    }

    @Override
    protected void tick() {
        Location currentLocation = this.getLocation();
        Block block = currentLocation.getBlock();
        if (block.getType() != Material.AIR) {
            if (this.onTouchFunction != null) {
                this.onTouchFunction.accept(this);
            }
            this.remove();
            return;
        }
        if (currentLocation.distanceSquared(this.spawnLocation) > 2500.0) {
            this.remove();
            return;
        }
        for (Player player : currentLocation.getNearbyPlayers(this.attackRadius)) {
            player.damage(this.contactDamage);
        }
    }
}

