/*
 * Decompiled with CFR 0.152.
 */
package io.github.alejomc26.baseclasses;

import io.github.alejomc26.baseclasses.Boss;
import io.github.alejomc26.baseclasses.CustomEntityImpl;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;

public final class Hitbox
extends CustomEntityImpl {
    private final Random random = new Random();
    private final Interaction interactionEntity;
    private final Boss boss;
    private int immunityFrames;
    private double damageReduction = 0.0;

    public Hitbox(Location location, Boss boss) {
        super(location);
        this.interactionEntity = (Interaction)location.getWorld().spawn(location, Interaction.class, interaction -> interaction.setResponsive(true));
        this.boss = boss;
        this.immunityFrames = boss.getImmunityFrames();
    }

    @Override
    public void teleport(Location location) {
        super.teleport(location);
        this.interactionEntity.teleport(location);
    }

    public Boss getBoss() {
        return this.boss;
    }

    public Interaction getInteractionEntity() {
        return this.interactionEntity;
    }

    public int getImmunityFrames() {
        return this.immunityFrames;
    }

    public void setImmunityFrames(int immunityFrames) {
        this.immunityFrames = immunityFrames;
    }

    public double getHeight() {
        return this.interactionEntity.getHeight();
    }

    public void setHeight(float height) {
        this.interactionEntity.setInteractionHeight(height);
    }

    public double getWidth() {
        return this.interactionEntity.getWidth();
    }

    public void setWidth(float width) {
        this.interactionEntity.setInteractionWidth(width);
    }

    public double getDamageReduction() {
        return this.damageReduction;
    }

    public void setDamageReduction(double damageReduction) {
        this.damageReduction = damageReduction;
    }

    @Override
    protected void tick() {
        if (this.immunityFrames > 0) {
            --this.immunityFrames;
        }
        for (Entity entity : this.interactionEntity.getNearbyEntities(this.getWidth() / 2.0, this.getHeight(), this.getWidth() / 2.0)) {
            if (!(entity instanceof AbstractArrow)) continue;
            AbstractArrow arrow = (AbstractArrow)entity;
            float motionMultiplier = (float)arrow.getVelocity().length();
            int arrowDamage = (int)Math.ceil((double)motionMultiplier * arrow.getDamage());
            if (arrow.isCritical()) {
                long criticalMultiplier = this.random.nextInt(arrowDamage / 2 + 2);
                arrowDamage = (int)((long)arrowDamage + criticalMultiplier);
            }
            this.boss.damage(arrowDamage);
            arrow.remove();
        }
    }
}

