/*
 * Decompiled with CFR 0.152.
 */
package io.github.alejomc26.utils;

import java.util.Map;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.Player;

public class BossUtils {
    public static Player getNearestPlayer(Location location) {
        Player nearestPlayer = null;
        double nearestDistanceSquare = Double.MAX_VALUE;
        for (Player player : location.getWorld().getPlayers()) {
            double distanceSquare = player.getLocation().distanceSquared(location);
            if (distanceSquare >= nearestDistanceSquare) continue;
            nearestDistanceSquare = distanceSquare;
            nearestPlayer = player;
        }
        return nearestPlayer;
    }

    public static Location lerpLocation(Location from, Location to, float percent) {
        double x = BossUtils.lerp(from.x(), to.x(), percent);
        double y = BossUtils.lerp(from.y(), to.y(), percent);
        double z = BossUtils.lerp(from.z(), to.z(), percent);
        return new Location(to.getWorld(), x, y, z);
    }

    public static double lerp(double start, double end, float percent) {
        return start + (end - start) * (double)percent;
    }

    public static float getPlayerDamage(Player player) {
        AttributeInstance attackDamageInstance = player.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        float baseDamage = attackDamageInstance != null ? (float)attackDamageInstance.getValue() : 0.0f;
        float attackCooldown = player.getAttackCooldown();
        float enchantmentBonus = 0.0f;
        for (Map.Entry enchantment : player.getInventory().getItemInMainHand().getEnchantments().entrySet()) {
            enchantmentBonus += ((Enchantment)enchantment.getKey()).getDamageIncrease(((Integer)enchantment.getValue()).intValue(), EntityCategory.NONE);
        }
        baseDamage = (float)((double)baseDamage * (0.2 + (double)(attackCooldown * attackCooldown) * 0.8));
        baseDamage = (float)((double)baseDamage * ((double)attackCooldown > 0.9 && player.getFallDistance() > 0.0f && !player.isClimbing() && !player.isInWater() ? 1.5 : 1.0));
        return baseDamage += enchantmentBonus;
    }
}

