/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexarchambault.pythonnativelibs.shaded.scala.collection;

import io.github.alexarchambault.pythonnativelibs.shaded.scala.Function0;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.Function1;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.Iterable;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.IterableFactory;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.IterableOnce;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.IterableOnceOps;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.Iterator;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.View;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.Builder;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.package$;
import java.io.Serializable;

public interface IterableOps<A, CC, C>
extends IterableOnce<A>,
IterableOnceOps<A, CC, C> {
    public C coll();

    public C fromSpecific(IterableOnce<A> var1);

    public IterableFactory<CC> iterableFactory();

    public Builder<A, C> newSpecificBuilder();

    default public C empty() {
        return this.fromSpecific(package$.MODULE$.Nil());
    }

    public static /* synthetic */ Object head$(IterableOps $this) {
        return $this.head();
    }

    default public A head() {
        return this.iterator().next();
    }

    public static /* synthetic */ int sizeCompare$(IterableOps $this, int otherSize) {
        return $this.sizeCompare(otherSize);
    }

    default public int sizeCompare(int otherSize) {
        if (otherSize < 0) {
            return 1;
        }
        int known = this.knownSize();
        if (known >= 0) {
            return Integer.compare(known, otherSize);
        }
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (i == otherSize) {
                return 1;
            }
            it.next();
            ++i;
        }
        return i - otherSize;
    }

    public static /* synthetic */ Object filterNot$(IterableOps $this, Function1 pred) {
        return $this.filterNot(pred);
    }

    default public C filterNot(Function1<A, Object> pred) {
        return this.fromSpecific(new View.Filter<A>(this, pred, true));
    }

    public static /* synthetic */ Object drop$(IterableOps $this, int n) {
        return $this.drop(n);
    }

    default public C drop(int n) {
        return this.fromSpecific(new View.Drop(this, n));
    }

    public static /* synthetic */ Object tail$(IterableOps $this) {
        return $this.tail();
    }

    default public C tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.drop(1);
    }

    public static /* synthetic */ Object slice$(IterableOps $this, int from, int until) {
        return $this.slice(from, until);
    }

    default public C slice(int from, int until) {
        return this.fromSpecific(new View.Drop(new View.Take(this, until), from));
    }

    public static /* synthetic */ Object map$(IterableOps $this, Function1 f) {
        return $this.map(f);
    }

    default public <B> CC map(Function1<A, B> f) {
        return this.iterableFactory().from(new View.Map<A, B>(this, f));
    }

    public static /* synthetic */ Object concat$(IterableOps $this, IterableOnce suffix) {
        return $this.concat(suffix);
    }

    /*
     * WARNING - void declaration
     */
    default public <B> CC concat(IterableOnce<B> suffix) {
        IterableOnceOps iterableOnceOps;
        IterableFactory<CC> iterableFactory = this.iterableFactory();
        if (suffix instanceof Iterable) {
            Iterable iterable = (Iterable)suffix;
            iterableOnceOps = new View.Concat(this, iterable);
        } else {
            void $plus$plus_xs;
            Iterator iterator = this.iterator();
            Function0<Iterator> & Serializable intersect = (Function0<Iterator> & Serializable)() -> suffix.iterator();
            if (iterator == null) {
                throw null;
            }
            intersect = null;
            iterableOnceOps = iterator.concat($plus$plus_xs);
        }
        return iterableFactory.from(iterableOnceOps);
    }

    public static /* synthetic */ Object $plus$plus$(IterableOps $this, IterableOnce suffix) {
        return $this.$plus$plus(suffix);
    }

    default public <B> CC $plus$plus(IterableOnce<B> suffix) {
        return this.concat(suffix);
    }
}

