/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable;

import io.github.alexarchambault.pythonnativelibs.shaded.scala.Function1;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.None$;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.IterableOnce;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.Iterator;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.Set;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSetFactoryDefaults;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.StrictOptimizedIterableOps;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.generic.DefaultSerializable;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.AbstractSet;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.RedBlackTree;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.RedBlackTree$;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.SortedSet;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.StrictOptimizedSortedSetOps;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.TreeMap;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.immutable.TreeSet$;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.Builder;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.Growable;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.ReusableBuilder;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.math.Ordering;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.runtime.Nothing$;

public final class TreeSet<A>
extends AbstractSet<A>
implements DefaultSerializable,
SortedSet<A>,
StrictOptimizedSortedSetOps<A, TreeSet, TreeSet<A>> {
    private final RedBlackTree.Tree<A, Object> tree;
    private final Ordering<A> ordering;

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return Set.equals$(this, that);
    }

    @Override
    public String stringPrefix() {
        return io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSet.stringPrefix$(this);
    }

    @Override
    public io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSet fromSpecific(IterableOnce coll) {
        return SortedSetFactoryDefaults.fromSpecific$(this, coll);
    }

    @Override
    public Builder<A, TreeSet<A>> newSpecificBuilder() {
        return SortedSetFactoryDefaults.newSpecificBuilder$(this);
    }

    @Override
    public io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSet empty() {
        return SortedSetFactoryDefaults.empty$(this);
    }

    public RedBlackTree.Tree<A, Object> tree() {
        return this.tree;
    }

    @Override
    public Ordering<A> ordering() {
        return this.ordering;
    }

    public TreeSet$ sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    private TreeSet<A> newSetOrSelf(RedBlackTree.Tree<A, Object> t) {
        if (t == this.tree()) {
            return this;
        }
        return new TreeSet<A>(t, this.ordering());
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public A head() {
        RedBlackTree.Tree<A, Object> tree = RedBlackTree$.MODULE$.smallest(this.tree());
        if (tree == null) {
            throw null;
        }
        return tree.scala$collection$immutable$RedBlackTree$Tree$$_key;
    }

    @Override
    public TreeSet<A> tail() {
        return new TreeSet<A>(RedBlackTree$.MODULE$.tail(this.tree()), this.ordering());
    }

    @Override
    public TreeSet<A> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.size()) {
            return (TreeSet)SortedSetFactoryDefaults.empty$(this);
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.drop(this.tree(), n, this.ordering()), this.ordering());
    }

    public TreeSet<A> take(int n) {
        if (n <= 0) {
            return (TreeSet)SortedSetFactoryDefaults.empty$(this);
        }
        if (n >= this.size()) {
            return this;
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.take(this.tree(), n, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> slice(int from, int until) {
        if (until <= from) {
            return (TreeSet)SortedSetFactoryDefaults.empty$(this);
        }
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.size()) {
            return this.drop(from);
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.slice(this.tree(), from, until, this.ordering()), this.ordering());
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        RedBlackTree$.MODULE$.foreachKey(this.tree(), f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<A> iterator() {
        void keysIterator_evidence$17;
        Ordering<A> ordering = this.ordering();
        None$ keysIterator_start = None$.MODULE$;
        RedBlackTree.Tree<A, Object> keysIterator_tree = this.tree();
        return new RedBlackTree.KeysIterator<Nothing$, Object>((RedBlackTree.Tree<Nothing$, Object>)keysIterator_tree, keysIterator_start, (Ordering<Nothing$>)keysIterator_evidence$17);
    }

    @Override
    public boolean contains(A elem) {
        return RedBlackTree$.MODULE$.contains(this.tree(), elem, this.ordering());
    }

    public TreeSet<A> incl(A elem) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.update(this.tree(), elem, null, false, this.ordering()));
    }

    public TreeSet<A> excl(A elem) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.delete(this.tree(), elem, this.ordering()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public TreeSet<A> concat(IterableOnce<A> that) {
        RedBlackTree.Tree<A, Object> tree;
        if (that instanceof TreeSet) {
            TreeSet treeSet = (TreeSet)that;
            Ordering<A> ordering = this.ordering();
            Ordering<A> ordering2 = treeSet.ordering();
            if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                tree = RedBlackTree$.MODULE$.union(this.tree(), treeSet.tree(), this.ordering());
                return this.newSetOrSelf(tree);
            }
        }
        Iterator<A> it = that.iterator();
        RedBlackTree.Tree<A, Object> t = this.tree();
        while (true) {
            if (!it.hasNext()) {
                tree = t;
                return this.newSetOrSelf(tree);
            }
            t = RedBlackTree$.MODULE$.update(t, it.next(), null, false, this.ordering());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TreeSet)) return io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSet.equals$(this, obj);
        TreeSet treeSet = (TreeSet)obj;
        Ordering<A> ordering = this.ordering();
        Ordering<A> ordering2 = treeSet.ordering();
        if (ordering != null) {
            if (!ordering.equals(ordering2)) return io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSet.equals$(this, obj);
            return RedBlackTree$.MODULE$.keysEqual(this.tree(), treeSet.tree(), this.ordering());
        }
        if (ordering2 == null) return RedBlackTree$.MODULE$.keysEqual(this.tree(), treeSet.tree(), this.ordering());
        return io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SortedSet.equals$(this, obj);
    }

    @Override
    public String className() {
        return "TreeSet";
    }

    public TreeSet(RedBlackTree.Tree<A, Object> tree, Ordering<A> ordering) {
        this.tree = tree;
        this.ordering = ordering;
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    public TreeSet(Ordering<A> ordering) {
        this(null, ordering);
    }

    private static class TreeSetBuilder<A>
    extends RedBlackTree.SetHelper<A>
    implements ReusableBuilder<A, TreeSet<A>> {
        private RedBlackTree.Tree<A, Object> tree = null;

        @Override
        public void sizeHint(int size) {
            Builder.sizeHint$(this, size);
        }

        @Override
        public <NewTo> Builder<A, NewTo> mapResult(Function1<TreeSet<A>, NewTo> f) {
            return Builder.mapResult$(this, f);
        }

        @Override
        public final Growable<A> $plus$eq(A elem) {
            return Growable.$plus$eq$(this, elem);
        }

        @Override
        public TreeSetBuilder<A> addOne(A elem) {
            this.tree = this.mutableUpd(this.tree, elem);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public TreeSetBuilder<A> addAll(IterableOnce<A> xs) {
            if (xs instanceof TreeSet) {
                TreeSet treeSet = (TreeSet)xs;
                Ordering ordering = treeSet.ordering();
                Ordering ordering2 = super.ordering();
                if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                    if (this.tree == null) {
                        this.tree = treeSet.tree();
                        return this;
                    }
                    this.tree = RedBlackTree$.MODULE$.union(this.beforePublish(this.tree), treeSet.tree(), super.ordering());
                    return this;
                }
            }
            if (xs instanceof TreeMap) {
                TreeMap treeMap = (TreeMap)xs;
                Ordering ordering = treeMap.ordering();
                Ordering ordering3 = super.ordering();
                if (!(ordering != null ? !ordering.equals(ordering3) : ordering3 != null)) {
                    if (this.tree == null) {
                        this.tree = treeMap.tree0();
                        return this;
                    }
                    this.tree = RedBlackTree$.MODULE$.union(this.beforePublish(this.tree), treeMap.tree0(), super.ordering());
                    return this;
                }
            }
            Growable.addAll$(this, xs);
            return this;
        }

        @Override
        public void clear() {
            this.tree = null;
        }

        @Override
        public TreeSet<A> result() {
            return new TreeSet<A>(this.beforePublish(this.tree), super.ordering());
        }

        public TreeSetBuilder(Ordering<A> ordering) {
            super(ordering);
        }
    }
}

