/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable;

import io.github.alexarchambault.pythonnativelibs.shaded.scala.Array$;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.Function1;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.IndexedSeqOps;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.Iterable;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.IterableOnce;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.Iterator;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.SeqFactory;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.StrictOptimizedIterableOps;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.StrictOptimizedSeqOps;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.generic.DefaultSerializable;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.AbstractBuffer;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.ArrayBuffer$;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.ArrayBufferView;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.Growable;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.IndexedBuffer;
import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ArrayBuffer, ArrayBuffer<A>>,
DefaultSerializable,
IndexedBuffer<A> {
    private transient int mutationCount = 0;
    private Object[] array;
    private int size0;

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object drop(int n) {
        return IndexedSeqOps.drop$(this, n);
    }

    @Override
    public Object slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$(this, len);
    }

    public Object[] array() {
        return this.array;
    }

    public void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    public int size0() {
        return this.size0;
    }

    public void size0_$eq(int x$1) {
        this.size0 = x$1;
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public void ensureSize(int n) {
        this.array_$eq(ArrayBuffer$.MODULE$.scala$collection$mutable$ArrayBuffer$$ensureSize(this.array(), this.size0(), n));
    }

    private void reduceToSize(int n) {
        ++this.mutationCount;
        Arrays.fill(this.array(), n, this.size0(), null);
        this.size0_$eq(n);
    }

    @Override
    public A apply(int n) {
        int checkWithinBounds_hi = n + 1;
        if (n < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(n).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(checkWithinBounds_hi - 1).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        return (A)this.array()[n];
    }

    public void update(int index, A elem) {
        int checkWithinBounds_hi = index + 1;
        if (index < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(index).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(checkWithinBounds_hi - 1).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        ++this.mutationCount;
        this.array()[index] = elem;
    }

    @Override
    public int length() {
        return this.size0();
    }

    public ArrayBufferView<A> view() {
        return new ArrayBufferView(this, () -> $this.mutationCount);
    }

    @Override
    public SeqFactory<ArrayBuffer> iterableFactory() {
        return ArrayBuffer$.MODULE$;
    }

    @Override
    public void clear() {
        this.reduceToSize(0);
    }

    @Override
    public ArrayBuffer<A> addOne(A elem) {
        ++this.mutationCount;
        int oldSize = this.size0();
        this.ensureSize(oldSize + 1);
        this.size0_$eq(oldSize + 1);
        this.update(oldSize, elem);
        return this;
    }

    @Override
    public ArrayBuffer<A> addAll(IterableOnce<A> elems) {
        if (elems instanceof ArrayBuffer) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)elems;
            int elemsLength = arrayBuffer.size0();
            if (elemsLength > 0) {
                ++this.mutationCount;
                this.ensureSize(this.length() + elemsLength);
                Array$.MODULE$.copy(arrayBuffer.array(), 0, this.array(), this.length(), elemsLength);
                this.size0_$eq(this.length() + elemsLength);
            }
        } else {
            Growable.addAll$(this, elems);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public A remove(int index) {
        void var2_3;
        int checkWithinBounds_hi = index + 1;
        if (index < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(index).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        if (checkWithinBounds_hi > this.size0()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(checkWithinBounds_hi - 1).append(" is out of bounds (min 0, max ").append(this.size0() - 1).append(")").toString());
        }
        A res = this.apply(index);
        Array$.MODULE$.copy(this.array(), index + 1, this.array(), index, this.size0() - (index + 1));
        this.reduceToSize(this.size0() - 1);
        return var2_3;
    }

    @Override
    public String stringPrefix() {
        return "ArrayBuffer";
    }

    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        int elemsToCopyToArray_max_y;
        int elemsToCopyToArray_min_y;
        int n = Array.getLength(xs);
        int elemsToCopyToArray_srcLen = this.length();
        int n2 = Math.min(len, elemsToCopyToArray_srcLen);
        int n3 = Math.min(n2, elemsToCopyToArray_min_y = n - start);
        int n4 = Math.max(n3, elemsToCopyToArray_max_y = 0);
        if (n4 > 0) {
            Array$.MODULE$.copy(this.array(), 0, xs, start, n4);
        }
        return n4;
    }

    public ArrayBuffer(Object[] initialElements, int initialSize) {
        this.array = initialElements;
        this.size0 = initialSize;
    }

    public ArrayBuffer() {
        this(new Object[16], 0);
    }
}

