/*
 * Decompiled with CFR 0.152.
 */
package io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable;

import io.github.alexarchambault.pythonnativelibs.shaded.scala.collection.mutable.HashEntry;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.runtime.BoxesRunTime;
import io.github.alexarchambault.pythonnativelibs.shaded.scala.runtime.Statics;
import java.util.Arrays;

public interface HashTable<A, B, Entry extends HashEntry<A, Entry>>
extends HashUtils<A> {
    public int _loadFactor();

    public void _loadFactor_$eq(int var1);

    public HashEntry<A, Entry>[] table();

    public void table_$eq(HashEntry<A, Entry>[] var1);

    public int tableSize();

    public void tableSize_$eq(int var1);

    public int threshold();

    public void threshold_$eq(int var1);

    public int[] sizemap();

    public void sizemap_$eq(int[] var1);

    public int seedvalue();

    public void seedvalue_$eq(int var1);

    public static /* synthetic */ int tableSizeSeed$(HashTable $this) {
        return $this.tableSizeSeed();
    }

    default public int tableSizeSeed() {
        return Integer.bitCount(this.table().length - 1);
    }

    public static /* synthetic */ int initialSize$(HashTable $this) {
        return $this.initialSize();
    }

    default public int initialSize() {
        return 16;
    }

    private int initialThreshold(int _loadFactor) {
        return (int)((long)this.initialCapacity() * (long)_loadFactor / (long)1000);
    }

    private int initialCapacity() {
        int capacity_expectedSize = this.initialSize();
        return 1 << -Integer.numberOfLeadingZeros(capacity_expectedSize - 1);
    }

    public static /* synthetic */ HashEntry findEntry$(HashTable $this, Object key) {
        return $this.findEntry(key);
    }

    default public Entry findEntry(A key) {
        return this.findEntry0(key, this.index(this.elemHashCode(key)));
    }

    public static /* synthetic */ HashEntry findEntry0$(HashTable $this, Object key, int h) {
        return $this.findEntry0(key, h);
    }

    /*
     * WARNING - void declaration
     */
    default public Entry findEntry0(A key, int h) {
        void var3_3;
        for (HashEntry<A, Object> e = this.table()[h]; e != null && !this.elemEquals(e.key(), key); e = e.next()) {
        }
        return var3_3;
    }

    public static /* synthetic */ void addEntry0$(HashTable $this, HashEntry e, int h) {
        $this.addEntry0(e, h);
    }

    default public void addEntry0(Entry e, int h) {
        e.next_$eq(this.table()[h]);
        this.table()[h] = e;
        this.tableSize_$eq(this.tableSize() + 1);
        this.nnSizeMapAdd(h);
        if (this.tableSize() > this.threshold()) {
            this.resize(2 * this.table().length);
        }
    }

    public static /* synthetic */ HashEntry findOrAddEntry$(HashTable $this, Object key, Object value) {
        return $this.findOrAddEntry(key, value);
    }

    default public Entry findOrAddEntry(A key, B value) {
        int h = this.index(this.elemHashCode(key));
        Entry e = this.findEntry0(key, h);
        if (e != null) {
            return e;
        }
        this.addEntry0(this.createNewEntry(key, value), h);
        return null;
    }

    public Entry createNewEntry(A var1, B var2);

    public static /* synthetic */ HashEntry removeEntry$(HashTable $this, Object key) {
        return $this.removeEntry(key);
    }

    default public Entry removeEntry(A key) {
        return this.removeEntry0(key, this.index(this.elemHashCode(key)));
    }

    public static /* synthetic */ HashEntry removeEntry0$(HashTable $this, Object key, int h) {
        return $this.removeEntry0(key, h);
    }

    default public Entry removeEntry0(A key, int h) {
        HashEntry<A, Object> e = this.table()[h];
        if (e != null) {
            Object e1;
            if (this.elemEquals(e.key(), key)) {
                this.table()[h] = e.next();
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e.next_$eq(null);
                return (Entry)e;
            }
            for (e1 = e.next(); e1 != null && !this.elemEquals(e1.key(), key); e1 = e1.next()) {
                e = e1;
            }
            if (e1 != null) {
                e.next_$eq(e1.next());
                this.tableSize_$eq(this.tableSize() - 1);
                this.nnSizeMapRemove(h);
                e1.next_$eq(null);
                return (Entry)e1;
            }
        }
        return null;
    }

    public static /* synthetic */ void clearTable$(HashTable $this) {
        $this.clearTable();
    }

    default public void clearTable() {
        for (int i = this.table().length - 1; i >= 0; --i) {
            this.table()[i] = null;
        }
        this.tableSize_$eq(0);
        this.nnSizeMapReset(0);
    }

    private void resize(int newSize) {
        HashEntry<A, Entry>[] oldTable = this.table();
        this.table_$eq(new HashEntry[newSize]);
        this.nnSizeMapReset(this.table().length);
        for (int i = oldTable.length - 1; i >= 0; --i) {
            HashEntry<A, Object> e = oldTable[i];
            while (e != null) {
                int h = this.index(this.elemHashCode(e.key()));
                Entry e1 = e.next();
                e.next_$eq(this.table()[h]);
                this.table()[h] = e;
                e = e1;
                this.nnSizeMapAdd(h);
            }
        }
        int newThreshold__loadFactor = this._loadFactor();
        this.threshold_$eq((int)((long)newSize * (long)newThreshold__loadFactor / (long)1000));
    }

    public static /* synthetic */ void nnSizeMapAdd$(HashTable $this, int h) {
        $this.nnSizeMapAdd(h);
    }

    default public void nnSizeMapAdd(int h) {
        if (this.sizemap() != null) {
            int[] nArray = this.sizemap();
            int n = h >> 5;
            nArray[n] = nArray[n] + 1;
        }
    }

    public static /* synthetic */ void nnSizeMapRemove$(HashTable $this, int h) {
        $this.nnSizeMapRemove(h);
    }

    default public void nnSizeMapRemove(int h) {
        if (this.sizemap() != null) {
            int[] nArray = this.sizemap();
            int n = h >> 5;
            nArray[n] = nArray[n] - 1;
        }
    }

    public static /* synthetic */ void nnSizeMapReset$(HashTable $this, int tableLength) {
        $this.nnSizeMapReset(tableLength);
    }

    default public void nnSizeMapReset(int tableLength) {
        if (this.sizemap() != null) {
            int n = (tableLength >> 5) + 1;
            if (this.sizemap().length != n) {
                this.sizemap_$eq(new int[n]);
                return;
            }
            Arrays.fill(this.sizemap(), 0);
        }
    }

    public static /* synthetic */ boolean elemEquals$(HashTable $this, Object key1, Object key2) {
        return $this.elemEquals(key1, key2);
    }

    default public boolean elemEquals(A key1, A key2) {
        return BoxesRunTime.equals(key1, key2);
    }

    public static /* synthetic */ int index$(HashTable $this, int hcode) {
        return $this.index(hcode);
    }

    default public int index(int hcode) {
        int ones = this.table().length - 1;
        int exponent = Integer.numberOfLeadingZeros(ones);
        return this.improve(hcode, this.seedvalue()) >>> exponent & ones;
    }

    public static void $init$(HashTable $this) {
        $this._loadFactor_$eq(750);
        $this.table_$eq(new HashEntry[$this.initialCapacity()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq($this.initialThreshold($this._loadFactor()));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }

    public static interface HashUtils<KeyType> {
        public static /* synthetic */ int elemHashCode$(HashUtils $this, Object key) {
            return $this.elemHashCode(key);
        }

        default public int elemHashCode(KeyType key) {
            return Statics.anyHash(key);
        }

        public static /* synthetic */ int improve$(HashUtils $this, int hcode, int seed) {
            return $this.improve(hcode, seed);
        }

        default public int improve(int hcode, int seed) {
            return Integer.rotateRight(Integer.reverseBytes(hcode * -1640532531) * -1640532531, seed);
        }
    }
}

