/*
 * Decompiled with CFR 0.152.
 */
package io.github.amanzat.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);
    public static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    public static List<String> readAllLines(String filePath) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        return Files.readAllLines(path);
    }

    public static boolean ensureDirectoryExists(String path) {
        if (!new File(path).exists()) {
            try {
                Path directoryPath = Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
                logger.info("Directory {} created", (Object)path);
                return Files.exists(directoryPath, new LinkOption[0]);
            }
            catch (IOException e) {
                logger.error("The directory {} can't be created", (Object)path, (Object)e);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteFile(String filePath) {
        try {
            if (Files.deleteIfExists(Paths.get(filePath, new String[0]))) {
                logger.info("File {} deleted successfully.", (Object)filePath);
                return true;
            }
            logger.warn("File {} doesn't exists.", (Object)filePath);
        }
        catch (IOException e) {
            logger.error("Error while deleting file {}", (Object)filePath, (Object)e);
        }
        return false;
    }

    public static String getFileName(String path) {
        if (path == null) {
            return null;
        }
        int index = FileUtils.indexOfLastDirectorySeparator(path);
        return path.substring(index + 1);
    }

    public static int indexOfLastDirectorySeparator(String path) {
        if (path == null) {
            return -1;
        }
        int lastUnixPos = path.lastIndexOf(47);
        int lastWindowsPos = path.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    @Generated
    private FileUtils() {
    }
}

