/*
 * Decompiled with CFR 0.152.
 */
package io.github.amanzat.util;

import io.github.amanzat.util.StringUtils;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtils {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DateTimeUtils.class);
    public static final long HOUR_MILLIS = Duration.ofHours(1L).toMillis();
    public static final long MINUTE_MILLIS = Duration.ofMinutes(1L).toMillis();
    public static final long SECOND_MILLIS = Duration.ofSeconds(1L).toMillis();

    public static String formatDurationHMS(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("The time duration in millis can't be negative.");
        }
        long hours = Math.floorDiv(millis, HOUR_MILLIS);
        long minutes = Math.floorDiv(millis %= HOUR_MILLIS, MINUTE_MILLIS);
        long seconds = Math.floorDiv(millis %= MINUTE_MILLIS, SECOND_MILLIS);
        return StringUtils.leftPad(String.valueOf(hours), 2, '0') + ":" + StringUtils.leftPad(String.valueOf(minutes), 2, '0') + ":" + StringUtils.leftPad(String.valueOf(seconds), 2, '0') + "." + StringUtils.leftPad(String.valueOf(millis %= SECOND_MILLIS), 3, '0');
    }

    public static Duration asDuration(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        try {
            return Duration.parse(value);
        }
        catch (DateTimeParseException e) {
            logger.warn("Error parsing {} to Duration.", (Object)value);
            return null;
        }
    }

    @Generated
    private DateTimeUtils() {
    }
}

