/*
 * Decompiled with CFR 0.152.
 */
package io.github.amanzat.util;

import java.util.Arrays;
import lombok.Generated;

public final class StringUtils {
    public static final String EMPTY_STRING = "";
    public static final String NEW_LINE = System.lineSeparator();
    public static final String TRUNCATION_MARKER = "..";

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.isEmpty();
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static boolean isBlank(CharSequence charSequence) {
        int length = StringUtils.length(charSequence);
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String toUpperCase(String value) {
        return value != null ? value.toUpperCase() : null;
    }

    public static String toLowerCase(String value) {
        return value != null ? value.toLowerCase() : null;
    }

    public static String truncateWithMarker(String value, int maxLength) {
        if (StringUtils.isBlank(value) || value.length() <= maxLength) {
            return value;
        }
        int markerLength = TRUNCATION_MARKER.length();
        return maxLength <= markerLength ? value.substring(0, maxLength) : value.substring(0, maxLength - markerLength).concat(TRUNCATION_MARKER);
    }

    public static String leftPad(String input, int size, char character) {
        return StringUtils.pad(input, size, character, Padding.LEFT);
    }

    public static String rightPad(String input, int size, char character) {
        return StringUtils.pad(input, size, character, Padding.RIGHT);
    }

    public static String concat(String value, char delimiter, String ... others) {
        if (others == null || others.length == 0) {
            return value;
        }
        StringBuilder result = new StringBuilder(value);
        for (String other : others) {
            result.append(delimiter).append(other);
        }
        return result.toString();
    }

    public static String concat(char delimiter, String ... values) {
        if (values == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (String value : values) {
            if (first) {
                first = false;
            } else {
                result.append(delimiter);
            }
            result.append(value);
        }
        return result.toString();
    }

    public static String[] concat(String value, String ... others) {
        if (others == null || others.length == 0) {
            return new String[]{value};
        }
        String[] result = new String[others.length + 1];
        result[0] = value;
        System.arraycopy(others, 0, result, 1, others.length);
        return result;
    }

    public static boolean onlyDigits(CharSequence value, int length) {
        if (value == null) {
            return false;
        }
        if (value.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String pad(String input, int size, char character, Padding padding) {
        if (input == null) {
            return null;
        }
        int padSize = size - input.length();
        if (padSize <= 0) {
            return input;
        }
        char[] chars = new char[padSize];
        Arrays.fill(chars, character);
        return padding.concat(input, String.valueOf(chars));
    }

    @Generated
    private StringUtils() {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Padding {
        LEFT{

            @Override
            public String concat(String str, String padStr) {
                return padStr.concat(str);
            }
        }
        ,
        RIGHT{

            @Override
            public String concat(String str, String padStr) {
                return str.concat(padStr);
            }
        };


        public abstract String concat(String var1, String var2);
    }
}

