/*
 * Decompiled with CFR 0.152.
 */
package io.github.amanzat.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadUtils {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);

    public static void safeSleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.warn("Error while sleeping.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void safeAwait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.warn("Error occurred while awaiting for CountDownLatch.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void safeAcquire(Semaphore semaphore) {
        try {
            semaphore.acquire();
        }
        catch (InterruptedException e) {
            logger.warn("Error occurred while acquiring semaphore permit.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Generated
    private ThreadUtils() {
    }
}

