/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.iban;

import java.math.BigInteger;
import sk.antons.iban.IbanConfig;
import sk.antons.iban.IbanConfigRepository;

public class Iban {
    String iban;
    IbanConfig config;

    private Iban(String iban, IbanConfig config) {
        this.iban = iban;
        this.config = config;
        if (this.config == null) {
            throw new IllegalArgumentException("unable to create iban from " + iban);
        }
    }

    public static Iban instance(String iban) {
        return Iban.instance(iban, IbanConfigRepository.parse(iban));
    }

    public static Iban instance(String iban, IbanConfig config) {
        if (iban == null) {
            throw new IllegalArgumentException("iban is null");
        }
        if (iban.length() < 4) {
            throw new IllegalArgumentException("malformed iban " + iban);
        }
        int pos = iban.indexOf(32);
        if (pos >= 0) {
            StringBuilder sb = new StringBuilder();
            int len = iban.length();
            for (int i = 0; i < len; ++i) {
                char c = iban.charAt(i);
                if (c == ' ') continue;
                sb.append(c);
            }
            iban = sb.toString();
        }
        return new Iban(iban, config);
    }

    public String toString() {
        return this.iban;
    }

    public String iban() {
        return this.iban;
    }

    public String ibanPretty() {
        StringBuilder sb = new StringBuilder();
        int len = this.iban.length();
        int spacePos = 0;
        for (int i = 0; i < len; ++i) {
            if (spacePos == 4) {
                sb.append(' ');
                spacePos = 0;
            }
            char c = this.iban.charAt(i);
            sb.append(c);
            ++spacePos;
        }
        return sb.toString();
    }

    public boolean lengthCheck() {
        return this.iban.length() == this.config.length();
    }

    public boolean formatCheck() {
        return this.config.formatCheck(this.iban);
    }

    public boolean ibanCheck() {
        return Iban.ibanCheck(this.iban);
    }

    public static boolean ibanCheck(String iban) {
        char c;
        int i;
        if (iban == null) {
            return false;
        }
        if (iban.length() < 4) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        int len = iban.length();
        for (i = 4; i < len; ++i) {
            c = iban.charAt(i);
            Iban.addIbanCharAsNumber(sb, c);
        }
        for (i = 0; i < 4; ++i) {
            c = iban.charAt(i);
            Iban.addIbanCharAsNumber(sb, c);
        }
        BigInteger bi = new BigInteger(sb.toString());
        BigInteger mod = bi.mod(BigInteger.valueOf(97L));
        return mod.intValue() == 1;
    }

    public static String ibanFix(String iban) {
        char c;
        int i;
        if (iban == null) {
            return null;
        }
        if (iban.length() < 4) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = iban.length();
        for (i = 4; i < len; ++i) {
            c = iban.charAt(i);
            Iban.addIbanCharAsNumber(sb, c);
        }
        for (i = 0; i < 2; ++i) {
            c = iban.charAt(i);
            Iban.addIbanCharAsNumber(sb, c);
        }
        sb.append("00");
        BigInteger bi = new BigInteger(sb.toString());
        BigInteger mod = bi.mod(BigInteger.valueOf(97L));
        int modi = mod.intValue();
        int checksum = 98 - modi;
        if (checksum < 10) {
            return iban.substring(0, 2) + "0" + checksum + iban.substring(4);
        }
        return iban.substring(0, 2) + checksum + iban.substring(4);
    }

    private static void addIbanCharAsNumber(StringBuilder sb, char c) {
        if ('0' <= c && c <= '9') {
            sb.append(c);
        } else {
            sb.append(c - 65 + 10);
        }
    }

    public String pattern() {
        return this.config.pattern;
    }

    public String format() {
        return this.config.format();
    }

    public String accountNumber() {
        return this.config.resolver('c').resolve(this.iban);
    }

    public String accountNumberPrefix() {
        return this.config.resolver('p').resolve(this.iban);
    }

    public String nationalBankNumber() {
        return this.config.resolver('b').resolve(this.iban);
    }

    public String bic() {
        return this.config.resolver('q').resolve(this.iban);
    }

    public String currency() {
        return this.config.resolver('m').resolve(this.iban);
    }

    public String branch() {
        return this.config.resolver('s').resolve(this.iban);
    }

    public String accountType() {
        return this.config.resolver('t').resolve(this.iban);
    }

    public String checkDigits() {
        return this.config.resolver('x').resolve(this.iban);
    }

    public String patternPart(char c) {
        return this.config.resolver(c).resolve(this.iban);
    }

    public static void main(String[] argv) {
        Iban iban = Iban.instance("SK17 0900 0000 0000 2404 1632");
        System.out.println(" iban: " + iban.iban());
        System.out.println(" iban pretty : " + iban.ibanPretty());
        System.out.println(" iban pattern : " + iban.pattern());
        System.out.println(" iban format : " + iban.format());
        System.out.println(" iban check length : " + iban.lengthCheck());
        System.out.println(" iban check format : " + iban.formatCheck());
        System.out.println(" iban check iban : " + iban.ibanCheck());
        System.out.println(" iban accountNumber : " + iban.accountNumber());
        System.out.println(" iban accountNumberPrefix : " + iban.accountNumberPrefix());
        System.out.println(" iban nationalBankNumber : " + iban.nationalBankNumber());
        System.out.println(" iban bic : " + iban.bic());
        System.out.println(" iban currency : " + iban.currency());
        System.out.println(" iban branch : " + iban.branch());
        System.out.println(" iban accountType : " + iban.accountType());
        System.out.println(" iban checkDigits : " + iban.checkDigits());
        System.out.println(" iban patternPart : " + iban.patternPart('b'));
        String ib = "SK1709000000000024041632";
        String ibf = Iban.ibanFix(ib);
        System.out.println(" iban " + ib + " check : " + Iban.ibanCheck(ib));
        System.out.println(" iban " + ibf + " check : " + Iban.ibanCheck(ibf));
        ib = "SK1509000000000024041632";
        ibf = Iban.ibanFix(ib);
        System.out.println(" iban " + ib + " check : " + Iban.ibanCheck(ib));
        System.out.println(" iban " + ibf + " check : " + Iban.ibanCheck(ibf));
        ib = "SK7509000000000024041632";
        ibf = Iban.ibanFix(ib);
        System.out.println(" iban " + ib + " check : " + Iban.ibanCheck(ib));
        System.out.println(" iban " + ibf + " check : " + Iban.ibanCheck(ibf));
    }
}

