/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.iban;

import java.util.function.IntPredicate;

public class IbanSubstringCheck {
    IntPredicate check;
    int startPos;
    int endPos;
    String type;

    public IbanSubstringCheck(String type, IntPredicate check, int startPos, int endPos) {
        this.check = check;
        this.startPos = startPos;
        this.endPos = endPos;
        this.type = type;
    }

    public boolean validate(String iban) {
        for (int i = this.startPos; i < this.endPos; ++i) {
            char c = iban.charAt(i);
            if (this.check.test(c)) continue;
            return false;
        }
        return true;
    }

    public static IbanSubstringCheck numeric(int startPos, int endPos) {
        return new IbanSubstringCheck("0", c -> 48 <= c && c <= 57, startPos, endPos);
    }

    public static IbanSubstringCheck capitals(int startPos, int endPos) {
        return new IbanSubstringCheck("A", c -> 65 <= c && c <= 90, startPos, endPos);
    }

    public static IbanSubstringCheck letters(int startPos, int endPos) {
        return new IbanSubstringCheck("Aa0", c -> 65 <= c && c <= 90 || 97 <= c && c <= 122 || 48 <= c && c <= 57, startPos, endPos);
    }

    public String toString() {
        return this.type + "[" + this.startPos + "-" + this.endPos + "]";
    }
}

