/*
 * Copyright 2023 Anton Straka
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package sk.antons.siutils.handler;

import java.util.function.Consumer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;

/**
 * Simple service call message handler. Implementations just process message 
 * data. Original message is returned to flow. 
 * @author antons
 */
public class AdhocMessageConsumer extends MessageConsumer {
    final Consumer<Message<?>> consumer;
    
    public AdhocMessageConsumer(Consumer<Message<?>> consumer) {
        this.consumer = consumer;
    }
    
    public static AdhocMessageConsumer consumeBy(final Consumer<Message<?>> consumer) {
        return new AdhocMessageConsumer(consumer);
    }

    @Override
    protected void accept(Message<?> message) throws MessagingException {
        consumer.accept(message);
    }

}
