/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.binary;

public class Hex {
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int fromHex(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Can't convert char '" + c + "' to hex number");
    }

    public static String encode(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int hb = b >> 4 & 0xF;
            int lb = b & 0xF;
            buff.append(hex[hb]);
            buff.append(hex[lb]);
        }
        return buff.toString();
    }

    public static byte[] decode(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        int len = str.length() / 2;
        if (str.length() % 2 != 0) {
            throw new IllegalArgumentException("Length of hex encoded string must be divided by 2");
        }
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int hb = Hex.fromHex(str.charAt(2 * i));
            int lb = Hex.fromHex(str.charAt(2 * i + 1));
            bytes[i] = (byte)((hb << 4 | lb) & 0xFF);
        }
        return bytes;
    }
}

