/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.binary;

import java.util.HashMap;
import java.util.Map;

public class Html {
    private static Node root = null;
    private static Map<Character, String> names = null;

    public static String escapeSimple(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() * 2);
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeSimpleAndNonAscii(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() * 2);
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    if (c < '\u0080') {
                        sb.append(c);
                        continue block7;
                    }
                    sb.append("&#").append((int)c).append(';');
                }
            }
        }
        return sb.toString();
    }

    public static String escapeNames(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() * 2);
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    String name = Html.names().get(Character.valueOf(c));
                    if (name == null) {
                        sb.append(c);
                        continue block7;
                    }
                    sb.append(name);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeNamesAndNonAscii(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() * 2);
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                default: {
                    String name = Html.names().get(Character.valueOf(c));
                    if (name != null) {
                        sb.append(name);
                        continue block7;
                    }
                    if (c < '\u007f') {
                        sb.append(c);
                        continue block7;
                    }
                    sb.append("&#").append((int)c).append(';');
                }
            }
        }
        return sb.toString();
    }

    public static String unescape(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length());
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                char nc = Html.charAt(value, len, i + 1);
                if (nc == '#') {
                    int num;
                    int numlen;
                    char nnc = Html.charAt(value, len, i + 2);
                    if (nnc == 'x') {
                        numlen = Html.hexLen(value, len, i + 3);
                        if (numlen > 0) {
                            num = Html.hexNum(value, len, i + 3, numlen);
                            sb.append((char)num);
                            i = i + numlen + 3;
                            continue;
                        }
                        sb.append(c);
                        continue;
                    }
                    numlen = Html.decimalLen(value, len, i + 2);
                    if (numlen > 0) {
                        num = Html.decimalNum(value, len, i + 2, numlen);
                        sb.append((char)num);
                        i = i + numlen + 2;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                Node node = Html.root().find(value, len, i);
                if (node == null) {
                    sb.append(c);
                    continue;
                }
                sb.append(node.character);
                i = i + node.name.length() - 1;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static char charAt(String value, int len, int index) {
        if (index < len) {
            return value.charAt(index);
        }
        return '\u0000';
    }

    private static int decimalLen(String value, int len, int index) {
        for (int i = 0; i < 5; ++i) {
            char c = Html.charAt(value, len, index + i);
            if (c == ';') {
                return i;
            }
            if (c < '0' || c > '9') break;
        }
        return -1;
    }

    private static int decimalNum(String value, int len, int index, int numlen) {
        int num = 0;
        for (int i = 0; i < numlen; ++i) {
            char c = Html.charAt(value, len, index + i);
            num = num * 10 + c - 48;
        }
        return num;
    }

    private static int hexLen(String value, int len, int index) {
        for (int i = 0; i < 5; ++i) {
            char c = Html.charAt(value, len, index + i);
            if (c == ';') {
                return i;
            }
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) break;
        }
        return -1;
    }

    private static int hexNum(String value, int len, int index, int numlen) {
        int num = 0;
        for (int i = 0; i < numlen; ++i) {
            char c = Html.charAt(value, len, index + i);
            num = c >= '0' && c <= '9' ? num * 16 + c - 48 : (c >= 'a' && c <= 'f' ? num * 16 + c - 97 : num * 16 + c - 65);
        }
        return num;
    }

    private static Node root() {
        if (root == null) {
            Html.init();
        }
        return root;
    }

    private static Map<Character, String> names() {
        if (names == null) {
            Html.init();
        }
        return names;
    }

    private static void addName(String name, char c, Node root, Map<Character, String> names) {
        root.add(name, c, 0);
        names.put(Character.valueOf(c), name);
    }

    private static void init() {
        Node node = new Node();
        HashMap<Character, String> map = new HashMap<Character, String>();
        Html.addName("&amp;", '&', node, map);
        Html.addName("&apos;", '\'', node, map);
        Html.addName("&quot;", '\"', node, map);
        Html.addName("&lt;", '<', node, map);
        Html.addName("&gt;", '>', node, map);
        Html.addName("&Aacute;", '\u00c1', node, map);
        Html.addName("&aacute;", '\u00e1', node, map);
        Html.addName("&Acirc;", '\u00c2', node, map);
        Html.addName("&acirc;", '\u00e2', node, map);
        Html.addName("&acute;", '\u00b4', node, map);
        Html.addName("&AElig;", '\u00c6', node, map);
        Html.addName("&aelig;", '\u00e6', node, map);
        Html.addName("&Agrave;", '\u00c0', node, map);
        Html.addName("&agrave;", '\u00e0', node, map);
        Html.addName("&alefsym;", '\u2135', node, map);
        Html.addName("&Alpha;", '\u0391', node, map);
        Html.addName("&alpha;", '\u03b1', node, map);
        Html.addName("&and;", '\u2227', node, map);
        Html.addName("&ang;", '\u2220', node, map);
        Html.addName("&Aring;", '\u00c5', node, map);
        Html.addName("&aring;", '\u00e5', node, map);
        Html.addName("&asymp;", '\u2248', node, map);
        Html.addName("&Atilde;", '\u00c3', node, map);
        Html.addName("&atilde;", '\u00e3', node, map);
        Html.addName("&Auml;", '\u00c4', node, map);
        Html.addName("&auml;", '\u00e4', node, map);
        Html.addName("&bdquo;", '\u201e', node, map);
        Html.addName("&Beta;", '\u0392', node, map);
        Html.addName("&beta;", '\u03b2', node, map);
        Html.addName("&brvbar;", '\u00a6', node, map);
        Html.addName("&bull;", '\u2022', node, map);
        Html.addName("&cap;", '\u2229', node, map);
        Html.addName("&Ccedil;", '\u00c7', node, map);
        Html.addName("&ccedil;", '\u00e7', node, map);
        Html.addName("&cedil;", '\u00b8', node, map);
        Html.addName("&cent;", '\u00a2', node, map);
        Html.addName("&Chi;", '\u03a7', node, map);
        Html.addName("&chi;", '\u03c7', node, map);
        Html.addName("&circ;", '\u02c6', node, map);
        Html.addName("&clubs;", '\u2663', node, map);
        Html.addName("&cong;", '\u2245', node, map);
        Html.addName("&copy;", '\u00a9', node, map);
        Html.addName("&crarr;", '\u21b5', node, map);
        Html.addName("&cup;", '\u222a', node, map);
        Html.addName("&curren;", '\u00a4', node, map);
        Html.addName("&dagger;", '\u2020', node, map);
        Html.addName("&Dagger;", '\u2021', node, map);
        Html.addName("&darr;", '\u2193', node, map);
        Html.addName("&dArr;", '\u21d3', node, map);
        Html.addName("&deg;", '\u00b0', node, map);
        Html.addName("&Delta;", '\u0394', node, map);
        Html.addName("&delta;", '\u03b4', node, map);
        Html.addName("&diams;", '\u2666', node, map);
        Html.addName("&divide;", '\u00f7', node, map);
        Html.addName("&Eacute;", '\u00c9', node, map);
        Html.addName("&eacute;", '\u00e9', node, map);
        Html.addName("&Ecirc;", '\u00ca', node, map);
        Html.addName("&ecirc;", '\u00ea', node, map);
        Html.addName("&Egrave;", '\u00c8', node, map);
        Html.addName("&egrave;", '\u00e8', node, map);
        Html.addName("&empty;", '\u2205', node, map);
        Html.addName("&emsp;", '\u2003', node, map);
        Html.addName("&ensp;", '\u2002', node, map);
        Html.addName("&Epsilon;", '\u0395', node, map);
        Html.addName("&epsilon;", '\u03b5', node, map);
        Html.addName("&equiv;", '\u2261', node, map);
        Html.addName("&Eta;", '\u0397', node, map);
        Html.addName("&eta;", '\u03b7', node, map);
        Html.addName("&ETH;", '\u00d0', node, map);
        Html.addName("&eth;", '\u00f0', node, map);
        Html.addName("&Euml;", '\u00cb', node, map);
        Html.addName("&euml;", '\u00eb', node, map);
        Html.addName("&euro;", '\u20ac', node, map);
        Html.addName("&exist;", '\u2203', node, map);
        Html.addName("&fnof;", '\u0192', node, map);
        Html.addName("&forall;", '\u2200', node, map);
        Html.addName("&frac12;", '\u00bd', node, map);
        Html.addName("&frac14;", '\u00bc', node, map);
        Html.addName("&frac34;", '\u00be', node, map);
        Html.addName("&frasl;", '\u2044', node, map);
        Html.addName("&Gamma;", '\u0393', node, map);
        Html.addName("&gamma;", '\u03b3', node, map);
        Html.addName("&ge;", '\u2265', node, map);
        Html.addName("&harr;", '\u2194', node, map);
        Html.addName("&hArr;", '\u21d4', node, map);
        Html.addName("&hearts;", '\u2665', node, map);
        Html.addName("&hellip;", '\u2026', node, map);
        Html.addName("&Iacute;", '\u00cd', node, map);
        Html.addName("&iacute;", '\u00ed', node, map);
        Html.addName("&Icirc;", '\u00ce', node, map);
        Html.addName("&icirc;", '\u00ee', node, map);
        Html.addName("&iexcl;", '\u00a1', node, map);
        Html.addName("&Igrave;", '\u00cc', node, map);
        Html.addName("&igrave;", '\u00ec', node, map);
        Html.addName("&image;", '\u2111', node, map);
        Html.addName("&infin;", '\u221e', node, map);
        Html.addName("&int;", '\u222b', node, map);
        Html.addName("&Iota;", '\u0399', node, map);
        Html.addName("&iota;", '\u03b9', node, map);
        Html.addName("&iquest;", '\u00bf', node, map);
        Html.addName("&isin;", '\u2208', node, map);
        Html.addName("&Iuml;", '\u00cf', node, map);
        Html.addName("&iuml;", '\u00ef', node, map);
        Html.addName("&Kappa;", '\u039a', node, map);
        Html.addName("&kappa;", '\u03ba', node, map);
        Html.addName("&Lambda;", '\u039b', node, map);
        Html.addName("&lambda;", '\u03bb', node, map);
        Html.addName("&lang;", '\u2329', node, map);
        Html.addName("&laquo;", '\u00ab', node, map);
        Html.addName("&larr;", '\u2190', node, map);
        Html.addName("&lArr;", '\u21d0', node, map);
        Html.addName("&lceil;", '\u2308', node, map);
        Html.addName("&ldquo;", '\u201c', node, map);
        Html.addName("&le;", '\u2264', node, map);
        Html.addName("&lfloor;", '\u230a', node, map);
        Html.addName("&lowast;", '\u2217', node, map);
        Html.addName("&loz;", '\u25ca', node, map);
        Html.addName("&lrm;", '\u200e', node, map);
        Html.addName("&lsaquo;", '\u2039', node, map);
        Html.addName("&lsquo;", '\u2018', node, map);
        Html.addName("&macr;", '\u00af', node, map);
        Html.addName("&mdash;", '\u2014', node, map);
        Html.addName("&micro;", '\u00b5', node, map);
        Html.addName("&middot;", '\u00b7', node, map);
        Html.addName("&minus;", '\u2212', node, map);
        Html.addName("&Mu;", '\u039c', node, map);
        Html.addName("&mu;", '\u03bc', node, map);
        Html.addName("&nabla;", '\u2207', node, map);
        Html.addName("&nbsp;", '\u00a0', node, map);
        Html.addName("&ndash;", '\u2013', node, map);
        Html.addName("&ne;", '\u2260', node, map);
        Html.addName("&ni;", '\u220b', node, map);
        Html.addName("&notin;", '\u2209', node, map);
        Html.addName("&not;", '\u00ac', node, map);
        Html.addName("&nsub;", '\u2284', node, map);
        Html.addName("&Ntilde;", '\u00d1', node, map);
        Html.addName("&ntilde;", '\u00f1', node, map);
        Html.addName("&Nu;", '\u039d', node, map);
        Html.addName("&nu;", '\u03bd', node, map);
        Html.addName("&Oacute;", '\u00d3', node, map);
        Html.addName("&oacute;", '\u00f3', node, map);
        Html.addName("&Ocirc;", '\u00d4', node, map);
        Html.addName("&ocirc;", '\u00f4', node, map);
        Html.addName("&OElig;", '\u0152', node, map);
        Html.addName("&oelig;", '\u0153', node, map);
        Html.addName("&Ograve;", '\u00d2', node, map);
        Html.addName("&ograve;", '\u00f2', node, map);
        Html.addName("&oline;", '\u203e', node, map);
        Html.addName("&Omega;", '\u03a9', node, map);
        Html.addName("&omega;", '\u03c9', node, map);
        Html.addName("&Omicron;", '\u039f', node, map);
        Html.addName("&omicron;", '\u03bf', node, map);
        Html.addName("&oplus;", '\u2295', node, map);
        Html.addName("&ordf;", '\u00aa', node, map);
        Html.addName("&ordm;", '\u00ba', node, map);
        Html.addName("&or;", '\u2228', node, map);
        Html.addName("&Oslash;", '\u00d8', node, map);
        Html.addName("&oslash;", '\u00f8', node, map);
        Html.addName("&Otilde;", '\u00d5', node, map);
        Html.addName("&otilde;", '\u00f5', node, map);
        Html.addName("&otimes;", '\u2297', node, map);
        Html.addName("&Ouml;", '\u00d6', node, map);
        Html.addName("&ouml;", '\u00f6', node, map);
        Html.addName("&para;", '\u00b6', node, map);
        Html.addName("&part;", '\u2202', node, map);
        Html.addName("&permil;", '\u2030', node, map);
        Html.addName("&perp;", '\u22a5', node, map);
        Html.addName("&Phi;", '\u03a6', node, map);
        Html.addName("&phi;", '\u03c6', node, map);
        Html.addName("&Pi;", '\u03a0', node, map);
        Html.addName("&pi;", '\u03c0', node, map);
        Html.addName("&piv;", '\u03d6', node, map);
        Html.addName("&plusmn;", '\u00b1', node, map);
        Html.addName("&pound;", '\u00a3', node, map);
        Html.addName("&prime;", '\u2032', node, map);
        Html.addName("&Prime;", '\u2033', node, map);
        Html.addName("&prod;", '\u220f', node, map);
        Html.addName("&prop;", '\u221d', node, map);
        Html.addName("&Psi;", '\u03a8', node, map);
        Html.addName("&psi;", '\u03c8', node, map);
        Html.addName("&radic;", '\u221a', node, map);
        Html.addName("&rang;", '\u232a', node, map);
        Html.addName("&raquo;", '\u00bb', node, map);
        Html.addName("&rarr;", '\u2192', node, map);
        Html.addName("&rArr;", '\u21d2', node, map);
        Html.addName("&rceil;", '\u2309', node, map);
        Html.addName("&rdquo;", '\u201d', node, map);
        Html.addName("&real;", '\u211c', node, map);
        Html.addName("&reg;", '\u00ae', node, map);
        Html.addName("&rfloor;", '\u230b', node, map);
        Html.addName("&Rho;", '\u03a1', node, map);
        Html.addName("&rho;", '\u03c1', node, map);
        Html.addName("&rlm;", '\u200f', node, map);
        Html.addName("&rsaquo;", '\u203a', node, map);
        Html.addName("&rsquo;", '\u2019', node, map);
        Html.addName("&sbquo;", '\u201a', node, map);
        Html.addName("&Scaron;", '\u0160', node, map);
        Html.addName("&scaron;", '\u0161', node, map);
        Html.addName("&sdot;", '\u22c5', node, map);
        Html.addName("&sect;", '\u00a7', node, map);
        Html.addName("&shy;", '\u00ad', node, map);
        Html.addName("&sigmaf;", '\u03c2', node, map);
        Html.addName("&Sigma;", '\u03a3', node, map);
        Html.addName("&sigma;", '\u03c3', node, map);
        Html.addName("&sim;", '\u223c', node, map);
        Html.addName("&spades;", '\u2660', node, map);
        Html.addName("&sube;", '\u2286', node, map);
        Html.addName("&sub;", '\u2282', node, map);
        Html.addName("&sum;", '\u2211', node, map);
        Html.addName("&sup1;", '\u00b9', node, map);
        Html.addName("&sup2;", '\u00b2', node, map);
        Html.addName("&sup3;", '\u00b3', node, map);
        Html.addName("&supe;", '\u2287', node, map);
        Html.addName("&sup;", '\u2283', node, map);
        Html.addName("&szlig;", '\u00df', node, map);
        Html.addName("&Tau;", '\u03a4', node, map);
        Html.addName("&tau;", '\u03c4', node, map);
        Html.addName("&there4;", '\u2234', node, map);
        Html.addName("&thetasym;", '\u03d1', node, map);
        Html.addName("&Theta;", '\u0398', node, map);
        Html.addName("&theta;", '\u03b8', node, map);
        Html.addName("&thinsp;", '\u2009', node, map);
        Html.addName("&THORN;", '\u00de', node, map);
        Html.addName("&thorn;", '\u00fe', node, map);
        Html.addName("&tilde;", '\u02dc', node, map);
        Html.addName("&times;", '\u00d7', node, map);
        Html.addName("&trade;", '\u2122', node, map);
        Html.addName("&Uacute;", '\u00da', node, map);
        Html.addName("&uacute;", '\u00fa', node, map);
        Html.addName("&uarr;", '\u2191', node, map);
        Html.addName("&uArr;", '\u21d1', node, map);
        Html.addName("&Ucirc;", '\u00db', node, map);
        Html.addName("&ucirc;", '\u00fb', node, map);
        Html.addName("&Ugrave;", '\u00d9', node, map);
        Html.addName("&ugrave;", '\u00f9', node, map);
        Html.addName("&uml;", '\u00a8', node, map);
        Html.addName("&upsih;", '\u03d2', node, map);
        Html.addName("&Upsilon;", '\u03a5', node, map);
        Html.addName("&upsilon;", '\u03c5', node, map);
        Html.addName("&Uuml;", '\u00dc', node, map);
        Html.addName("&uuml;", '\u00fc', node, map);
        Html.addName("&weierp;", '\u2118', node, map);
        Html.addName("&Xi;", '\u039e', node, map);
        Html.addName("&xi;", '\u03be', node, map);
        Html.addName("&Yacute;", '\u00dd', node, map);
        Html.addName("&yacute;", '\u00fd', node, map);
        Html.addName("&yen;", '\u00a5', node, map);
        Html.addName("&yuml;", '\u00ff', node, map);
        Html.addName("&Yuml;", '\u0178', node, map);
        Html.addName("&Zeta;", '\u0396', node, map);
        Html.addName("&zeta;", '\u03b6', node, map);
        Html.addName("&zwj;", '\u200d', node, map);
        Html.addName("&zwnj;", '\u200c', node, map);
        root = node;
        names = map;
    }

    private static class Node {
        String name;
        char character;
        Node[] children = new Node[64];

        private Node() {
        }

        private int index(char c) {
            if (c == '&') {
                return 0;
            }
            if (c == ';') {
                return 1;
            }
            if ('0' <= c && c <= '9') {
                return c - 48 + 2;
            }
            if ('a' <= c && c <= 'z') {
                return c - 97 + 10 + 2;
            }
            if ('A' <= c && c <= 'Z') {
                return c - 65 + 26 + 10 + 2;
            }
            return -1;
        }

        void add(String name, char character, int index) {
            if (name.length() == index) {
                this.name = name;
                this.character = character;
            } else {
                char c = name.charAt(index);
                Node n = this.children[this.index(c)];
                if (n == null) {
                    this.children[this.index((char)c)] = n = new Node();
                }
                n.add(name, character, index + 1);
            }
        }

        Node find(String value, int len, int index) {
            char c = Html.charAt(value, len, index);
            int i = this.index(c);
            if (i < 0) {
                return null;
            }
            Node n = this.children[i];
            if (n == null) {
                return null;
            }
            if (c == ';') {
                return n;
            }
            return n.find(value, len, index + 1);
        }
    }
}

