/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.binary;

import java.util.HashMap;
import java.util.Map;

public class HtmlEraser {
    private String xml;
    private boolean reducespaces = true;
    private boolean tabtospace = true;
    private boolean nltospace = true;
    private boolean unescape = true;
    private int maxlen = 0;
    private int length;
    private int length2;
    private int length3;
    private static String[] eraseelems = new String[]{"style", "script", "meta"};
    private static Node root = null;

    public HtmlEraser reducespaces(boolean value) {
        this.reducespaces = value;
        return this;
    }

    public HtmlEraser tabtospace(boolean value) {
        this.tabtospace = value;
        return this;
    }

    public HtmlEraser nltospace(boolean value) {
        this.nltospace = value;
        return this;
    }

    public HtmlEraser unescape(boolean value) {
        this.unescape = value;
        return this;
    }

    public HtmlEraser maxlen(int value) {
        this.maxlen = value;
        return this;
    }

    public HtmlEraser(String xml) {
        this.xml = xml;
        this.length = xml.length();
        this.length2 = this.length - 2;
        this.length3 = this.length - 3;
    }

    public static HtmlEraser of(String xml) {
        return new HtmlEraser(xml);
    }

    public String erase() {
        try {
            StringBuilder sb = new StringBuilder();
            char previous = '-';
            boolean insidecomm = false;
            boolean insidetag = false;
            boolean eraseelem = false;
            int index = 0;
            while (index < this.length) {
                if (this.maxlen > 0 && sb.length() > this.maxlen) {
                    sb.append("...");
                    break;
                }
                char c = this.xml.charAt(index);
                ++index;
                if (!insidecomm && !insidetag && c == '<') {
                    if (this.isStartComment(index)) {
                        insidecomm = true;
                    }
                    if (this.isStartEraseElem(index)) {
                        eraseelem = true;
                    } else {
                        insidetag = true;
                    }
                }
                if (!(insidecomm || insidetag || eraseelem)) {
                    if (this.tabtospace && c == '\t') {
                        c = ' ';
                    }
                    if (this.nltospace && c == '\n') {
                        c = ' ';
                    }
                    if (this.nltospace && c == '\r') {
                        c = ' ';
                    }
                    if (this.unescape && c == '&') {
                        NodeResult result = this.unescapeNumeric(index - 1);
                        if (result == null) {
                            result = this.unescape(index - 1, HtmlEraser.root());
                        }
                        if (result != null) {
                            c = result.c;
                            index = index + result.len - 1;
                        }
                    }
                    if (c == ' ') {
                        if (this.reducespaces) {
                            if (previous != ' ') {
                                sb.append(c);
                            }
                        } else {
                            sb.append(c);
                        }
                    } else {
                        sb.append(c);
                    }
                    previous = c;
                }
                if (insidecomm) {
                    if (c != '-' || !this.isEndComment(index)) continue;
                    index += 3;
                    insidecomm = false;
                    continue;
                }
                if (c != '>') continue;
                if (insidetag) {
                    insidetag = false;
                }
                if (!eraseelem || !this.isEndEraseElem(index - 1)) continue;
                eraseelem = false;
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean isStartComment(int index) {
        if (index >= this.length3) {
            return false;
        }
        if (this.xml.charAt(index) != '!') {
            return false;
        }
        if (this.xml.charAt(index + 1) != '-') {
            return false;
        }
        return this.xml.charAt(index + 2) == '-';
    }

    private boolean isEndComment(int index) {
        if (index >= this.length2) {
            return false;
        }
        if (this.xml.charAt(index) != '-') {
            return false;
        }
        return this.xml.charAt(index + 1) == '>';
    }

    private boolean isStartEraseElem(int index) {
        boolean isok = false;
        for (String eraseelem : eraseelems) {
            int i = index;
            int len = eraseelem.length();
            boolean match = true;
            int j = 0;
            while (j < len) {
                char c2;
                if (i >= this.length) {
                    match = false;
                    break;
                }
                char c1 = Character.toLowerCase(this.xml.charAt(i));
                if (c1 != (c2 = eraseelem.charAt(j))) {
                    match = false;
                    break;
                }
                ++j;
                ++i;
            }
            if (!match || !this.isNameEnd(i) || !this.isInsideStartElem(i)) continue;
            isok = true;
            break;
        }
        return isok;
    }

    private boolean isEndEraseElem(int index) {
        boolean isok = false;
        for (String eraseelem : eraseelems) {
            int len = eraseelem.length();
            int i = index - len - 2;
            if (i >= 0 && this.xml.charAt(i++) != '<' || i >= 0 && this.xml.charAt(i++) != '/') continue;
            boolean match = true;
            int j = 0;
            while (j < len) {
                char c2;
                if (i < 0) {
                    match = false;
                    break;
                }
                char c1 = Character.toLowerCase(this.xml.charAt(i));
                if (c1 != (c2 = eraseelem.charAt(j))) {
                    match = false;
                    break;
                }
                ++j;
                ++i;
            }
            if (!match) continue;
            isok = true;
            break;
        }
        return isok;
    }

    private boolean isInsideStartElem(int index) {
        int prev = 32;
        while (index < this.length) {
            char c = this.xml.charAt(index);
            if (c == '>') {
                return prev != 47;
            }
            ++index;
        }
        return false;
    }

    private boolean isNameEnd(int index) {
        if (index >= this.length) {
            return false;
        }
        char c = this.xml.charAt(index);
        switch (c) {
            case '\n': 
            case '\r': 
            case ' ': 
            case '>': {
                return true;
            }
        }
        return false;
    }

    private NodeResult unescapeNumeric(int index) {
        if (index >= this.length) {
            return null;
        }
        if (this.xml.charAt(index++) != '&') {
            return null;
        }
        if (this.xml.charAt(index++) != '#') {
            return null;
        }
        if (this.xml.charAt(index) != 'x') {
            ++index;
            int num = 0;
            for (int i = 0; i < 5; ++i) {
                char c = this.xml.charAt(index++);
                if (index >= this.length) {
                    return null;
                }
                if (c == ';') {
                    return NodeResult.of((char)num, i + 5);
                }
                if ('0' <= c && c <= '9') {
                    num = num * 16 + c - 48;
                    continue;
                }
                if ('a' <= c && c <= 'f') {
                    num = num * 16 + c - 97 + 10;
                    continue;
                }
                if ('A' <= c && c <= 'F') {
                    num = num * 16 + c - 65 + 10;
                    continue;
                }
                return null;
            }
            return null;
        }
        int num = 0;
        for (int i = 0; i < 5; ++i) {
            char c = this.xml.charAt(index++);
            if (index >= this.length) {
                return null;
            }
            if (c == ';') {
                return NodeResult.of((char)num, i + 4);
            }
            if ('0' > c || c > '9') {
                return null;
            }
            num = num * 10 + c - 48;
        }
        return null;
    }

    private NodeResult unescape(int index, Node node) {
        if (node == null) {
            return null;
        }
        if (index >= this.length) {
            return null;
        }
        char c = this.xml.charAt(index);
        Node n = node.get(c);
        if (n == null) {
            return null;
        }
        if (c == ';') {
            return NodeResult.of(n.character, n.name.length());
        }
        return this.unescape(index + 1, n);
    }

    private static Node root() {
        if (root == null) {
            HtmlEraser.init();
        }
        return root;
    }

    private static void addName(String name, char c, Node root, Map<Character, String> names) {
        root.add(name, c, 0);
        names.put(Character.valueOf(c), name);
    }

    private static void init() {
        Node node = new Node();
        HashMap<Character, String> map = new HashMap<Character, String>();
        HtmlEraser.addName("&amp;", '&', node, map);
        HtmlEraser.addName("&apos;", '\'', node, map);
        HtmlEraser.addName("&quot;", '\"', node, map);
        HtmlEraser.addName("&lt;", '<', node, map);
        HtmlEraser.addName("&gt;", '>', node, map);
        HtmlEraser.addName("&nbsp;", ' ', node, map);
        HtmlEraser.addName("&Aacute;", '\u00c1', node, map);
        HtmlEraser.addName("&aacute;", '\u00e1', node, map);
        HtmlEraser.addName("&Acirc;", '\u00c2', node, map);
        HtmlEraser.addName("&acirc;", '\u00e2', node, map);
        HtmlEraser.addName("&acute;", '\u00b4', node, map);
        HtmlEraser.addName("&AElig;", '\u00c6', node, map);
        HtmlEraser.addName("&aelig;", '\u00e6', node, map);
        HtmlEraser.addName("&Agrave;", '\u00c0', node, map);
        HtmlEraser.addName("&agrave;", '\u00e0', node, map);
        HtmlEraser.addName("&alefsym;", '\u2135', node, map);
        HtmlEraser.addName("&Alpha;", '\u0391', node, map);
        HtmlEraser.addName("&alpha;", '\u03b1', node, map);
        HtmlEraser.addName("&and;", '\u2227', node, map);
        HtmlEraser.addName("&ang;", '\u2220', node, map);
        HtmlEraser.addName("&Aring;", '\u00c5', node, map);
        HtmlEraser.addName("&aring;", '\u00e5', node, map);
        HtmlEraser.addName("&asymp;", '\u2248', node, map);
        HtmlEraser.addName("&Atilde;", '\u00c3', node, map);
        HtmlEraser.addName("&atilde;", '\u00e3', node, map);
        HtmlEraser.addName("&Auml;", '\u00c4', node, map);
        HtmlEraser.addName("&auml;", '\u00e4', node, map);
        HtmlEraser.addName("&bdquo;", '\u201e', node, map);
        HtmlEraser.addName("&Beta;", '\u0392', node, map);
        HtmlEraser.addName("&beta;", '\u03b2', node, map);
        HtmlEraser.addName("&brvbar;", '\u00a6', node, map);
        HtmlEraser.addName("&bull;", '\u2022', node, map);
        HtmlEraser.addName("&cap;", '\u2229', node, map);
        HtmlEraser.addName("&Ccedil;", '\u00c7', node, map);
        HtmlEraser.addName("&ccedil;", '\u00e7', node, map);
        HtmlEraser.addName("&cedil;", '\u00b8', node, map);
        HtmlEraser.addName("&cent;", '\u00a2', node, map);
        HtmlEraser.addName("&Chi;", '\u03a7', node, map);
        HtmlEraser.addName("&chi;", '\u03c7', node, map);
        HtmlEraser.addName("&circ;", '\u02c6', node, map);
        HtmlEraser.addName("&clubs;", '\u2663', node, map);
        HtmlEraser.addName("&cong;", '\u2245', node, map);
        HtmlEraser.addName("&copy;", '\u00a9', node, map);
        HtmlEraser.addName("&crarr;", '\u21b5', node, map);
        HtmlEraser.addName("&cup;", '\u222a', node, map);
        HtmlEraser.addName("&curren;", '\u00a4', node, map);
        HtmlEraser.addName("&dagger;", '\u2020', node, map);
        HtmlEraser.addName("&Dagger;", '\u2021', node, map);
        HtmlEraser.addName("&darr;", '\u2193', node, map);
        HtmlEraser.addName("&dArr;", '\u21d3', node, map);
        HtmlEraser.addName("&deg;", '\u00b0', node, map);
        HtmlEraser.addName("&Delta;", '\u0394', node, map);
        HtmlEraser.addName("&delta;", '\u03b4', node, map);
        HtmlEraser.addName("&diams;", '\u2666', node, map);
        HtmlEraser.addName("&divide;", '\u00f7', node, map);
        HtmlEraser.addName("&Eacute;", '\u00c9', node, map);
        HtmlEraser.addName("&eacute;", '\u00e9', node, map);
        HtmlEraser.addName("&Ecirc;", '\u00ca', node, map);
        HtmlEraser.addName("&ecirc;", '\u00ea', node, map);
        HtmlEraser.addName("&Egrave;", '\u00c8', node, map);
        HtmlEraser.addName("&egrave;", '\u00e8', node, map);
        HtmlEraser.addName("&empty;", '\u2205', node, map);
        HtmlEraser.addName("&emsp;", '\u2003', node, map);
        HtmlEraser.addName("&ensp;", '\u2002', node, map);
        HtmlEraser.addName("&Epsilon;", '\u0395', node, map);
        HtmlEraser.addName("&epsilon;", '\u03b5', node, map);
        HtmlEraser.addName("&equiv;", '\u2261', node, map);
        HtmlEraser.addName("&Eta;", '\u0397', node, map);
        HtmlEraser.addName("&eta;", '\u03b7', node, map);
        HtmlEraser.addName("&ETH;", '\u00d0', node, map);
        HtmlEraser.addName("&eth;", '\u00f0', node, map);
        HtmlEraser.addName("&Euml;", '\u00cb', node, map);
        HtmlEraser.addName("&euml;", '\u00eb', node, map);
        HtmlEraser.addName("&euro;", '\u20ac', node, map);
        HtmlEraser.addName("&exist;", '\u2203', node, map);
        HtmlEraser.addName("&fnof;", '\u0192', node, map);
        HtmlEraser.addName("&forall;", '\u2200', node, map);
        HtmlEraser.addName("&frac12;", '\u00bd', node, map);
        HtmlEraser.addName("&frac14;", '\u00bc', node, map);
        HtmlEraser.addName("&frac34;", '\u00be', node, map);
        HtmlEraser.addName("&frasl;", '\u2044', node, map);
        HtmlEraser.addName("&Gamma;", '\u0393', node, map);
        HtmlEraser.addName("&gamma;", '\u03b3', node, map);
        HtmlEraser.addName("&ge;", '\u2265', node, map);
        HtmlEraser.addName("&harr;", '\u2194', node, map);
        HtmlEraser.addName("&hArr;", '\u21d4', node, map);
        HtmlEraser.addName("&hearts;", '\u2665', node, map);
        HtmlEraser.addName("&hellip;", '\u2026', node, map);
        HtmlEraser.addName("&Iacute;", '\u00cd', node, map);
        HtmlEraser.addName("&iacute;", '\u00ed', node, map);
        HtmlEraser.addName("&Icirc;", '\u00ce', node, map);
        HtmlEraser.addName("&icirc;", '\u00ee', node, map);
        HtmlEraser.addName("&iexcl;", '\u00a1', node, map);
        HtmlEraser.addName("&Igrave;", '\u00cc', node, map);
        HtmlEraser.addName("&igrave;", '\u00ec', node, map);
        HtmlEraser.addName("&image;", '\u2111', node, map);
        HtmlEraser.addName("&infin;", '\u221e', node, map);
        HtmlEraser.addName("&int;", '\u222b', node, map);
        HtmlEraser.addName("&Iota;", '\u0399', node, map);
        HtmlEraser.addName("&iota;", '\u03b9', node, map);
        HtmlEraser.addName("&iquest;", '\u00bf', node, map);
        HtmlEraser.addName("&isin;", '\u2208', node, map);
        HtmlEraser.addName("&Iuml;", '\u00cf', node, map);
        HtmlEraser.addName("&iuml;", '\u00ef', node, map);
        HtmlEraser.addName("&Kappa;", '\u039a', node, map);
        HtmlEraser.addName("&kappa;", '\u03ba', node, map);
        HtmlEraser.addName("&Lambda;", '\u039b', node, map);
        HtmlEraser.addName("&lambda;", '\u03bb', node, map);
        HtmlEraser.addName("&lang;", '\u2329', node, map);
        HtmlEraser.addName("&laquo;", '\u00ab', node, map);
        HtmlEraser.addName("&larr;", '\u2190', node, map);
        HtmlEraser.addName("&lArr;", '\u21d0', node, map);
        HtmlEraser.addName("&lceil;", '\u2308', node, map);
        HtmlEraser.addName("&ldquo;", '\u201c', node, map);
        HtmlEraser.addName("&le;", '\u2264', node, map);
        HtmlEraser.addName("&lfloor;", '\u230a', node, map);
        HtmlEraser.addName("&lowast;", '\u2217', node, map);
        HtmlEraser.addName("&loz;", '\u25ca', node, map);
        HtmlEraser.addName("&lrm;", '\u200e', node, map);
        HtmlEraser.addName("&lsaquo;", '\u2039', node, map);
        HtmlEraser.addName("&lsquo;", '\u2018', node, map);
        HtmlEraser.addName("&macr;", '\u00af', node, map);
        HtmlEraser.addName("&mdash;", '\u2014', node, map);
        HtmlEraser.addName("&micro;", '\u00b5', node, map);
        HtmlEraser.addName("&middot;", '\u00b7', node, map);
        HtmlEraser.addName("&minus;", '\u2212', node, map);
        HtmlEraser.addName("&Mu;", '\u039c', node, map);
        HtmlEraser.addName("&mu;", '\u03bc', node, map);
        HtmlEraser.addName("&nabla;", '\u2207', node, map);
        HtmlEraser.addName("&nbsp;", ' ', node, map);
        HtmlEraser.addName("&ndash;", '\u2013', node, map);
        HtmlEraser.addName("&ne;", '\u2260', node, map);
        HtmlEraser.addName("&ni;", '\u220b', node, map);
        HtmlEraser.addName("&notin;", '\u2209', node, map);
        HtmlEraser.addName("&not;", '\u00ac', node, map);
        HtmlEraser.addName("&nsub;", '\u2284', node, map);
        HtmlEraser.addName("&Ntilde;", '\u00d1', node, map);
        HtmlEraser.addName("&ntilde;", '\u00f1', node, map);
        HtmlEraser.addName("&Nu;", '\u039d', node, map);
        HtmlEraser.addName("&nu;", '\u03bd', node, map);
        HtmlEraser.addName("&Oacute;", '\u00d3', node, map);
        HtmlEraser.addName("&oacute;", '\u00f3', node, map);
        HtmlEraser.addName("&Ocirc;", '\u00d4', node, map);
        HtmlEraser.addName("&ocirc;", '\u00f4', node, map);
        HtmlEraser.addName("&OElig;", '\u0152', node, map);
        HtmlEraser.addName("&oelig;", '\u0153', node, map);
        HtmlEraser.addName("&Ograve;", '\u00d2', node, map);
        HtmlEraser.addName("&ograve;", '\u00f2', node, map);
        HtmlEraser.addName("&oline;", '\u203e', node, map);
        HtmlEraser.addName("&Omega;", '\u03a9', node, map);
        HtmlEraser.addName("&omega;", '\u03c9', node, map);
        HtmlEraser.addName("&Omicron;", '\u039f', node, map);
        HtmlEraser.addName("&omicron;", '\u03bf', node, map);
        HtmlEraser.addName("&oplus;", '\u2295', node, map);
        HtmlEraser.addName("&ordf;", '\u00aa', node, map);
        HtmlEraser.addName("&ordm;", '\u00ba', node, map);
        HtmlEraser.addName("&or;", '\u2228', node, map);
        HtmlEraser.addName("&Oslash;", '\u00d8', node, map);
        HtmlEraser.addName("&oslash;", '\u00f8', node, map);
        HtmlEraser.addName("&Otilde;", '\u00d5', node, map);
        HtmlEraser.addName("&otilde;", '\u00f5', node, map);
        HtmlEraser.addName("&otimes;", '\u2297', node, map);
        HtmlEraser.addName("&Ouml;", '\u00d6', node, map);
        HtmlEraser.addName("&ouml;", '\u00f6', node, map);
        HtmlEraser.addName("&para;", '\u00b6', node, map);
        HtmlEraser.addName("&part;", '\u2202', node, map);
        HtmlEraser.addName("&permil;", '\u2030', node, map);
        HtmlEraser.addName("&perp;", '\u22a5', node, map);
        HtmlEraser.addName("&Phi;", '\u03a6', node, map);
        HtmlEraser.addName("&phi;", '\u03c6', node, map);
        HtmlEraser.addName("&Pi;", '\u03a0', node, map);
        HtmlEraser.addName("&pi;", '\u03c0', node, map);
        HtmlEraser.addName("&piv;", '\u03d6', node, map);
        HtmlEraser.addName("&plusmn;", '\u00b1', node, map);
        HtmlEraser.addName("&pound;", '\u00a3', node, map);
        HtmlEraser.addName("&prime;", '\u2032', node, map);
        HtmlEraser.addName("&Prime;", '\u2033', node, map);
        HtmlEraser.addName("&prod;", '\u220f', node, map);
        HtmlEraser.addName("&prop;", '\u221d', node, map);
        HtmlEraser.addName("&Psi;", '\u03a8', node, map);
        HtmlEraser.addName("&psi;", '\u03c8', node, map);
        HtmlEraser.addName("&radic;", '\u221a', node, map);
        HtmlEraser.addName("&rang;", '\u232a', node, map);
        HtmlEraser.addName("&raquo;", '\u00bb', node, map);
        HtmlEraser.addName("&rarr;", '\u2192', node, map);
        HtmlEraser.addName("&rArr;", '\u21d2', node, map);
        HtmlEraser.addName("&rceil;", '\u2309', node, map);
        HtmlEraser.addName("&rdquo;", '\u201d', node, map);
        HtmlEraser.addName("&real;", '\u211c', node, map);
        HtmlEraser.addName("&reg;", '\u00ae', node, map);
        HtmlEraser.addName("&rfloor;", '\u230b', node, map);
        HtmlEraser.addName("&Rho;", '\u03a1', node, map);
        HtmlEraser.addName("&rho;", '\u03c1', node, map);
        HtmlEraser.addName("&rlm;", '\u200f', node, map);
        HtmlEraser.addName("&rsaquo;", '\u203a', node, map);
        HtmlEraser.addName("&rsquo;", '\u2019', node, map);
        HtmlEraser.addName("&sbquo;", '\u201a', node, map);
        HtmlEraser.addName("&Scaron;", '\u0160', node, map);
        HtmlEraser.addName("&scaron;", '\u0161', node, map);
        HtmlEraser.addName("&sdot;", '\u22c5', node, map);
        HtmlEraser.addName("&sect;", '\u00a7', node, map);
        HtmlEraser.addName("&shy;", '\u00ad', node, map);
        HtmlEraser.addName("&sigmaf;", '\u03c2', node, map);
        HtmlEraser.addName("&Sigma;", '\u03a3', node, map);
        HtmlEraser.addName("&sigma;", '\u03c3', node, map);
        HtmlEraser.addName("&sim;", '\u223c', node, map);
        HtmlEraser.addName("&spades;", '\u2660', node, map);
        HtmlEraser.addName("&sube;", '\u2286', node, map);
        HtmlEraser.addName("&sub;", '\u2282', node, map);
        HtmlEraser.addName("&sum;", '\u2211', node, map);
        HtmlEraser.addName("&sup1;", '\u00b9', node, map);
        HtmlEraser.addName("&sup2;", '\u00b2', node, map);
        HtmlEraser.addName("&sup3;", '\u00b3', node, map);
        HtmlEraser.addName("&supe;", '\u2287', node, map);
        HtmlEraser.addName("&sup;", '\u2283', node, map);
        HtmlEraser.addName("&szlig;", '\u00df', node, map);
        HtmlEraser.addName("&Tau;", '\u03a4', node, map);
        HtmlEraser.addName("&tau;", '\u03c4', node, map);
        HtmlEraser.addName("&there4;", '\u2234', node, map);
        HtmlEraser.addName("&thetasym;", '\u03d1', node, map);
        HtmlEraser.addName("&Theta;", '\u0398', node, map);
        HtmlEraser.addName("&theta;", '\u03b8', node, map);
        HtmlEraser.addName("&thinsp;", '\u2009', node, map);
        HtmlEraser.addName("&THORN;", '\u00de', node, map);
        HtmlEraser.addName("&thorn;", '\u00fe', node, map);
        HtmlEraser.addName("&tilde;", '\u02dc', node, map);
        HtmlEraser.addName("&times;", '\u00d7', node, map);
        HtmlEraser.addName("&trade;", '\u2122', node, map);
        HtmlEraser.addName("&Uacute;", '\u00da', node, map);
        HtmlEraser.addName("&uacute;", '\u00fa', node, map);
        HtmlEraser.addName("&uarr;", '\u2191', node, map);
        HtmlEraser.addName("&uArr;", '\u21d1', node, map);
        HtmlEraser.addName("&Ucirc;", '\u00db', node, map);
        HtmlEraser.addName("&ucirc;", '\u00fb', node, map);
        HtmlEraser.addName("&Ugrave;", '\u00d9', node, map);
        HtmlEraser.addName("&ugrave;", '\u00f9', node, map);
        HtmlEraser.addName("&uml;", '\u00a8', node, map);
        HtmlEraser.addName("&upsih;", '\u03d2', node, map);
        HtmlEraser.addName("&Upsilon;", '\u03a5', node, map);
        HtmlEraser.addName("&upsilon;", '\u03c5', node, map);
        HtmlEraser.addName("&Uuml;", '\u00dc', node, map);
        HtmlEraser.addName("&uuml;", '\u00fc', node, map);
        HtmlEraser.addName("&weierp;", '\u2118', node, map);
        HtmlEraser.addName("&Xi;", '\u039e', node, map);
        HtmlEraser.addName("&xi;", '\u03be', node, map);
        HtmlEraser.addName("&Yacute;", '\u00dd', node, map);
        HtmlEraser.addName("&yacute;", '\u00fd', node, map);
        HtmlEraser.addName("&yen;", '\u00a5', node, map);
        HtmlEraser.addName("&yuml;", '\u00ff', node, map);
        HtmlEraser.addName("&Yuml;", '\u0178', node, map);
        HtmlEraser.addName("&Zeta;", '\u0396', node, map);
        HtmlEraser.addName("&zeta;", '\u03b6', node, map);
        HtmlEraser.addName("&zwj;", ' ', node, map);
        HtmlEraser.addName("&zwnj;", ' ', node, map);
        root = node;
    }

    private static class Node {
        String name;
        char character;
        Node[] children = new Node[64];

        private Node() {
        }

        private int index(char c) {
            if (c == '&') {
                return 0;
            }
            if (c == ';') {
                return 1;
            }
            if ('0' <= c && c <= '9') {
                return c - 48 + 2;
            }
            if ('a' <= c && c <= 'z') {
                return c - 97 + 10 + 2;
            }
            if ('A' <= c && c <= 'Z') {
                return c - 65 + 26 + 10 + 2;
            }
            return -1;
        }

        void add(String name, char character, int index) {
            if (name.length() == index) {
                this.name = name;
                this.character = character;
            } else {
                char c = name.charAt(index);
                Node n = this.children[this.index(c)];
                if (n == null) {
                    this.children[this.index((char)c)] = n = new Node();
                }
                n.add(name, character, index + 1);
            }
        }

        Node get(char c) {
            int index = this.index(c);
            if (index < 0) {
                return null;
            }
            Node n = this.children[index];
            return n;
        }
    }

    private static class NodeResult {
        char c;
        int len;

        private NodeResult() {
        }

        private static NodeResult of(char c, int len) {
            NodeResult nr = new NodeResult();
            nr.c = c;
            nr.len = len;
            return nr;
        }
    }
}

