/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.jaul.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapCache<K, V>
implements Map<K, V> {
    private int limit = -1;
    private long expiration = -1L;
    private Map<K, Entry<K, V>> cache = null;
    private Entry<K, V> head = null;
    private Entry<K, V> tail = null;

    public MapCache() {
        this.cache = new HashMap<K, Entry<K, V>>();
    }

    public MapCache(int initSize) {
        this.cache = new HashMap<K, Entry<K, V>>(initSize);
    }

    public static <KK, VV> MapCache<KK, VV> instance(Class<KK> keyType, Class<VV> valueType) {
        return new MapCache();
    }

    public static <KK, VV> MapCache<KK, VV> instance(Class<KK> keyType, Class<VV> valueType, int initSize) {
        return new MapCache(initSize);
    }

    public int limit() {
        return this.limit;
    }

    public MapCache<K, V> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public long expiration() {
        return this.expiration;
    }

    public MapCache<K, V> expiration(long expiration) {
        this.expiration = expiration;
        return this;
    }

    public Map<K, V> synchronize() {
        return Collections.synchronizedMap(this);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    private Entry<K, V> expire(Entry<K, V> entry) {
        if (entry == null) {
            return null;
        }
        if (this.expiration < 1L) {
            return entry;
        }
        long time = System.currentTimeMillis();
        if (entry.time >= time) {
            return entry;
        }
        this.tail = entry.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        while (entry != null) {
            this.cache.remove(entry.key);
            entry = entry.next;
        }
        return null;
    }

    private void remove(Entry<K, V> entry) {
        if (entry == null) {
            return;
        }
        this.cache.remove(entry.key);
        if (entry.prev == null) {
            this.head = entry.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            entry.prev.next = entry.next;
        }
        if (entry.next == null) {
            this.tail = entry.prev;
            if (this.tail != null) {
                this.tail.next = null;
            }
        } else {
            entry.next.prev = entry.prev;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        long time = System.currentTimeMillis();
        Entry<K, V> entry = this.cache.get(key);
        return (entry = this.expire(entry)) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        long time = System.currentTimeMillis();
        for (Map.Entry<K, Entry<K, V>> entry : this.cache.entrySet()) {
            Entry<K, V> en = entry.getValue();
            if (en.time < time) continue;
            if (value == null && en.value == null) {
                return true;
            }
            if (!value.equals(en.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.cache.get(key);
        if ((entry = this.expire(entry)) == null) {
            return null;
        }
        return entry.value;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("Null key is not allowed");
        }
        Entry<K, V> entry = this.cache.get(key);
        if (entry != null) {
            this.remove(entry);
        }
        if (this.limit > 0 && this.size() >= this.limit) {
            this.remove(this.tail);
        }
        entry = new Entry();
        entry.key = key;
        entry.value = value;
        if (this.tail == null) {
            this.tail = entry;
            this.head = entry;
        } else {
            this.head.prev = entry;
            entry.next = this.head;
            this.head = entry;
        }
        this.cache.put(key, entry);
        return value;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            return null;
        }
        Entry<K, V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        this.remove(entry);
        return entry.value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<K, V> object : m.entrySet()) {
            this.put(object.getKey(), object.getValue());
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.head = null;
        this.tail = null;
    }

    @Override
    public Set<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList<Entry<K, V>> list = new ArrayList<Entry<K, V>>();
        for (Map.Entry<K, Entry<K, V>> object : this.cache.entrySet()) {
            list.add(object.getValue());
        }
        return list;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String dunp() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nkeys: ").append(this.cache.keySet());
        sb.append("\nhead: ").append((Object)(this.head == null ? "" : this.head.key));
        sb.append("\ntail: ").append((Object)(this.tail == null ? "" : this.tail.key));
        sb.append("\ndesc: ");
        Entry<K, V> entry = this.head;
        while (entry != null) {
            sb.append(", ").append(entry.key);
            entry = entry.next;
        }
        sb.append("\nasc: ");
        entry = this.tail;
        while (entry != null) {
            sb.append(", ").append(entry.key);
            entry = entry.prev;
        }
        return sb.toString();
    }

    private class Entry<K, V> {
        public K key;
        public V value;
        public long time;
        public Entry<K, V> prev;
        public Entry<K, V> next;

        private Entry() {
            this.time = MapCache.this.expiration < 1L ? Long.MAX_VALUE : System.currentTimeMillis() + MapCache.this.expiration;
        }
    }
}

