/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sk.antons.jaul.Is;

public class Args {
    private String[] args;
    private Map<String, List<String>> argMap = new HashMap<String, List<String>>();
    private Set<String> singles = new HashSet<String>();
    private Set<String> pairs = new HashSet<String>();

    public static Args instance() {
        return new Args();
    }

    public Args single(String value) {
        this.singles.add(value);
        return this;
    }

    public Args pair(String value) {
        this.pairs.add(value);
        return this;
    }

    public Args parse(String[] args) {
        this.args = args;
        if (args == null) {
            return this;
        }
        String previous = "";
        for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            if (this.singles.contains(param)) {
                this.addArg(param);
                previous = "";
                continue;
            }
            if (this.pairs.contains(param)) {
                previous = param;
                continue;
            }
            this.addArg(previous, param);
            previous = "";
        }
        return this;
    }

    private void addArg(String name) {
        this.addArg(name, "");
    }

    private void addArg(String name, String value) {
        List<String> list;
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if ((list = this.argMap.get(name)) == null) {
            list = new ArrayList<String>();
            this.argMap.put(name, list);
        }
        list.add(value);
    }

    public List<String> all(String ... args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args == null) {
            return list;
        }
        for (String arg : args) {
            List<String> l = this.argMap.get(arg);
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    public String first(String ... args) {
        if (args == null) {
            return null;
        }
        for (String arg : args) {
            List<String> l = this.argMap.get(arg);
            if (Is.empty(l)) continue;
            return l.get(0);
        }
        return null;
    }

    public boolean isSet(String ... args) {
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            List<String> l = this.argMap.get(arg);
            if (Is.empty(l)) continue;
            return true;
        }
        return false;
    }
}

