/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.tool;

import java.util.List;
import java.util.logging.Logger;
import sk.antons.sprops.SimpleEncoder;
import sk.antons.sprops.tool.Args;
import sk.antons.sprops.tool.Command;
import sk.antons.sprops.tool.Resolved;

public class EncodeCommand
implements Command {
    private static Logger log = Logger.getLogger("cmd.enc");

    @Override
    public boolean requirePassword() {
        return true;
    }

    @Override
    public boolean checkInput(Args args) {
        if (!args.isSet("")) {
            log.warning("No strings to encode are provided");
            return false;
        }
        return true;
    }

    @Override
    public boolean realize(Args args) {
        List<String> strings = args.all("");
        SimpleEncoder encoder = SimpleEncoder.instance(Resolved.password());
        encoder.algorithm(Resolved.algorithm());
        for (String string : strings) {
            try {
                log.info("Encoding string from: '" + string + "'");
                log.info("                  to: '" + encoder.encode(string) + "'");
            }
            catch (Exception e) {
                log.warning("  Unable to encode string because of " + e);
            }
        }
        return true;
    }
}

