/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.tool;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import sk.antons.jaul.Is;
import sk.antons.sprops.SimpleEncoder;
import sk.antons.sprops.tool.Args;
import sk.antons.sprops.tool.Command;
import sk.antons.sprops.tool.PropFile;
import sk.antons.sprops.tool.Resolved;

public class FileDecodeAllCommand
implements Command {
    private static Logger log = Logger.getLogger("cmd.fdec");
    private PropFile propfile = null;

    @Override
    public boolean requirePassword() {
        return true;
    }

    @Override
    public boolean checkInput(Args args) {
        String file = args.first("-fdecodeall", "--fdecodeall");
        if (Is.empty(file)) {
            log.warning("No properties file specified");
            return false;
        }
        File f = new File(file);
        if (!f.exists()) {
            log.warning("Properties file " + file + " not exists");
            return false;
        }
        if (!f.isFile()) {
            log.warning("Properties file " + file + " is not file");
            return false;
        }
        this.propfile = PropFile.instance(file);
        return true;
    }

    @Override
    public boolean realize(Args args) {
        List<String> strings = this.propfile.propsToDecode();
        SimpleEncoder encoder = SimpleEncoder.instance(Resolved.password());
        encoder.algorithm(Resolved.algorithm());
        StringBuilder result = new StringBuilder();
        for (String string : strings) {
            try {
                log.info("Property: '" + string + "'");
                String value = this.propfile.getProperty(string);
                String decoded = encoder.decode(value);
                this.propfile.replace(string, decoded);
                log.info("Encoding string from: '" + value + "'");
                log.info("                  to: '" + decoded + "'");
            }
            catch (Exception e) {
                log.warning("  Unable to encode string because of " + e);
            }
        }
        return true;
    }
}

