/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.sprops.tool;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import sk.antons.jaul.Is;
import sk.antons.jaul.Split;
import sk.antons.jaul.util.TextFile;

public class PropFile {
    private Properties props;
    private String text;
    private String file;

    public PropFile(String file) {
        this.file = file;
        this.load();
    }

    private void load() {
        try {
            this.text = TextFile.read(this.file, "utf-8");
            this.props = new Properties();
            FileInputStream fi = new FileInputStream(this.file);
            this.props.load(fi);
            fi.close();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("PropFile " + this.file, e);
        }
    }

    public String text() {
        return this.text;
    }

    public String getProperty(String property) {
        return this.props.getProperty(property);
    }

    public static PropFile instance(String file) {
        return new PropFile(file);
    }

    public List<String> propsToEncode() {
        Set<String> names = this.props.stringPropertyNames();
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            String value = this.props.getProperty(name);
            if (Is.empty(value) || value.startsWith("sprops:")) continue;
            list.add(name);
        }
        Collections.sort(list);
        return list;
    }

    public List<String> propsToDecode() {
        Set<String> names = this.props.stringPropertyNames();
        ArrayList<String> list = new ArrayList<String>();
        for (String name : names) {
            String value = this.props.getProperty(name);
            if (Is.empty(value) || !value.startsWith("sprops:")) continue;
            list.add(name);
        }
        Collections.sort(list);
        return list;
    }

    public void replace(String property, String value) {
        if (Is.empty(property)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        List<String> lines = Split.string(this.text).bySubstringToList("\n");
        for (String line : lines) {
            if (line.startsWith(property + "=") || line.startsWith(property + " =")) {
                line = property + "=" + value;
            }
            sb.append(line).append('\n');
        }
        TextFile.save(this.file, "utf-8", sb.toString());
        this.load();
    }
}

