/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sk.antons.util.logging.appender.AbstractAppender;
import sk.antons.util.logging.appender.AppenderFactory;

public class SimpleLineFormatter
extends Formatter {
    private List<AbstractAppender> appenders = null;

    public SimpleLineFormatter() {
        LogManager manager = LogManager.getLogManager();
        String pattern = manager.getProperty("sk.antons.util.logging.SimpleLineFormatter.pattern");
        if (pattern == null) {
            pattern = "${date} ${time} ${level:3:-3} ${sname:-30:-30}: ${message} ";
        }
        this.appenders = AppenderFactory.pattern(pattern);
    }

    public SimpleLineFormatter(String pattern) {
        LogManager manager = LogManager.getLogManager();
        if (pattern == null) {
            pattern = "${date} ${time} ${level:3:-3} ${sname:-30:-30}: ${message} ";
        }
        this.appenders = AppenderFactory.pattern(pattern);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder sb = new StringBuilder();
        for (AbstractAppender appender : this.appenders) {
            appender.append(sb, record);
        }
        if (record.getThrown() != null) {
            sb.append('\n').append(record.getThrown()).append('\n');
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

