/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.util.logging.conf;

import sk.antons.util.logging.SimpleLineFormatter;
import sk.antons.util.logging.conf.HandlerSetup;

public class HandlerFormatSetup {
    protected HandlerSetup handlerSetup;
    private StringBuilder pattern = new StringBuilder();

    public HandlerFormatSetup(HandlerSetup handlerSetup) {
        this.handlerSetup = handlerSetup;
    }

    public HandlerSetup patternEnd() {
        if (this.handlerSetup.handler != null && this.pattern.length() > 0) {
            SimpleLineFormatter slf = new SimpleLineFormatter(this.pattern.toString());
            this.handlerSetup.handler.setFormatter(slf);
        }
        return this.handlerSetup;
    }

    public HandlerFormatSetup text(String text) {
        this.pattern.append(text);
        return this;
    }

    public HandlerFormatSetup name() {
        this.pattern.append("${name}");
        return this;
    }

    public HandlerFormatSetup name(int max) {
        this.pattern.append("${name:" + max + "}");
        return this;
    }

    public HandlerFormatSetup name(int max, int min) {
        this.pattern.append("${name:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup simplaName() {
        this.pattern.append("${sname}");
        return this;
    }

    public HandlerFormatSetup simpleName(int max) {
        this.pattern.append("${sname:" + max + "}");
        return this;
    }

    public HandlerFormatSetup simpleName(int max, int min) {
        this.pattern.append("${sname:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup level() {
        this.pattern.append("${level}");
        return this;
    }

    public HandlerFormatSetup level(int max) {
        this.pattern.append("${level:" + max + "}");
        return this;
    }

    public HandlerFormatSetup level(int max, int min) {
        this.pattern.append("${level:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup date() {
        this.pattern.append("${date}");
        return this;
    }

    public HandlerFormatSetup time() {
        this.pattern.append("${time}");
        return this;
    }

    public HandlerFormatSetup formatedTime(String format) {
        this.pattern.append("${ftime:0:0:" + format + "}");
        return this;
    }

    public HandlerFormatSetup className() {
        this.pattern.append("${class}");
        return this;
    }

    public HandlerFormatSetup className(int max) {
        this.pattern.append("${class:" + max + "}");
        return this;
    }

    public HandlerFormatSetup className(int max, int min) {
        this.pattern.append("${class:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup simpleClassName() {
        this.pattern.append("${sclass}");
        return this;
    }

    public HandlerFormatSetup simpleClassName(int max) {
        this.pattern.append("${sclass:" + max + "}");
        return this;
    }

    public HandlerFormatSetup simpleClassName(int max, int min) {
        this.pattern.append("${sclass:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup message() {
        this.pattern.append("${message}");
        return this;
    }

    public HandlerFormatSetup message(int max) {
        this.pattern.append("${message:" + max + "}");
        return this;
    }

    public HandlerFormatSetup message(int max, int min) {
        this.pattern.append("${message:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup method() {
        this.pattern.append("${method}");
        return this;
    }

    public HandlerFormatSetup method(int max) {
        this.pattern.append("${method:" + max + "}");
        return this;
    }

    public HandlerFormatSetup method(int max, int min) {
        this.pattern.append("${method:" + max + ":" + min + "}");
        return this;
    }

    public HandlerFormatSetup thread() {
        this.pattern.append("${thread}");
        return this;
    }

    public HandlerFormatSetup thread(int max) {
        this.pattern.append("${thread:" + max + "}");
        return this;
    }

    public HandlerFormatSetup thread(int max, int min) {
        this.pattern.append("${thread:" + max + ":" + min + "}");
        return this;
    }
}

