/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.path.element;

import java.util.ArrayList;
import java.util.List;

public class Sequence {
    private boolean wild = false;
    private char[] chars = null;
    private int startpos = -1;
    private int endpos = -1;
    private int size = -1;

    private Sequence(char[] chars, int startpos, int endpos, boolean wild) {
        this.chars = chars;
        this.startpos = startpos;
        this.endpos = endpos;
        this.wild = wild;
        this.size = endpos - startpos;
    }

    public char[] chars() {
        return this.chars;
    }

    public int startpos() {
        return this.startpos;
    }

    public int endpos() {
        return this.endpos;
    }

    public boolean isWild() {
        return this.wild;
    }

    public int size() {
        return this.size;
    }

    public static List<Sequence> split(char[] chars, int startpos, int endpos) {
        ArrayList<Sequence> rv = new ArrayList<Sequence>();
        int laststart = -1;
        boolean inwild = false;
        for (int i = startpos; i < endpos; ++i) {
            Sequence s;
            char c = chars[i];
            if (inwild) {
                if (c != '*') {
                    if (laststart > -1) {
                        s = new Sequence(chars, laststart, i, inwild);
                        rv.add(s);
                    }
                    laststart = i;
                    inwild = false;
                }
            } else if (c == '*') {
                if (laststart > -1) {
                    s = new Sequence(chars, laststart, i, inwild);
                    rv.add(s);
                }
                laststart = i;
                inwild = true;
            }
            if (laststart >= 0) continue;
            laststart = i;
        }
        if (laststart > -1) {
            Sequence s = new Sequence(chars, laststart, endpos, inwild);
            rv.add(s);
        }
        return rv;
    }

    public int index(char[] chars, int startpos, int endpos) {
        if (this.wild) {
            return startpos;
        }
        if (endpos - startpos < this.size) {
            return -1;
        }
        for (int i = startpos; i < endpos - this.size + 1; ++i) {
            boolean match = true;
            for (int j = 0; j < this.size; ++j) {
                char c = this.chars[this.startpos + j];
                if (c == '?' || c == chars[i + j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "Sequence{wild=" + this.wild + ", chars=" + new String(this.chars, this.startpos, this.endpos - this.startpos) + '}';
    }
}

