/*
 * Decompiled with CFR 0.152.
 */
package sk.antons.web.path.element;

import java.util.List;
import sk.antons.web.path.element.Sequence;
import sk.antons.web.path.element.SingleElementMatcher;

public class SequenceElementMatcher
extends SingleElementMatcher {
    private List<Sequence> sequences;
    private int size;

    public SequenceElementMatcher(List<Sequence> sequences) {
        this.sequences = sequences;
        this.size = sequences.size();
    }

    @Override
    public boolean match(char[] chars, int startpos, int endpos) {
        return this.matchImpl(chars, startpos, endpos, 0);
    }

    private boolean matchImpl(char[] chars, int startpos, int endpos, int index) {
        if (index >= this.size) {
            return startpos >= endpos;
        }
        Sequence s = this.sequences.get(index);
        if (s.isWild()) {
            for (int i = startpos; i < endpos; ++i) {
                boolean result = this.matchImpl(chars, i, endpos, index + 1);
                if (!result) continue;
                return true;
            }
            return false;
        }
        int pos = s.index(chars, startpos, endpos);
        while (pos > -1) {
            boolean result = this.matchImpl(chars, pos + s.size(), endpos, index + 1);
            if (result) {
                return true;
            }
            pos = s.index(chars, pos + 1, endpos);
        }
        return false;
    }
}

