/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.codegen.annotations.processing;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.atkawa7.codegen.annotations.DomainModel;
import io.github.atkawa7.codegen.annotations.Queryable;
import io.github.atkawa7.codegen.annotations.processing.CodegenUtils;
import io.github.atkawa7.codegen.annotations.processing.models.DomainModelMeta;
import io.github.atkawa7.codegen.annotations.processing.models.FieldMeta;
import io.github.atkawa7.codegen.annotations.processing.models.QueryableMeta;
import io.github.atkawa7.codegen.annotations.processing.models.QueryablesMeta;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.persistence.Id;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.stereotype.Repository;

public class RepositoryCodegen
extends AbstractProcessor {
    private Messager messager;
    public static Map<String, List<FieldMeta>> cache = new HashMap<String, List<FieldMeta>>();
    private Map<String, String> options;
    private Types typesUtils;

    public static List<String> getClassNames(Class<?> ... args) {
        if (args != null) {
            ArrayList<String> names = new ArrayList<String>(args.length);
            for (Class<?> classType : args) {
                names.add(classType.getCanonicalName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    public static boolean isDate(TypeMirror typeMirror) {
        String fullQualified = typeMirror.toString();
        for (String className : RepositoryCodegen.getClassNames(java.util.Date.class, Date.class, Time.class, Timestamp.class, LocalDate.class, LocalDateTime.class, ZonedDateTime.class, Instant.class, OffsetDateTime.class, OffsetTime.class, Year.class, YearMonth.class, ZonedDateTime.class, LocalTime.class)) {
            if (!className.equalsIgnoreCase(fullQualified)) continue;
            return true;
        }
        return false;
    }

    public static boolean isString(TypeMirror typeMirror) {
        String fullQualified = typeMirror.toString();
        for (String className : RepositoryCodegen.getClassNames(String.class)) {
            if (!className.equalsIgnoreCase(fullQualified)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArrayOfType(TypeMirror typeMirror, Class<?> type) {
        return typeMirror.toString().equalsIgnoreCase(String.format("%s[]", type.getCanonicalName()));
    }

    public static Map<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(AnnotationMirror annotation) {
        HashMap<ExecutableElement, AnnotationValue> values = new HashMap<ExecutableElement, AnnotationValue>();
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = annotation.getElementValues();
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (declaredValues.containsKey(method)) {
                values.put(method, declaredValues.get(method));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values.put(method, method.getDefaultValue());
                continue;
            }
            throw new IllegalStateException("Unset annotation value without default should never happen: ");
        }
        return values;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.options = processingEnv.getOptions();
        this.typesUtils = processingEnv.getTypeUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(DomainModel.class.getName());
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList("codegen.packageName", "codegen.debug"));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public Set<TypeElement> getTypeElementsAnnotatedWith(Class<? extends Annotation> classType, RoundEnvironment roundEnv) {
        Set<? extends Element> annotatedWith = roundEnv.getElementsAnnotatedWith(classType);
        return ElementFilter.typesIn(annotatedWith);
    }

    public List<FieldMeta> getFieldsForType(TypeElement typeElement) {
        List<FieldMeta> cached = cache.get(typeElement.getQualifiedName().toString());
        if (cached != null) {
            return cached;
        }
        ArrayList<FieldMeta> metas = new ArrayList<FieldMeta>(5);
        for (Element element : typeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD) continue;
            FieldMeta meta = new FieldMeta();
            meta.setName(element.getSimpleName().toString());
            meta.setFullyQualifiedName(element.asType().toString());
            meta.setElement(element);
            metas.add(meta);
        }
        return metas;
    }

    public List<FieldMeta> getAllFieldsForType(TypeElement typeElement) {
        ArrayList<FieldMeta> metas = new ArrayList<FieldMeta>(0);
        for (TypeMirror typeMirror : this.typesUtils.directSupertypes(typeElement.asType())) {
            metas.addAll(this.getFieldsForType(CodegenUtils.convertToTypeElement(typeMirror)));
        }
        metas.addAll(this.getFieldsForType(typeElement));
        return metas;
    }

    public Map<String, Object> getValues(AnnotationMirror annotationMirror) {
        Map<ExecutableElement, AnnotationValue> values = RepositoryCodegen.getAnnotationValuesWithDefaults(annotationMirror);
        HashMap<String, Object> out = new HashMap<String, Object>(values.size());
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : values.entrySet()) {
            String key = entry.getKey().getSimpleName().toString();
            Object value = entry.getValue().getValue();
            out.put(key, value);
        }
        return out;
    }

    public String json(Map<String, Object> map) {
        return "{" + map.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + e.getValue() + "\"").collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<TypeElement> elements = this.getTypeElementsAnnotatedWith(DomainModel.class, roundEnv);
        if (elements.isEmpty()) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("---------------------Processing----------------\n\n");
        builder.append(String.format("Codegen processing started %s\n", new java.util.Date()));
        builder.append(String.format("Processing %d classes \n", elements.size()));
        int classesProcessed = 0;
        ArrayList<DomainModelMeta> classMetaList = new ArrayList<DomainModelMeta>();
        for (TypeElement typeElement : elements) {
            Object typeMirror;
            DomainModelMeta domainModelMeta = new DomainModelMeta();
            domainModelMeta.setName(typeElement.getSimpleName().toString());
            domainModelMeta.setFullyQualifiedName(typeElement.getQualifiedName().toString());
            domainModelMeta.setTypeElement(typeElement);
            builder.append(String.format("%-2d. Processing Class <%s>\n", ++classesProcessed, domainModelMeta.getFullyQualifiedName()));
            List<FieldMeta> metaList = this.getAllFieldsForType(typeElement);
            for (int i = 0; i < metaList.size(); ++i) {
                FieldMeta meta = metaList.get(i);
                Optional<AnnotationMirror> hasQueryable = meta.findAnnotationMirrorForField(Queryable.class);
                builder.append(String.format("\t\t%-2d. name=%s type=%s hasQueryable=%s\n", i + 1, meta.getName(), meta.getFullyQualifiedName(), hasQueryable.isPresent()));
                domainModelMeta.getAllFields().put(meta.getName(), meta);
                if (hasQueryable.isPresent()) {
                    meta.setAnnotationMirror(hasQueryable.get());
                    domainModelMeta.getFieldMetas().add(meta);
                    Map<String, Object> values = this.getValues(hasQueryable.get());
                    QueryableMeta queryableMeta = new QueryableMeta();
                    queryableMeta.setMany((Boolean)values.get("many"));
                    queryableMeta.setPageable((Boolean)values.get("pageable"));
                    queryableMeta.setOptional((Boolean)values.get("optional"));
                    meta.setQueryableMeta(queryableMeta);
                }
                int nestedCounter = 0;
                if (CodegenUtils.isInternalClass(meta.getFullyQualifiedName()) || !((typeMirror = meta.getElement().asType()) instanceof DeclaredType)) continue;
                for (FieldMeta nested : this.getAllFieldsForType(CodegenUtils.convertToTypeElement(meta.getElement().asType()))) {
                    nested.setSource(meta);
                    Optional<AnnotationMirror> hasId = nested.findAnnotationMirrorForField(Id.class);
                    String key = meta.getName() + StringUtils.capitalize((String)nested.getName());
                    if (hasQueryable.isPresent() && hasId.isPresent()) {
                        domainModelMeta.getFieldMetas().add(nested);
                        nested.setQueryableMeta(meta.getQueryableMeta());
                    }
                    domainModelMeta.getAllFields().put(key, nested);
                    builder.append(String.format("\t\t\t\t%-2d. name=%s type=%s hasId=%s\n", ++nestedCounter, nested.getName(), nested.getFullyQualifiedName(), hasId.isPresent()));
                }
            }
            classMetaList.add(domainModelMeta);
            Optional<AnnotationMirror> hasDomainModel = domainModelMeta.findAnnotationMirrorForField(DomainModel.class);
            if (hasDomainModel.isPresent()) {
                builder.append("\n\nDomainModel Annotation Values\n\n");
                Map<ExecutableElement, AnnotationValue> values = RepositoryCodegen.getAnnotationValuesWithDefaults(hasDomainModel.get());
                builder.append(String.format("Found %d Annotation Values\n", values.size()));
                int counter = 0;
                HashMap<String, Object> context = new HashMap<String, Object>(values.size());
                typeMirror = values.entrySet().iterator();
                while (typeMirror.hasNext()) {
                    Map.Entry<ExecutableElement, AnnotationValue> entry = typeMirror.next();
                    ++counter;
                    ExecutableElement key = entry.getKey();
                    String name = key.getSimpleName().toString();
                    Object value = entry.getValue().getValue();
                    if (value instanceof List) {
                        ArrayList contexts = new ArrayList(((List)value).size());
                        for (Object v1 : (List)value) {
                            if (v1 instanceof AnnotationMirror) {
                                int[] nestedCounter = new int[]{0};
                                HashMap nestedContext = new HashMap(values.size());
                                Map<ExecutableElement, AnnotationValue> nested = RepositoryCodegen.getAnnotationValuesWithDefaults((AnnotationMirror)v1);
                                nested.forEach((k, v) -> {
                                    nestedCounter[0] = nestedCounter[0] + 1;
                                    Object v2 = v.getValue();
                                    if (v2 instanceof List) {
                                        ArrayList<String> attributes = new ArrayList<String>(((List)v2).size());
                                        for (Object f : (List)v2) {
                                            if (!(f instanceof AnnotationValue)) continue;
                                            attributes.add(Objects.toString(((AnnotationValue)f).getValue()));
                                        }
                                        nestedContext.put(k.getSimpleName().toString(), attributes);
                                    } else {
                                        nestedContext.put(k.getSimpleName().toString(), v2);
                                    }
                                    builder.append(String.format("\t\t\t\t%-2d. key=%s value=%s\n", nestedCounter[0], k.getSimpleName(), v.getValue()));
                                });
                                contexts.add(nestedContext);
                                continue;
                            }
                            contexts.add(v1);
                        }
                        context.put(name, contexts);
                        continue;
                    }
                    context.put(name, value);
                    builder.append(String.format("\t\t%-2d. key=%s value=%s\n", counter, name, value));
                }
                domainModelMeta.setPrimaryKeyClass(context.get("primaryKeyClass"));
                domainModelMeta.setNoRepositoryBean((Boolean)context.get("noRepositoryBean"));
                Object nestedData = context.get("queryables");
                if (nestedData != null) {
                    ArrayList<QueryablesMeta> queryablesMetas = new ArrayList<QueryablesMeta>(((List)nestedData).size());
                    for (Map data : (List)nestedData) {
                        QueryablesMeta queryablesMeta = new QueryablesMeta();
                        queryablesMeta.setMany((Boolean)data.get("many"));
                        queryablesMeta.setOptional((Boolean)data.get("optional"));
                        queryablesMeta.setPageable((Boolean)data.get("pageable"));
                        queryablesMeta.setFieldNames((List)data.get("fieldNames"));
                        queryablesMetas.add(queryablesMeta);
                    }
                    domainModelMeta.setMetas(queryablesMetas);
                }
            }
            builder.append("\n\n");
        }
        this.generate(classMetaList);
        if ("true".equalsIgnoreCase(this.options.get("codegen.debug"))) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, builder.toString());
        }
        return false;
    }

    public void generate(List<DomainModelMeta> classMetaList) {
        for (DomainModelMeta domainModelMeta : classMetaList) {
            String repositoryName = domainModelMeta.getName() + "Repository";
            String qualifiedName = domainModelMeta.getFullyQualifiedName();
            String packageName = this.options.getOrDefault("codegen.packageName", qualifiedName.substring(0, qualifiedName.lastIndexOf(".")) + ".repositories");
            List<MethodSpec> methods = this.getMethods(domainModelMeta);
            Class classT = domainModelMeta.isNoRepositoryBean() ? NoRepositoryBean.class : Repository.class;
            TypeSpec spec = TypeSpec.interfaceBuilder((String)repositoryName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(classT).build()).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JpaRepository.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)domainModelMeta.getTypeElement().asType()), ClassName.get((TypeMirror)((TypeMirror)domainModelMeta.getPrimaryKeyClass()))})).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(JpaSpecificationExecutor.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)domainModelMeta.getTypeElement().asType())})).addMethods(methods).build();
            try {
                JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)spec).build();
                javaFile.writeTo(this.processingEnv.getFiler());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private List<MethodSpec> getMethods(DomainModelMeta domainModelMeta) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>(0);
        for (QueryablesMeta queryablesMeta : domainModelMeta.getMetas()) {
            MethodSpec.Builder builder;
            List<String> fieldNames = queryablesMeta.getFieldNames();
            if (fieldNames == null || fieldNames.size() <= 0) continue;
            ArrayList<String> capitalized = new ArrayList<String>(fieldNames.size());
            ArrayList<Pair> parameters = new ArrayList<Pair>(fieldNames.size());
            for (String fieldName : fieldNames) {
                FieldMeta fieldMeta = domainModelMeta.getAllFields().get(fieldName);
                if (fieldMeta == null) {
                    throw new IllegalArgumentException(String.format("FieldName(%s) doesn't exists on (%s)", fieldName, domainModelMeta.getFullyQualifiedName()));
                }
                capitalized.add(StringUtils.capitalize((String)fieldName));
                parameters.add(Pair.of((Object)fieldMeta.getElement().asType(), (Object)fieldName));
            }
            if (queryablesMeta.isMany() || queryablesMeta.isPageable()) {
                builder = MethodSpec.methodBuilder((String)String.format("findAllBy%s", StringUtils.join(capitalized, (String)"And")));
                for (Pair pair : parameters) {
                    builder.addParameter(TypeName.get((TypeMirror)((TypeMirror)pair.getKey())), (String)pair.getValue(), new Modifier[0]);
                }
                if (queryablesMeta.isPageable()) {
                    builder.addParameter(Pageable.class, "pageable", new Modifier[0]);
                    builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Page.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType())}));
                } else {
                    builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType())}));
                }
                builder.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
                methods.add(builder.build());
                continue;
            }
            builder = MethodSpec.methodBuilder((String)String.format("findBy%s", StringUtils.join(capitalized, (String)"And")));
            for (Pair pair : parameters) {
                builder.addParameter(TypeName.get((TypeMirror)((TypeMirror)pair.getKey())), (String)pair.getValue(), new Modifier[0]);
            }
            if (queryablesMeta.isOptional()) {
                builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType())}));
            } else {
                builder.returns(TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType()));
            }
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
            methods.add(builder.build());
        }
        for (FieldMeta fieldMeta : domainModelMeta.getFieldMetas()) {
            MethodSpec.Builder builder;
            QueryableMeta queryableMeta = fieldMeta.getQueryableMeta();
            String key = fieldMeta.getName();
            if (fieldMeta.getSource() != null) {
                key = fieldMeta.getSource().getName() + StringUtils.capitalize((String)fieldMeta.getName());
            }
            if (queryableMeta.isMany() || queryableMeta.isPageable()) {
                builder = MethodSpec.methodBuilder((String)String.format("findAllBy%s", StringUtils.capitalize((String)key))).addParameter(TypeName.get((TypeMirror)fieldMeta.getElement().asType()), key, new Modifier[0]);
                if (queryableMeta.isPageable()) {
                    builder.addParameter(Pageable.class, "pageable", new Modifier[0]);
                    builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Page.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType())}));
                } else {
                    builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType())}));
                }
            } else {
                builder = MethodSpec.methodBuilder((String)String.format("findBy%s", StringUtils.capitalize((String)key))).addParameter(TypeName.get((TypeMirror)fieldMeta.getElement().asType()), key, new Modifier[0]);
                if (queryableMeta.isOptional()) {
                    builder.returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Optional.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType())}));
                } else {
                    builder.returns(TypeName.get((TypeMirror)domainModelMeta.getTypeElement().asType()));
                }
            }
            builder.addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC});
            methods.add(builder.build());
        }
        return methods;
    }
}

