package io.github.atkawa7.codegen.annotations.processing;



import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("Cannot create an instance of this class");
    }

    public static <T> T last(final T[] array) {
        if (array != null && array.length > 0) {
            return array[array.length - 1];
        }

        return null;
    }




    public static <T> T last(final List<T> list) {
        int len;
        if (list != null && (len = list.size()) > 0) {
            return list.get(len - 1);
        }
        return null;
    }

    public static <T> T first(final T[] array) {
        if (array != null && array.length > 0) {
            return array[0];
        }
        return null;
    }

    public static <T> T first(final List<T> list) {
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }
}
