/*
 * Decompiled with CFR 0.152.
 */
package io.github.atkawa7.codegen.annotations.processing;

import io.github.atkawa7.codegen.annotations.DomainModel;
import io.github.atkawa7.codegen.annotations.Queryable;
import io.github.atkawa7.codegen.annotations.processing.CollectionUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringSubstitutor;

public class RepositoryCodegen
extends AbstractProcessor {
    private Messager messager;
    private Map<String, String> options;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.options = processingEnv.getOptions();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(DomainModel.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.messager.printMessage(Diagnostic.Kind.WARNING, "Processing data codegen");
        Set<? extends Element> annotatedWith = roundEnv.getElementsAnnotatedWith(DomainModel.class);
        Set<TypeElement> elements = ElementFilter.typesIn(annotatedWith);
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Size of elements is %d", elements.size()));
        for (TypeElement typeElement : elements) {
            Map<String, String> methodContext;
            this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Processing data codegen class <%s>", typeElement.getQualifiedName()));
            HashMap<String, String> context = new HashMap<String, String>(5);
            context.put("qualifiedName", typeElement.getQualifiedName().toString());
            context.put("primaryKeyClass", Long.class.getName());
            ArrayList<MutablePair> queriablesContexts = new ArrayList<MutablePair>();
            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
                    Object t;
                    ExecutableElement key = (ExecutableElement)entry.getKey();
                    Iterator<? extends AnnotationMirror> value = ((AnnotationValue)entry.getValue()).getValue();
                    if (value instanceof List && (t = CollectionUtils.first((List)((Object)value))) instanceof AnnotationMirror) {
                        List childAnnotations = (List)((Object)value);
                        for (AnnotationMirror annotationMirror2 : childAnnotations) {
                            ArrayList<String> fieldNames = new ArrayList<String>(0);
                            HashMap<String, String> methodContext2 = new HashMap<String, String>();
                            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationMirror2.getElementValues().entrySet()) {
                                ExecutableElement k = e.getKey();
                                AnnotationValue v = e.getValue();
                                this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Child Return Type (%s)", k.getReturnType()));
                                if (k.getReturnType().toString().equalsIgnoreCase("java.lang.String[]")) {
                                    List values = (List)v.getValue();
                                    if (values == null || values.size() <= 1) continue;
                                    for (Object attr : values) {
                                        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Attr Key (%s) (%s)", attr, attr.getClass()));
                                        fieldNames.add(((AnnotationValue)attr).getValue().toString());
                                    }
                                    continue;
                                }
                                methodContext2.put(k.getSimpleName().toString(), v.getValue().toString());
                            }
                            queriablesContexts.add(new MutablePair(fieldNames, methodContext2));
                        }
                    }
                    this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Class Annotation Key (%s) (%s)", key.getReturnType(), value.getClass().getSimpleName()));
                    context.put(key.getSimpleName().toString(), value.toString());
                }
            }
            HashSet<String> methods = new HashSet<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD) continue;
                methodContext = new HashMap(5);
                hashMap.put(element.getSimpleName().toString(), element.asType().toString());
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    DeclaredType declaredType = annotationMirror.getAnnotationType();
                    if (!declaredType.toString().equals(Queryable.class.getName())) continue;
                    this.messager.printMessage(Diagnostic.Kind.WARNING, String.format("Field Annotation(%s)(%s)", annotationMirror.getAnnotationType(), element.asType()));
                    methodContext.put("qualifiedName", element.asType().toString());
                    methodContext.put("name", element.getSimpleName().toString());
                    methodContext.put("capitalized", StringUtils.capitalize((String)element.getSimpleName().toString()));
                    methodContext.put("fieldNames", element.asType().toString() + " " + element.getSimpleName().toString());
                    for (Map.Entry entry : annotationMirror.getElementValues().entrySet()) {
                        ExecutableElement key = (ExecutableElement)entry.getKey();
                        Object value = ((AnnotationValue)entry.getValue()).getValue();
                        methodContext.put(key.getSimpleName().toString(), value.toString());
                    }
                    methods.add(this.getMethod(typeElement, context, methodContext));
                }
            }
            for (Pair pair : queriablesContexts) {
                methodContext = (Map)pair.getValue();
                List fieldNames = (List)pair.getKey();
                ArrayList<String> arrayList = new ArrayList<String>(fieldNames.size());
                ArrayList<String> parameters = new ArrayList<String>(fieldNames.size());
                for (String string : fieldNames) {
                    String type = (String)hashMap.get(string);
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("FieldName(%s) doesn't exists on (%s)", string, typeElement.getQualifiedName()));
                    }
                    arrayList.add(StringUtils.capitalize((String)string));
                    parameters.add(type + "  " + string);
                }
                methodContext.put("capitalized", String.join((CharSequence)"And", arrayList));
                methodContext.put("fieldNames", String.join((CharSequence)", ", parameters));
                methods.add(this.getMethod(typeElement, context, methodContext));
            }
            String name = typeElement.getSimpleName().toString();
            String string = typeElement.getQualifiedName().toString();
            String packageName = this.options.getOrDefault("codegen.packageName", string.substring(0, string.lastIndexOf(".")) + ".repositories");
            String repositoryName = name + "Repository";
            StringJoiner stringJoiner = new StringJoiner(";\nimport ", "import ", ";\n\n");
            stringJoiner.add("org.springframework.data.domain.Page");
            stringJoiner.add("org.springframework.data.domain.Pageable");
            stringJoiner.add("org.springframework.data.jpa.repository.JpaRepository");
            stringJoiner.add("org.springframework.data.jpa.repository.JpaSpecificationExecutor");
            stringJoiner.add("org.springframework.data.repository.NoRepositoryBean");
            stringJoiner.add("org.springframework.stereotype.Repository");
            stringJoiner.add("java.util.List");
            stringJoiner.add("java.util.Optional");
            StringBuilder source = new StringBuilder();
            source.append("package ");
            source.append(packageName);
            source.append(";\n\n");
            source.append(stringJoiner.toString());
            boolean noRepositoryBean = Boolean.parseBoolean(context.getOrDefault("noRepositoryBean", "false"));
            if (noRepositoryBean) {
                source.append("@NoRepositoryBean\n");
            } else {
                source.append("@Repository\n");
            }
            source.append("public interface ");
            source.append(repositoryName);
            source.append(new StringSubstitutor(context).replace(" extends JpaRepository<${qualifiedName}, ${primaryKeyClass}>, JpaSpecificationExecutor<${qualifiedName}>"));
            source.append(" {\n\n");
            source.append(String.join((CharSequence)";\n\n", methods));
            if (methods.size() > 0) {
                source.append(";");
            }
            source.append("\n\n}\n");
            try {
                JavaFileObject javaFileObject = this.processingEnv.getFiler().createSourceFile(packageName + '.' + repositoryName, new Element[0]);
                Writer writer = javaFileObject.openWriter();
                try {
                    writer.write(source.toString());
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return false;
    }

    private String getMethod(TypeElement typeElement, Map<String, String> context, Map<String, String> methodContext) {
        String methodTemplate;
        String returnType;
        boolean many = Boolean.parseBoolean(methodContext.getOrDefault("many", "false"));
        boolean pageable = Boolean.parseBoolean(methodContext.getOrDefault("pageable", "false"));
        boolean optional = Boolean.parseBoolean(methodContext.getOrDefault("optional", "true"));
        this.messager.printMessage(Diagnostic.Kind.WARNING, "Optional " + optional + methodContext.getOrDefault("optional", "true"));
        if (many) {
            if (pageable) {
                returnType = new StringSubstitutor(context).replace("Page<${qualifiedName}> ");
                methodTemplate = new StringSubstitutor(methodContext).replace("findAllBy${capitalized}(${fieldNames}, Pageable pageable)");
            } else {
                returnType = new StringSubstitutor(context).replace("List<${qualifiedName}> ");
                methodTemplate = new StringSubstitutor(methodContext).replace("findAllBy${capitalized}(${fieldNames})");
            }
        } else {
            returnType = optional ? new StringSubstitutor(context).replace("Optional<${qualifiedName}> ") : typeElement.getQualifiedName() + " ";
            methodTemplate = new StringSubstitutor(methodContext).replace("findBy${capitalized}(${fieldNames})");
        }
        return "    " + returnType + methodTemplate;
    }
}

